/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet.processor;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.csinterface.agent.servlet.RequestProcessor;
import com.kingdee.eas.csinterface.agent.servlet.openapi.IOpenAPIServlet;
import com.kingdee.eas.csinterface.agent.servlet.openapi.OepnAPIActionEnum;
import com.kingdee.eas.csinterface.agent.servlet.openapi.impl.AbstractOpenAPIServlet;
import com.kingdee.eas.csinterface.agent.servlet.openapi.impl.OpenAPIDeleteImpl;
import com.kingdee.eas.csinterface.agent.servlet.openapi.impl.OpenAPIGetSolutionsImpl;
import com.kingdee.eas.csinterface.agent.servlet.openapi.impl.OpenAPIPackImpl;
import com.kingdee.eas.csinterface.agent.servlet.openapi.impl.OpenAPISaveImpl;
import com.kingdee.eas.csinterface.agent.servlet.openapi.impl.OpenAPIServletImpl;
import com.kingdee.eas.csinterface.agent.servlet.processor.WebAPILoginServlet;
import com.kingdee.eas.csinterface.agent.util.WebUtil;
import com.kingdee.eas.csinterface.base.cache.SessionUtil;
import com.kingdee.eas.csinterface.webservice.app.util.ReturnDataService;
import com.kingdee.eas.csinterface.webservice.framework.Return;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebOpenAPIServlet
extends RequestProcessor {
    private static final Logger logger = Logger.getLogger(WebOpenAPIServlet.class);
    public static final String openAPIPackagePath = "com.kingdee.eas.csinterface.agent.servlet.openapi.impl.";
    private static Map<String, IOpenAPIServlet> servletImpl = new HashMap<String, IOpenAPIServlet>();
    public static boolean ALL_HASH_UPDATE = false;

    @Override
    public String getTargetURI() {
        return "/openapi/";
    }

    @Override
    public String process(Map<String, String> params, String reqContent) throws Exception {
        String result = null;
        Context context = null;
        this.response.setHeader("Content-type", "text/html;charset=UTF-8");
        Object oldSession = this.getContext(params);
        if (!(oldSession instanceof Context)) {
            return oldSession.toString();
        }
        context = (Context)oldSession;
        String uri = this.request.getRequestURI();
        logger.info((Object)("[EIP]request URI : " + uri));
        uri = WebUtil.relative("/easportal/eip", uri);
        uri = uri.startsWith("/") ? uri : "/" + uri;
        String action = uri.substring(uri.lastIndexOf("/") + 1);
        AbstractOpenAPIServlet servletImpl = null;
        OepnAPIActionEnum actionEnum = OepnAPIActionEnum.getInstance(action);
        if (OepnAPIActionEnum.DELETE.equals((Object)actionEnum)) {
            servletImpl = new OpenAPIDeleteImpl();
        } else if (OepnAPIActionEnum.AUDIT.equals((Object)actionEnum) || OepnAPIActionEnum.UNAUDIT.equals((Object)actionEnum) || OepnAPIActionEnum.DELETE.equals((Object)actionEnum) || OepnAPIActionEnum.SUBMIT.equals((Object)actionEnum)) {
            servletImpl = new OpenAPIPackImpl();
        } else if (OepnAPIActionEnum.SAVE.equals((Object)actionEnum)) {
            servletImpl = new OpenAPISaveImpl();
        } else if (OepnAPIActionEnum.GETSOLUTIONS.equals((Object)actionEnum)) {
            servletImpl = new OpenAPIGetSolutionsImpl();
        } else if (OepnAPIActionEnum.INTEGRATE.equals((Object)actionEnum)) {
            servletImpl = new OpenAPIServletImpl();
        }
        if (servletImpl == null) {
            throw new NullPointerException();
        }
        Object execMsg = servletImpl.process(context, this.request, this.response, params, reqContent);
        if (execMsg instanceof IObjectPK[]) {
            // empty if block
        }
        execMsg = execMsg.toString().replaceAll("\\\\r", "");
        execMsg = execMsg.toString().replaceAll("\\\\n", " ");
        execMsg = execMsg.toString().replaceAll("\\\\t", "");
        result = ReturnDataService.format(Return.valueOf(0, execMsg.toString(), "\u6267\u884c\u6210\u529f"));
        return execMsg.toString();
    }

    private Object getContext(Map<String, String> params) throws Exception {
        Context context;
        String token = this.request.getParameter("token");
        if (token == null) {
            token = params.get("token");
        }
        if ((context = SessionUtil.getContextByToken(token)) == null) {
            return WebAPILoginServlet.reLogin();
        }
        context.setClientHostIP("127.0.0.1");
        return context;
    }
}

