/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.app.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.eas.csinterface.app.base.EIPORMServiceUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashSet;
import java.util.Set;

public class EIPLicenseCheckUtil {
    private static final Set<String> CHECK_ENOUGH_BOSTYPE = new HashSet<String>(){
        {
            this.add("B667CC39");
        }
    };
    private static final Set<String> CHECK_HASLICENSE_BOSTYPE = new HashSet<String>(){
        {
            this.add("1611F82D");
            this.add("CACEE952");
            this.add("BE2E7EA9");
            this.add("89D3E4BB");
            this.add("DE7112DC");
            this.add("9E09E8C9");
            this.add("4BCA6DD1");
            this.add("F1C9A600");
            this.add("F4586F23");
        }
    };
    private static final Set<String> CHECK_HASLICENSE_FACADE = new HashSet<String>(){
        {
            this.add("132132c6-a0fc-4454-97e6-00508fc6a519");
            this.add("1be9ff44-1f36-4245-8b1a-27e51d53dca8");
            this.add("2d5ffdb2-0d2f-4d92-9042-a26fd1dcac8a");
            this.add("ecdd0318-4ae6-40c9-8484-7dcdd05a0f02");
            this.add("b2e7fbf9-63e2-4a49-9131-4e99607b770d");
            this.add("1bd8cde4-52d8-42c2-8da5-847d7e0294d6");
            this.add("a94a3987-00fb-1000-e000-0007c0a813e6");
            this.add("2518af2b-0de5-4d8e-9f9a-19aa545b3330");
            this.add("e5addff1-3ea4-4f55-a95f-761785ecd0e2");
            this.add("83ca3da6-e7e4-4e15-9999-bcc5c5147c87");
            this.add("dfd2c083-00fa-1000-e000-001fc0a813e6");
            this.add("74698285-32a3-41b1-a43b-92532ac0f380");
            this.add("");
        }
    };

    public static void checkLicensePassed(Context ctx) throws BOSException {
        EIPORMServiceUtil.canAddLicenseOnceMore(ctx);
    }

    public static void checkLicenseEnough(Context ctx) throws BOSException {
        EIPORMServiceUtil.checkLicenseEnough(ctx);
    }

    public static void checkLicense(ServiceContext svcCtx) throws BOSException {
        String methodPK = svcCtx.getOperationPK().toString();
        Context ctx = (Context)svcCtx.getOperationParameters()[0];
        String bosType = svcCtx.getBoType().toString();
        if (CHECK_ENOUGH_BOSTYPE.contains(bosType)) {
            EIPLicenseCheckUtil.checkHasEnoughLicense(svcCtx);
            return;
        }
        if (CHECK_HASLICENSE_BOSTYPE.contains(bosType)) {
            EIPORMServiceUtil.checkLicenseEnough(ctx);
            return;
        }
        if (CHECK_HASLICENSE_FACADE.contains(methodPK)) {
            EIPORMServiceUtil.checkLicenseEnough(ctx);
            return;
        }
    }

    private static void checkHasEnoughLicense(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        CoreBaseInfo coreBaseInfo;
        String methodPK = svcCtx.getOperationPK().toString();
        Context ctx = (Context)svcCtx.getOperationParameters()[0];
        if ("a94a3987-00fb-1000-e000-0007c0a813e6".equals(methodPK)) {
            EIPORMServiceUtil.canAddLicenseOnceMore(ctx);
        } else if ("2518af2b-0de5-4d8e-9f9a-19aa545b3330".equals(methodPK) || "e5addff1-3ea4-4f55-a95f-761785ecd0e2".equals(methodPK) || "e5addff1-3ea4-4f55-a95f-761785ecd0e2".equals(methodPK)) {
            EIPORMServiceUtil.checkLicenseEnough(ctx);
        } else if ("dfd2c083-00fa-1000-e000-001fc0a813e6".equals(methodPK) && (coreBaseInfo = (CoreBaseInfo)svcCtx.getOperationParameters()[1]).getId() == null) {
            EIPORMServiceUtil.canAddLicenseOnceMore(ctx);
        }
    }
}

