/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.app.mq;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.csinterface.base.cache.SessionUtil;
import com.kingdee.eas.csinterface.base.cache.session.impl.ORMRPCSessionCache;
import com.kingdee.eas.csinterface.util.AES;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeCollection;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeFactory;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeInfo;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class EASMQExtends {
    private static final Logger logger = Logger.getLogger(EASMQExtends.class);

    public static void execute(JSONObject extend) throws Exception {
        String user = extend.getString("user");
        String password = extend.getString("password");
        String language = extend.getString("language");
        String dataCenter = extend.getString("datacenter");
        String solution = extend.getString("solution");
        String access = extend.getString("access");
        String auth = null;
        if (extend.containsKey((Object)"auth")) {
            auth = extend.getString("auth");
        }
        user = AES.decryptToString(user, access);
        Context queryContext = new Context();
        queryContext.setAIS(dataCenter);
        queryContext.setSolution(solution);
        queryContext.setUserName(user);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("apiKey", (Object)access));
        view.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("encryptCode"));
        view.setSelector(selectors);
        String encryptCode = "";
        WSIdentificationCodeCollection colls = WSIdentificationCodeFactory.getLocalInstance(queryContext).getWSIdentificationCodeCollection(view);
        Iterator ite = colls.iterator();
        if (ite.hasNext()) {
            encryptCode = ((WSIdentificationCodeInfo)ite.next()).getEncryptCode();
        }
        password = AES.decryptToString(password, encryptCode);
        Context ctx = SessionUtil.login(user, password, dataCenter, language, solution, auth);
        ctx.put((Object)"access", (Object)access);
        ORMRPCSessionCache.setContext(ctx);
    }

    public static String buildException(String bodyStr, Throwable e) {
        JSONObject expJson = new JSONObject();
        String taskId = "no_task_id";
        JSONObject body = null;
        try {
            body = JSONObject.parseObject((String)bodyStr);
            if (body.containsKey((Object)"taskId")) {
                taskId = body.getString("taskId");
            }
        }
        catch (Throwable e2) {
            logger.error((Object)"\u6784\u9020\u4e0a\u4e0b\u6587\u5f02\u5e38\u4fe1\u606f\u5bf9\u8c61\u5f02\u5e38\uff01", e);
        }
        expJson.put("taskId", (Object)taskId);
        expJson.put("success", (Object)false);
        expJson.put("errorMsg", (Object)e.getMessage());
        expJson.put("trace", (Object)ThrowableHelper.toString(e));
        expJson.put("message", (Object)body);
        return expJson.toJSONString();
    }
}

