/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.app.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.async.AsyncTaskFactory;
import com.kingdee.eas.csinterface.async.AsyncTaskInfo;
import com.kingdee.eas.csinterface.async.AsyncTaskStatus;
import com.kingdee.eas.csinterface.async.AsyncTaskTreeInfo;
import com.kingdee.eas.csinterface.async.IAsyncTask;
import com.kingdee.eas.csinterface.async.app.task.AsyncOrderTaskUtil;
import com.kingdee.eas.csinterface.async.app.task.model.ResultInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Logger;

public class AsyncTaskExecute {
    private static Logger logger = Logger.getLogger(AsyncTaskExecute.class);
    protected static Map<String, AsyncTaskTreeInfo> asyncClassMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void execute(Context ctx, Job job, String taskId, String data, String aysncType, ResultInfo result) {
        block13: {
            IAsyncTask instsance = null;
            AsyncTaskInfo taskInfo = null;
            result = new ResultInfo(false, false, null, null, null);
            instsance = AsyncTaskFactory.getLocalInstance(ctx);
            taskInfo = instsance.getAsyncTaskInfo(CommonUtil.convert2PK(taskId));
            AsyncTaskExecute.enter(ctx, instsance, taskInfo);
            AsyncOrderTaskUtil.setCurrentTask(taskInfo);
            AsyncTaskExecute.innnerExecute(ctx, job, taskId, data, aysncType, result);
            result.setSuccess(true);
            try {
                AsyncTaskExecute.exit(ctx, instsance, taskInfo, result);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setException(e);
                result.setErrorMsg(e.getMessage());
                logger.error((Object)("EIP:Finish Async Task Error,taskId:" + taskId + ",data:" + data), (Throwable)e);
            }
            break block13;
            catch (Throwable e) {
                try {
                    result.setSuccess(false);
                    try {
                        result.setException((Exception)e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    result.setErrorMsg(e.getMessage());
                    String errorMsg = "EIP:Execute Async Task Error,data:" + data;
                    if (taskInfo != null) {
                        taskInfo.setStatus(AsyncTaskStatus.fail);
                        taskInfo.setMessage(errorMsg);
                        taskInfo.setTrace(ThrowableHelper.toString(e));
                    }
                    logger.error((Object)errorMsg, e);
                }
                catch (Throwable throwable) {
                    try {
                        AsyncTaskExecute.exit(ctx, instsance, taskInfo, result);
                    }
                    catch (Exception e2) {
                        result.setSuccess(false);
                        result.setException(e2);
                        result.setErrorMsg(e2.getMessage());
                        logger.error((Object)("EIP:Finish Async Task Error,taskId:" + taskId + ",data:" + data), (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    AsyncTaskExecute.exit(ctx, instsance, taskInfo, result);
                }
                catch (Exception e3) {
                    result.setSuccess(false);
                    result.setException(e3);
                    result.setErrorMsg(e3.getMessage());
                    logger.error((Object)("EIP:Finish Async Task Error,taskId:" + taskId + ",data:" + data), (Throwable)e3);
                }
            }
        }
    }

    private static AsyncTaskInfo enter(Context ctx, IAsyncTask instsance, AsyncTaskInfo taskInfo) throws BOSException, EASBizException {
        if (taskInfo != null) {
            taskInfo.setStatus(AsyncTaskStatus.processing);
            instsance.save((CoreBaseInfo)taskInfo);
        }
        return taskInfo;
    }

    private static void exit(Context ctx, IAsyncTask instsance, AsyncTaskInfo taskInfo, ResultInfo result) throws BOSException, EASBizException {
        if (taskInfo != null) {
            if (!AsyncTaskStatus.fail.equals((Object)taskInfo.getStatus()) || result.isSuccess()) {
                taskInfo.setStatus(AsyncTaskStatus.wait);
            }
            if (!result.isSuccess()) {
                taskInfo.setStatus(AsyncTaskStatus.fail);
            }
            taskInfo.setMessage(result.getErrorMsg());
            taskInfo.setTrace(ThrowableHelper.toString((Throwable)result.getException()));
        }
        instsance.save((CoreBaseInfo)taskInfo);
    }

    private static void innnerExecute(Context ctx, Job job, String taskId, String data, String aysncType, ResultInfo result) throws Throwable {
        if (asyncClassMap == null) {
            try {
                AsyncOrderTaskUtil.getAllAsynConfig(ctx);
            }
            catch (BOSException e) {
                logger.error((Object)ThrowableHelper.toString((Exception)((Object)e)));
            }
        }
        AsyncTaskTreeInfo treeInfo = asyncClassMap.get(aysncType);
        String implClass = treeInfo.getImplClass();
        Class<?> userClass = null;
        Method userMethod = null;
        try {
            userClass = Class.forName(implClass);
        }
        catch (ClassNotFoundException e) {
            result.setErrorMsg("EIP: cannot found class: " + implClass);
            result.setException(e);
        }
        try {
            userMethod = userClass.getMethod("execute", Context.class, Job.class, String.class, ResultInfo.class);
        }
        catch (Exception e) {
            result.setErrorMsg("EIP: class " + implClass + " must implements com.kingdee.eas.csinterface.async.app.task.IAsyncTaskExecutor");
            result.setException(e);
        }
        if (userMethod == null) {
            throw new NullPointerException();
        }
        result = (ResultInfo)userMethod.invoke(userClass.newInstance(), ctx, job, data, result);
    }
}

