/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.app.task.smalltask.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.InvalidEntityViewException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryInfo;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.app.DynamicBillBatchInsertHelper;
import com.kingdee.eas.csinterface.async.app.task.handler.IApiUserHandler;
import com.kingdee.eas.csinterface.async.app.task.util.AsyncBaseDataParse;
import com.kingdee.eas.csinterface.async.app.task.util.CurrentDealBillUtil;
import com.kingdee.eas.csinterface.async.app.task.util.SaveDataRelationUtil;
import com.kingdee.eas.csinterface.async.util.BOSEntityUtil;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.openapi.OpenAPIDispatcherInfo;
import com.kingdee.eas.csinterface.schedule.app.service.util.DAPUtil;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.util.ClassUtil;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.EntityHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class APIMidBillDataImpl {
    public static final String SOURCE_BILLID = "eipsrcid";
    public static final String OPEN_ID = "openid";
    public static final String SOURCE_ENTITYID = "srcEntity";
    private String billNumber;
    private String botpNumber;
    private BOSObjectType bosType;
    private IMetaDataPK metaDataPK;
    private Context ctx;
    private JSONArray arrayData;
    private StructuredDataModel dataModel;
    private CoreBillBaseCollection middleColl = new CoreBillBaseCollection();
    private String midBillTableName = null;
    private boolean saveMidData;
    private Map<String, String> srcId2MidIdMap = new HashMap<String, String>();
    private String srcEntityId = null;
    private String destEntityId = null;

    public Object createDestBill(Context ctx, String billNumber, String botpNumber, JSONArray arrayData, boolean saveMidData, String srcEntityId, OpenAPIDispatcherInfo openAPIDispatcher, String serviceImpl) throws Exception {
        DAPTransformResult resultObj = null;
        this.billNumber = billNumber;
        this.botpNumber = botpNumber;
        this.ctx = ctx;
        this.arrayData = arrayData;
        this.saveMidData = saveMidData;
        this.srcEntityId = srcEntityId;
        this.initialBillMetaData(billNumber);
        BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("where number = '" + billNumber + "'");
        if (billMappingInfo == null) {
            throw new Exception("\u5bf9\u5e94\u7684\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u65b9\u6848\u7f16\u7801\u4e3a\uff1a" + billNumber);
        }
        this.dataModel = DataModelUtil.convert(billMappingInfo);
        IApiUserHandler userHandle = null;
        if (!StringUtils.isEmpty((String)serviceImpl)) {
            userHandle = (IApiUserHandler)ClassUtil.getNewInstance(serviceImpl);
        }
        if (userHandle != null) {
            for (Object eachData : arrayData) {
                JSONObject data = (JSONObject)eachData;
                data = userHandle.handleOriginal(ctx, data);
                if (userHandle.isEndWithProcess() || data == null) continue;
                arrayData.add((Object)data);
            }
        }
        this.createMidBills();
        if (userHandle != null) {
            this.middleColl = userHandle.handleProcess(ctx, arrayData, this.middleColl);
        }
        BOTMappingInfo botMapping = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name = '" + botpNumber + "'");
        this.destEntityId = botMapping.getDestEntityName();
        String apiKey = openAPIDispatcher.getIdentification().getApiKey();
        String method = null;
        if (1 == botMapping.getIsTempSave()) {
            method = "save";
        } else if (0 == botMapping.getIsTempSave()) {
            method = "submit";
        }
        CurrentDealBillUtil.setCurrent(apiKey, this.bosType.toString(), method);
        Object result = null;
        if (DefineSysEnum.DAP.equals((Object)botMapping.getDefineSys()) || DefineSysEnum.DAPPC.equals((Object)botMapping.getDefineSys())) {
            resultObj = DAPUtil.dap(ctx, this.midBillTableName, this.middleColl, botMapping);
            if (userHandle != null) {
                resultObj = userHandle.handleDAPResult(ctx, resultObj);
            }
        } else {
            BTPTransformResult btpResult = new BTPTransformResult();
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            resultObj = iBTPManager.transformForBotp(this.middleColl, botMapping.getDestEntityName(), CommonUtil.convert2PK(botMapping.getId().toString()));
            if (userHandle != null) {
                resultObj = userHandle.handleBOTPResult(ctx, (BTPTransformResult)resultObj);
            }
        }
        SaveDataRelationUtil.save(ctx, resultObj, this.srcId2MidIdMap, this.srcEntityId, this.bosType.toString(), this.destEntityId, openAPIDispatcher);
        if (method != null) {
            BOSEntityUtil.reSaveBill(ctx, (ICoreBase)BOSEntityUtil.getLocalInstance(ctx, botMapping.getDestEntityName()), resultObj, method);
        }
        return resultObj;
    }

    private void createMidBills() throws Exception {
        if (this.arrayData == null || this.arrayData.size() == 0) {
            return;
        }
        StructuredDataModel.TableModel headerModel = this.dataModel.getPriorityTables()[0];
        StructuredDataModel.TableModel entryModel = this.dataModel.getPriorityTables()[1];
        StructuredDataModel.ColumnModel[] headerColumns = headerModel.columns;
        StructuredDataModel.ColumnModel[] entryColumns = entryModel.columns;
        String entryKey = null;
        int j = this.arrayData.size();
        block2: for (int i = 0; i < j; ++i) {
            JSONObject obj = this.arrayData.getJSONObject(0);
            for (String key : obj.keySet()) {
                Object val;
                if (StringUtils.isEmpty((String)key) || !((val = obj.get((Object)key)) instanceof JSONArray)) continue;
                entryKey = key;
                break block2;
            }
        }
        JSONObject eachData = null;
        JSONObject eachEntry = null;
        Map<String, Map<String, CoreBaseInfo>> coreDataMap = AsyncBaseDataParse.initBaseDataMapping(this.arrayData, this.dataModel, this.ctx, entryKey);
        int j2 = this.arrayData.size();
        for (int i = 0; i < j2; ++i) {
            eachData = this.arrayData.getJSONObject(i);
            this.srcEntityId = eachData.getString(SOURCE_ENTITYID);
            DynamicBillTemplateInfo billInfo = new DynamicBillTemplateInfo();
            billInfo.setBizDate(new Date(System.currentTimeMillis()));
            billInfo.setBOSType(this.bosType);
            billInfo.setPK(this.metaDataPK);
            billInfo.setId(BOSUuid.create((BOSObjectType)this.bosType));
            Object sourceBillId = eachData.get((Object)SOURCE_BILLID);
            if (sourceBillId != null) {
                billInfo.setSourceBillId(sourceBillId.toString());
                this.srcId2MidIdMap.put(billInfo.getId().toString(), sourceBillId.toString());
            }
            for (StructuredDataModel.ColumnModel colModel : headerColumns) {
                Object value = eachData.get((Object)colModel.name.toLowerCase());
                billInfo.put(colModel.destName, this.getBaseDataValue(colModel, value, coreDataMap));
            }
            if (entryKey != null) {
                DynamicBillTemplateEntryCollection entryColl = new DynamicBillTemplateEntryCollection();
                DIPMetadata dm = new DIPMetadata(this.billNumber);
                String entryName = dm.getEntryEntityPK();
                MetaDataPK entryetaDataPK = MetaDataPK.create((String)entryName);
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
                EntityObjectInfo entryEntity = loader.getEntity((IMetaDataPK)entryetaDataPK);
                JSONArray entryData = eachData.getJSONArray(entryKey);
                int ms = entryData.size();
                for (int m = 0; m < ms; ++m) {
                    eachEntry = entryData.getJSONObject(m);
                    DynamicBillTemplateEntryInfo entry = new DynamicBillTemplateEntryInfo();
                    entry.setParent(billInfo);
                    entry.setId(BOSUuid.create((BOSObjectType)entryEntity.getBOSType()));
                    entry.setSeq(m);
                    Object sourceBillEntryId = eachEntry.get((Object)SOURCE_BILLID);
                    if (sourceBillEntryId != null) {
                        entry.setString("sourceBillEntryId", sourceBillEntryId.toString());
                        entry.setString(SOURCE_BILLID, sourceBillEntryId.toString());
                        this.srcId2MidIdMap.put(entry.getId().toString(), sourceBillEntryId.toString());
                    }
                    for (StructuredDataModel.ColumnModel colModel : entryColumns) {
                        Object value = eachEntry.get((Object)colModel.name.toLowerCase());
                        entry.put(colModel.destName, this.getBaseDataValue(colModel, value, coreDataMap));
                    }
                    entryColl.add(entry);
                }
                billInfo.put("entrys", (Object)entryColl);
            }
            this.middleColl.add((CoreBillBaseInfo)billInfo);
        }
        if (this.saveMidData) {
            try {
                this._addBatchMidBill(this.middleColl);
            }
            catch (Exception e) {
                throw new DIPException("\u6570\u636e\u66f4\u65b0\u5230\u4e2d\u95f4\u8868\u5f02\u5e38:" + e.getMessage(), e);
            }
        }
    }

    private Object getBaseDataValue(StructuredDataModel.ColumnModel dataModel, Object sourValue, Map<String, Map<String, CoreBaseInfo>> coreDataMap) throws Exception {
        Object transValue;
        block22: {
            transValue = null;
            BaseDataTypeInfo baseDataType = (BaseDataTypeInfo)dataModel.baseDataType;
            if (baseDataType != null) {
                try {
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    selectors.add(new SelectorItemInfo("destBaseData.queryName"));
                    baseDataType = BaseDataTypeFactory.getLocalInstance(this.ctx).getBaseDataTypeInfo(CommonUtil.convert2PK(baseDataType.getId().toString()), selectors);
                }
                catch (Exception selectors) {
                    // empty catch block
                }
                String queryName = baseDataType.getDestBaseData().getQueryName();
                BOSObjectType bosType = Utils.getBOSTypeFromQueryPK((IMetaDataPK)MetaDataPK.create((String)queryName), null);
                try {
                    EntityObjectInfo eoi = EJBAccessFactory.createLocalInstance((Context)this.ctx).getEntityInfo(bosType);
                    String className = eoi.getBusinessImplName() + "Info";
                    Class<?> clazz = Class.forName(className);
                    IObjectValue objectInfo = (IObjectValue)clazz.newInstance();
                    String typeID = baseDataType.getId().toString();
                    String aaaaaa = EntityHelper.getChineseEntityName(this.ctx, bosType);
                    if (sourValue == null || StringUtils.isEmpty((String)sourValue.toString())) break block22;
                    CoreBaseInfo obvResult = null;
                    ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosType);
                    Boolean isJSON = sourValue.toString().startsWith("{");
                    if (isJSON.booleanValue()) {
                        JSONObject objValue = JSONObject.parseObject((String)sourValue.toString());
                        String id = objValue.getString("id");
                        if (!StringUtils.isEmpty((String)id)) {
                            try {
                                obvResult = coreBase.getValue("select id where id='" + id + "'");
                            }
                            catch (ObjectNotFoundException e) {
                                throw new Exception("id\u4e3a" + id + "\u7684\u201c" + EntityHelper.getChineseEntityName(this.ctx, bosType) + "\u201d\u4e0d\u5b58\u5728\uff01");
                            }
                            catch (InvalidEntityViewException e) {
                                if (e.getMessage().indexOf("TooManyRecord") == 0) {
                                    throw new Exception("id\u4e3a" + id + "\u7684\u201c" + EntityHelper.getChineseEntityName(this.ctx, bosType) + "\u201d\u91cd\u590d\uff01");
                                }
                                throw e;
                            }
                            objectInfo.setString("id", id);
                        }
                        if (objectInfo.get("id") == null) {
                            String number = objValue.getString("number");
                            try {
                                obvResult = coreBase.getValue("select id where number='" + number + "'");
                            }
                            catch (ObjectNotFoundException e) {
                                throw new Exception("\u7f16\u7801\u4e3a" + number + "\u7684\u201c" + EntityHelper.getChineseEntityName(this.ctx, bosType) + "\u201d\u4e0d\u5b58\u5728\uff01");
                            }
                            catch (InvalidEntityViewException e) {
                                if (e.getMessage().indexOf("TooManyRecord") == 0) {
                                    throw new Exception("\u7f16\u7801\u4e3a" + number + "\u7684\u201c" + EntityHelper.getChineseEntityName(this.ctx, bosType) + "\u201d\u91cd\u590d\uff01");
                                }
                                throw e;
                            }
                            if (obvResult != null) {
                                objectInfo.setString("id", obvResult.get("id").toString());
                            }
                        }
                        return objectInfo;
                    }
                    try {
                        obvResult = coreBase.getValue("select id where number='" + sourValue + "'");
                    }
                    catch (ObjectNotFoundException e) {
                        throw new Exception("\u7f16\u7801\u4e3a" + sourValue + "\u7684\u201c" + EntityHelper.getChineseEntityName(this.ctx, bosType) + "\u201d\u4e0d\u5b58\u5728\uff01");
                    }
                    catch (InvalidEntityViewException e) {
                        if (e.getMessage().indexOf("TooManyRecord") == 0) {
                            throw new Exception("\u7f16\u7801\u4e3a" + sourValue + "\u7684\u201c" + EntityHelper.getChineseEntityName(this.ctx, bosType) + "\u201d\u91cd\u590d\uff01");
                        }
                        throw e;
                    }
                    if (obvResult != null) {
                        objectInfo.setString("id", obvResult.get("id").toString());
                    }
                    return objectInfo;
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            transValue = sourValue;
        }
        return transValue;
    }

    private void initialBillMetaData(String billNumber) {
        DIPMetadata dm = new DIPMetadata(billNumber);
        String fullName = dm.getHeaderEntityPK();
        this.metaDataPK = MetaDataPK.create((String)fullName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
        EntityObjectInfo entity = loader.getEntity(this.metaDataPK);
        this.bosType = entity.getType();
        String entryName = dm.getEntryEntityPK();
        MetaDataPK entryetaDataPK = MetaDataPK.create((String)entryName);
        EntityObjectInfo entryEntity = loader.getEntity((IMetaDataPK)entryetaDataPK);
        this.midBillTableName = DIPMetadata.getShortName(dm.getHeaderTablePK());
    }

    protected void _addBatchMidBill(CoreBillBaseCollection middleColl) throws Exception {
        DynamicBillBatchInsertHelper.prepare(this.ctx, this.billNumber, null);
        DynamicBillBatchInsertHelper insertHelper = DynamicBillBatchInsertHelper.getInstance();
        this.insertByNativeJDBCBatch(middleColl, insertHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertByNativeJDBCBatch(CoreBillBaseCollection middleColl, DynamicBillBatchInsertHelper insertHelper) throws SQLException, BOSException {
        Connection con = EJBFactory.getConnection((Context)this.ctx);
        PreparedStatement insertHeadStatement = null;
        PreparedStatement insertEntryStatement = null;
        try {
            insertHeadStatement = con.prepareStatement(insertHelper.getInsertHeaderSql());
            insertEntryStatement = con.prepareStatement(insertHelper.getInsertEntrySql());
            for (int i = 0; i < middleColl.size(); ++i) {
                DynamicBillTemplateInfo headInfo = (DynamicBillTemplateInfo)middleColl.get(i);
                DynamicBillTemplateEntryCollection entryColl = headInfo.getEntrys();
                insertHelper.setHeaderParameters(insertHeadStatement, headInfo);
                insertHeadStatement.addBatch();
                for (int j = 0; j < entryColl.size(); ++j) {
                    DynamicBillTemplateEntryInfo entryInfo = entryColl.get(j);
                    insertHelper.setEntryParameters(insertEntryStatement, entryInfo, j + 1);
                    insertEntryStatement.addBatch();
                }
            }
            insertHelper.updateTransmitChunked(con);
            insertHeadStatement.executeBatch();
            insertEntryStatement.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(insertEntryStatement);
            SQLUtils.cleanup((Statement)insertHeadStatement);
            SQLUtils.cleanup((Connection)con);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)insertEntryStatement);
        SQLUtils.cleanup((Statement)insertHeadStatement);
        SQLUtils.cleanup((Connection)con);
    }
}

