/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynEntryCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynEntryInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSpecialSQLFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSubPlanFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.AbstractBaseDataSynHeadControllerBean;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.template.BaseDataPlanCacheTemplate;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.cache.util.CacheType;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaseDataSynHeadControllerBean
extends AbstractBaseDataSynHeadControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.basedatasyn.app.BaseDataSynHeadControllerBean");

    @Override
    protected Map _convertId2CoreBaseInfo(Context ctx, String[] idArray) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        HashMap<String, CoreBaseInfo> map = new HashMap<String, CoreBaseInfo>();
        if (null == idArray || 0 == idArray.length) {
            return new HashMap();
        }
        String firstId = idArray[0];
        StringBuffer ids = new StringBuffer(firstId);
        for (int i = 1; i < idArray.length; ++i) {
            ids.append(",");
            ids.append(idArray[i]);
        }
        ICoreBase coreBase = CommonUtil.getCoreBaseInstance(ctx, firstId);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
        ev.setFilter(filter);
        CoreBaseCollection coll = coreBase.getCollection(ev);
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            CoreBaseInfo baseInfo = coll.get(i);
            String key = baseInfo.getId().toString();
            map.put(key, baseInfo);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("cost time:" + (endTime - startTime) + "ms");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int _getDBType(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        int dbType = 0;
        try {
            conn = DBUtils.getConnection(ctx);
            if (DBUtil.isOracle((Connection)conn)) {
                dbType = 2;
            } else if (DBUtil.isDB2((Connection)conn)) {
                dbType = 1;
            } else if (DBUtil.isMSSQL((Connection)conn)) {
                dbType = 3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SQLUtil.cleanup(conn);
        }
        return dbType;
    }

    @Override
    protected String _getPKTableName(Context ctx, String planId) throws BOSException, EASBizException {
        String tableName = "";
        BaseDataSynHeadInfo headInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(planId));
        BaseDataSynTableCollection coll = headInfo.getTableEntrys();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            BaseDataSynTableInfo tableInfo = (BaseDataSynTableInfo)it.next();
            if (!tableInfo.isMainTable()) continue;
            tableName = tableInfo.getTableName();
            break;
        }
        return tableName;
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BaseDataSynHeadInfo headInfo = (BaseDataSynHeadInfo)model;
        if (!headInfo.isEnabled()) {
            return;
        }
        BaseDataSynEntryCollection scheduleList = headInfo.getEntrys();
        for (int i = 0; i < scheduleList.size(); ++i) {
            BaseDataSynEntryInfo entity = scheduleList.get(i);
            String scheduleId = entity.getScheduleId();
            ScheduleFactory.getLocalInstance(ctx).disableSchedule(scheduleId);
        }
        headInfo.setEnabled(false);
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BaseDataSynHeadInfo headInfo = (BaseDataSynHeadInfo)model;
        if (headInfo.isEnabled()) {
            return;
        }
        headInfo.setEnabled(true);
        super._cancelCancel(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("subPlanId", (Object)pk.toString(), CompareType.EQUALS));
        boolean hasBeanUsed = BaseDataSynSubPlanFactory.getLocalInstance(ctx).exists(filter);
        if (hasBeanUsed) {
            throw new BOSException("\u8be5\u65b9\u6848\u5df2\u88ab\u5176\u5b83\u7ec4\u5408\u65b9\u6848\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
        }
        ScheduleFactory.getLocalInstance(ctx).delete("where baseDataSyn.id = '" + pk.toString() + "'");
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk.toString(), CompareType.EQUALS));
        BaseDataSynSpecialSQLFactory.getLocalInstance(ctx).delete(filter);
        super._delete(ctx, pk);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        BaseDataSynHeadInfo headInfo = (BaseDataSynHeadInfo)model;
        BaseDataSynTableCollection tc = headInfo.getTableEntrys();
        Iterator it = tc.iterator();
        while (it.hasNext()) {
            BaseDataSynTableInfo temTable = (BaseDataSynTableInfo)it.next();
            this.cleanBaseDataplanCache(headInfo, temTable);
        }
        return super.submit(ctx, model);
    }

    private void cleanBaseDataplanCache(BaseDataSynHeadInfo headInfo, BaseDataSynTableInfo tableInfo) {
        CacheType[] cts = CacheType.values();
        BaseDataPlanCacheTemplate plans = null;
        for (CacheType ct : cts) {
            String key;
            plans = new BaseDataPlanCacheTemplate(ct);
            if (CacheType.SYNHEAD.getValue().equals(ct.getValue()) || CacheType.SYNTABLE.getValue().equals(ct.getValue())) {
                if (null != headInfo.getId() && plans.contains(headInfo.getId().toString())) {
                    plans.remove(headInfo.getId().toString());
                }
                if (StringUtils.isEmpty(headInfo.getNumber()) || !plans.contains(headInfo.getNumber())) continue;
                plans.remove(headInfo.getNumber());
                continue;
            }
            if (!CacheType.SYNCOLUMN.getValue().equals(ct.getValue()) || null == tableInfo.getId() || StringUtils.isEmpty(tableInfo.getTableName()) || !plans.contains(key = tableInfo.getId().toString() + "$$" + tableInfo.getTableName())) continue;
            plans.remove(key);
        }
    }
}

