/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.basedataSynByWsservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.agent.base.ResultInfo;
import com.kingdee.eas.csinterface.agent.service.json.JSONObject;
import com.kingdee.eas.csinterface.agent.service.work.basedata.BillDataStatus;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.DataRow;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.process.impl.BaseDataSynConvertFilter;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.FlatDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.BufferedBillDataProvider;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.BaseDataSaver;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataRunner;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataSynSender;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.basedataSynByWsservice.BaseDataSynUtilByWSService;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.IERPExecute;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.webservice.BaseDataSynWebServiceFactory;
import com.kingdee.eas.csinterface.webservice.BaseDataSynWebServiceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.user.EASBaseDataSynUserHandler;
import com.kingdee.eas.csinterface.webservice.app.handler.user.EASUserHandler;
import com.kingdee.eas.csinterface.webservice.app.handler.user.IERPUserHandler;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;

public class BaseDataSynSenderByWSService
extends BaseDataSynSender {
    private static Logger logger = Logger.getLogger(BaseDataSynSenderByWSService.class);

    public BaseDataSynSenderByWSService(BaseDataRunner baseDataThread, Map<String, String> resultMap, String wsserviceId) {
        super(baseDataThread, resultMap, wsserviceId);
    }

    public String sendWSService() throws Exception {
        ResultInfo resultInfo = null;
        JSONObject json = new JSONObject();
        try {
            String successNum;
            BaseDataSynConvertFilter filter = new BaseDataSynConvertFilter(this.ctx, this.dataModel);
            filter.doFilter(this.baseDataThread.bufferDataProvider.getSendDataRows());
            LinkedList idList = new LinkedList();
            JSONObject mappingJson = new JSONObject();
            ColumnModel[] columModelRow = this.getColumnModelForAdd();
            int length = columModelRow.length;
            LinkedList<String[]> entryRowList = new LinkedList<String[]>();
            HashSet<String> idSet = new HashSet<String>();
            String mainPK = BaseDataSynUtilByWSService.getMainPK(this.dataModel);
            for (DataRow dataRow : this.baseDataThread.bufferDataProvider.getSendDataRows()) {
                this.wrapRowData(columModelRow, length, dataRow, entryRowList, mainPK);
                idList.add(dataRow.getValues().get(dataRow.pkColumn));
                idSet.add("'" + dataRow.getValues().get(dataRow.pkColumn).toString() + "'");
            }
            if (entryRowList.size() == 0) {
                return "";
            }
            BaseDataSaver saver = this.insertIntoDescSystem(columModelRow, entryRowList, mainPK, idSet);
            ArrayList<Object> newIdList = new ArrayList<Object>();
            String existsNum = saver.getExistNumber();
            if (!StringUtils.isEmpty((String)existsNum)) {
                newIdList.addAll(com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converString2List(existsNum, ",", "'"));
            }
            if (!StringUtils.isEmpty((String)(successNum = saver.getSuccessNumber()))) {
                newIdList.addAll(com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converString2List(successNum, ",", "'"));
            }
            this.chunkedWaitAckIDs.put(this.transmitSequenceNumber, newIdList);
            resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
            this.baseDataThread.bufferDataProvider.open(this.ctx);
            this.baseDataThread.bufferDataProvider.feedback(this.transmitChunkedNumber, newIdList, this.connectionId, BillDataStatus.ack, false);
            this.chunkedWaitAckIDs.remove(this.transmitSequenceNumber);
            mappingJson.put("transmitSerialNumber", this.transmitSequenceNumber);
            mappingJson.put("entrys", entryRowList);
            mappingJson.put("colType", this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
            resultInfo.setData(mappingJson.toString());
            resultInfo.setTableName(this.baseDataThread.baseDataSynInfo.getTableName());
            json = new JSONObject(resultInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            resultInfo = (ResultInfo)ResultInfo.STATUS_ERROR.clone();
            resultInfo.setStatusMsg(e.getMessage());
            json = new JSONObject(resultInfo);
            throw new BOSException((Throwable)e);
        }
        return json.toString();
    }

    private void wrapRowData(ColumnModel[] columModelRow, int length, DataRow dataRow, List<String[]> entryRowList, String mainPK) {
        String[] entryRow = new String[columModelRow.length];
        Map data = dataRow.getValues();
        for (int i = 0; i < length; ++i) {
            String columnVal;
            ColumnModel entryColumnModel = columModelRow[i];
            Object obj = null;
            String srcName = entryColumnModel.name;
            String destName = entryColumnModel.destName;
            String key = StringUtils.isEmpty((String)srcName) ? destName : srcName;
            obj = "FID".equalsIgnoreCase(srcName) && !"FID".equalsIgnoreCase(destName) ? (Object)data.get(destName) : (Object)data.get(key);
            String string = columnVal = obj == null ? "" : obj.toString();
            if (destName.equalsIgnoreCase(mainPK)) {
                if (i != 0) {
                    String oldValue = entryRow[0];
                    entryRow[0] = columnVal;
                    entryRow[i] = oldValue;
                    continue;
                }
                entryRow[i] = columnVal;
                continue;
            }
            entryRow[i] = columnVal;
        }
        entryRowList.add(entryRow);
    }

    private void wrapRowData4Change(ColumnModel[] columModelRow, int length, DataRow dataRow, List<String[]> entryRowList, String mainPK) {
        String[] entryRow = new String[columModelRow.length];
        Map data = dataRow.getValues();
        String mainPkValue = "";
        ColumnModel entryColumnModel = null;
        for (int i = 0; i < length; ++i) {
            String columnVal;
            Object obj = null;
            entryColumnModel = columModelRow[i];
            String srcName = entryColumnModel.name;
            String destName = entryColumnModel.destName;
            String key = StringUtils.isEmpty((String)srcName) ? destName : srcName;
            obj = "FID".equalsIgnoreCase(srcName) && !"FID".equalsIgnoreCase(destName) ? (Object)data.get(destName) : (Object)data.get(key);
            String string = columnVal = obj == null ? "" : obj.toString();
            if (destName.equalsIgnoreCase(mainPK)) {
                if (i != 0) {
                    String oldValue = entryRow[0];
                    entryRow[0] = columnVal;
                    entryRow[i] = oldValue;
                    continue;
                }
                entryRow[i] = columnVal;
                continue;
            }
            entryRow[i] = columnVal;
        }
        entryRowList.add(entryRow);
    }

    private ColumnModel[] getColumnModelForAdd() {
        StructuredDataModel.TableModel entryModel = this.baseDataThread.dataModel.getPriorityTables()[1];
        StructuredDataModel.TableModel newModel = this.baseDataThread.dataModel.getPriorityTables()[2];
        Object[] entryColumnModels = entryModel.columns;
        Object[] newColumnModels = newModel.columns;
        return (ColumnModel[])ArrayUtils.addAll((Object[])entryColumnModels, (Object[])newColumnModels);
    }

    private ColumnModel[] getColumnModelForUpdate() {
        StructuredDataModel.TableModel headModel = this.baseDataThread.dataModel.getPriorityTables()[0];
        StructuredDataModel.TableModel entryModel = this.baseDataThread.dataModel.getPriorityTables()[1];
        StructuredDataModel.TableModel newModel = this.baseDataThread.dataModel.getPriorityTables()[2];
        Object[] entryColumnModels = headModel.columns;
        Object[] newColumnModels = newModel.columns;
        ColumnModel[] columns = (ColumnModel[])ArrayUtils.addAll((Object[])entryColumnModels, (Object[])newColumnModels);
        ArrayList<ColumnModel> modelList = new ArrayList<ColumnModel>();
        for (ColumnModel column : columns) {
            if (!column.isChangeSyn) continue;
            modelList.add(column);
        }
        return modelList.toArray(new ColumnModel[0]);
    }

    public String sendUpdateWSService() throws Exception {
        ResultInfo resultInfo = null;
        JSONObject json = new JSONObject();
        try {
            String successNum;
            BaseDataSynConvertFilter filter = new BaseDataSynConvertFilter(this.ctx, this.dataModel);
            filter.doFilter(this.baseDataThread.bufferDataProvider.getSendDataRows());
            LinkedList idList = new LinkedList();
            JSONObject mappingJson = new JSONObject();
            ColumnModel[] columModelRow = this.getColumnModelForUpdate();
            int length = columModelRow.length;
            LinkedList<String[]> entryRowList = new LinkedList<String[]>();
            String mainPK = BaseDataSynUtilByWSService.getMainPK(this.dataModel);
            HashSet<String> idSet = new HashSet<String>();
            for (DataRow dataRow : this.baseDataThread.bufferDataProvider.getSendDataRows()) {
                this.wrapRowData(columModelRow, length, dataRow, entryRowList, mainPK);
                idList.add(dataRow.getValues().get(dataRow.pkColumn));
                idSet.add("'" + dataRow.getValues().get(dataRow.pkColumn).toString() + "'");
            }
            if (entryRowList.size() == 0) {
                return "";
            }
            BaseDataSaver saver = this.updateIntoDescSystem(columModelRow, entryRowList, mainPK, idSet);
            ArrayList<String> newIdList = new ArrayList<String>();
            String existsNum = saver.getExistNumber();
            if (!StringUtils.isEmpty((String)existsNum)) {
                newIdList.addAll(com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converString2List(existsNum, ",", "'"));
            }
            if (!StringUtils.isEmpty((String)(successNum = saver.getSuccessNumber()))) {
                newIdList.addAll(com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converString2List(successNum, ",", "'"));
            }
            this.chunkedWaitAckIDs.put(this.transmitSequenceNumber, newIdList);
            resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
            mappingJson.put("transmitSerialNumber", this.transmitSequenceNumber);
            mappingJson.put("entrys", entryRowList);
            mappingJson.put("colType", this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
            resultInfo.setData(mappingJson.toString());
            resultInfo.setTableName(this.baseDataThread.baseDataSynInfo.getTableName());
            json = new JSONObject(resultInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            resultInfo = (ResultInfo)ResultInfo.STATUS_ERROR.clone();
            resultInfo.setStatusMsg(e.getMessage());
            json = new JSONObject(resultInfo);
            throw new BOSException((Throwable)e);
        }
        return json.toString();
    }

    public void initUpdateDataWSServiceDelete(FlatDataModel flatDataModel) throws Exception {
        HashSet<String> deleteSet = new HashSet<String>();
        BaseDataSaver saver = null;
        BaseDataSynHeadInfo headInfo = null;
        String tableName = this.baseDataThread.baseDataSynInfo.getDestTableName();
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = this.baseDataThread.baseDataSynInfo.getTableName();
        }
        try {
            long t = System.currentTimeMillis();
            String mainPK = BaseDataSynUtilByWSService.getMainPK(this.baseDataThread.dataModel);
            StringBuffer idbuf = new StringBuffer();
            ArrayList<String[]> idList = new ArrayList<String[]>();
            for (String id : flatDataModel.getDeleteIds()) {
                String[] param = new String[]{id};
                idList.add(param);
                idbuf.append(id).append(",");
                deleteSet.add(id);
            }
            idbuf.deleteCharAt(idbuf.length() - 1);
            String wsserviceId = MonitorManager.getCurrent().getExtendedProperty("wsserviceId");
            String webserviceId = MonitorManager.getCurrent().getExtendedProperty("webserviceId");
            if (!StringUtils.isEmpty((String)wsserviceId)) {
                WSServiceInfo wsserviceInfo = WSServiceFactory.getLocalInstance(this.ctx).getWSServiceInfo(CommonUtil.convert2PK(wsserviceId));
                saver = new BaseDataSaver(wsserviceInfo);
                this.sendDataByWSServiceDel(idbuf.toString(), tableName, mainPK);
            }
            if (!StringUtils.isEmpty((String)webserviceId)) {
                BaseDataSynWebServiceInfo baseDataSynWebServiceInfo = BaseDataSynWebServiceFactory.getLocalInstance(this.ctx).getBaseDataSynWebServiceInfo(CommonUtil.convert2PK(webserviceId));
                saver = new BaseDataSaver(baseDataSynWebServiceInfo);
                this.sendDataByWebServiceDel(idbuf.toString(), tableName, mainPK);
            }
            String agent4http = MonitorManager.getCurrent().getExtendedProperty("agentId4http");
            StringBuffer deleteSQL = new StringBuffer();
            deleteSQL.append("delete from ").append(this.baseDataThread.baseDataSynInfo.getPkTableName()).append(" where headpk = ?").append(" and agentid = '" + agent4http + "'");
            DbUtil.executeBatch((Context)this.ctx, (String)deleteSQL.toString(), idList);
            t = System.currentTimeMillis() - t;
            logger.info((Object)("fetch update" + flatDataModel.getDeleteIds().size() + " rows, elapsed time : " + t + " ms"));
            headInfo = BaseDataSynHeadFactory.getLocalInstance(this.ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(this.baseDataThread.baseDataSynInfo.getParent().getId().toString()));
            saver.setSuccessNumber(deleteSet);
        }
        catch (Exception e) {
            logger.error((Object)"Eip:delete descSystem data fail!");
            saver.setExistNumber(deleteSet);
            throw new Exception(e);
        }
        finally {
            try {
                if (headInfo != null) {
                    BufferedBillDataProvider.saveSubMonitorlog(this.ctx, saver, tableName, "del", this.baseDataThread.baseDataSynInfo.isMainTable(), headInfo.getNumber());
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteDescSystem(String idList, String tableName, String mainPK) throws BOSException {
        String wsserviceId = MonitorManager.getCurrent().getExtendedProperty("wsserviceId");
        String webserviceId = MonitorManager.getCurrent().getExtendedProperty("webserviceId");
        if (StringUtils.isEmpty((String)wsserviceId)) {
            this.sendDataByWSServiceDel(idList, tableName, mainPK);
        } else if (!StringUtils.isEmpty((String)webserviceId)) {
            this.sendDataByWebServiceDel(idList, tableName, mainPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseDataSaver updateIntoDescSystem(ColumnModel[] columModelRow, List<String[]> dataList, String mainPK, Set<String> idSet) throws Exception {
        String webserviceId;
        BaseDataSynHeadInfo headInfo = BaseDataSynHeadFactory.getLocalInstance(this.ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(this.baseDataThread.baseDataSynInfo.getParent().getId().toString()));
        String tableName = this.baseDataThread.baseDataSynInfo.getDestTableName();
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = this.baseDataThread.baseDataSynInfo.getTableName();
        }
        long beginUpdateTime = System.currentTimeMillis();
        BaseDataSaver saver = null;
        String wsserviceId = MonitorManager.getCurrent().getExtendedProperty("wsserviceId");
        if (!StringUtils.isEmpty((String)wsserviceId)) {
            WSServiceInfo serviceInfo = IERPExecute.getWSServiceInfo(this.ctx, wsserviceId, "");
            if (serviceInfo.getTree().getNumber().toUpperCase().indexOf("IERP") > -1) {
                saver = new BaseDataSaver(serviceInfo);
                this.sendDataToIERPUpdate(saver, idSet, dataList, tableName, mainPK, columModelRow, this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
            } else {
                WSServiceInfo wsserviceInfo = WSServiceFactory.getLocalInstance(this.ctx).getWSServiceInfo(CommonUtil.convert2PK(wsserviceId));
                saver = new BaseDataSaver(wsserviceInfo);
                this.sendDataByWSServiceUpdate(saver, idSet, dataList, tableName, mainPK, columModelRow, this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
            }
        }
        if (!StringUtils.isEmpty((String)(webserviceId = MonitorManager.getCurrent().getExtendedProperty("webserviceId")))) {
            BaseDataSynWebServiceInfo webServiceInfo = BaseDataSynWebServiceFactory.getLocalInstance(this.ctx).getBaseDataSynWebServiceInfo(CommonUtil.convert2PK(webserviceId));
            saver = new BaseDataSaver(webServiceInfo);
            this.sendDataByWebServiceUpdate(saver, idSet, dataList, tableName, mainPK, columModelRow, this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
        }
        long endUpdateTime = System.currentTimeMillis();
        try {
            this.baseDataThread.bufferDataProvider.open(this.ctx);
            this.baseDataThread.bufferDataProvider.feedbackChangeForJDBC(this.baseDataThread.bufferDataProvider.getReadBillBase(), this.connectionId, "-1", -1, BillDataStatus.ack);
        }
        finally {
            this.baseDataThread.bufferDataProvider.close();
            SubMonitorLogFactory.getLocalInstance(this.ctx).addLogWithoutTrans(saver, tableName, "update", this.baseDataThread.baseDataSynInfo.isMainTable(), headInfo.getNumber());
            StringBuffer execMsg = new StringBuffer();
            execMsg.append("\u66f4\u65b0\u76ee\u6807\u6570\u636e\u5e93\u8017\u65f6\uff1a" + (endUpdateTime - beginUpdateTime) + "ms \r");
            ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo(execMsg.toString());
            long subLogTime = System.currentTimeMillis();
            execMsg.append("\u8bb0\u5f55\u5b50\u65e5\u5fd7\u8017\u65f6\uff1a" + (subLogTime - endUpdateTime) + "ms \r");
        }
        return saver;
    }

    private BaseDataSaver insertIntoDescSystem(ColumnModel[] columModelRow, List<String[]> dataList, String mainPK, Set<String> idSet) throws Exception {
        String tableName = this.baseDataThread.baseDataSynInfo.getDestTableName();
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = this.baseDataThread.baseDataSynInfo.getTableName();
        }
        BaseDataSaver saver = null;
        BaseDataSynHeadInfo headInfo = BaseDataSynHeadFactory.getLocalInstance(this.ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(this.baseDataThread.baseDataSynInfo.getParent().getId().toString()));
        long beginInsertTime = System.currentTimeMillis();
        StringBuffer execMsg = new StringBuffer();
        try {
            String webserviceId;
            String wsserviceId = MonitorManager.getCurrent().getExtendedProperty("wsserviceId");
            if (!StringUtils.isEmpty((String)wsserviceId)) {
                WSServiceInfo serviceInfo = IERPExecute.getWSServiceInfo(this.ctx, wsserviceId, "");
                if (serviceInfo.getTree().getNumber().toUpperCase().indexOf("IERP") > -1) {
                    saver = new BaseDataSaver(serviceInfo);
                    this.sendDataToIERPAdd(saver, idSet, dataList, tableName, mainPK, columModelRow, this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
                } else {
                    serviceInfo = WSServiceFactory.getLocalInstance(this.ctx).getWSServiceInfo(CommonUtil.convert2PK(wsserviceId));
                    saver = new BaseDataSaver(serviceInfo);
                    this.sendDataByWSServiceAdd(saver, idSet, dataList, tableName, mainPK, columModelRow, this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
                }
            }
            if (!StringUtils.isEmpty((String)(webserviceId = MonitorManager.getCurrent().getExtendedProperty("webserviceId")))) {
                BaseDataSynWebServiceInfo webServiceInfo = BaseDataSynWebServiceFactory.getLocalInstance(this.ctx).getBaseDataSynWebServiceInfo(CommonUtil.convert2PK(webserviceId));
                saver = new BaseDataSaver(webServiceInfo);
                this.sendDataByWebServiceAdd(saver, idSet, dataList, tableName, mainPK, columModelRow, this.getColumnTypes(this.baseDataThread.baseDataSynInfo));
            }
        }
        catch (Exception e) {
            saver.setFailureNumber(idSet);
            throw new BOSException((Throwable)e);
        }
        finally {
            long endInsertTime = System.currentTimeMillis();
            execMsg.append("\u63d2\u5165\u76ee\u6807\u6570\u636e\u5e93\u8017\u65f6\uff1a" + (endInsertTime - beginInsertTime) + "ms \r");
            SubMonitorLogFactory.getLocalInstance(this.ctx).addLogWithoutTrans(saver, tableName, "add", this.baseDataThread.baseDataSynInfo.isMainTable(), headInfo.getNumber());
            long subLogTime = System.currentTimeMillis();
            execMsg.append("\u8bb0\u5f55\u5b50\u65e5\u5fd7\u8017\u65f6\uff1a" + (subLogTime - endInsertTime) + "ms \r");
            ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo(execMsg.toString());
        }
        return saver;
    }

    private void sendDataByWSServiceDel(String dataList, String tableName, String mainPK) throws BOSException {
        String returnValue = EASUserHandler.sendDataToEasForDel(this.ctx, dataList, tableName, mainPK, "3");
        if (StringUtils.isEmpty((String)returnValue)) {
            throw new BOSException();
        }
    }

    private void sendDataByWebServiceDel(String dataList, String tableName, String mainPK) throws BOSException {
        String returnValue = EASBaseDataSynUserHandler.sendDataToEasForDel(this.ctx, dataList, tableName, mainPK, "3");
        if (StringUtils.isEmpty((String)returnValue)) {
            throw new BOSException();
        }
    }

    private void sendDataByWSServiceUpdate(BaseDataSaver baseData, Set<String> idSet, List<String[]> dataList, String tableName, String mainPK, ColumnModel[] colNameRaw, Map<String, String> getColumnTypes) throws BOSException {
        String returnValue = EASUserHandler.sendDataToEasforAdd2Update(this.ctx, dataList, tableName, mainPK, colNameRaw, getColumnTypes, "2");
        if (StringUtils.isEmpty((String)returnValue)) {
            throw new BOSException();
        }
        this.converStringToSet(baseData, returnValue, idSet);
    }

    private void sendDataToIERPUpdate(BaseDataSaver baseData, Set<String> idSet, List<String[]> dataList, String tableName, String mainPK, ColumnModel[] colNameRaw, Map<String, String> getColumnTypes) throws BOSException {
        String returnValue = IERPUserHandler.sendDataforAdd2Update(this.ctx, dataList, tableName, mainPK, colNameRaw, getColumnTypes, "2", baseData.getWSService());
        if (StringUtils.isEmpty((String)returnValue)) {
            throw new BOSException();
        }
        this.converStringToSet(baseData, returnValue, idSet);
    }

    private void sendDataByWebServiceUpdate(BaseDataSaver baseData, Set<String> idSet, List<String[]> dataList, String tableName, String mainPK, ColumnModel[] colNameRaw, Map<String, String> getColumnTypes) throws BOSException {
        String returnValue = EASBaseDataSynUserHandler.sendDataToEasforAdd2Update(this.ctx, dataList, tableName, mainPK, colNameRaw, getColumnTypes, "2");
        if (StringUtils.isEmpty((String)returnValue)) {
            throw new BOSException();
        }
        this.converStringToSet(baseData, returnValue, idSet);
    }

    private void sendDataByWSServiceAdd(BaseDataSaver baseData, Set<String> idSet, List<String[]> dataList, String tableName, String mainPK, ColumnModel[] colNameRaw, Map<String, String> getColumnTypes) throws BOSException {
        String returnValue = EASUserHandler.sendDataToEasforAdd2Update(this.ctx, dataList, tableName, mainPK, colNameRaw, getColumnTypes, "1");
        if (StringUtils.isEmpty((String)returnValue)) {
            throw new BOSException();
        }
        this.converStringToSet(baseData, returnValue, idSet);
    }

    private void sendDataToIERPAdd(BaseDataSaver baseData, Set<String> idSet, List<String[]> dataList, String tableName, String mainPK, ColumnModel[] colNameRaw, Map<String, String> getColumnTypes) throws BOSException {
        String returnValue = IERPUserHandler.sendDataforAdd2Update(this.ctx, dataList, tableName, mainPK, colNameRaw, getColumnTypes, "1", baseData.getWSService());
        if (StringUtils.isEmpty((String)returnValue)) {
            throw new BOSException();
        }
        this.converStringToSet(baseData, returnValue, idSet);
    }

    private void sendDataByWebServiceAdd(BaseDataSaver baseData, Set<String> idSet, List<String[]> dataList, String tableName, String mainPK, ColumnModel[] colNameRaw, Map<String, String> getColumnTypes) throws BOSException {
        String returnValue = EASBaseDataSynUserHandler.sendDataToEasforAdd2Update(this.ctx, dataList, tableName, mainPK, colNameRaw, getColumnTypes, "1");
        if (StringUtils.isEmpty((String)returnValue)) {
            throw new BOSException();
        }
        this.converStringToSet(baseData, returnValue, idSet);
    }

    private void converStringToSet(BaseDataSaver baseData, String returnValue, Set<String> idSet) {
        com.alibaba.fastjson.JSONObject jsonOjbect = com.alibaba.fastjson.JSONObject.parseObject((String)returnValue);
        List<String> list1 = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converString2List(jsonOjbect.get((Object)"ExistId").toString(), ",", "");
        HashSet<String> existNumber = new HashSet<String>(list1);
        baseData.setExistNumber(existNumber);
        List<String> list2 = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converString2List(jsonOjbect.get((Object)"SuccessId").toString(), ",", "");
        HashSet<String> successNumber = new HashSet<String>(list2);
        baseData.setSuccessNumber(successNumber);
        idSet.removeAll(successNumber);
        idSet.removeAll(existNumber);
        baseData.setFailureNumber(idSet);
    }

    public static JsonNode deleteDescSystem(Context ctx, String idList, String tableName, String mainPK, String delMethod) throws BOSException {
        String webserviceId = MonitorManager.getCurrent().getExtendedProperty("webserviceId");
        JsonNode r = null;
        if (!StringUtils.isEmpty((String)webserviceId)) {
            r = BaseDataSynSenderByWSService.sendDataByWebServiceDel(ctx, idList, tableName, mainPK, delMethod);
        }
        return r;
    }

    private static JsonNode sendDataByWebServiceDel(Context ctx, String dataList, String tableName, String mainPK, String delMethod) throws BOSException {
        return EASBaseDataSynUserHandler.baseWebSendDataToEasForDel(ctx, dataList, tableName, mainPK, delMethod);
    }
}

