/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.BillDataStatus;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.ObjectPKInfo;
import com.kingdee.eas.csinterface.agent.service.work.basedata.snapshot.ChangefulBillData;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataRunner;
import com.kingdee.eas.csinterface.agent.service.work.basedata.util.DataModelUtil;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynPublisherFacadeFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSpecialSQLCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSpecialSQLFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSpecialSQLInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSubPlanCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynHead;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.KeyTableUtil;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BaseDataInitialPKtableUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataInitialPKtableUtil");
    public static final int NEW_BASEDATA_PLAN = 0;
    public static final int NORMAL_BASEDATA_PLAN = 1;
    private ConnectionInfo connInfo = null;
    private EipUserInfo agentInfo = null;
    private List<BaseDataSynHeadInfo> findPlanList = new ArrayList<BaseDataSynHeadInfo>();
    private List<String> unknowPlanList = new ArrayList<String>();
    private FileOutputStream writer = null;
    private String recordFilePath = "";
    private Set<String> hasDelInvalidRecordTable = new HashSet<String>();
    private static Map<String, List<String>> exectingBaseDataMaping = new HashMap<String, List<String>>();

    private List<String> getExecutingPlan(String agentId) {
        return exectingBaseDataMaping.get(agentId);
    }

    public BaseDataInitialPKtableUtil getInstance() {
        return new BaseDataInitialPKtableUtil();
    }

    public String initPKTable(Context ctx, List planNumList, boolean initAnyway, int type, String dbType, String connNum, String agentNum, String userNum, Map specialSQL, Map extendsParam) throws BOSException, EASBizException {
        String result = null;
        BaseDataInitialPKtableUtil.checkParamValid(ctx, planNumList, initAnyway, type, dbType, connNum, agentNum, userNum, specialSQL, extendsParam);
        this.checkParamExist(ctx, planNumList, initAnyway, connNum, agentNum);
        if (0 == type) {
            this.execNewBaseDataPlan(ctx, initAnyway, dbType, connNum, agentNum, userNum, specialSQL, extendsParam);
        } else if (1 == type) {
            // empty if block
        }
        if (!StringUtils.isEmpty((String)userNum)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
            String msgTitle = "EIP \u57fa\u7840\u8d44\u6599\u540c\u6b65\u521d\u59cb\u5316_" + format.format(new Date());
            String msgSender = "\u7cfb\u7edf";
            String msgBody = "\u57fa\u7840\u8d44\u6599\u540c\u6b65\u521d\u59cb\u5316\u5df2\u7ecf\u6267\u884c\u5b8c\u6bd5\uff0c\u56e0\u5185\u5bb9\u8fc7\u591a\u4e0d\u80fd\u5728\u96c6\u6210\u72b6\u6001\u67e5\u770b\u91cc\u5c55\u793a\u3002\r\n\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u53d6\u5f97\u670d\u52a1\u5668\u91cc\u8bb0\u5f55\u7684\u65e5\u5fd7\u6587\u4ef6\uff0c\u5e76\u786e\u8ba4\u6267\u884c\u60c5\u51b5\u3002\r\n\u65e5\u5fd7\u6587\u4ef6\u5b8c\u6574\u8def\u5f84\u4e3a\uff1a" + this.recordFilePath;
            List<String> userList = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converString2List(userNum, ",", "");
            ArrayList<String> userIDList = new ArrayList<String>();
            StringBuffer userBf = new StringBuffer();
            for (int i = 0; i < userList.size(); ++i) {
                if (i > 0) {
                    userBf.append(",");
                }
                userBf.append("'" + userList.get(i) + "'");
            }
            UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where number in(" + userBf.toString() + ")");
            Iterator userIte = userColl.iterator();
            while (userIte.hasNext()) {
                userIDList.add(((UserInfo)userIte.next()).getId().toString());
            }
            if (userIDList.size() > 0) {
                MonitorManager.sendByMessage(ctx, msgTitle, msgSender, msgBody, userIDList);
            }
        }
        return result;
    }

    private String execNewBaseDataPlan(Context ctx, boolean initAnyway, String dbType, String connNum, String agentNum, String userNum, Map specialSQL, Map extendsParam) throws BOSException, EASBizException {
        String spSQL = "";
        String planNum = "";
        String agentId = this.connInfo == null ? this.agentInfo.getId().toString() : this.connInfo.getId().toString();
        long totalPlanBegin = System.currentTimeMillis();
        StringBuffer eachPlanMsgBuf = null;
        for (BaseDataSynHeadInfo planInfo : this.findPlanList) {
            spSQL = specialSQL == null ? "" : specialSQL.get(planNum);
            String errorMsg = "";
            eachPlanMsgBuf = new StringBuffer();
            eachPlanMsgBuf.append("********************\r\n");
            eachPlanMsgBuf.append("\u540c\u6b65\u65b9\u6848\uff1a" + planInfo.getNumber() + "\uff08" + planInfo.getName() + "\uff09\r");
            this.recordMessage(eachPlanMsgBuf.toString());
            long begin = System.currentTimeMillis();
            try {
                this.expandPlan(ctx, planInfo, spSQL == null ? "" : spSQL.toString(), agentId, initAnyway);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                BOSException cause = e;
                errorMsg = "\u6267\u884c\u4e2d\u65ad\uff1a\r" + ThrowableHelper.toString(cause) + "\r";
                throw e;
            }
            finally {
                long end = System.currentTimeMillis();
                String execTime = end - begin + "ms";
                eachPlanMsgBuf = new StringBuffer();
                eachPlanMsgBuf.append("\u6267\u884c\u603b\u8017\u65f6\uff1a" + execTime + "\r");
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    eachPlanMsgBuf.append(errorMsg);
                }
                eachPlanMsgBuf.append("\r\n");
                this.recordMessage(eachPlanMsgBuf.toString());
                long totalPlanEnd = System.currentTimeMillis();
                String totalMsg = "\r\n--------------\u6b64\u6b21\u521d\u59cb\u5316\u603b\u8017\u65f6\uff1a" + (totalPlanEnd - totalPlanBegin) + "ms --------------\r\n";
                this.recordMessage(totalMsg);
                if (this.writer == null) continue;
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void expandPlan(Context ctx, BaseDataSynHeadInfo baseDataSynInfo, String specialSQL, String agentId, boolean initAnyway) throws BOSException, EASBizException {
        boolean isMultiPlan = baseDataSynInfo.isMultiPlan();
        if (isMultiPlan) {
            BaseDataSynSubPlanCollection subPlans = baseDataSynInfo.getPlans();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < subPlans.size(); ++i) {
                idSet.add(subPlans.get(i).getSubPlanId());
            }
            String[] idArray = idSet.toArray(new String[0]);
            IBaseDataSynHead instance = BaseDataSynHeadFactory.getLocalInstance(ctx);
            Map map = instance.convertId2CoreBaseInfo(idArray);
            for (CoreBaseInfo baseInfo : map.values()) {
                BaseDataSynHeadInfo subPlan = (BaseDataSynHeadInfo)baseInfo;
                if (subPlan.isMultiPlan()) {
                    this.expandPlan(ctx, subPlan, specialSQL, agentId, initAnyway);
                    continue;
                }
                this.execEachPlan(ctx, subPlan, specialSQL, agentId, initAnyway);
            }
        } else {
            this.execEachPlan(ctx, baseDataSynInfo, specialSQL, agentId, initAnyway);
        }
    }

    private void execEachPlan(Context ctx, BaseDataSynHeadInfo baseDataSynInfo, String extendSQL, String agentId, boolean initAnyway) throws BOSException, EASBizException {
        String planId = baseDataSynInfo.getId().toString();
        String planNum = baseDataSynInfo.getNumber();
        String planDesc = baseDataSynInfo.getNumber() + "(" + baseDataSynInfo.getName() + ")";
        StringBuffer bf = new StringBuffer();
        String tempTableName = "";
        try {
            boolean hasInit;
            boolean hasPublish = BaseDataSynUtil.checkPlanHasPublish(ctx, baseDataSynInfo);
            if (!hasPublish) {
                BaseDataSynPublisherFacadeFactory.getLocalInstance(ctx).publish(planId);
            }
            if (!initAnyway && (hasInit = BaseDataSynUtil.checkPlanHasInit(ctx, baseDataSynInfo, "", agentId))) {
                throw new DIPException("\u5df2\u7ecf\u540c\u6b65\u8fc7\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u521d\u59cb\u5316\u3002");
            }
            tempTableName = this.getMainPKListForAdd(ctx, baseDataSynInfo, agentId);
            this.recordMessage(bf.toString());
            Connection conn = null;
            PreparedStatement preStmt = null;
            ResultSet preRs = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                conn = SQLUtil.getKSQLConnection(ctx);
                Integer totalSize = 0;
                String totalSizeSQL = "SELECT count(*) count FROM " + tempTableName;
                stmt = conn.createStatement();
                rs = stmt.executeQuery(totalSizeSQL);
                while (rs.next()) {
                    totalSize = rs.getInt("count");
                }
                if (totalSize == 0) {
                    throw new DIPException("\u672a\u53d1\u73b0\u9700\u8981\u540c\u6b65\u7684\u6570\u636e");
                }
                this.recordMessage("\u65b9\u6848\u4e3b\u8868\u6570\u636e\u91cf\uff1a" + totalSize);
                int PAGESIZE = 100000;
                int totalPage = (totalSize - 1) / PAGESIZE + 1;
                int beginIndex = 0;
                int endIndex = 0;
                String batchSQL = "SELECT fid FROM " + tempTableName + "  WHERE KSQL_SEQ > ? AND KSQL_SEQ <= ? ORDER BY KSQL_SEQ ASC";
                preStmt = conn.prepareStatement(batchSQL);
                for (int i = 0; i < totalPage; ++i) {
                    beginIndex = i * PAGESIZE;
                    endIndex = (i + 1) * PAGESIZE;
                    endIndex = endIndex > totalSize ? totalSize : endIndex;
                    preStmt.setInt(1, beginIndex);
                    preStmt.setInt(2, endIndex);
                    preRs = preStmt.executeQuery();
                    ArrayList<String> pkList = new ArrayList<String>();
                    while (preRs.next()) {
                        pkList.add(preRs.getString("fid"));
                    }
                    List<String> tmpPKList = null;
                    String mainTableFIDs = null;
                    int PAGESIZE2 = 999;
                    int totalSize2 = pkList.size();
                    int totalPage2 = (totalSize2 - 1) / PAGESIZE2 + 1;
                    int beginIndex2 = 0;
                    int endIndex2 = 0;
                    List<BaseDataSynTableInfo> sortedTableColl = BaseDataSynUtil.getSortedTablesDesc(baseDataSynInfo);
                    bf.append("\u5171\u5206" + totalPage2 + " \u6279\u6267\u884c \r");
                    HashMap<String, Integer> tableRecordCountMap = new HashMap<String, Integer>();
                    for (BaseDataSynTableInfo tableInfo : sortedTableColl) {
                        String tableName = tableInfo.getTableName();
                        bf.append("\u6267\u884c\u7684\u8868\u540d\uff1a" + tableName + "\r");
                        long beginTime = System.currentTimeMillis();
                        for (int k = 0; k < totalPage2; ++k) {
                            long eachBegin = System.currentTimeMillis();
                            beginIndex2 = k * PAGESIZE2;
                            endIndex2 = (k + 1) * PAGESIZE2;
                            endIndex2 = endIndex2 > totalSize2 ? totalSize2 : endIndex2;
                            tmpPKList = pkList.subList(beginIndex2, endIndex2);
                            mainTableFIDs = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(tmpPKList, ",", "'");
                            Integer beginCount = (Integer)tableRecordCountMap.get(tableName);
                            beginCount = beginCount == null ? 0 : beginCount;
                            this.initEachTable(ctx, tableInfo, agentId, mainTableFIDs, tableRecordCountMap);
                            Integer nowCount = (Integer)tableRecordCountMap.get(tableName);
                            long eachEnd = System.currentTimeMillis();
                            bf.append("\u7b2c" + (k + 1) + "\u6279\uff0c\u6570\u636e\u91cf\uff1a" + (nowCount - beginCount) + "\uff0c\u8017\u65f6" + (eachEnd - eachBegin) + "ms \r");
                        }
                        long endTime = System.currentTimeMillis();
                        bf.append("\u603b\u6570\u636e\u91cf\uff1a" + tableRecordCountMap.get(tableName) + "\r");
                        bf.append("\u603b\u8017\u65f6\uff1a" + (endTime - beginTime) + "ms \r\n\r\n");
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    SQLUtil.cleanup(rs, stmt, conn);
                    SQLUtil.cleanup(preRs, preStmt, null);
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                    throw throwable;
                }
            }
            SQLUtil.cleanup(rs, stmt, conn);
            SQLUtil.cleanup(preRs, preStmt, null);
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
        catch (DIPException e) {
            bf.append("\u6267\u884c\u4e2d\u65ad\uff1a" + e.getMessage().toString() + "\r");
            throw new BOSException("\u6267\u884c\u4e2d\u65ad\uff1a", (Throwable)e);
        }
        catch (Exception e) {
            Exception cause = e;
            bf.append("\u6267\u884c\u4e2d\u65ad\uff1a\r" + ThrowableHelper.toString((Throwable)cause) + "\r");
            throw new BOSException("\u6267\u884c\u4e2d\u65ad\uff1a", (Throwable)e);
        }
        finally {
            this.recordMessage(bf.toString());
            this.hasDelInvalidRecordTable.clear();
        }
    }

    private void initEachTable(Context ctx, BaseDataSynTableInfo tableInfo, String agentId, String mainTableFIDs, Map<String, Integer> tableRecordCountMap) throws Exception {
        String pkTableName = tableInfo.getPkTableName().replace("\"", "");
        if (!tableInfo.isMainTable() && !this.hasDelInvalidRecordTable.contains(pkTableName)) {
            BaseDataRunner.deleteInvalidRecord(ctx, pkTableName, agentId);
            this.hasDelInvalidRecordTable.add(pkTableName);
        }
        StructuredDataModel dataModel = DataModelUtil.convert(tableInfo, ctx, true);
        List<ObjectPKInfo> readBillBase = BaseDataInitialPKtableUtil.prepareInsertData(ctx, dataModel, tableInfo, agentId, mainTableFIDs);
        int recordCount = readBillBase.size();
        this.recordCount(tableRecordCountMap, tableInfo.getTableName(), readBillBase.size());
        if (recordCount == 0) {
            return;
        }
        BaseDataInitialPKtableUtil.insertPKTable(ctx, readBillBase, agentId, "-1", -1, pkTableName);
    }

    private void recordCount(Map<String, Integer> tableRecordCountMap, String tableName, int addedSize) {
        Integer hasCount = tableRecordCountMap.get(tableName);
        if (hasCount == null) {
            hasCount = 0;
        }
        tableRecordCountMap.put(tableName, hasCount + addedSize);
    }

    private static List<ObjectPKInfo> prepareInsertData(Context ctx, StructuredDataModel dataModel, BaseDataSynTableInfo tableInfo, String agentId, String mainTableFIDs) throws Exception {
        ArrayList<ObjectPKInfo> readBillBase = new ArrayList<ObjectPKInfo>();
        boolean isMainTable = tableInfo.isMainTable();
        String querySQL = BaseDataInitialPKtableUtil.initQueryString(ctx, dataModel, tableInfo, tableInfo.getRelateSQL(), Integer.MAX_VALUE, mainTableFIDs, agentId);
        Connection dbConn = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            dbConn = SQLUtil.getKSQLConnection(ctx);
            stmt = dbConn.prepareStatement(querySQL);
            String[] sortedChangefulFields = null;
            sortedChangefulFields = isMainTable ? ChangefulBillData.getSortedChangefulFields4BaseData(dataModel) : ChangefulBillData.getSortedChangefulFields(dataModel);
            ChangefulBillData changefulBillData = new ChangefulBillData(sortedChangefulFields, true, DBUtil.isOracle((Connection)dbConn));
            Object headpkVal = "";
            String pkField = BaseDataInitialPKtableUtil.getPKFieldName(dataModel);
            int rowCount = 0;
            rs = stmt.executeQuery();
            while (rs.next()) {
                ++rowCount;
                headpkVal = rs.getObject(pkField);
                if (headpkVal == null) {
                    throw new NullPointerException("headpk column value is null!");
                }
                Object mianPK = null;
                if (!isMainTable) {
                    mianPK = rs.getObject("mainPK");
                }
                if (changefulBillData == null) continue;
                if (isMainTable) {
                    changefulBillData.appendFieldBytes4MainTable(rs);
                    readBillBase.add(new ObjectPKInfo(headpkVal, "", changefulBillData.getNewChangeTime(), mianPK));
                    continue;
                }
                changefulBillData.appendFieldBytes(rs);
                changefulBillData.snapshot();
                readBillBase.add(new ObjectPKInfo(headpkVal, changefulBillData.getNewHashCode(), "", mianPK));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(rs, stmt, dbConn);
                throw throwable;
            }
        }
        SQLUtil.cleanup(rs, stmt, dbConn);
        return readBillBase;
    }

    private static String getPKFieldName(StructuredDataModel dataModel) {
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        StructuredDataModel.TableModel entry = tableModels[1];
        String entryPkName = "fid";
        for (int i = 0; i < entry.columns.length; ++i) {
            if (!entry.columns[i].isPk) continue;
            entryPkName = entry.columns[i].name;
            break;
        }
        return entryPkName;
    }

    private static String initQueryString(Context ctx, StructuredDataModel dataModel, BaseDataSynTableInfo tableInfo, String relateSQL, int pageSize, String mainTableFIDs, String agentId) {
        String specialSQL;
        String mainTableField;
        boolean isMainTable = tableInfo.isMainTable();
        String srcWhere = tableInfo.getSrcWhere();
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        StringBuilder sqlBuf = new StringBuilder();
        sqlBuf.append("select distinct top ").append(pageSize).append(" ");
        String headPkName = null;
        String entryPkName = null;
        boolean colHeadNum = false;
        int colEntryNum = 0;
        String AS_NAME = "t1.";
        String ALIAS_NAME = "t1";
        for (int i = 0; i < entry.columns.length; ++i) {
            if (colEntryNum > 0) {
                sqlBuf.append(", ");
            }
            if (entry.columns[i].isPk) {
                entryPkName = entry.columns[i].name;
            }
            sqlBuf.append(AS_NAME).append(entry.columns[i].name);
            ++colEntryNum;
        }
        if (!(StringUtils.isEmpty((String)relateSQL) || StringUtils.isEmpty((String)(mainTableField = relateSQL.substring(relateSQL.lastIndexOf("and") + 3, relateSQL.lastIndexOf("in(")))) || StringUtils.endsWithIgnoreCase((String)relateSQL, (String)mainTableField))) {
            sqlBuf.append(" , ").append(mainTableField).append(" ").append("mainPK");
        }
        sqlBuf.append(" from ").append(tableInfo.getTableName()).append(" " + ALIAS_NAME);
        if (!StringUtils.isEmpty((String)relateSQL) && (relateSQL = relateSQL.replace(tableInfo.getTableName() + ".", AS_NAME)) != null) {
            relateSQL = relateSQL.replace("${fid}", mainTableFIDs);
            sqlBuf.append(relateSQL);
        }
        sqlBuf.append(" where ");
        if (isMainTable && !StringUtils.isEmpty((String)mainTableFIDs)) {
            sqlBuf.append(" " + ALIAS_NAME + ".fid in (" + mainTableFIDs + ") ");
        }
        if (!isMainTable) {
            sqlBuf.append(" not exists(select 1 from ").append(tableInfo.getPkTableName().replaceAll("\"", "")).append(" p").append(" where " + AS_NAME).append(entryPkName).append(" = p.").append("headpk AND p.agentId = '" + agentId + "'").append(")");
        }
        if (!StringUtils.isEmpty((String)srcWhere)) {
            if (StringUtils.startsWithIgnoreCase((String)srcWhere, (String)"where")) {
                srcWhere = StringUtils.replaceIgnoreCase((String)srcWhere, (String)"where", (String)"");
                srcWhere = srcWhere.replace(tableInfo.getTableName() + ".", AS_NAME);
            }
            if (srcWhere.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(srcWhere);
            } else {
                sqlBuf.append(" and ").append(srcWhere);
            }
        }
        if (isMainTable && !StringUtils.isEmpty((String)(specialSQL = BaseDataInitialPKtableUtil.getSpecialSQL(ctx, tableInfo, agentId)))) {
            if (StringUtils.startsWithIgnoreCase((String)specialSQL, (String)"where")) {
                specialSQL = StringUtils.replaceIgnoreCase((String)specialSQL, (String)"where", (String)"");
            }
            if (specialSQL.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(specialSQL);
            } else {
                sqlBuf.append(" and ").append(specialSQL);
            }
        }
        if (!StringUtils.isEmpty(headPkName) && !StringUtils.isEmpty((String)entryPkName)) {
            sqlBuf.append(" order by ").append(AS_NAME).append(headPkName).append(", " + AS_NAME).append(entryPkName).append(" asc");
        } else if (StringUtils.isEmpty(headPkName)) {
            sqlBuf.append(" order by ").append(AS_NAME).append("FID").append(" asc");
        } else {
            sqlBuf.append(" order by ").append(AS_NAME).append(headPkName).append(" asc");
        }
        return sqlBuf.toString();
    }

    public static String getSpecialSQL(Context ctx, BaseDataSynTableInfo tableInfo, String agentId) {
        String sql = null;
        EntityViewInfo view = new EntityViewInfo();
        try {
            Iterator it;
            String headId = tableInfo.getParent().getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)headId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("connnection.id", (Object)agentId, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            view.setFilter(filter);
            BaseDataSynSpecialSQLCollection coll = BaseDataSynSpecialSQLFactory.getLocalInstance(ctx).getBaseDataSynSpecialSQLCollection(view);
            if (coll.size() > 0 && (it = coll.iterator()).hasNext()) {
                BaseDataSynSpecialSQLInfo specialSQL = (BaseDataSynSpecialSQLInfo)it.next();
                sql = specialSQL.getSql();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return sql;
    }

    private static void insertPKTable(Context ctx, List<ObjectPKInfo> readBillBase, String agentId, String transmitSerialNumber, int transmitChunkedNumber, String pkTableName) throws SQLException, Exception {
        if (readBillBase == null && readBillBase.size() == 0) {
            return;
        }
        Connection dbConn = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into " + pkTableName).append("(").append("headpk").append(",").append("transmitChunkedNumber,").append("transmitSerialNumber,").append("hashCode").append(", ").append("changeTime").append(", ").append("status,").append("agentId,").append("createTime").append(", ").append("mainPK").append(") values (?,?,?,?,?,?,?,?,?)").toString();
        try {
            dbConn = SQLUtil.getKSQLConnection(ctx);
            stmt = dbConn.prepareStatement(insertSQL.toString());
            long t = System.currentTimeMillis();
            Date date = new Date(t);
            Timestamp nowTimes = new Timestamp(date.getTime());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            for (int i = 0; i < readBillBase.size(); ++i) {
                int index = 1;
                stmt.setObject(index++, readBillBase.get((int)i).headpk);
                stmt.setInt(index++, transmitChunkedNumber);
                stmt.setString(index++, transmitSerialNumber);
                stmt.setString(index++, readBillBase.get((int)i).hashCode);
                boolean nullTime = StringUtils.isEmpty((String)readBillBase.get((int)i).changeTime);
                try {
                    if (!nullTime) {
                        date = sdf.parse(readBillBase.get((int)i).changeTime);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                stmt.setTimestamp(index++, nullTime ? null : new Timestamp(date.getTime()));
                stmt.setInt(index++, BillDataStatus.ack.getValue());
                stmt.setString(index++, agentId);
                stmt.setTimestamp(index++, nowTimes);
                stmt.setObject(index++, readBillBase.get((int)i).mainPK);
                stmt.addBatch();
            }
            stmt.executeBatch();
            try {
                dbConn.commit();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            t = System.currentTimeMillis() - t;
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u3010\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38\u3011", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(rs, stmt, dbConn);
                throw throwable;
            }
        }
        SQLUtil.cleanup(rs, stmt, dbConn);
    }

    public static void checkParamValid(Context ctx, List planNumList, boolean initAnyway, int type, String dbType, String connNum, String agentNum, String userNum, Map specialSQL, Map extendsParam) throws BOSException, EASBizException {
        boolean isAgent;
        if (planNumList == null || planNumList.size() == 0) {
            throw new BOSException("\u672a\u4f20\u5165\u540c\u6b65\u65b9\u6848");
        }
        if (type != 0 && type != 1) {
            throw new BOSException("\u672a\u77e5\u7684\u57fa\u7840\u8d44\u6599\u521d\u59cb\u5316\u7c7b\u578b");
        }
        boolean isJDBC = DataSourceType.jdbc.getValue().equalsIgnoreCase(dbType) && !StringUtils.isEmpty((String)connNum);
        boolean bl = isAgent = DataSourceType.agent.getValue().equalsIgnoreCase(dbType) && !StringUtils.isEmpty((String)agentNum);
        if (!isJDBC && !isAgent) {
            throw new BOSException("\u76ee\u6807\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\u6216\u8005\u4e3a\u6307\u5b9a\u76ee\u6807\u6570\u636e\u63a5\u6536\u65b9");
        }
    }

    public void checkParamExist(Context ctx, List planNumList, boolean initAnyway, String connNum, String agentNum) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)connNum)) {
            ConnectionInfo connInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo("where number='" + connNum + "'");
            if (connInfo == null) {
                throw new BOSException("\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7f16\u7801\uff08" + connNum + "\uff09\u4e0d\u5b58\u5728");
            }
            this.connInfo = connInfo;
        }
        if (!StringUtils.isEmpty((String)agentNum)) {
            EipUserInfo agent = EipUserFactory.getLocalInstance(ctx).getEipUserInfo("where number = '" + agentNum + "'");
            if (agent == null) {
                throw new BOSException("\u5ba2\u6237\u7aef\u4ee3\u7406\u7f16\u7801\uff08" + connNum + "\uff09\u4e0d\u5b58\u5728");
            }
            this.agentInfo = agent;
        }
        if (planNumList.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            HashSet planSet = new HashSet();
            planSet.addAll(planNumList);
            filter.getFilterItems().add(new FilterItemInfo("number", planSet, CompareType.INCLUDE));
            view.setFilter(filter);
            BaseDataSynHeadCollection planColl = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadCollection(view);
            Iterator planIterator = planColl.iterator();
            BaseDataSynHeadInfo planInfo = null;
            String planNum = null;
            ArrayList<String> existPlanList = new ArrayList<String>();
            while (planIterator.hasNext()) {
                planInfo = (BaseDataSynHeadInfo)planIterator.next();
                planNum = planInfo.getNumber();
                this.findPlanList.add(planInfo);
                existPlanList.add(planNum);
            }
            planNumList.removeAll(existPlanList);
            this.unknowPlanList.addAll(planNumList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMainPKListForAdd(Context ctx, BaseDataSynHeadInfo headInfo, String agentId) throws BOSException, EASBizException {
        ArrayList mainPKList = new ArrayList();
        BaseDataSynTableInfo mainTable = BaseDataSynUtil.getMainTableInfo(ctx, headInfo);
        StructuredDataModel dataModel = null;
        try {
            dataModel = DataModelUtil.convert(mainTable, ctx, true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new BOSException((Throwable)e1);
        }
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        String entryPkName = null;
        for (int i = 0; i < entry.columns.length; ++i) {
            if (!entry.columns[i].isPk) continue;
            entryPkName = entry.columns[i].name;
            break;
        }
        if (entryPkName == null) {
            throw new BOSException("\u65b9\u6848\u4e3b\u8868\uff08" + mainTable.getTableName() + "\uff09\u672a\u914d\u7f6e\u4e3b\u952e\u5b57\u6bb5\u3002");
        }
        String addSQL = this.initMainTableAddQueryString(ctx, entryPkName, mainTable, agentId, null);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        boolean totalCount = false;
        String idTmpTable = "";
        try {
            long begin = System.currentTimeMillis();
            idTmpTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_virtualModeDataAccess(KSQL_SEQ INT IDENTITY (1, 1) NOT NULL ,fid varchar(44))");
            String intoTmpSQL = "insert into " + idTmpTable + " (KSQL_SEQ,fid) " + addSQL;
            conn = SQLUtil.getKSQLConnection(ctx);
            stmt = conn.createStatement();
            stmt.execute(intoTmpSQL);
            long end = System.currentTimeMillis();
            String msg = "EIP-\u521d\u59cb\u5316\u65b9\u6848\uff1a" + headInfo.getNumber() + "(" + headInfo.getName() + ")\uff0c\u6570\u636e\u63d2\u5165\u5230\u4e34\u65f6\u8868\uff1a" + idTmpTable + "\uff0c\u63d2\u5165\u4e34\u65f6\u8868\u603b\u8017\u65f6\uff1a" + (end - begin) + "ms\uff0c\u5904\u7406\u65f6\u95f4\uff1a" + new Date(begin) + "\r\n";
            logger.error((Object)msg);
            SQLUtil.cleanup(rs, stmt, conn);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtil.cleanup(rs, stmt, conn);
        }
        return idTmpTable;
    }

    private String initMainTableAddQueryString(Context ctx, String entryPkName, BaseDataSynTableInfo tableInfo, String agentId, String filterString) throws BOSException {
        String specialSQL;
        String queryString = null;
        String tableName = tableInfo.getTableName();
        String pkTableName = tableInfo.getPkTableName().replaceAll("\"", "");
        String srcWhere = tableInfo.getSrcWhere();
        String AS_NAME = "t1.";
        String ALIAS_NAME = "t1";
        StringBuilder sqlBuf = new StringBuilder();
        sqlBuf.append("select " + entryPkName);
        sqlBuf.append(" from ").append(tableName).append(" " + ALIAS_NAME);
        sqlBuf.append(" where ");
        sqlBuf.append(" not exists(select 1 from ").append(pkTableName).append(" p").append(" where " + AS_NAME).append(entryPkName).append(" = p.").append("headpk AND p.agentId = '" + agentId + "') ");
        if (!StringUtils.isEmpty((String)srcWhere)) {
            if (StringUtils.startsWithIgnoreCase((String)srcWhere, (String)"where")) {
                srcWhere = StringUtils.replaceIgnoreCase((String)srcWhere, (String)"where", (String)"");
                srcWhere = srcWhere.replace(tableName + ".", AS_NAME);
            }
            if (srcWhere.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(srcWhere);
            } else {
                sqlBuf.append(" and ").append(srcWhere);
            }
        }
        if (!StringUtils.isEmpty((String)(specialSQL = BaseDataInitialPKtableUtil.getSpecialSQL(ctx, tableInfo, agentId)))) {
            if (StringUtils.startsWithIgnoreCase((String)specialSQL, (String)"where")) {
                specialSQL = StringUtils.replaceIgnoreCase((String)specialSQL, (String)"where", (String)"");
            }
            if (specialSQL.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(specialSQL);
            } else {
                sqlBuf.append(" and ").append(specialSQL);
            }
        }
        if (!StringUtils.isEmpty((String)filterString)) {
            if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                sqlBuf.append(" and ");
            }
            sqlBuf.append(filterString);
        }
        sqlBuf.append(" order by ").append(AS_NAME).append(entryPkName).append(" asc");
        queryString = sqlBuf.toString();
        return queryString;
    }

    private void recordMessage(String msg) throws BOSException {
        try {
            if (this.writer == null) {
                this.writer = new FileOutputStream(this.getFile(), true);
            }
            this.writer.write(msg.getBytes());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public File getFile() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
        String fileName = format.format(new Date()) + ".txt";
        File folder = BaseDataInitialPKtableUtil.getBaseDataLogDir();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder, fileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            this.recordFilePath = file.getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public static File getBaseDataLogDir() {
        String logPath = System.getProperty("EAS_HOME") + File.separator + "admin" + File.separator + "logs" + File.separator + "BaseDataLog";
        return new File(logPath);
    }

    public void initPKTableHeadPK(Context ctx, BaseDataSynHeadInfo baseDataSynInfo) throws BOSException, EASBizException {
        boolean isMultiPlan = baseDataSynInfo.isMultiPlan();
        if (isMultiPlan) {
            BaseDataSynSubPlanCollection subPlans = baseDataSynInfo.getPlans();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < subPlans.size(); ++i) {
                idSet.add(subPlans.get(i).getSubPlanId());
            }
            String[] idArray = idSet.toArray(new String[0]);
            IBaseDataSynHead instance = BaseDataSynHeadFactory.getLocalInstance(ctx);
            Map map = instance.convertId2CoreBaseInfo(idArray);
            for (CoreBaseInfo baseInfo : map.values()) {
                BaseDataSynHeadInfo subPlan = (BaseDataSynHeadInfo)baseInfo;
                subPlan.getExtendedProperties().putAll(baseDataSynInfo.getExtendedProperties());
                if (subPlan.isMultiPlan()) {
                    this.initPKTableHeadPK(ctx, subPlan);
                    continue;
                }
                this.initEachPKTableHeadPK(ctx, subPlan);
            }
        } else {
            this.initEachPKTableHeadPK(ctx, baseDataSynInfo);
        }
    }

    private void initEachPKTableHeadPK(Context ctx, BaseDataSynHeadInfo baseDataSynInfo) throws BOSException, EASBizException {
        try {
            boolean hasPublish = BaseDataSynUtil.checkPlanHasPublish(ctx, baseDataSynInfo);
            if (!hasPublish) {
                BaseDataSynPublisherFacadeFactory.getLocalInstance(ctx).publish(baseDataSynInfo.getId().toString());
            }
            this.buildAndExecuteUpdateSQL(ctx, baseDataSynInfo);
        }
        catch (Exception e) {
            logger.error((Object)("EIP Init PKTable error, planName:" + baseDataSynInfo.getName()));
            throw new BOSException((Throwable)e);
        }
    }

    private void buildAndExecuteUpdateSQL(Context ctx, BaseDataSynHeadInfo baseDataSynInfo) throws Exception {
        ArrayList<String> sqlList = new ArrayList<String>();
        String timeStr = KeyTableUtil.getKSQLTimesFormat(new Date());
        List<BaseDataSynTableInfo> sortedTableColl = BaseDataSynUtil.getSortedTablesDesc(baseDataSynInfo);
        for (BaseDataSynTableInfo tableInfo : sortedTableColl) {
            String pkTableName = tableInfo.getPkTableName();
            StringBuffer updateSQL = new StringBuffer();
            if (StringUtils.isEmpty((String)pkTableName)) continue;
            if (tableInfo.isMainTable()) {
                updateSQL.append("update ").append(pkTableName).append(" set ").append("createTime").append(" = ").append(timeStr);
            } else {
                updateSQL.append("update ").append(pkTableName).append(" set mainpk = ").append(" (select distinct ");
                String relateSQL = tableInfo.getRelateSQL();
                if (!StringUtils.isEmpty((String)relateSQL)) {
                    String mainTableField = relateSQL.substring(relateSQL.lastIndexOf("and") + 3, relateSQL.lastIndexOf("in("));
                    String tableRelation = relateSQL.substring(0, relateSQL.lastIndexOf("and"));
                    updateSQL.append(mainTableField).append(" from ").append(tableInfo.getTableName()).append(" ").append(tableRelation).append(" where ").append(" (").append(pkTableName).append(".").append("mainPK").append(" is null or ").append(pkTableName).append(".").append("mainPK").append(" = '') ").append(" and headpk = ").append(tableInfo.getTableName()).append(".fid ").append(")").append(",").append("createTime").append("= ").append(timeStr);
                }
            }
            sqlList.add(updateSQL.toString());
        }
        KeyTableUtil.executeBatch(ctx, sqlList, false);
    }
}

