/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.eas.csinterface.basedatasyn.app.util.IORMRPCEIPBaseDataSyn;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BaseDataOrmUtil {
    private static final Logger logger = Logger.getLogger(BaseDataOrmUtil.class);
    public static String ADDRESS = "ADDRESS";
    public static String PORT = "PORT";
    public static String USERNAME = "USERNAME";
    public static String PASSWORD = "PASSWORD";
    public static String DATACENTER = "DATACENTER";
    public static String LANGUAGE = "LANGUAGE";

    private static IORMRPCEIPBaseDataSyn getORMRPCBosObject(String url) throws BOSException {
        IORMModel bosObject = RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.csinterface.basedatasyn.app.util.ORMRPCEIPBaseDataSyn", IORMRPCEIPBaseDataSyn.class);
        return (IORMRPCEIPBaseDataSyn)bosObject;
    }

    public static void addNewByRPC(Context ctx, IObjectValue model) throws BOSException {
        String url = "";
        Connection conn = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            conn = DBUtils.getConnection((Context)ctx);
            stmt = conn.createStatement();
            String sql = "select * from T_EIP_REMOTESERVICE";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                url = rs.getString("FWEBADDRESS");
                String userName = rs.getString("FUSERNAME");
                String password = rs.getString("FPASSWORD");
                String dataCenter = rs.getString("FDATACENTER");
                String language = rs.getString("FLANGUAGE");
                map.put(USERNAME, userName);
                map.put(PASSWORD, password);
                map.put(DATACENTER, dataCenter);
                map.put(LANGUAGE, language);
                String port = String.valueOf(rs.getInt("FPORT"));
                url = port.startsWith(":") ? url + port : url + ":" + port;
                BaseDataOrmUtil.getORMRPCBosObject(url)._addNew(model, map);
            }
        }
        catch (Exception e) {
            try {
                String errorMessage = "\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3\u5931\u8d25!,\u8fdc\u7a0b\u670d\u52a1\u5730\u5740\u4e3a\uff1a" + url;
                if (e != null && StringUtils.isEmpty((String)e.getMessage())) {
                    errorMessage = errorMessage + e.getMessage();
                }
                throw new BOSException(errorMessage, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }
}

