/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynPreCheckLogFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynPreCheckLogInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ParseCheckSQL;
import com.kingdee.eas.csinterface.basedatasyn.app.util.basedataindex.UniqueIndexFacade;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaseDataSynCheckUtil {
    private static Logger logger = Logger.getLogger(BaseDataSynCheckUtil.class);
    public static final String BEFORE_SQL = "beforeSQL";
    public static final String SELF_SQL = "selfSQL";
    public static final String OPPS_SQL = "oppSQL";
    public static final String OPP_VALUE = "value";
    public static final String SQL_CODE = "code";
    public static final String SQL_VALUE = "value";
    public static final String CONN_STR = "_";
    public static final Integer EACH_COUNT = 300;

    public static void addBeforeSQLCheckIfNeed(Context ctx, BaseDataSynTableInfo tableInfo, String ksql, List<String> pkList, String connId, String beforeSQLDefine) throws Exception {
        if (StringUtils.isEmpty((String)beforeSQLDefine)) {
            return;
        }
        StringBuffer hasExistValueBuffer = new StringBuffer();
        JSONArray jsonArr = JSONArray.parseArray((String)beforeSQLDefine);
        String selfSQL = "";
        String oppSQL = "";
        String oppValue = "";
        for (int i = 0; i < jsonArr.size(); ++i) {
            JSONObject obj = jsonArr.getJSONObject(i);
            if (obj.containsKey((Object)SELF_SQL)) {
                selfSQL = obj.getString(SELF_SQL);
                continue;
            }
            if (obj.containsKey((Object)OPPS_SQL)) {
                oppSQL = obj.getString(OPPS_SQL);
                continue;
            }
            if (!obj.containsKey((Object)"value")) continue;
            oppValue = obj.getString("value");
        }
        ParseCheckSQL selfSQLCode = new ParseCheckSQL(selfSQL);
        selfSQLCode.parse();
        ParseCheckSQL oppSQLCode = new ParseCheckSQL(oppSQL);
        if (StringUtils.isEmpty((String)oppSQL)) {
            return;
        }
        oppSQLCode.parse();
        if (StringUtils.isEmpty((String)oppValue)) {
            throw new Exception("\u4e3b\u8868\u7684\u524d\u7f6e\u6821\u9a8c\u811a\u672c\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11\u5bf9\u6bd4\u5b57\u6bb5");
        }
        ArrayList<Map<String, Object>> checkAddList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> fidMap = new HashMap<String, String>();
        List<String> checkSQLList = new ArrayList<String>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getConnection(ctx);
            stmt = conn.createStatement();
            rs = BaseDataSynCheckUtil.getResultSet(conn, stmt, rs, ksql);
            checkSQLList = BaseDataSynCheckUtil.getCheckSQL(rs, stmt, selfSQLCode, oppSQLCode, oppValue, pkList, fidMap, checkAddList, checkSQLList);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        ConnectionInfo connInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(connId));
        DataBaseType dbType = DataBaseType.getInstance(connInfo.getDBType().getName());
        Connection connection = null;
        Statement statement = null;
        try {
            connection = KSQLUtil.getKSQLConnection(dbType, connInfo.getIP(), connInfo.getPort(), connInfo.getInstance(), connInfo.getUsername(), connInfo.getPassword());
            statement = connection.createStatement();
            String old_extContext = MonitorManager.getCurrentBaseDataDown().getExtendedProperty("extContext");
            if (old_extContext == null) {
                hasExistValueBuffer.append("\u6570\u636e\u5bf9\u7167\u5173\u7cfb\uff1a\u6e90\u6807\u5fd7\u503c\uff0c\u76ee\u6807\u6807\u5fd7\u503c\uff0c\u5177\u4f53\u7684\u503c\u7ec4\u5408\n");
            }
            boolean hasExistData = false;
            for (int i = 0; i < checkSQLList.size(); ++i) {
                CoreBaseCollection colls = new CoreBaseCollection();
                ResultSet resultSet = null;
                try {
                    resultSet = statement.executeQuery(checkSQLList.get(i));
                    Timestamp time = new Timestamp(System.currentTimeMillis());
                    while (resultSet.next()) {
                        String code = resultSet.getString(SQL_CODE);
                        String value = resultSet.getString("value");
                        for (String key : fidMap.keySet()) {
                            if (!((String)fidMap.get(key)).equals(value) || key.equals(code)) continue;
                            pkList.remove(key);
                            if (!hasExistData) {
                                hasExistData = true;
                            }
                            hasExistValueBuffer.append(key).append(" , " + code).append(" , ").append(value).append("\r\n");
                            BaseDataSynPreCheckLogInfo info = new BaseDataSynPreCheckLogInfo();
                            info.setSrcValue(key);
                            info.setDestValue(code);
                            info.setDetailValue(value);
                            info.setTable(tableInfo);
                            info.setFields(oppValue);
                            info.setCreateTime(time);
                            info.setLastUpdateTime(time);
                            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                            info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                            colls.add((CoreBaseInfo)info);
                        }
                    }
                    BaseDataSynPreCheckLogFactory.getLocalInstance(ctx).addnewBatchData(colls);
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(resultSet);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)resultSet);
            }
            if (hasExistData) {
                old_extContext = old_extContext == null ? hasExistValueBuffer.toString() : old_extContext + hasExistValueBuffer.toString();
                MonitorManager.getCurrentBaseDataDown().setExtendedProperty("extContext", old_extContext);
                logger.error((Object)("---EIP\u57fa\u7840\u8d44\u6599\u540c\u6b65\u68c0\u67e5\u5230\u6570\u636e\u4e00\u81f4\u65f6\u7684LOG----" + hasExistValueBuffer.toString() + "------------"));
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, statement, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)statement, (Connection)connection);
    }

    public static List<String> getCheckSQLByResult(List<Map<String, Object>> checkAddList, ParseCheckSQL selfSQLCode) {
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuffer eachShouldCheckBuffer = new StringBuffer();
        int execMapIndex = 1;
        StringBuffer tmpRoopStrBuffer = new StringBuffer();
        for (int i = 0; i < checkAddList.size(); ++i) {
            if (execMapIndex == 1) {
                eachShouldCheckBuffer = new StringBuffer();
                eachShouldCheckBuffer.append(selfSQLCode.beforeStr);
                eachShouldCheckBuffer.append(" (");
            }
            if (execMapIndex > 1) {
                eachShouldCheckBuffer.append(" or ");
            }
            ++execMapIndex;
            Map<String, Object> map = checkAddList.get(i);
            String finalRoopStr = selfSQLCode.roopStr;
            for (String key : selfSQLCode.valueSQLCode.keySet()) {
                finalRoopStr = finalRoopStr.replace(selfSQLCode.valueSQLCode.get(key), "'" + String.valueOf(map.get(key.toUpperCase())) + "'");
            }
            eachShouldCheckBuffer.append("(");
            eachShouldCheckBuffer.append(" " + finalRoopStr + " ");
            eachShouldCheckBuffer.append(")");
            if (execMapIndex % EACH_COUNT != 0) continue;
            tmpRoopStrBuffer.append(eachShouldCheckBuffer);
            tmpRoopStrBuffer.append(") ");
            tmpRoopStrBuffer.append(selfSQLCode.afterStr);
            sqlList.add(tmpRoopStrBuffer.toString());
            System.out.println("------ \u51c6\u5907\u6267\u884c\u6821\u9a8c\u7684SQL ----" + tmpRoopStrBuffer.toString());
            tmpRoopStrBuffer = new StringBuffer();
            execMapIndex = 1;
        }
        logger.error((Object)"ssss");
        if (eachShouldCheckBuffer.length() > 0) {
            eachShouldCheckBuffer.append(") ");
            eachShouldCheckBuffer.append(selfSQLCode.afterStr);
            sqlList.add(eachShouldCheckBuffer.toString());
            System.out.println("------ \u51c6\u5907\u6267\u884c\u6821\u9a8c\u7684SQL ----" + tmpRoopStrBuffer.toString());
        }
        return sqlList;
    }

    public static ResultSet getResultSet(Connection conn, Statement stmt, ResultSet resultSet, String ksql) throws Exception {
        String s = "";
        s = DBUtils.isPostgresSQL(conn) ? ksql : (!(conn instanceof KDConnection) ? TransUtil.Translate((String)ksql, (int)DBUtils.getDBType(conn)) : ksql);
        resultSet = DBUtil.isOracle((Connection)conn) ? stmt.executeQuery(ksql) : stmt.executeQuery(s);
        return resultSet;
    }

    private static List<String> getCheckSQL(ResultSet rs, Statement stmt, ParseCheckSQL selfSQLCode, ParseCheckSQL oppSQLCode, String oppValue, List<String> pkList, Map<String, String> fidMap, List<Map<String, Object>> checkAddList, List<String> checkSQLList) throws Exception {
        HashMap<String, Object> execMap = null;
        boolean isNoSelfSQL = StringUtils.isEmpty((String)selfSQLCode.beforeStr);
        Map<String, String> valueSQLCode = oppSQLCode.valueSQLCode;
        valueSQLCode = isNoSelfSQL ? oppSQLCode.valueSQLCode : selfSQLCode.valueSQLCode;
        String[] oppValues = oppValue.split(",");
        while (rs.next()) {
            String fid = rs.getString("FID");
            pkList.add(fid);
            execMap = new HashMap<String, Object>();
            for (String key : valueSQLCode.keySet()) {
                execMap.put(key.toUpperCase(), rs.getObject(key));
            }
            checkAddList.add(execMap);
            if (!isNoSelfSQL) continue;
            StringBuffer value = new StringBuffer();
            boolean isFirst = false;
            for (String oppColumn : oppValues) {
                if (isFirst) {
                    value.append(CONN_STR);
                }
                value.append(rs.getObject(oppColumn));
                isFirst = true;
            }
            fidMap.put(fid, value.toString());
        }
        if (isNoSelfSQL) {
            checkSQLList = BaseDataSynCheckUtil.getCheckSQLByResult(checkAddList, oppSQLCode);
            return checkSQLList;
        }
        checkSQLList = BaseDataSynCheckUtil.getCheckSQLByResult(checkAddList, selfSQLCode);
        SQLUtils.cleanup((ResultSet)rs);
        ResultSetMetaData metaData = null;
        int columnCount = 0;
        ArrayList<Map<String, Object>> selfResult = new ArrayList<Map<String, Object>>();
        for (String checkSQL : checkSQLList) {
            try {
                rs = stmt.executeQuery(checkSQL);
                metaData = rs.getMetaData();
                columnCount = metaData.getColumnCount();
                while (rs.next()) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    for (int i = 0; i < columnCount; ++i) {
                        String columnName = metaData.getColumnName(i + 1);
                        result.put(columnName.toUpperCase(), rs.getObject(columnName));
                    }
                    fidMap.put(String.valueOf(rs.getObject(SQL_CODE)), String.valueOf(rs.getObject("value")));
                    selfResult.add(result);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        return BaseDataSynCheckUtil.getCheckSQLByResult(selfResult, oppSQLCode);
    }

    private static String generateSrcSql(List<String> columns, String tableName, List<String> pkList) {
        StringBuilder srcSql = new StringBuilder("select fid , ");
        for (int i = 0; i < columns.size(); ++i) {
            srcSql.append(columns.get(i));
            if (i + 1 == columns.size()) continue;
            srcSql.append(", ");
        }
        srcSql.append(" from ").append(tableName).append(" where fid in ( ");
        srcSql.append(com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(pkList, ",", "'"));
        srcSql.append(" ) ");
        return srcSql.toString();
    }

    public static void addBeforeSQLCheckNew(Context ctx, BaseDataSynTableInfo tableInfo, String ksql, List<String> pkList, String connId, String indexName) throws Exception {
        List<String> columnsByIndex;
        String tableName;
        Statement statement;
        Connection connection;
        block21: {
            if (StringUtils.isEmpty((String)indexName)) {
                return;
            }
            ConnectionInfo connInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(connId));
            DataBaseType dbType = DataBaseType.getInstance(connInfo.getDBType().getName());
            connection = null;
            statement = null;
            connection = KSQLUtil.getKSQLConnection(dbType, connInfo.getIP(), connInfo.getPort(), connInfo.getInstance(), connInfo.getUsername(), connInfo.getPassword());
            Map<String, List<String>> columnsByIndexMap = new UniqueIndexFacade().getColumnNamesByIndexOrConstraint(connection, indexName);
            tableName = tableInfo.getTableName();
            columnsByIndex = null;
            String tempTableName = tableName.toLowerCase();
            if (columnsByIndexMap.containsKey(tempTableName)) {
                columnsByIndex = columnsByIndexMap.get(tempTableName);
            }
            if (null != columnsByIndex && columnsByIndex.size() != 0) break block21;
            SQLUtils.cleanup(null, statement, (Connection)connection);
            return;
        }
        try {
            ArrayList result;
            int currentPage;
            if (!StringUtils.isEmpty((String)ksql)) {
                pkList = BaseDataSynCheckUtil.getNeedInsertSrcPkList(ctx, ksql, pkList);
            }
            int totalSize = pkList.size();
            int pageSize = 300;
            int count = totalSize / pageSize;
            int remain = totalSize % pageSize;
            String srcSql = null;
            Object destSql = null;
            HashMap<String, String> judgeMap = new HashMap<String, String>();
            ArrayList<String> checkSQLList = new ArrayList<String>();
            if (count > 0) {
                for (currentPage = 0; currentPage < count; ++currentPage) {
                    srcSql = BaseDataSynCheckUtil.generateSrcSql(columnsByIndex, tableName, pkList.subList(currentPage * pageSize, (currentPage + 1) * pageSize));
                    result = SQL.executeQuery((Context)ctx, (String)srcSql);
                    BaseDataSynCheckUtil.constructJudgeMap(columnsByIndex, judgeMap, result);
                    checkSQLList.add(BaseDataSynCheckUtil.generateDestSql(columnsByIndex, tableName, result));
                }
            }
            if (remain > 0) {
                srcSql = BaseDataSynCheckUtil.generateSrcSql(columnsByIndex, tableName, pkList.subList(currentPage * pageSize, currentPage * pageSize + remain));
                result = SQL.executeQuery((Context)ctx, (String)srcSql);
                BaseDataSynCheckUtil.constructJudgeMap(columnsByIndex, judgeMap, result);
                checkSQLList.add(BaseDataSynCheckUtil.generateDestSql(columnsByIndex, tableName, result));
            }
            StringBuffer hasExistValueBuffer = new StringBuffer();
            statement = connection.createStatement();
            String old_extContext = MonitorManager.getCurrentBaseDataDown().getExtendedProperty("extContext");
            if (old_extContext == null) {
                hasExistValueBuffer.append("\u6570\u636e\u5bf9\u7167\u5173\u7cfb\uff1a\u6e90\u6807\u5fd7\u503c\uff0c\u76ee\u6807\u6807\u5fd7\u503c\uff0c\u5177\u4f53\u7684\u503c\u7ec4\u5408\n");
            }
            boolean hasExistData = false;
            for (int i = 0; i < checkSQLList.size(); ++i) {
                CoreBaseCollection colls = new CoreBaseCollection();
                ResultSet resultSet = null;
                try {
                    resultSet = statement.executeQuery((String)checkSQLList.get(i));
                    Timestamp time = new Timestamp(System.currentTimeMillis());
                    while (resultSet.next()) {
                        String destid = resultSet.getString("fid");
                        StringBuilder multiValue = new StringBuilder();
                        for (int i1 = 0; i1 < columnsByIndex.size(); ++i1) {
                            multiValue.append(resultSet.getObject(columnsByIndex.get(i1)));
                        }
                        String destValue = multiValue.toString();
                        String srcId = (String)judgeMap.get(destValue);
                        if (srcId.equals(destid)) continue;
                        pkList.remove(srcId);
                        if (BaseDataSynCheckUtil.isBaseDataSynPreCheckLogRecord(ctx, srcId, destid)) continue;
                        if (!hasExistData) {
                            hasExistData = true;
                        }
                        hasExistValueBuffer.append(srcId).append(" , " + destid).append(" , ").append(destValue).append("\r\n");
                        BaseDataSynPreCheckLogInfo info = new BaseDataSynPreCheckLogInfo();
                        info.setSrcValue(srcId);
                        info.setDestValue(destid);
                        info.setDetailValue(destValue);
                        info.setTable(tableInfo);
                        info.setFields(Arrays.toString(columnsByIndex.toArray()));
                        info.setCreateTime(time);
                        info.setLastUpdateTime(time);
                        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                        info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                        colls.add((CoreBaseInfo)info);
                    }
                    BaseDataSynPreCheckLogFactory.getLocalInstance(ctx).addnewBatchData(colls);
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)("\u57fa\u7840\u8d44\u6599\u540c\u6b65\uff0c\u524d\u7f6e\u811a\u672c\u68c0\u67e5\u5f02\u5e38\uff01srcSql\uff1a" + srcSql), (Throwable)e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(resultSet);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)resultSet);
            }
            if (hasExistData) {
                old_extContext = old_extContext == null ? hasExistValueBuffer.toString() : old_extContext + hasExistValueBuffer.toString();
                MonitorManager.getCurrentBaseDataDown().setExtendedProperty("extContext", old_extContext);
                logger.error((Object)("---EIP\u57fa\u7840\u8d44\u6599\u540c\u6b65\u68c0\u67e5\u5230\u6570\u636e\u4e00\u81f4\u65f6\u7684LOG----" + hasExistValueBuffer.toString() + "------------"));
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, statement, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)statement, (Connection)connection);
    }

    private static String generateDestSql(List<String> columns, String tableName, ArrayList result) {
        int i;
        StringBuilder destSql = new StringBuilder("select fid , ");
        for (i = 0; i < columns.size(); ++i) {
            destSql.append(columns.get(i));
            if (i + 1 == columns.size()) continue;
            destSql.append(", ");
        }
        destSql.append(" from ").append(tableName).append(" where  ( ");
        for (i = 0; i < result.size(); ++i) {
            destSql.append(" (");
            HashMap value = (HashMap)result.get(i);
            for (int j = 0; j < columns.size(); ++j) {
                destSql.append(columns.get(j)).append(" = '").append(value.get(columns.get(j))).append("'");
                if (j + 1 == columns.size()) continue;
                destSql.append(" and ");
            }
            destSql.append(" )");
            if (i + 1 == result.size()) continue;
            destSql.append(" or ");
        }
        destSql.append(" )");
        return destSql.toString();
    }

    private static void constructJudgeMap(List<String> columnsByIndex, Map<String, String> judgeMap, ArrayList result) {
        for (int i = 0; i < result.size(); ++i) {
            HashMap value = (HashMap)result.get(i);
            StringBuilder appendField = new StringBuilder();
            for (int i1 = 0; i1 < columnsByIndex.size(); ++i1) {
                appendField.append(value.get(columnsByIndex.get(i1)));
            }
            judgeMap.put(appendField.toString(), (String)value.get("fid"));
        }
    }

    private static List<String> getNeedInsertSrcPkList(Context ctx, String ksql, List<String> pkList) throws BOSException {
        ArrayList result = SQL.executeQuery((Context)ctx, (String)ksql);
        for (int i = 0; i < result.size(); ++i) {
            HashMap record = (HashMap)result.get(i);
            if (pkList.contains((String)record.get("fid"))) continue;
            pkList.add((String)record.get("fid"));
        }
        return pkList;
    }

    public static boolean isBaseDataSynPreCheckLogRecord(Context ctx, String srcId, String destid) {
        try {
            return BaseDataSynPreCheckLogFactory.getLocalInstance(ctx).exists("where srcValue='" + srcId + "' and destValue ='" + destid + "'");
        }
        catch (Exception e) {
            logger.error((Object)ThrowableHelper.toString(e));
            return false;
        }
    }
}

