/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHelper;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.KeyTable;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.util.DataTypeConverter;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class KeyTableUtil {
    public static final String NO_PKTABLE = "\u672a\u751f\u6210\u589e\u91cf\u8868";
    private static Logger logger = Logger.getLogger(KeyTableUtil.class);
    public static final String CREATETIMESQL = "IF Not Exists(select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '{0}'  and KSQL_COL_NAME ='createtime') \n alter table {1} add createtime datetime ; ";
    public static final String MAINPKSQL = "IF Not Exists(select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '{0}' and KSQL_COL_NAME ='mainPK') \n alter table {1} add mainPK varchar(80) ; ";
    public static final String UNIQUEINDEXSQL = "IF Not Exists(Select * From KSQL_INDEXES Where KSQL_INDNAME= '{0}' ) \n create unique index {1}  on {2} (headpk, agentid) ; ";
    public static final String MAINPKINDEXSQL = "IF Not Exists(Select * From KSQL_INDEXES Where KSQL_INDNAME= '{0}' ) \n create index {1}  on {2} (mainpk) ; ";
    public static final String STATUSINDEXSQL = "IF Not Exists(Select * From KSQL_INDEXES Where KSQL_INDNAME= '{0}' ) \n create index {1}  on {2} (status) ; ";

    public static void createKeyTable(Context ctx, BaseDataSynTableInfo tableInfo) throws BOSException, EASBizException, SQLException, DIPException {
        Connection conn = DBUtils.getConnection(ctx);
        KeyTable keyTable = KeyTableUtil.getKeyTable(tableInfo, ctx);
        tableInfo.setPkTableName(keyTable.getTableName());
        DBType dbType = KeyTableUtil.getDBType(conn);
        KeyTableUtil.createKeyTable(conn, dbType, keyTable, tableInfo.getTableName());
        try {
            KeyTableUtil.createUniqueIndexIfNeed(ctx, keyTable.getTableName());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static DBType getDBType(Connection conn) {
        DBType dbType;
        block5: {
            dbType = DBType.SQLServer;
            try {
                if (com.kingdee.bos.bi.model.DB.DBUtil.isOracle((Connection)conn)) {
                    dbType = DBType.Oracle;
                    break block5;
                }
                if (com.kingdee.bos.bi.model.DB.DBUtil.isMSSQL((Connection)conn)) {
                    dbType = DBType.SQLServer;
                    break block5;
                }
                if (com.kingdee.bos.bi.model.DB.DBUtil.isDB2((Connection)conn)) {
                    dbType = DBType.DB2;
                    break block5;
                }
                throw new SQLException("\u672a\u77e5\u6570\u636e\u5e93\u7c7b\u578b");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return dbType;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existKeyTable(Context ctx, BaseDataSynTableInfo tableInfo) throws EASBizException, BOSException, SQLException, DIPException {
        block7: {
            keyTablenName = KeyTableUtil.getPKTableName(tableInfo);
            conn = DBUtils.getConnection(ctx);
            statement = null;
            rs = null;
            try {
                statement = conn.createStatement();
                ksql = "select KSQL_TABNAME from KSQL_USERTABLES where KSQL_TABNAME = '" + keyTablenName + "'";
                System.out.println("execute dataBase PKTable Query ksql :" + ksql);
                rs = statement.executeQuery(ksql);
                rowSet = (IRowSet)DBUtil.makeRowSet((ResultSet)rs);
                if (rowSet.next()) ** GOTO lbl-1000
                ksql = "select KSQL_TABNAME from KSQL_USERTABLES where KSQL_TABNAME like 'T_EIP_Z_%'";
                rs = statement.executeQuery(ksql);
                rowSet = (IRowSet)DBUtil.makeRowSet((ResultSet)rs);
                while (rowSet.next()) {
                    if (!keyTablenName.equalsIgnoreCase(rowSet.getString(1))) continue;
                    var8_9 = true;
                    break block7;
                }
                ** GOTO lbl-1000
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable var9_12) {
                    SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                    throw var9_12;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return var8_9;
lbl-1000:
        // 1 sources

        {
            var8_10 = false;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return var8_10;
lbl-1000:
        // 1 sources

        {
            var8_11 = true;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return var8_11;
    }

    private static String getPKTableName(BaseDataSynTableInfo tableInfo) {
        return BaseDataSynHelper.calc2PkTableName(tableInfo.getTableName());
    }

    private static KeyTable getKeyTable(BaseDataSynTableInfo tablInfo, Context ctx) throws BOSException {
        BaseDataSynColumnInfo headpk = null;
        String keyTablenName = KeyTableUtil.getPKTableName(tablInfo);
        return new KeyTable(keyTablenName, headpk);
    }

    private static void createKeyTable(Connection conn, DBType dbType, KeyTable table, String tableName) throws BOSException {
        String ksql = KeyTableUtil.getSQL2CreateKeyTable(table, dbType);
        try {
            KeyTableUtil.executeUpdate(conn, new String[]{ksql});
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getMSSQLOrderRule(Connection conn, String tableName) throws Exception {
        String rule = "";
        Statement statement = null;
        ResultSet set = null;
        try {
            statement = conn.createStatement();
            String sql = "select collation from syscolumns where id=object_id(N'" + tableName + "')";
            set = statement.executeQuery(sql);
            while (set.next() && StringUtils.isEmpty((String)(rule = set.getString("collation")))) {
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
        return rule;
    }

    public static void executeUpdate(Connection con, String[] ksqls) throws BOSException, SQLException {
        Statement statement = null;
        try {
            statement = con.createStatement();
            for (String ksql : ksqls) {
                if (StringUtils.isEmpty((String)ksql)) continue;
                statement.executeUpdate(ksql);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
    }

    private static String getSQL2CreateKeyTable(KeyTable table, DBType dbType) {
        DataTypeConverter typeConverter = DataTypeConverter.getConverter(dbType);
        String tableName = table.getTableName();
        StringBuffer sb = new StringBuffer("create table " + tableName);
        sb.append(" (");
        sb.append(" headpk varchar(44)");
        sb.append(", transmitSerialNumber varchar(44)");
        sb.append(", transmitChunkedNumber varchar(6)");
        sb.append(", changeTime datetime");
        sb.append(", hashCode varchar(64)");
        sb.append(", agentId varchar(64)");
        sb.append(", status int");
        sb.append(", changeStatus int default 0");
        sb.append(", changeTransmitNumber varchar(44)");
        sb.append(", createTime datetime");
        sb.append(", mainpk varchar(80)");
        sb.append(")");
        return sb.toString();
    }

    public static void dropKeyTable(Context ctx, BaseDataSynTableInfo info) throws BOSException, EASBizException {
    }

    public static void createUniqueIndexIfNeed(Context ctx, String pkTableName) throws Exception {
        if (StringUtils.isEmpty((String)pkTableName)) {
            return;
        }
        String md5_16 = KeyTableUtil.MD5(pkTableName);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        paramList.add(new Object[]{md5_16, md5_16, pkTableName});
        KeyTableUtil.formatAndExecuteSQL(ctx, UNIQUEINDEXSQL, paramList, false);
    }

    public static void createMainPKIndexIfNeed(Context ctx, String pkTableName) throws Exception {
        if (StringUtils.isEmpty((String)pkTableName)) {
            return;
        }
        String md5_16 = KeyTableUtil.MD5(pkTableName + "mainPK");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        paramList.add(new Object[]{md5_16, md5_16, pkTableName});
        KeyTableUtil.formatAndExecuteSQL(ctx, MAINPKINDEXSQL, paramList, false);
    }

    public static void createStatusIndexIfNeed(Context ctx, String pkTableName) throws Exception {
        if (StringUtils.isEmpty((String)pkTableName)) {
            return;
        }
        String md5_16 = KeyTableUtil.MD5(pkTableName + "status");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        paramList.add(new Object[]{md5_16, md5_16, pkTableName});
        KeyTableUtil.formatAndExecuteSQL(ctx, STATUSINDEXSQL, paramList, false);
    }

    public static void createCreateTimeIfNeed(Context ctx, String pkTableName) throws Exception {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        paramList.add(new Object[]{pkTableName, pkTableName});
        KeyTableUtil.formatAndExecuteSQL(ctx, CREATETIMESQL, paramList, false);
    }

    public static void createMainHeadpkNeed(Context ctx, String pkTableName) throws Exception {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        paramList.add(new Object[]{pkTableName, pkTableName});
        KeyTableUtil.formatAndExecuteSQL(ctx, MAINPKSQL, paramList, false);
    }

    public static String MD5(String sourceStr) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(sourceStr.getBytes());
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            result = buf.toString().substring(8, 24);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e);
        }
        return "E" + result;
    }

    public static void formatAndExecuteSQL(Context ctx, String sql, List<Object[]> paramsList, boolean needTranslate) throws BOSException {
        if (paramsList == null) {
            paramsList = new ArrayList<Object[]>();
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        Object[] params = null;
        String tmpSQL = "";
        for (int i = 0; i < paramsList.size(); ++i) {
            params = paramsList.get(i);
            tmpSQL = sql;
            for (int j = 0; j < params.length; ++j) {
                tmpSQL = params[j] != null ? tmpSQL.replace("{" + j + "}", String.valueOf(params[j])) : tmpSQL.replace("{" + j + "}", "");
            }
            sqlList.add(tmpSQL);
        }
        if (paramsList.size() == 0) {
            sqlList.add(sql);
        }
        KeyTableUtil.executeBatch(ctx, sqlList, needTranslate);
    }

    public static int[] executeBatch(Context ctx, List<String> sqlList, boolean needTranslate) throws BOSException {
        int dbType = DbType.getValue((String)ContextUtil.getDbType((Context)ctx));
        int MAX_DATA_ROW = 5000;
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            conn.setAutoCommit(false);
            statement = conn.createStatement();
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < sqlList.size(); ++i) {
                String ksql = sqlList.get(i);
                if (StringUtils.isEmpty((String)ksql)) continue;
                if (needTranslate) {
                    ksql = TransUtil.Translate((String)sqlList.get(i), (int)dbType);
                }
                logger.error((Object)("EIP Execute SQL:" + ksql));
                statement.addBatch(ksql);
                if (i == k * MAX_DATA_ROW) {
                    flag = true;
                }
                if (i <= k * MAX_DATA_ROW || !flag) continue;
                statement.executeBatch();
                ++k;
                flag = false;
                statement.clearBatch();
            }
            if (!flag) {
                statement.executeBatch();
            }
            conn.commit();
        }
        catch (Exception exc) {
            try {
                throw new BOSException("EIP Sql execute exception : ", (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
        return new int[0];
    }

    public static String getKSQLTimesFormat(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer timeBuffer = new StringBuffer();
        timeBuffer.append("{ts'").append(format.format(date)).append("'}");
        String timeStr = timeBuffer.toString();
        return timeStr;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existKeyTable(Context ctx, String tableName) throws EASBizException, BOSException, SQLException, DIPException {
        block7: {
            conn = DBUtils.getConnection(ctx);
            statement = null;
            rs = null;
            try {
                statement = conn.createStatement();
                ksql = "select KSQL_TABNAME from KSQL_USERTABLES where KSQL_TABNAME = '" + tableName + "'";
                System.out.println("execute dataBase PKTable Query ksql :" + ksql);
                rs = statement.executeQuery(ksql);
                rowSet = (IRowSet)DBUtil.makeRowSet((ResultSet)rs);
                if (rowSet.next()) ** GOTO lbl-1000
                ksql = "select KSQL_TABNAME from KSQL_USERTABLES where KSQL_TABNAME like 'T_EIP_C_%'";
                rs = statement.executeQuery(ksql);
                rowSet = (IRowSet)DBUtil.makeRowSet((ResultSet)rs);
                while (rowSet.next()) {
                    if (!tableName.equalsIgnoreCase(rowSet.getString(1))) continue;
                    var7_8 = true;
                    break block7;
                }
                ** GOTO lbl-1000
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable var8_11) {
                    SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                    throw var8_11;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return var7_8;
lbl-1000:
        // 1 sources

        {
            var7_9 = false;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return var7_9;
lbl-1000:
        // 1 sources

        {
            var7_10 = true;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return var7_10;
    }

    public static void createCTable(Context ctx, String tableName) throws Exception {
        Connection conn = null;
        StringBuffer buffer = new StringBuffer();
        StringBuffer sb = new StringBuffer("If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='").append(tableName).append("') create table " + tableName);
        sb.append(" (");
        sb.append("agentid nvarchar(44) DEFAULT '' NOT NULL,");
        sb.append("HEADPK nvarchar(80) DEFAULT '' NOT NULL");
        sb.append(",FCREATETIME datetime)");
        try {
            conn = DBUtils.getConnection(ctx);
            KeyTableUtil.executeUpdate(conn, new String[]{sb.toString()});
            KeyTableUtil.createUniqueIndexIfNeed(ctx, tableName);
        }
        catch (Exception e) {
            logger.error((Object)("\u5efa\u8868\u5931\u8d25\uff1asql\u8bed\u53e5(" + sb.toString() + ")"));
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

