/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util.basedataindex;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.basedatasyn.app.util.basedataindex.IUniqueIndexHandler;
import com.kingdee.eas.csinterface.basedatasyn.app.util.basedataindex.UniqueIndexHandlerByMysqlImpl;
import com.kingdee.eas.csinterface.basedatasyn.app.util.basedataindex.UniqueIndexHandlerByOraImpl;
import com.kingdee.eas.csinterface.basedatasyn.app.util.basedataindex.UniqueIndexHandlerBySqlServerImpl;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UniqueIndexFacade {
    private static Logger LOG = Logger.getLogger(UniqueIndexFacade.class);
    static final List<IUniqueIndexHandler> defaultStrategys = new ArrayList<IUniqueIndexHandler>();

    public Map<String, List<String>> getColumnNamesByIndexOrConstraint(Connection cn, String indexOrConstraintName) throws Exception {
        String productName = cn.getMetaData().getDatabaseProductName().toLowerCase();
        if (!this.isHoldProduct(productName)) {
            throw new BOSException("\u5f53\u524d\u96c6\u6210\u5e73\u53f0\u7cfb\u7edf\u4e2d\u7531\u7d22\u5f15\u751f\u6210\u524d\u7f6e\u811a\u672c\uff0c\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + productName);
        }
        for (IUniqueIndexHandler u : defaultStrategys) {
            if (!u.support(productName)) continue;
            return u.handlerIndex(cn, indexOrConstraintName);
        }
        return null;
    }

    private boolean isHoldProduct(String prodName) {
        boolean b = false;
        if (!StringUtils.isEmpty(prodName) && prodName.toLowerCase().indexOf("sql server") > -1) {
            return true;
        }
        for (DataBaseType t : DataBaseType.values()) {
            if (StringUtils.isEmpty(prodName) || prodName.toLowerCase().indexOf(t.getName().toLowerCase()) <= -1) continue;
            b = true;
        }
        return b;
    }

    static {
        defaultStrategys.add(new UniqueIndexHandlerByOraImpl());
        defaultStrategys.add(new UniqueIndexHandlerBySqlServerImpl());
        defaultStrategys.add(new UniqueIndexHandlerByMysqlImpl());
    }
}

