/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.billmapping.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.BriefViewTreeNode;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.app.AbstractBillMappingControllerBean;
import com.kingdee.eas.csinterface.billmapping.app.MidBillDataProcessFacadeControllerBean;
import com.kingdee.eas.csinterface.billmapping.app.util.KeyTableUtil;
import com.kingdee.eas.csinterface.billmapping.app.util.TempTableUtil;
import com.kingdee.eas.csinterface.billmapping.app.util.ThreadUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataTemplateCopyUtil;
import com.kingdee.eas.csinterface.business.BizWizardCollection;
import com.kingdee.eas.csinterface.business.BizWizardFactory;
import com.kingdee.eas.csinterface.business.BizWizardInfo;
import com.kingdee.eas.csinterface.data.snapshot.ChangefulBillData;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.planmanager.PlanManagerCollection;
import com.kingdee.eas.csinterface.planmanager.PlanManagerFactory;
import com.kingdee.eas.csinterface.planmanager.PlanManagerInfo;
import com.kingdee.eas.csinterface.schedule.ISchedule;
import com.kingdee.eas.csinterface.schedule.ScheduleCollection;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryCollection;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.IMultiToMultiMap;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapCollection;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapFactory;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapInfo;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapMergeEntryListFactory;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewCollection;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewFactory;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillMappingControllerBean
extends AbstractBillMappingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.billmapping.app.BillMappingControllerBean");

    private void checkCanDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks;
        BillMappingInfo info = this.getBillMappingInfo(ctx, pk);
        if (!info.isPublished()) {
            return;
        }
        String midBillName = info.getNumber();
        IDynamicBillTemplate template = MidBillFactory.getInstance(ctx, midBillName);
        if (template != null && (pks = template.getPKList()) != null && pks.length > 0) {
            throw new BOSException("\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u7f16\u53f7\uff08" + midBillName + "\uff09\u5df2\u7ecf\u751f\u6210\u4e86\u4e2d\u95f4\u5355\u636e\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRelationEntiry(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkCanDelete(ctx, pk);
        BillMappingInfo info = this.getBillMappingInfo(ctx, pk);
        BizWizardFactory.getLocalInstance(ctx).delete("where billMapId = '" + pk.toString() + "'");
        this.deleteMultiToMultiMap(ctx, pk);
        ScheduleFactory.getLocalInstance(ctx).delete("where strategy.id = '" + pk.toString() + "'");
        boolean published = info.isPublished();
        if (published) {
            try {
                if (KeyTableUtil.existKeyTable(ctx, info)) {
                    KeyTableUtil.dropKeyTable(ctx, info);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            Connection connection = null;
            try {
                ConnectionInfo connectionInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(info.getSrcDBConn().getId().toString()));
                DBType dbType = connectionInfo.getDBType();
                String tempTableName = TempTableUtil.getTempTableName(dbType, info.getPkTableName());
                connection = KSQLUtil.getConnection(connectionInfo);
                if (TempTableUtil.checkExistTable(tempTableName, connection, dbType, connectionInfo.getInstance().toString())) {
                    TempTableUtil.dropTempTable(tempTableName, connection);
                }
                SQLUtils.cleanup((Connection)connection);
            }
            catch (Exception e) {
                logger.error((Object)("\u5220\u9664\u4e2d\u95f4\u8868\u7684\u4e34\u65f6\u8bb0\u5f55\u8868\u9519\u8bef\uff1a" + ThreadUtil.logCallStatck(e)));
            }
            finally {
                SQLUtils.cleanup(connection);
            }
            try {
                MetadataTemplateCopyUtil.delete(ctx, info.getNumber());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String name = "com.kingdee.eas.csinterface.custom.app." + info.getNumber();
            FilterInfo btpFilter = new FilterInfo();
            btpFilter.getFilterItems().add(new FilterItemInfo("srcEntityFullName", (Object)name, CompareType.EQUALS));
            BOTMappingFactory.getLocalInstance((Context)ctx).delete(btpFilter);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizbillmapping.id", (Object)pk.toString(), CompareType.EQUALS));
        PlanManagerFactory.getLocalInstance(ctx).delete(filter);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.deleteRelationEntiry(ctx, pk);
            super._delete(ctx, pk);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        for (IObjectPK pk : pkArray) {
            this.deleteRelationEntiry(ctx, pk);
        }
        super._deleteBatchData(ctx, pkArray);
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] pkArray;
        for (IObjectPK pk : pkArray = super.getPKList(ctx, filter, null)) {
            this.deleteRelationEntiry(ctx, pk);
        }
        super._delete(ctx, filter);
        return pkArray;
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] pkArray;
        for (IObjectPK pk : pkArray = super.getPKList(ctx, oql)) {
            this.deleteRelationEntiry(ctx, pk);
        }
        super._delete(ctx, oql);
        return pkArray;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (IObjectPK pk : arrayPK) {
            this.deleteRelationEntiry(ctx, pk);
        }
        super._delete(ctx, arrayPK);
    }

    private void checkBizwizard(Context ctx, IObjectPK pk, BillMappingInfo info) throws BOSException, EASBizException {
        StringBuffer wizardNum = new StringBuffer();
        BizWizardCollection wizardColl = BizWizardFactory.getLocalInstance(ctx).getBizWizardCollection("where billMapId = '" + pk.toString() + "'");
        Iterator it = wizardColl.iterator();
        while (it.hasNext()) {
            if (wizardNum.length() > 0) {
                wizardNum.append(",");
            }
            BizWizardInfo wizardInfo = (BizWizardInfo)it.next();
            wizardNum.append(wizardInfo.getNumber());
        }
        if (wizardNum.length() > 0) {
            throw new BOSException("\u7f16\u7801\u4e3a(" + info.getNumber() + ")\u7684\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u5df2\u7ecf\u88ab\u96c6\u6210\u5411\u5bfc(\u201c" + wizardNum + ")\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
        }
    }

    private void deleteSchedule(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ScheduleFactory.getLocalInstance(ctx).delete("where strategy.id = '" + pk.toString() + "'");
    }

    private void deleteMultiToMultiMap(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMultiToMultiMap mmmap = MultiToMultiMapFactory.getLocalInstance(ctx);
        IObjectPK[] mmmapPks = mmmap.delete("where strategy.id = '" + pk.toString() + "'");
        if (mmmapPks != null && mmmapPks.length > 0) {
            StringBuilder ids = new StringBuilder();
            for (int i = 0; i < mmmapPks.length; ++i) {
                if (i > 0) {
                    ids.append(",");
                }
                ids.append("'").append(mmmapPks[i].toString()).append("'");
            }
            MultiToMultiMapMergeEntryListFactory.getLocalInstance(ctx).delete("where parent.id in (" + ids.toString() + ")");
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, model);
        BillMappingInfo billInfo = (BillMappingInfo)model;
        if (billInfo.isNeedResetSnapshot()) {
            logger.error((Object)("csinterface\u7b2c\u4e00\u6b21\u4fdd\u5b58\u4e1a\u52a1\u5355\u636e\u6620\u5c04\uff0c\u9ed8\u8ba4\u4e0d\u6267\u884c\u68c0\u6d4b\u5feb\u7167\u903b\u8f91\uff01isNeedResetSnapshot==" + billInfo.isNeedResetSnapshot()));
            try {
                String id = billInfo.getId().toString();
                Object[] oldChanges = ChangefulBillData.getSortedChangefulFields(DataModelUtil.convert(BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("where id='" + id + "'")));
                String oldChangeField = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.arrayToString(oldChanges, ",");
                Object[] newChanges = ChangefulBillData.getSortedChangefulFields(DataModelUtil.convert((BillMappingInfo)model));
                String newChangeField = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.arrayToString(newChanges, ",");
                if (newChangeField != null && !newChangeField.equalsIgnoreCase(oldChangeField)) {
                    model.setExtendedProperty("oldChangefulFields", com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.arrayToString(oldChanges, ","));
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            MidBillDataProcessFacadeControllerBean.triggerProcessSnapShot(ctx, (BillMappingInfo)model);
        }
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, model);
        return super._save(ctx, model);
    }

    private void checkDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BillMappingInfo billMappingInfo = (BillMappingInfo)model;
        BOSUuid newID = billMappingInfo.getId();
        String checkNumberSQL = "";
        String checkNameSQL = "";
        if (newID == null) {
            checkNumberSQL = "where number='" + billMappingInfo.getNumber() + "'";
            checkNameSQL = "where billMappingName='" + billMappingInfo.getBillMappingName() + "'";
        } else {
            checkNumberSQL = "where number='" + billMappingInfo.getNumber() + "' and id <> '" + newID.toString() + "'";
            checkNameSQL = "where billMappingName='" + billMappingInfo.getBillMappingName() + "' and id <> '" + newID.toString() + "'";
        }
        if (BillMappingFactory.getLocalInstance(ctx).exists(checkNumberSQL)) {
            throw new EASBizException(new NumericExceptionSubItem("check_exist", "\u5df2\u5b58\u5728\u76f8\u540c\u201c\u7f16\u7801\u201d\u4e3a\u201c" + billMappingInfo.getNumber() + "\u201d\u7684\u5355\u636e"));
        }
        if (BillMappingFactory.getLocalInstance(ctx).exists(checkNameSQL)) {
            throw new EASBizException(new NumericExceptionSubItem("check_exist", "\u5df2\u5b58\u5728\u76f8\u540c\u201c\u89c4\u5219\u540d\u79f0\u201d\u4e3a\u201c" + billMappingInfo.getBillMappingName() + "\u201d\u7684\u5355\u636e"));
        }
    }

    @Override
    public BillMappingInfo getBillMappingInfo(Context ctx, String oql) throws BOSException, EASBizException {
        BillMappingInfo billMappingInfo = super.getBillMappingInfo(ctx, oql);
        if (billMappingInfo.getAgentUser() != null) {
            EipUserInfo eipUserInfo = (EipUserInfo)EipUserFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(billMappingInfo.getAgentUser().getId()));
            billMappingInfo.setAgentUser(eipUserInfo);
        }
        return billMappingInfo;
    }

    @Override
    protected Set _getBaseDataType(Context ctx, String billMappingId, boolean isAllValue) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        if (StringUtils.isEmpty((String)billMappingId)) {
            return idSet;
        }
        BillMappingInfo bill = this.getBillMappingInfo(ctx, CommonUtil.convert2PK(billMappingId));
        BaseDataTypeInfo typeInfo = null;
        if (bill != null) {
            BillMappingEntryCollection coll = bill.getEntrys();
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                BillMappingEntryInfo entry = (BillMappingEntryInfo)it.next();
                if (entry == null || !isAllValue && entry.isDropped() || (typeInfo = entry.getBaseDataType()) == null) continue;
                idSet.add(typeInfo.getId().toString());
            }
            AssistAccountTypeInfo assistInfo = bill.getAssistAccountType();
            if (assistInfo != null) {
                assistInfo = AssistAccountTypeFactory.getLocalInstance(ctx).getAssistAccountTypeInfo(CommonUtil.convert2PK(assistInfo.getId().toString()));
                AssistAccountTypeEntryCollection entrys = assistInfo.getEntrys();
                Iterator acctIt = entrys.iterator();
                while (acctIt.hasNext()) {
                    BaseDataTypeInfo typeInf;
                    AssistAccountTypeEntryInfo acct = (AssistAccountTypeEntryInfo)acctIt.next();
                    if (acct == null || (typeInf = acct.getBaseDataType()) == null) continue;
                    idSet.add(typeInf.getId().toString());
                }
            }
        }
        return idSet;
    }

    @Override
    protected Set _getBaseDataMapping(Context ctx, String billMappingID, boolean isAllValue) throws BOSException, EASBizException {
        HashSet<String> mapIds = new HashSet<String>();
        Set typeIdSet = this._getBaseDataType(ctx, billMappingID, isAllValue);
        if (typeIdSet.size() == 0) {
            return mapIds;
        }
        StringBuffer idBuffer = new StringBuffer();
        for (String typeId : typeIdSet) {
            if (idBuffer.length() > 0) {
                idBuffer.append(",");
            }
            idBuffer.append("'").append(typeId).append("'");
        }
        BaseDataMapingCollection coll = BaseDataMapingFactory.getLocalInstance(ctx).getBaseDataMapingCollection(" where baseDataType.id in (" + idBuffer.toString() + ")");
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            BaseDataMapingInfo info = (BaseDataMapingInfo)it.next();
            if (info == null) continue;
            mapIds.add(info.getId().toString());
        }
        return mapIds;
    }

    @Override
    protected Set _getMultiBaseData(Context ctx, String billMappingId) throws BOSException, EASBizException {
        HashSet<String> mapIds = new HashSet<String>();
        MultiToMultiMapCollection coll = MultiToMultiMapFactory.getLocalInstance(ctx).getMultiToMultiMapCollection("where strategy.id = '" + billMappingId + "'");
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            MultiToMultiMapInfo info = (MultiToMultiMapInfo)it.next();
            if (info == null) continue;
            mapIds.add(info.getId().toString());
        }
        return mapIds;
    }

    @Override
    protected Set _getSchedule(Context ctx, String billMappingId, int scheduleType) throws BOSException, EASBizException {
        HashSet<String> scheduleIds = new HashSet<String>();
        ISchedule instacne = ScheduleFactory.getLocalInstance(ctx);
        ScheduleCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set mapIds = new HashSet();
        if (scheduleType != 1) {
            mapIds = this._getBaseDataMapping(ctx, billMappingId, false);
        }
        switch (scheduleType) {
            case 1: {
                filter.getFilterItems().add(new FilterItemInfo("strategy.id", (Object)billMappingId, CompareType.EQUALS));
                break;
            }
            case 2: {
                filter.getFilterItems().add(new FilterItemInfo("baseDataMap.id", mapIds, CompareType.INCLUDE));
                break;
            }
            default: {
                filter.getFilterItems().add(new FilterItemInfo("strategy.id", (Object)billMappingId, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("baseDataMap.id", mapIds, CompareType.INCLUDE));
                filter.setMaskString("#0 or #1");
            }
        }
        view.setFilter(filter);
        coll = ScheduleFactory.getLocalInstance(ctx).getScheduleCollection(view);
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            ScheduleInfo info = (ScheduleInfo)it.next();
            scheduleIds.add(info.getId().toString());
        }
        return scheduleIds;
    }

    @Override
    protected void _deleteValidMeta(Context ctx) throws BOSException, EASBizException {
        ArrayList<String> metaList = new ArrayList<String>();
        ArrayList<String> existList = new ArrayList<String>();
        IBriefViewTreeNode vtn = SubSystemUtils.getSubSystemByName((Context)ctx, (String)"com_kingdee_eas_base_botp", (BOSObjectType[])new BOSObjectType[]{MetaDataTypeList.ENTITY});
        for (int i = 0; i < vtn.getChildCount(); ++i) {
            BriefViewTreeNode tree = (BriefViewTreeNode)vtn.getChildAt(i);
            MetaDataBriefInfo info = (MetaDataBriefInfo)tree.getUserObject();
            String packageName = info.getName();
            if (!"csinterface".equalsIgnoreCase(packageName)) continue;
            for (int j = 0; j < tree.getChildCount(); ++j) {
                BriefViewTreeNode node = (BriefViewTreeNode)tree.getChildAt(j);
                MetaDataBriefInfo nodeInfo = (MetaDataBriefInfo)node.getUserObject();
                String nodeName = nodeInfo.getName();
                if (!"custom".equalsIgnoreCase(nodeName)) continue;
                for (int k = 0; k < node.getChildCount(); ++k) {
                    BriefViewTreeNode billNode = (BriefViewTreeNode)node.getChildAt(k);
                    MetaDataBriefInfo billNodeInfo = (MetaDataBriefInfo)billNode.getUserObject();
                    String billNum = billNodeInfo.getName();
                    metaList.add(billNum);
                }
            }
        }
        BillMappingCollection coll = this.getBillMappingCollection(ctx);
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            BillMappingInfo billInfo = (BillMappingInfo)it.next();
            existList.add(billInfo.getNumber());
        }
        metaList.removeAll(existList);
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < metaList.size(); ++i) {
            try {
                MetadataTemplateCopyUtil.delete(ctx, (String)metaList.get(i));
                continue;
            }
            catch (Exception e) {
                bf.append((String)metaList.get(i) + ",");
            }
        }
        logger.error((Object)("EIP\u5220\u9664\u65e0\u6548\u5143\u6570\u636e\u5931\u8d25\u7684\u540d\u79f0\u5355\u636e\u540d\u79f0\uff1a" + bf.toString()));
    }

    @Override
    protected List _getBOTPList(Context ctx, String billId, boolean isAll) throws BOSException, EASBizException {
        ArrayList<String> botIds = new ArrayList<String>();
        BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo(CommonUtil.convert2PK(billId));
        String name = "com.kingdee.eas.csinterface.custom.app." + billMappingInfo.getNumber();
        EntityViewInfo btpView = new EntityViewInfo();
        FilterInfo btpFilter = new FilterInfo();
        btpFilter.getFilterItems().add(new FilterItemInfo("srcEntityFullName", (Object)name, CompareType.EQUALS));
        if (!isAll) {
            btpFilter.getFilterItems().add(new FilterItemInfo("extRule.isEffected", (Object)"1", CompareType.EQUALS));
        }
        btpView.setFilter(btpFilter);
        IBOTMapping botInstance = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingCollection btps = botInstance.getBOTMappingCollection(btpView);
        for (BOTMappingInfo botInfo : btps) {
            botIds.add(botInfo.getId().toString());
        }
        return botIds;
    }

    @Override
    protected String _getSrcDbView(Context ctx, String billId) throws BOSException, EASBizException {
        String srcDBViewId;
        block2: {
            srcDBViewId = null;
            BillMappingInfo billInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo(CommonUtil.convert2PK(billId));
            String srcViewName = billInfo.getSrcViewName();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("mainView", (Object)srcViewName, CompareType.EQUALS));
            DataSourceType dsType = billInfo.getDsType();
            if (DataSourceType.jdbc.equals((Object)dsType)) {
                filter.getFilterItems().add(new FilterItemInfo("connection.id", (Object)billInfo.getSrcDBConn().getId().toString(), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("agentUser.id", (Object)billInfo.getAgentUser().getId().toString(), CompareType.EQUALS));
            }
            view.setFilter(filter);
            SrcDBViewCollection srcViewColl = SrcDBViewFactory.getLocalInstance(ctx).getSrcDBViewCollection(view);
            Iterator it = srcViewColl.iterator();
            if (!it.hasNext()) break block2;
            SrcDBViewInfo viewInfo = (SrcDBViewInfo)it.next();
            srcDBViewId = viewInfo.getId().toString();
        }
        return srcDBViewId;
    }

    @Override
    protected List _getBizWizard(Context ctx, String billId) throws BOSException, EASBizException {
        ArrayList<String> bizWizardList = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billMapId", (Object)billId, CompareType.EQUALS));
        view.setFilter(filter);
        BizWizardCollection wizardColl = BizWizardFactory.getLocalInstance(ctx).getBizWizardCollection(view);
        Iterator it = wizardColl.iterator();
        while (it.hasNext()) {
            BizWizardInfo wizard = (BizWizardInfo)it.next();
            bizWizardList.add(wizard.getId().toString());
        }
        return bizWizardList;
    }

    @Override
    protected List _getPlanManager(Context ctx, String billId) throws BOSException, EASBizException {
        ArrayList<String> planList = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizbillmapping.id", (Object)billId, CompareType.EQUALS));
        view.setFilter(filter);
        PlanManagerCollection planColl = PlanManagerFactory.getLocalInstance(ctx).getPlanManagerCollection(view);
        Iterator it = planColl.iterator();
        while (it.hasNext()) {
            PlanManagerInfo plan = (PlanManagerInfo)it.next();
            planList.add(plan.getId().toString());
        }
        return planList;
    }
}

