/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.billmapping.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.monitor.app.util.JobHandler4BillMutexAPI;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleFacade;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.Uuid;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillFunMetuxUtil {
    private static final Logger logger = Logger.getLogger(BillFunMetuxUtil.class);
    private static final String BILL_PREFIX = "BILL_";
    private static final String BASEDATA_PREFIX = "BASEDATA_";
    public static final String EIP_SERVICETYPE = "EIP";

    public static void getRequestFunctionMutex(Context ctx, MutexParameter mutexParameter) {
        IMutexServiceControl mutexServiceControl = null;
        try {
            mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutexServiceControl.requestMutex(mutexParameter);
        }
        catch (BOSException e) {
            logger.error((Object)"\u7533\u8bf7\u529f\u80fd\u4e92\u65a5\u9501\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public static Map getFunctionMutexList(Context ctx) {
        IMutexServiceControl mutexServiceControl = null;
        Map map = null;
        try {
            mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            map = mutexServiceControl.getMutexList();
        }
        catch (BOSException e) {
            logger.error((Object)"\u83b7\u53d6\u6240\u6709\u7684\u529f\u80fd\u4e92\u65a5\u9501\u5f02\u5e38\uff01", (Throwable)e);
        }
        return map;
    }

    public static void releaseFunctionMutex(Context ctx, Uuid requestId) {
        if (requestId == null) {
            return;
        }
        IMutexServiceControl mutexServiceControl = null;
        try {
            mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutexServiceControl.releaseMutex(requestId);
        }
        catch (BOSException e) {
            logger.error((Object)"\u91ca\u653e\u529f\u80fd\u4e92\u65a5\u9501\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public static boolean isRequstFunMutex(Context ctx, BillMappingInfo billMappingInfo, String operatorType) {
        boolean flag = false;
        try {
            Map funMutexList = BillFunMetuxUtil.getFunctionMutexList(ctx);
            if (funMutexList == null || funMutexList.size() == 0) {
                flag = true;
            } else {
                Iterator entries = funMutexList.entrySet().iterator();
                int count = 0;
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    String key = (String)entry.getKey();
                    MutexParameter value = (MutexParameter)entry.getValue();
                    if (!(BILL_PREFIX + billMappingInfo.getNumber()).equals(value.getMutexName())) continue;
                    flag = operatorType.equals(value.getActionName());
                    ++count;
                }
                if (count == 0) {
                    flag = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"EIP\u5355\u636e\u96c6\u6210\uff0c\u83b7\u53d6\u529f\u80fd\u4e92\u65a5\u9501\u5f02\u5e38\uff01", (Throwable)e);
        }
        return flag;
    }

    public static MutexParameter requestFunMutex(Context ctx, CoreBaseInfo base, String operatorType) {
        MutexParameter retParam = null;
        if (null != base && base instanceof BillMappingInfo) {
            retParam = BillFunMetuxUtil.generateFunMutexParam(ctx, (BillMappingInfo)base, operatorType, BILL_PREFIX);
            BillFunMetuxUtil.getRequestFunctionMutex(ctx, retParam);
        }
        return retParam;
    }

    private static MutexParameter generateFunMutexParam(Context ctx, BillMappingInfo billMappingInfo, String operatorType, String typePrefix) {
        MutexParameter retParam = new MutexParameter();
        retParam.setActionName(operatorType);
        retParam.setAIX(ctx.getAIS());
        retParam.setCreateTime(new Date());
        retParam.setDcName(ctx.getAIS());
        retParam.setDescription(ctx.getAIS() + "_" + billMappingInfo.getNumber() + "_" + operatorType);
        retParam.setMutexLockType(MutexLockType.SHARE_LOCK);
        retParam.setMutexName(typePrefix + billMappingInfo.getNumber());
        retParam.setSessionID(ctx.getContextID());
        retParam.setOrgUnitID(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
        retParam.setRequestId(Uuid.create());
        retParam.setUserID(BOSUuid.read((String)ctx.getCaller().toString()));
        return retParam;
    }

    public static void triggerBillDelayTask4Client(Context ctx, Map<String, Object> param, String filter, BillMappingInfo billMappingInfo, BOTMappingInfo botMappingInfo, Set<String> headpkSet, String operateType, long delayTime) throws BOSException {
        try {
            int mutexCode = (billMappingInfo.getId().toString() + new SimpleDateFormat("yyyy-MM-dd").format(new Date())).hashCode();
            String description = "~" + mutexCode + "_EIP\u5355\u636e\u540c\u6b65(" + billMappingInfo.getNumber() + ")_" + operateType;
            String mutex = "G::_" + billMappingInfo.getNumber() + "_" + operateType + "_" + Uuid.create();
            Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() + delayTime);
            JobHandler4BillMutexAPI handler = new JobHandler4BillMutexAPI(param, filter, billMappingInfo, botMappingInfo, headpkSet, operateType);
            JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)handler, true, true, 0, mutex, null, Configuration.defaultJobIsolationLevel());
            try {
                Method method = cfg.getClass().getMethod("setServiceType", String.class);
                method.invoke((Object)cfg, EIP_SERVICETYPE);
            }
            catch (Throwable method) {
                // empty catch block
            }
            String instanceName = Configuration.instanceId();
            Job job1 = new Job(ctx, instanceName + "_" + description, cfg, null, scheduledTime);
            String isolation = ScheduleFacade.getIsolation(EIP_SERVICETYPE, ctx);
            if (isolation != null) {
                job1.setIsolationBoundary(isolation);
            }
            JobServiceFactory.getLocalInstance((Context)ctx).createJobInstance(job1);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void triggerBillDelayTask4Schedule(Context ctx, String scheduledId, Map<String, Object> param, long delayTime) throws BOSException {
        try {
            int mutexCode = (scheduledId + new SimpleDateFormat("yyyy-MM-dd").format(new Date())).hashCode();
            String description = "~" + mutexCode + "_EIP\u6267\u884c\u8c03\u5ea6(" + scheduledId + ")";
            String mutex = "G::_" + scheduledId + "_" + Uuid.create();
            Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() + delayTime);
            JobHandler4BillMutexAPI handler = new JobHandler4BillMutexAPI(scheduledId, param);
            JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)handler, true, true, 0, mutex, null, Configuration.defaultJobIsolationLevel());
            try {
                Method method = cfg.getClass().getMethod("setServiceType", String.class);
                method.invoke((Object)cfg, EIP_SERVICETYPE);
            }
            catch (Throwable method) {
                // empty catch block
            }
            String instanceName = Configuration.instanceId();
            Job job1 = new Job(ctx, instanceName + "_" + description, cfg, null, scheduledTime);
            String isolation = ScheduleFacade.getIsolation(EIP_SERVICETYPE, ctx);
            if (isolation != null) {
                job1.setIsolationBoundary(isolation);
            }
            JobServiceFactory.getLocalInstance((Context)ctx).createJobInstance(job1);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

