/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.billmapping.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingType;
import com.kingdee.eas.csinterface.billmapping.IBillMapping;
import com.kingdee.eas.csinterface.billmapping.IReportField;
import com.kingdee.eas.csinterface.billmapping.ReportFieldCollection;
import com.kingdee.eas.csinterface.billmapping.ReportFieldFactory;
import com.kingdee.eas.csinterface.billmapping.ReportFieldInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.util.CommonUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BillMappingUtil {
    public static SelectorItemCollection getFullSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("srcDBConn.*");
        selector.add("assistAccountType.*");
        selector.add("assistAccountType.entrys.*");
        selector.add("assistAccountType.entrys.baseDataType.*");
        selector.add("assistAccountType.entrys.baseDataType.destBaseData.*");
        selector.add("Entrys.*");
        selector.add("Entrys.baseDataType.*");
        selector.add("Entrys.baseDataType.destBaseData.*");
        return selector;
    }

    public static Map<String, String> getReportFieldForColumn(Context ctx, String billNumber) throws Exception {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        BillMappingInfo billInfo = null;
        IBillMapping instance = null;
        IReportField reportInstance = null;
        if (ctx == null) {
            instance = BillMappingFactory.getRemoteInstance();
            reportInstance = ReportFieldFactory.getRemoteInstance();
        } else {
            instance = BillMappingFactory.getLocalInstance(ctx);
            reportInstance = ReportFieldFactory.getLocalInstance(ctx);
        }
        billInfo = instance.getBillMappingInfo("where number='" + billNumber + "'");
        if (billInfo == null) {
            throw new BOSException("EIP-\u67e5\u8be2\u7684\u5355\u636e\u7f16\u7801\uff08" + billNumber + "\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002");
        }
        if (BillMappingType.reportMapping.equals((Object)billInfo.getMappingType())) {
            DIPMetadata dm = new DIPMetadata(billInfo.getNumber());
            EntityObjectInfo headEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
            EntityObjectInfo entryEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
            if (headEntityInfo == null) {
                throw new BOSException("EIP-\u5355\u636e\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u3002");
            }
            BillMappingEntryCollection entrys = BillMappingUtil.getUnDropedEntry(billInfo);
            Iterator entryIte = entrys.iterator();
            BillMappingEntryInfo entryInfo = null;
            String midName = null;
            PropertyInfo prot = null;
            String dbColumnName = null;
            ReportFieldInfo report = null;
            while (entryIte.hasNext()) {
                entryInfo = (BillMappingEntryInfo)entryIte.next();
                boolean isHead = entryInfo.isHead();
                midName = entryInfo.getMidFieldName();
                report = entryInfo.getReportField();
                if (report == null) continue;
                report = reportInstance.getReportFieldInfo(CommonUtil.convert2PK(entryInfo.getReportField().getId().toString()));
                prot = isHead ? headEntityInfo.getPropertyByName(midName) : entryEntityInfo.getPropertyByName(midName);
                dbColumnName = prot.getMappingField().getName();
                fieldMap.put(report.getNumber().toLowerCase(), dbColumnName);
            }
        }
        return fieldMap;
    }

    public static Map<String, String> getReportFieldForProperty(Context ctx, String billNumber) throws Exception {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        BillMappingInfo billInfo = null;
        IBillMapping instance = null;
        IReportField reportInstance = null;
        if (ctx == null) {
            instance = BillMappingFactory.getRemoteInstance();
            reportInstance = ReportFieldFactory.getRemoteInstance();
        } else {
            instance = BillMappingFactory.getLocalInstance(ctx);
            reportInstance = ReportFieldFactory.getLocalInstance(ctx);
        }
        billInfo = instance.getBillMappingInfo("where number='" + billNumber + "'");
        if (billInfo == null) {
            throw new BOSException("EIP-\u67e5\u8be2\u7684\u5355\u636e\u7f16\u7801\uff08" + billNumber + "\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002");
        }
        if (BillMappingType.reportMapping.equals((Object)billInfo.getMappingType())) {
            DIPMetadata dm = new DIPMetadata(billInfo.getNumber());
            EntityObjectInfo headEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
            EntityObjectInfo entryEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
            if (headEntityInfo == null) {
                throw new BOSException("EIP-\u5355\u636e\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u3002");
            }
            BillMappingEntryCollection entrys = BillMappingUtil.getUnDropedEntry(billInfo);
            Iterator entryIte = entrys.iterator();
            BillMappingEntryInfo entryInfo = null;
            String midName = null;
            PropertyInfo prot = null;
            String fieldName = null;
            ReportFieldInfo report = null;
            HashMap<String, ReportFieldInfo> reportMap = new HashMap<String, ReportFieldInfo>();
            ReportFieldCollection reportColl = reportInstance.getReportFieldCollection();
            Iterator reportIte = reportColl.iterator();
            while (reportIte.hasNext()) {
                ReportFieldInfo reprotInfo = (ReportFieldInfo)reportIte.next();
                reportMap.put(reprotInfo.getId().toString(), reprotInfo);
            }
            while (entryIte.hasNext()) {
                entryInfo = (BillMappingEntryInfo)entryIte.next();
                boolean isHead = entryInfo.isHead();
                midName = entryInfo.getMidFieldName();
                report = entryInfo.getReportField();
                if (report == null || (report = (ReportFieldInfo)reportMap.get(entryInfo.getReportField().getId().toString())) == null) continue;
                prot = isHead ? headEntityInfo.getPropertyByName(midName) : entryEntityInfo.getPropertyByName(midName);
                fieldName = prot.getName();
                fieldMap.put(report.getNumber().toLowerCase(), fieldName);
            }
        }
        return fieldMap;
    }

    public static BillMappingEntryCollection getUnDropedEntry(BillMappingInfo billInfo) throws Exception {
        BillMappingEntryCollection entrys = billInfo.getEntrys();
        Iterator entryIte = entrys.iterator();
        BillMappingEntryInfo entryInfo = null;
        while (entryIte.hasNext()) {
            entryInfo = (BillMappingEntryInfo)entryIte.next();
            if (!entryInfo.isDropped()) continue;
            entryIte.remove();
        }
        return entrys;
    }
}

