/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.load;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.openapi.util.OpenApiBOUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.biz.DataSourceInfo;
import com.kingdee.eas.csinterface.biz.EIPRelationCollection;
import com.kingdee.eas.csinterface.biz.EIPRelationFactory;
import com.kingdee.eas.csinterface.biz.EIPRelationInfo;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.app.DataSourceType;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.data.PKTableData;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.load.AbstractDataLoader;
import com.kingdee.eas.csinterface.biz.log.MonitorLogManager;
import com.kingdee.eas.csinterface.biz.model.PKTable;
import com.kingdee.eas.csinterface.biz.util.DateUtils;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataLoaderForAdd
extends AbstractDataLoader {
    private static final Logger logger = Logger.getLogger(DataLoaderForAdd.class);

    protected DataLoaderForAdd() {
    }

    @Override
    public List<String> loadData(String data) {
        ProjectInfo projectInfo = (ProjectInfo)EIPContext.getInstance().get("projectInfo");
        data = this.preHandle(data, projectInfo);
        String clzObjectValueName = null;
        try {
            Context ctx = EIPContext.getInstance().getContext();
            BOSObjectType bosObjectType = BOSObjectType.create((String)projectInfo.getTargetObj());
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosObjectType);
            clzObjectValueName = entityObjectInfo.getObjectCollectionClass();
            Class<IObjectCollection> objectCollectionClass = Class.forName(clzObjectValueName);
            MethodInfo method = this.getMethodInfoFromEntryInfo(projectInfo.getTargetFunc(), entityObjectInfo, "addMethod");
            Object[] result = new Object[]{};
            if (!StringUtils.isEmpty((String)data)) {
                List<Object> paramsValue = this.getParamsValue(method, objectCollectionClass, data);
                result = new Object[paramsValue.size()];
                for (int i = 0; i < paramsValue.size(); ++i) {
                    result[i] = OpenApiBOUtils.callMethod((Context)ctx, (BOSObjectType)bosObjectType, (MethodInfo)method, (Object[])new Object[]{paramsValue.get(i)});
                }
            }
            List<String> successIds = this.parseResult(result);
            this.postHandle(successIds, projectInfo);
            return successIds;
        }
        catch (ClassNotFoundException e) {
            MonitorLogManager.error("\u96c6\u6210\u5931\u8d25\uff1a" + e.getCause().getMessage() + ("can't find " + clzObjectValueName) + "\n", ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            logger.error((Object)("\u96c6\u6210\u51fa\u9519\uff0ccan't find " + clzObjectValueName), (Throwable)e);
        }
        catch (Exception e1) {
            MonitorLogManager.error("\u96c6\u6210\u5931\u8d25\uff1a" + e1.getCause().getMessage() + "\n", ExceptionUtil.getExcLinkStackTrace((Throwable)e1));
            logger.error((Object)"\u96c6\u6210\u51fa\u9519", (Throwable)e1);
        }
        return Collections.emptyList();
    }

    @Override
    public void callback(List<String> successIds, TableData srcData) {
        Context ctx = EIPContext.getInstance().getContext();
        Map srcToDest = (Map)EIPContext.getInstance().get("srcToDest");
        ConnectionInfo conn = (ConnectionInfo)EIPContext.getInstance().get("connectionInfo");
        DataSourceInfo dataSourceInfo = (DataSourceInfo)EIPContext.getInstance().get("dataSourceInfo");
        ProjectInfo projectInfo = (ProjectInfo)EIPContext.getInstance().get("projectInfo");
        Map dataSourceResult = (Map)EIPContext.getInstance().get("dataSourceResult");
        String changeTimeField = (String)dataSourceResult.get("changeTimeField");
        String headPKField = (String)dataSourceResult.get("headpk");
        boolean fromJBDC = DataSourceType.JDBC.equals((Object)dataSourceInfo.getDsType());
        PKTable pkTable = new PKTable(dataSourceInfo.getMainView(), conn);
        EIPRelationCollection relations = new EIPRelationCollection();
        String code = dataSourceInfo.getIdentify();
        String targetObj = projectInfo.getTargetObj();
        String connid = conn == null ? null : conn.getId().toString();
        srcData.reset();
        while (srcData.next()) {
            String headPK = srcData.getString(headPKField);
            String destId = (String)srcToDest.get(headPK);
            if (!successIds.contains(destId)) continue;
            EIPRelationInfo relation = new EIPRelationInfo();
            relation.setSrcObjectID(headPK);
            relation.setDestObjectID(destId);
            relation.setIdentificationCode(code);
            relation.setDestEntityID(targetObj);
            relations.add(relation);
            String changeTime = srcData.getString(changeTimeField);
            if (!fromJBDC) continue;
            pkTable.addTableData(new PKTableData(headPK, null, null, connid, 1, 1, new Timestamp(DateUtils.parse(changeTime).getTime()), null));
        }
        if (fromJBDC && pkTable.size() > 0) {
            pkTable.executeInsert();
        }
        if (relations.size() > 0) {
            CoreBaseCollection objCol = new CoreBaseCollection();
            objCol.addObjectCollection((IObjectCollection)relations);
            try {
                EIPRelationFactory.getLocalInstance(ctx).save(objCol);
            }
            catch (Exception e) {
                logger.error((Object)"\u3010EIP\u3011\u4fdd\u5b58\u5173\u7cfb\u5f02\u5e38", (Throwable)e);
            }
        }
    }
}

