/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.load;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.openapi.util.OpenApiBOUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.biz.DataSourceInfo;
import com.kingdee.eas.csinterface.biz.EIPRelationFactory;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.app.DataSourceType;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.data.PKTableData;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.load.AbstractDataLoader;
import com.kingdee.eas.csinterface.biz.model.PKTable;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataLoaderForDelete
extends AbstractDataLoader {
    private static final Logger logger = Logger.getLogger(DataLoaderForDelete.class);

    protected DataLoaderForDelete() {
    }

    @Override
    public List<String> loadData(String data) {
        ProjectInfo projectInfo = (ProjectInfo)EIPContext.getInstance().get("projectInfo");
        data = this.preHandle(data, projectInfo);
        try {
            List ids = (List)JSONObject.parseObject((String)data, List.class);
            Context ctx = EIPContext.getInstance().getContext();
            ArrayList<ObjectStringPK> pks = new ArrayList<ObjectStringPK>();
            for (int i = 0; i < ids.size(); ++i) {
                String pk = (String)ids.get(i);
                if (StringUtils.isEmpty((String)pk)) continue;
                pks.add(new ObjectStringPK(pk));
            }
            if (!pks.isEmpty()) {
                BOSObjectType bosObjectType = BOSObjectType.create((String)projectInfo.getTargetObj());
                EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosObjectType);
                MethodInfo method = this.getMethodInfoFromEntryInfo(projectInfo.getTargetFunc(), entityObjectInfo, "deleteMethod");
                OpenApiBOUtils.callMethod((Context)ctx, (BOSObjectType)bosObjectType, (MethodInfo)method, (Object[])new Object[]{pks.toArray(new ObjectStringPK[0])});
            }
            this.postHandle(ids, projectInfo);
            return ids;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void callback(List<String> successIds, TableData srcData) {
        Context ctx = EIPContext.getInstance().getContext();
        Map srcToDest = (Map)EIPContext.getInstance().get("srcToDest");
        ConnectionInfo conn = (ConnectionInfo)EIPContext.getInstance().get("connectionInfo");
        DataSourceInfo dataSourceInfo = (DataSourceInfo)EIPContext.getInstance().get("dataSourceInfo");
        if (DataSourceType.JDBC.equals((Object)dataSourceInfo.getDsType())) {
            PKTable pkTable = new PKTable(dataSourceInfo.getMainView(), conn);
            for (String successId : successIds) {
                pkTable.addTableData(new PKTableData((String)srcToDest.get(successId)));
            }
            pkTable.executeDelete();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("identificationCode", (Object)dataSourceInfo.getIdentify(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", new HashSet<String>(successIds), CompareType.INCLUDE));
        try {
            EIPRelationFactory.getLocalInstance(ctx).delete(filter);
        }
        catch (Exception e) {
            logger.error((Object)"\u3010EIP\u3011\u5220\u9664\u5173\u7cfb\u8868\u5f02\u5e38", (Throwable)e);
        }
    }
}

