/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.model;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.csinterface.biz.exception.EIPException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SQLBuilder {
    private Map<String, Table> tables = new HashMap<String, Table>();

    private SQLBuilder() {
    }

    public static SQLBuilder getInstance() {
        return new SQLBuilder();
    }

    public Table addATable(String tableName) {
        if (this.tables.size() != 0) {
            throw new EIPException("\u975e\u4e3b\u8868\u8bf7\u6307\u5b9a\u5173\u8054\u5173\u7cfb");
        }
        Table table = new Table(tableName, "t1");
        this.tables.put("t1", table);
        return table;
    }

    public Table addATable(String tableName, String selfField, String relateTable, String relateField) {
        String alias = "t" + (this.tables.size() + 1);
        Table table = new Table(tableName, alias, this.tables.get(relateTable), relateField, selfField);
        this.tables.put(alias, table);
        return table;
    }

    public Table getMainTable() {
        ArrayList<Table> soreTables = new ArrayList<Table>(this.tables.values());
        Collections.sort(soreTables, new Comparator<Table>(){

            @Override
            public int compare(Table t1, Table t2) {
                return t1.getAlias().compareTo(t2.getAlias());
            }
        });
        if (!soreTables.isEmpty()) {
            return (Table)soreTables.get(0);
        }
        return null;
    }

    public String toSql() {
        ArrayList<Table> soreTables = new ArrayList<Table>(this.tables.values());
        Collections.sort(soreTables, new Comparator<Table>(){

            @Override
            public int compare(Table t1, Table t2) {
                return t1.getAlias().compareTo(t2.getAlias());
            }
        });
        Iterator it = soreTables.iterator();
        StringBuilder selectors = new StringBuilder("");
        StringBuilder froms = new StringBuilder("");
        StringBuilder wheres = new StringBuilder("");
        while (it.hasNext()) {
            Table table = (Table)it.next();
            String selector = table.getSlector();
            if (selectors.length() > 0 && selector.length() > 0) {
                selectors.append(",");
            }
            selectors.append(selector);
            String join = table.getJoins();
            if (froms.length() > 0 && join.length() > 0) {
                froms.append(" ");
            }
            froms.append(join);
            String filter = table.getFilter();
            if (StringUtils.isEmpty((String)filter)) continue;
            if (wheres.length() > 0) {
                wheres.append(" and ");
            }
            wheres.append(filter);
        }
        StringBuilder sql = new StringBuilder("SELECT ");
        Table mainTable = (Table)soreTables.get(0);
        if (mainTable.isIsDistinct()) {
            sql.append(" DISTINCT ");
        }
        if (mainTable.getIndex() != null && mainTable.getRows() != null) {
            sql.append(" TOP ").append(mainTable.getRows()).append(",").append(mainTable.getIndex());
        }
        sql.append((CharSequence)selectors).append(" FROM ").append((CharSequence)froms);
        if (wheres.length() > 0) {
            sql.append(" WHERE ").append((CharSequence)wheres);
        }
        return sql.toString();
    }

    public class Column {
        private String name;
        private String alias;

        public Column() {
        }

        public Column(String name, String alias) {
            this.name = name;
            this.alias = alias;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    public class Table {
        private Logger logger = Logger.getLogger(Table.class);
        private String name;
        private String alias;
        private List<Column> columns = new ArrayList<Column>();
        private String filter;
        private Table relateTable;
        private String relateField;
        private String selfField;
        private Integer rows;
        private Integer index;
        private boolean isDistinct = false;

        public Table() {
        }

        public Table(String name, String alias) {
            this.name = name;
            this.alias = alias;
        }

        public Table(String name, String alias, Table relateTable, String relateField, String selfField) {
            this.name = name;
            this.alias = alias;
            this.relateTable = relateTable;
            this.relateField = relateField;
            this.selfField = selfField;
        }

        public Column addColumn(String name) {
            return this.addColumn(name, name);
        }

        public Column addColumn(String name, String alias) {
            Column column = new Column(name, alias);
            if (this.columns == null) {
                this.columns = new ArrayList<Column>();
            }
            this.columns.add(column);
            return column;
        }

        public void appendFilter(String filter) {
            if (StringUtils.isEmpty((String)filter)) {
                return;
            }
            if (this.filter == null) {
                this.filter = filter;
            } else {
                boolean startWithConn = filter.trim().matches("^(and|or).+");
                if (!startWithConn && this.filter.length() > 0) {
                    filter = " and " + filter;
                } else if (this.filter.length() > 0 && !filter.startsWith(" ")) {
                    filter = " " + filter;
                }
                this.filter = this.filter + filter;
            }
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getSlector() {
            StringBuilder selector = new StringBuilder();
            for (Column column : this.columns) {
                selector.append(this.alias + ".\"").append(column.getName()).append("\" AS \"").append(column.getAlias()).append("\"").append(",");
            }
            if (selector.length() > 0) {
                return selector.substring(0, selector.length() - 1);
            }
            return "";
        }

        public String getJoins() {
            if (StringUtils.isEmpty((String)this.selfField)) {
                return this.name + " " + this.alias;
            }
            return new StringBuffer("LEFT OUTER JOIN ").append(this.name).append(" ").append(this.alias).append(" ON ").append(this.relateTable.getAlias()).append(".").append(this.relateField).append(" = ").append(this.alias).append(".").append(this.selfField).toString();
        }

        public String getFilter() {
            this.formatFilter();
            return this.filter;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public List<Column> getColumns() {
            return this.columns;
        }

        public Table getRelateTable() {
            return this.relateTable;
        }

        public String getRelateField() {
            return this.relateField;
        }

        public String getSelfField() {
            return this.selfField;
        }

        public Integer getRows() {
            return this.rows;
        }

        public void setRows(Integer rows) {
            this.rows = rows;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public boolean isIsDistinct() {
            return this.isDistinct;
        }

        public void setIsDistinct(boolean isDistinct) {
            this.isDistinct = isDistinct;
        }

        private void formatFilter() {
            if (StringUtils.isEmpty((String)this.filter)) {
                return;
            }
            try {
                FilterInfo filterInfo = new FilterInfo(this.filter);
                FilterItemCollection coll = filterInfo.getFilterItems();
                for (int i = 0; i < coll.size(); ++i) {
                    String propName = coll.get(i).getPropertyName();
                    if (StringUtils.isEmpty((String)propName) || propName.indexOf(46) >= 0) continue;
                    coll.get(i).setPropertyName(this.alias + "." + propName);
                }
                this.filter = filterInfo.toSql();
            }
            catch (ParserException e) {
                this.logger.error((Object)e);
            }
        }
    }
}

