/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.bizbill.metadata.editor;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfoHelper;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.IEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.info.FieldInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.TableInfoUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ListUIEditor
implements IEditor {
    private static final String DYNPROPERTYBINDS = "dynpropertybinds";
    public static final String PRO_FORMATXML = "formatXml";
    private UIObjectInfo uiModel;
    private ComponentInfo tblMainComponent;
    private TableInfo tblMain;
    private QueryInfo queryInfo;
    public static final String bindingObject = "mainQuery";

    public ListUIEditor(UIObjectInfo uiModel, QueryInfo queryInfo) {
        this.uiModel = uiModel;
        this.queryInfo = queryInfo;
        this.init();
    }

    private void init() {
        if (!this.uiModel.isAssembled()) {
            this.uiModel = UIObjectAssembler.assembleUI((Context)ContextManager.getContext(), (UIObjectInfo)this.uiModel);
        }
        ComponentCollection componentCollection = this.uiModel.getMainPanelComponent().getComponents();
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            if (!"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(componentInfo.getClassType())) continue;
            this.tblMainComponent = componentInfo;
            this.tblMain = this.getTableInfo();
        }
    }

    private TableInfo getTableInfo() {
        ComponentInfo cInfo = this.tblMainComponent;
        String formatXml = this.getFormatXml();
        TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)formatXml);
        String formatXmlExt = cInfo.getExtendedProperty("extend_formatxml");
        TableInfoHelper.parseFormatXmlExt((TableInfo)tableInfo, (String)formatXmlExt);
        String order = cInfo.getExtendedProperty("column_order");
        ListUIEditor.reOrderTableFormatXml(tableInfo, order);
        return tableInfo;
    }

    private String getFormatXml() {
        return this.getFormatXml(AbstractUIObjectInfo.currentLocale);
    }

    private String getFormatXml(Locale locale) {
        PropertyInfo property;
        ComponentInfo cInfo = this.tblMainComponent;
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType()) && (property = cInfo.getProperties().get(PRO_FORMATXML)) != null) {
            return property.getValue(locale);
        }
        return null;
    }

    private void setFormatXml(String formatXml) {
        this.setFormatXml(formatXml, UIObjectInfo.currentLocale, true);
    }

    private void setFormatXml(String formatXml, Locale locale, boolean fireProperty) {
        ComponentInfo cInfo = this.tblMainComponent;
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType())) {
            PropertyInfo propInfo = cInfo.getPropertyByName(PRO_FORMATXML);
            if (propInfo == null) {
                propInfo = new PropertyInfo();
                propInfo.setName(PRO_FORMATXML);
                propInfo.setType(String.class.getName());
            }
            propInfo.setMultiLanguage(true);
            propInfo.setValue(formatXml, locale);
            if (cInfo.isHerited()) {
                propInfo.setOverride(true);
            }
            cInfo.getProperties().add(propInfo);
        }
    }

    @Override
    public void add(FieldInfo fieldInfo) throws Exception {
        ColumnInfo column = new ColumnInfo(this.tblMain);
        String name = this.getColumnName(fieldInfo);
        column.setName(name);
        column.setWidth(100);
        column.setHide(false);
        column.setLock(true);
        column.setMergeable(true);
        column.setResizeable(true);
        column.setMoveable(true);
        column.setGroup(fieldInfo.getNamePrefix() == null);
        column.setRequired(false);
        column.setHorizonAlign("left");
        column.setConfigured(true);
        this.tblMain.addColumn(column);
        List headers = this.tblMain.getHeaders();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            HeaderInfo headerInfo = (HeaderInfo)headers.get(i);
            this.addCell(headerInfo, this.getHeaderAlias(fieldInfo));
        }
        this.refreshComponent();
        this.bind(fieldInfo);
    }

    public void addNumber(FieldInfo fieldInfo) throws Exception {
        ColumnInfo column = new ColumnInfo(this.tblMain);
        String name = this.getColumnNumber(fieldInfo);
        column.setName(name);
        column.setWidth(100);
        column.setHide(false);
        column.setLock(true);
        column.setMergeable(true);
        column.setResizeable(true);
        column.setMoveable(true);
        column.setGroup(fieldInfo.getNamePrefix() == null);
        column.setRequired(false);
        column.setHorizonAlign("left");
        column.setConfigured(true);
        this.tblMain.addColumn(column);
        List headers = this.tblMain.getHeaders();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            HeaderInfo headerInfo = (HeaderInfo)headers.get(i);
            this.addCell(headerInfo, this.getHeaderName(fieldInfo));
        }
        this.refreshComponent();
        this.bindNumber(fieldInfo);
    }

    private void refreshComponent() {
        UIObjectInfo uiModel = this.uiModel;
        if (uiModel != null && uiModel instanceof UIObjectInfo) {
            this.extractTableSumInfo(uiModel, this.tblMainComponent, this.tblMain);
        }
        String formatXMLExt = TableInfoHelper.toFormatXmlExt((TableInfo)this.tblMain);
        this.tblMainComponent.setExtendedProperty("extend_formatxml", formatXMLExt);
        String order = ListUIEditor.getTableColumnOrder(this.tblMain);
        this.tblMainComponent.setExtendedProperty("column_order", order);
        if (this.tblMain.getMergeBlockCount() == 0) {
            this.storeFormatXml(this.tblMain);
        } else {
            this.setFormatXml(KDTableDesignerHelper.getXmlFrom((TableInfo)this.tblMain));
        }
        this.tblMainComponent.setConfigured(true);
    }

    private void storeFormatXml(TableInfo tableInfo) {
        for (int i = 0; i < BOSLocaleUtil.EAS_LOCALES.length; ++i) {
            Locale locale = BOSLocaleUtil.EAS_LOCALES[i];
            String formatXml = "";
            String shortcode = BOSLocaleUtil.getShortCode((Locale)locale);
            if (shortcode != null && shortcode != BOSLocaleUtil.getShortCode((Locale)UIObjectInfo.currentLocale)) {
                formatXml = this.getFormatXml(locale);
                TableInfo otableInfo = KDTableDesignerHelper.getTableInfoFrom((String)formatXml);
                TableInfoUtils util = new TableInfoUtils();
                util.setCurrentLocale(AbstractUIObjectInfo.currentLocale);
                util.setTargetLocal(locale);
                util.synTableInfo(otableInfo, tableInfo);
                formatXml = KDTableDesignerHelper.getXmlFrom((TableInfo)otableInfo);
                this.setFormatXml(formatXml, locale, false);
                continue;
            }
            this.setFormatXml(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
        }
    }

    private static String getTableColumnOrder(TableInfo table) {
        if (table == null) {
            return null;
        }
        List columns = table.getColumns();
        StringBuffer sb = new StringBuffer();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
            if (i == 0) {
                sb.append(columnInfo.getName());
                continue;
            }
            sb.append("|" + columnInfo.getName());
        }
        return sb.toString();
    }

    private void extractTableSumInfo(UIObjectInfo uiObject, ComponentInfo tableControl, TableInfo tableInfo) {
        List columns = tableInfo.getColumns();
        int m = columns.size();
        for (int j = 0; j < m; ++j) {
            ColumnInfo column = (ColumnInfo)columns.get(j);
            com.kingdee.bos.metadata.entity.PropertyInfo property = EditUIProxyHelper.getColumnBindProperty((UIObjectInfo)uiObject, (ComponentInfo)tableControl, (String)column.getName(), (boolean)true);
            if (!ConvertUtils.getExtendedPropertyBooelanValue((IObjectValue)property, (String)"needSum")) continue;
            column.setExtendedProperty("needSum", Boolean.TRUE.toString());
        }
    }

    private void addCell(HeaderInfo header, String headName) {
        CellInfo cell = new CellInfo(header);
        cell.setName(headName);
        cell.setConfigured(true);
        header.addCell(cell);
    }

    private void removeCell(int index) {
        List headers = this.tblMain.getHeaders();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            HeaderInfo head = (HeaderInfo)headers.get(i);
            if (index > head.getCellCount() - 1) continue;
            CellInfo cell = (CellInfo)head.getCells().get(index);
            head.removeCell(cell);
        }
    }

    private String getHeaderAlias(FieldInfo fieldInfo) {
        return fieldInfo.getAlias();
    }

    private String getHeaderName(FieldInfo fieldInfo) {
        return fieldInfo.getAlias() + "_\u7f16\u7801";
    }

    private String getColumnName(FieldInfo fieldInfo) {
        String fieldName = fieldInfo.getName();
        return fieldName;
    }

    private String getColumnNumber(FieldInfo fieldInfo) {
        String fieldName = fieldInfo.getName();
        return fieldName + "0";
    }

    private void bind(FieldInfo fieldInfo) throws DIPException {
        String componentName = this.tblMainComponent.getName();
        String propertyName = this.getColumnName(fieldInfo) + ".text";
        String objectName = bindingObject;
        String filedName = fieldInfo.getName();
        if (componentName == null || componentName.equals("") || propertyName == null || propertyName.equals("") || objectName == null || objectName.equals("")) {
            return;
        }
        if ((filedName == null || filedName.equals("")) && propertyName.indexOf("items") == -1) {
            return;
        }
        PropertyBindingInfo propertyBindingInfo = this.createBindingInfo(fieldInfo);
        ComponentCollection componentCollection = this.uiModel.getComponents();
        this.findTheComponentAndBind(propertyBindingInfo, componentName, propertyName, componentCollection);
        this.addProBindDesc(this.tblMainComponent, propertyBindingInfo);
    }

    private void bindNumber(FieldInfo fieldInfo) throws DIPException {
        String componentName = this.tblMainComponent.getName();
        String propertyName = this.getColumnNumber(fieldInfo) + ".text";
        String objectName = bindingObject;
        String filedName = fieldInfo.getName();
        if (componentName == null || componentName.equals("") || propertyName == null || propertyName.equals("") || objectName == null || objectName.equals("")) {
            return;
        }
        if ((filedName == null || filedName.equals("")) && propertyName.indexOf("items") == -1) {
            return;
        }
        PropertyBindingInfo propertyBindingInfo = this.createBindingInfoNumber(fieldInfo);
        ComponentCollection componentCollection = this.uiModel.getComponents();
        this.findTheComponentAndBind(propertyBindingInfo, componentName, propertyName, componentCollection);
        this.addProBindDesc(this.tblMainComponent, propertyBindingInfo);
    }

    private ComponentCollection findTheComponentAndBind(PropertyBindingInfo propertyBindingInfo, String componentName, String propertyName, ComponentCollection componentCollection) {
        boolean find = false;
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            if (componentInfo.getName().trim().equals(componentName)) {
                PropertyBindingCollection propertyBindingCollection = componentInfo.getPropertyBindings();
                for (int j = 0; j < propertyBindingCollection.size(); ++j) {
                    PropertyBindingInfo tempPropertyBindingInfo = propertyBindingCollection.get(j);
                    if (!tempPropertyBindingInfo.getPropertyName().equals(propertyName)) continue;
                    find = true;
                    tempPropertyBindingInfo = this.setPropertyBindingInfoValue(tempPropertyBindingInfo, propertyBindingInfo);
                    propertyBindingCollection.set(j, tempPropertyBindingInfo);
                    componentInfo.setPropertyBindings(propertyBindingCollection);
                    componentCollection.set(i, componentInfo);
                    return componentCollection;
                }
                if (!find) {
                    PropertyBindingInfo tempPBI = new PropertyBindingInfo();
                    tempPBI.setPropertyName(propertyName);
                    tempPBI = this.setPropertyBindingInfoValue(tempPBI, propertyBindingInfo);
                    propertyBindingCollection.add(tempPBI);
                    componentInfo.setPropertyBindings(propertyBindingCollection);
                    componentCollection.set(i, componentInfo);
                    return componentCollection;
                }
            }
            if (componentInfo.isContainer()) {
                ComponentCollection subComponentCollection = componentInfo.getComponents();
                ComponentCollection newSubComponentCollection = this.findTheComponentAndBind(propertyBindingInfo, componentName, propertyName, subComponentCollection);
                componentInfo.setComponents(newSubComponentCollection);
            }
            componentCollection.set(i, componentInfo);
        }
        return componentCollection;
    }

    private PropertyBindingInfo setPropertyBindingInfoValue(PropertyBindingInfo oldPropertyBindingInfo, PropertyBindingInfo newPropertyBindingInfo) {
        oldPropertyBindingInfo.setBindingObject(newPropertyBindingInfo.getBindingObject());
        if (newPropertyBindingInfo.getBingdingField() != null) {
            oldPropertyBindingInfo.setBingdingField(newPropertyBindingInfo.getBingdingField());
        } else {
            oldPropertyBindingInfo.setBingdingField("");
        }
        oldPropertyBindingInfo.setAccessType(2);
        oldPropertyBindingInfo.setAutoMode(false);
        oldPropertyBindingInfo.setPropertyType(newPropertyBindingInfo.getPropertyType());
        oldPropertyBindingInfo.setFieldType(newPropertyBindingInfo.getFieldType());
        oldPropertyBindingInfo.setUserDefined(newPropertyBindingInfo.isUserDefined());
        return oldPropertyBindingInfo;
    }

    private void addProBindDesc(ComponentInfo componentInfo, PropertyBindingInfo propertyBindingInfo) {
        if (componentInfo == null || propertyBindingInfo == null || StringUtils.isEmpty((String)propertyBindingInfo.getPropertyName())) {
            return;
        }
        String proName = propertyBindingInfo.getPropertyName();
        if (componentInfo == null || proName == null) {
            return;
        }
        String dynProBinds = componentInfo.getExtendedProperty(DYNPROPERTYBINDS);
        if (StringUtils.isEmpty((String)dynProBinds)) {
            componentInfo.setExtendedProperty(DYNPROPERTYBINDS, proName);
        } else {
            String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
            boolean exists = false;
            if (pros != null && pros.length > 0) {
                for (int i = 0; i < pros.length; ++i) {
                    if (!proName.equals(pros[i])) continue;
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                dynProBinds = dynProBinds + "|" + proName;
                componentInfo.setExtendedProperty(DYNPROPERTYBINDS, dynProBinds);
            }
        }
    }

    private PropertyBindingInfo createBindingInfo(FieldInfo fieldInfo) throws DIPException {
        PropertyBindingInfo bindingInfo = new PropertyBindingInfo();
        bindingInfo.setPropertyName(this.getColumnName(fieldInfo) + ".text");
        String tempType = null;
        if (StringUtils.isEmpty(tempType)) {
            bindingInfo.setPropertyType(Object.class.getName());
        } else {
            bindingInfo.setPropertyType(tempType);
        }
        bindingInfo.setAccessType(2);
        bindingInfo.setAutoMode(false);
        bindingInfo.setBindingObject(bindingObject);
        QueryFieldInfo queryFieldInfo = this.getQueryFieldInfo(fieldInfo);
        bindingInfo.setBingdingField(queryFieldInfo.getName());
        bindingInfo.setFieldType(ListUIEditor.getFiledType(queryFieldInfo));
        bindingInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        return bindingInfo;
    }

    private PropertyBindingInfo createBindingInfoNumber(FieldInfo fieldInfo) throws DIPException {
        PropertyBindingInfo bindingInfo = new PropertyBindingInfo();
        bindingInfo.setPropertyName(this.getColumnNumber(fieldInfo) + ".text");
        String tempType = null;
        if (StringUtils.isEmpty(tempType)) {
            bindingInfo.setPropertyType(Object.class.getName());
        } else {
            bindingInfo.setPropertyType(tempType);
        }
        bindingInfo.setAccessType(2);
        bindingInfo.setAutoMode(false);
        bindingInfo.setBindingObject(bindingObject);
        QueryFieldInfo queryFieldInfo = this.getQueryFieldInfo(fieldInfo);
        bindingInfo.setBingdingField(queryFieldInfo.getName());
        bindingInfo.setFieldType(ListUIEditor.getFiledType(queryFieldInfo));
        bindingInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        return bindingInfo;
    }

    private static String getFiledType(Object field) {
        String type = "java.lang.String";
        if (field instanceof OwnPropertyInfo) {
            OwnPropertyInfo propInfo = (OwnPropertyInfo)field;
            type = DataType.ENUM.equals((Object)propInfo.getDataType()) ? propInfo.getEnumType().getClassName() : propInfo.getJavaType();
        }
        return type;
    }

    private QueryFieldInfo getQueryFieldInfo(FieldInfo fieldInfo) throws DIPException {
        if (this.queryInfo instanceof QueryInfo) {
            SelectorInfo selectorInfo = this.queryInfo.getSelector();
            int size = selectorInfo.size();
            String displayName = this.getBaseDataDisplayName(fieldInfo);
            for (int i = 0; i < size; ++i) {
                QueryFieldInfo qfInfo = selectorInfo.get(i);
                String fieldName = qfInfo.getName();
                if (!fieldName.equals(displayName)) continue;
                return qfInfo;
            }
            throw new DIPException("'" + displayName + "' not found in " + this.queryInfo.getName());
        }
        return null;
    }

    private String getBaseDataDisplayName(FieldInfo fieldInfo) {
        boolean isBaseDataType;
        boolean bl = isBaseDataType = !StringUtils.isEmpty((String)fieldInfo.getBaseDataType());
        if (isBaseDataType) {
            String baseDataDisplayName = fieldInfo.getBaseDataDisplayName();
            if (!StringUtils.isEmpty((String)baseDataDisplayName) && baseDataDisplayName.indexOf(".") > 0) {
                baseDataDisplayName = baseDataDisplayName.split("\\.")[1];
            }
            return fieldInfo.getName() + "." + baseDataDisplayName;
        }
        return fieldInfo.getName();
    }

    private static void reOrderTableFormatXml(TableInfo table, String order) {
        if (table == null || StringUtils.isEmpty((String)order) || table.getMergeBlockCount() > 0) {
            return;
        }
        String[] orders = order.split("\\|");
        if (orders == null) {
            return;
        }
        ArrayList<String> listColumnNames = new ArrayList<String>(orders.length);
        int size = orders.length;
        for (int j = 0; j < size; ++j) {
            listColumnNames.add(orders[j]);
        }
        ListUIEditor.reOrderTableFormatXml(table, listColumnNames);
    }

    private static void reOrderTableFormatXml(TableInfo tableInfo, List list) {
        if (tableInfo == null || list == null) {
            return;
        }
        int m = 0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int index = ListUIEditor.getColumnIndexByName(tableInfo, list.get(i).toString());
            if (index == -1) continue;
            ListUIEditor.moveKDTableColumn(tableInfo, index, m);
            ++m;
        }
    }

    private static int getColumnIndexByName(TableInfo table, String columnName) {
        if (table == null || StringUtils.isEmpty((String)columnName)) {
            return -1;
        }
        String[] names = table.getColumnNameList();
        int size = names.length;
        for (int i = 0; i < size; ++i) {
            if (!columnName.equals(names[i])) continue;
            return i;
        }
        return -1;
    }

    private static void moveKDTableColumn(TableInfo table, int from, int to) {
        if (table != null && from >= 0 && to >= 0 && from != to && table.getHeaderCount() > 0) {
            int count;
            int n = table.getHeaderCount();
            for (int i = 0; i < n; ++i) {
                HeaderInfo headerInfo = (HeaderInfo)table.getHeaders().get(i);
                count = headerInfo.getCellCount();
                if (from >= count || to >= count) continue;
                ArrayList cells = headerInfo.getCells();
                Object obj = cells.remove(from);
                cells.add(to, obj);
            }
            count = table.getColumnCount();
            if (from < count && to < count) {
                List columns = table.getColumns();
                Object obj = columns.remove(from);
                columns.add(to, obj);
            }
        }
    }

    @Override
    public void delete(FieldInfo fieldInfo) throws Exception {
        String name = this.getColumnName(fieldInfo);
        List columns = this.tblMain.getColumns();
        int index = -1;
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
            if (!columnInfo.getName().equals(name)) continue;
            this.tblMain.removeColumn(columnInfo);
            index = i;
            break;
        }
        if (-1 != index) {
            this.removeCell(index);
            this.deleteBindData(fieldInfo);
        }
        this.deleteNumber(fieldInfo);
        this.refreshComponent();
    }

    private void deleteBindData(FieldInfo fieldInfo) {
        ComponentInfo cominfo = this.tblMainComponent;
        String proName = this.getColumnName(fieldInfo) + ".text";
        PropertyBindingCollection pbc = cominfo.getPropertyBindings();
        if (pbc.get(proName) != null) {
            PropertyBindingInfo propertyBindingInfo = pbc.get(proName);
            pbc.remove(propertyBindingInfo);
        }
        if (cominfo.getExtendedProperty(DYNPROPERTYBINDS) != null) {
            String bindsText = cominfo.getExtendedProperty(DYNPROPERTYBINDS);
            if (bindsText != null && bindsText.indexOf(proName) > -1 && bindsText.length() == proName.length()) {
                cominfo.setExtendedProperty(DYNPROPERTYBINDS, null);
            } else if (bindsText != null && bindsText.indexOf(proName) > -1 && bindsText.length() > proName.length() && bindsText.substring(0, proName.length()).equals(proName)) {
                bindsText = StringUtils.replace((String)bindsText, (String)(proName + "|"), (String)"");
                cominfo.setExtendedProperty(DYNPROPERTYBINDS, bindsText);
            } else if (bindsText != null && bindsText.indexOf(proName) > -1 && bindsText.length() > proName.length() && !bindsText.substring(0, proName.length()).equals(proName)) {
                bindsText = StringUtils.replace((String)bindsText, (String)("|" + proName), (String)"");
                cominfo.setExtendedProperty(DYNPROPERTYBINDS, bindsText);
            }
        }
    }

    public void deleteNumber(FieldInfo fieldInfo) throws Exception {
        String name = this.getColumnNumber(fieldInfo);
        List columns = this.tblMain.getColumns();
        int index = -1;
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
            if (!columnInfo.getName().equals(name)) continue;
            this.tblMain.removeColumn(columnInfo);
            index = i;
            break;
        }
        if (-1 != index) {
            this.removeCell(index);
            this.deleteBindNumberData(fieldInfo);
        }
    }

    private void deleteBindNumberData(FieldInfo fieldInfo) {
        ComponentInfo cominfo = this.tblMainComponent;
        String proName = this.getColumnNumber(fieldInfo) + ".text";
        PropertyBindingCollection pbc = cominfo.getPropertyBindings();
        if (pbc.get(proName) != null) {
            PropertyBindingInfo propertyBindingInfo = pbc.get(proName);
            pbc.remove(propertyBindingInfo);
        }
        if (cominfo.getExtendedProperty(DYNPROPERTYBINDS) != null) {
            String bindsText = cominfo.getExtendedProperty(DYNPROPERTYBINDS);
            if (bindsText != null && bindsText.indexOf(proName) > -1 && bindsText.length() == proName.length()) {
                cominfo.setExtendedProperty(DYNPROPERTYBINDS, null);
            } else if (bindsText != null && bindsText.indexOf(proName) > -1 && bindsText.length() > proName.length() && bindsText.substring(0, proName.length()).equals(proName)) {
                bindsText = StringUtils.replace((String)bindsText, (String)(proName + "|"), (String)"");
                cominfo.setExtendedProperty(DYNPROPERTYBINDS, bindsText);
            } else if (bindsText != null && bindsText.indexOf(proName) > -1 && bindsText.length() > proName.length() && !bindsText.substring(0, proName.length()).equals(proName)) {
                bindsText = StringUtils.replace((String)bindsText, (String)("|" + proName), (String)"");
                cominfo.setExtendedProperty(DYNPROPERTYBINDS, bindsText);
            }
        }
    }

    public UIObjectInfo getListUIObject() {
        return this.uiModel;
    }
}

