/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.bizbill.metadata.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataOptions;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DBUtils {
    private static Logger logger = Logger.getLogger(DBUtils.class);

    public static boolean dbHaveData(Connection cn, String tableName) throws SQLException {
        boolean bl;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT 1 FROM " + tableName + " WHERE EXISTS (SELECT 1  FROM " + tableName + ")";
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            bl = rs.next();
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((ResultSet)rs);
        return bl;
    }

    public static boolean isTableExists(Connection cn, String tableName) throws SQLException {
        boolean sql2;
        ResultSet rs = null;
        try {
            if (!StringUtils.isEmpty((String)tableName)) {
                String sql2 = "SELECT 1 FROM KSQL_USERTABLES WHERE EXISTS (SELECT 1  FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ?)";
                PreparedStatement stmt = cn.prepareStatement(sql2);
                stmt.setString(1, tableName.toUpperCase());
                rs = stmt.executeQuery();
            }
            sql2 = rs == null ? false : rs.next();
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return sql2;
    }

    public static SQLType getSQLType(short dataType) {
        switch (dataType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return SQLType.INT;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return SQLType.NUMERIC;
            }
            case 1: {
                return SQLType.CHAR;
            }
            case 12: {
                return SQLType.VARCHAR;
            }
            case -1: {
                return SQLType.CLOB;
            }
            case 91: 
            case 92: 
            case 93: {
                return SQLType.DATETIME;
            }
            case -2: {
                return SQLType.BINARY;
            }
            case -3: {
                return SQLType.VARBINARY;
            }
            case -4: {
                return SQLType.BLOB;
            }
            case 2004: {
                return SQLType.BLOB;
            }
            case 2005: {
                return SQLType.CLOB;
            }
        }
        return null;
    }

    public static String getColSQL(ColumnInfo col) {
        String sql = "";
        String sqlpost = DBUtils.getDataType(col);
        String defValue = col.getDefaultValue();
        if (defValue != null) {
            sqlpost = sqlpost + " DEFAULT " + defValue;
        }
        sqlpost = sqlpost + (col.isNullable() ? " NULL" : " NOT NULL");
        if (col.isMultilingual()) {
            for (int i = 1; i <= 3; ++i) {
                sql = sql + col.getName() + "_l" + i + " " + sqlpost;
                if (i >= 3) continue;
                sql = sql + ",";
            }
        } else {
            sql = col.getName() + " " + sqlpost;
        }
        return sql;
    }

    public static String getColSQLWithoutMultiLanguage(ColumnInfo col) {
        String sql = col.getName() + " " + DBUtils.getDataType(col);
        String defValue = col.getDefaultValue();
        if (defValue != null) {
            sql = sql + " DEFAULT " + defValue;
        }
        sql = sql + (col.isNullable() ? " NULL" : " NOT NULL");
        return sql;
    }

    public static String getColSQLInMultiLanguage(ColumnInfo col, int language) {
        String sql = col.getName() + "_l" + language + " " + DBUtils.getDataType(col);
        String defValue = col.getDefaultValue();
        if (defValue != null) {
            sql = sql + " DEFAULT " + defValue;
        }
        sql = sql + (col.isNullable() ? " NULL" : " NOT NULL");
        return sql;
    }

    public static String getDataType(ColumnInfo col) {
        SQLType name = col.getTypeName();
        if (SQLType.CHAR.equals((Object)name) || SQLType.VARCHAR.equals((Object)name) || SQLType.NCHAR.equals((Object)name) || SQLType.NVARCHAR.equals((Object)name) || SQLType.CLOB.equals((Object)name) || SQLType.BLOB.equals((Object)name) || SQLType.NCLOB.equals((Object)name) || SQLType.BINARY.equals((Object)name) || SQLType.VARBINARY.equals((Object)name)) {
            return name.getName() + "(" + col.getLength() + ")";
        }
        if (SQLType.NUMERIC.equals((Object)name)) {
            int precision = col.getPrecision();
            if (precision == 0) {
                precision = col.getLength() - 1;
            }
            return "DECIMAL(" + precision + "," + col.getScale() + ")";
        }
        if (SQLType.INT.equals((Object)name) || SQLType.DATETIME.equals((Object)name)) {
            return name.getName();
        }
        logger.error((Object)("invalid col DataType " + col.getTypeName().getName()), (Throwable)new Exception("invalid col DataType"));
        return name.getName();
    }

    public static ColumnInfo getColumnByName(AbstractTableInfo table, String name) {
        int s = table.getColumns().size();
        for (int i = 0; i < s; ++i) {
            ColumnInfo col = table.getColumns().get(i);
            if (!col.getName().equalsIgnoreCase(name)) continue;
            return col;
        }
        return null;
    }

    public static IndexInfo getIndexByName(AbstractTableInfo table, String name) {
        int s = table.getIndexes().size();
        for (int i = 0; i < s; ++i) {
            IndexInfo info = table.getIndexes().get(i);
            if (!info.getName().equalsIgnoreCase(name)) continue;
            return info;
        }
        return null;
    }

    public static void fillIndex(ResultSet rs, AbstractTableInfo table) throws SQLException {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            if (indexName == null || table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
            IndexInfo index = null;
            for (int i = 0; i < table.getIndexes().size(); ++i) {
                if (!table.getIndexes().get(i).getName().equals(indexName)) continue;
                index = table.getIndexes().get(i);
                break;
            }
            if (index == null) {
                index = new IndexInfo();
                index.setName(rs.getString("INDEX_NAME"));
                index.setUnique(!rs.getBoolean("NON_UNIQUE"));
                table.getIndexes().add(index);
            }
            IndexColumnInfo indexColumn = new IndexColumnInfo();
            indexColumn.setColumn(DBUtils.getColumnByName(table, rs.getString("COLUMN_NAME")));
            indexColumn.setSortType(rs.getString("ASC_OR_DESC").equals("A") ? SortType.ASCEND : SortType.DESCEND);
            index.getIndexColumns().add(indexColumn);
        }
    }

    public static ForeignKeyCollection getRefFKList(Connection cn, String tableName) throws SQLException {
        ForeignKeyCollection fkList = new ForeignKeyCollection();
        ResultSet rs = cn.getMetaData().getExportedKeys(null, null, tableName);
        while (rs.next()) {
            String fkName = rs.getString("FK_NAME");
            ForeignKeyInfo fk = null;
            for (int i = 0; i < fkList.size(); ++i) {
                if (!fkList.get(i).getName().equals(fkName)) continue;
                fk = fkList.get(i);
                break;
            }
            if (fk == null) {
                fk = new ForeignKeyInfo();
                AbstractTableInfo refTable = new AbstractTableInfo();
                refTable.setName(rs.getString("FKTABLE_NAME"));
                fk.setRefTable(refTable);
                fk.setName(fkName);
                fkList.add(fk);
            }
            FKColumnPairInfo fkcol = new FKColumnPairInfo();
            ColumnInfo fkcolumn = new ColumnInfo();
            fkcolumn.setName(rs.getString("FKCOLUMN_NAME"));
            fkcol.setForeignKeyColumn(fkcolumn);
            ColumnInfo pkcolumn = new ColumnInfo();
            pkcolumn.setName(rs.getString("PKCOLUMN_NAME"));
            fkcol.setPrimaryKeyColumn(pkcolumn);
            fk.getFKColumnPairs().add(fkcol);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return fkList;
    }

    public static final DataType getDataType(SQLType sqlType) {
        if (sqlType.equals((Object)SQLType.INT)) {
            return DataType.INTEGER;
        }
        if (sqlType.equals((Object)SQLType.NUMERIC)) {
            return DataType.DECIMAL;
        }
        if (sqlType.equals((Object)SQLType.NCHAR) || sqlType.equals((Object)SQLType.CHAR)) {
            return DataType.STRING;
        }
        if (sqlType.equals((Object)SQLType.NVARCHAR) || sqlType.equals((Object)SQLType.VARCHAR) || sqlType.equals((Object)SQLType.CLOB) || sqlType.equals((Object)SQLType.NCLOB)) {
            return DataType.STRING;
        }
        if (sqlType.equals((Object)SQLType.BINARY) || sqlType.equals((Object)SQLType.VARBINARY) || sqlType.equals((Object)SQLType.BLOB)) {
            return DataType.BYTEARRAY;
        }
        if (sqlType.equals((Object)SQLType.DATETIME)) {
            return DataType.TIMESTAMP;
        }
        return null;
    }

    public static void excuteSql(Connection conn, String sql) throws BOSException {
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(resultSet, (Statement)statement);
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean existsColumn(Context ctx, String table, String column) throws BOSException {
        Connection conn;
        PreparedStatement statement;
        ResultSet resultSet;
        block8: {
            boolean bl;
            resultSet = null;
            statement = null;
            conn = null;
            try {
                conn = DBUtils.getConnection(ctx);
                String sql = "SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME=? AND KSQL_COL_NAME=? ";
                statement = conn.prepareStatement(sql);
                if (StringUtils.isEmpty((String)table) || StringUtils.isEmpty((String)column)) break block8;
                statement.setString(1, table);
                statement.setString(2, column);
                resultSet = statement.executeQuery();
                bl = resultSet.next();
            }
            catch (SQLException sqle) {
                try {
                    logger.error((Object)sqle, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, statement, (Connection)conn);
                    if (ProfileConfig.getInstance().logORMapping) {
                        ThreadProfileContext.getInstance().exit();
                    }
                    throw throwable;
                }
                SQLUtils.cleanup(resultSet, (Statement)statement, (Connection)conn);
                if (ProfileConfig.getInstance().logORMapping) {
                    ThreadProfileContext.getInstance().exit();
                }
            }
            SQLUtils.cleanup((ResultSet)resultSet, (Statement)statement, (Connection)conn);
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().exit();
            }
            return bl;
        }
        SQLUtils.cleanup(resultSet, (Statement)statement, (Connection)conn);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().exit();
        }
        return false;
    }

    public static final String getColumnName(Context ctx, String table, String suggestName) throws BOSException {
        String column = suggestName;
        for (int i = 1; i < Integer.MAX_VALUE && DBUtils.existsColumn(ctx, table, column); ++i) {
            column = suggestName + i;
        }
        return column;
    }

    public static String createTableName(String bizUnitName) {
        String packageCode = "EIP";
        String sPreFix = (MetaDataOptions.isDevelopVersion() ? "T_" : "CT_") + packageCode + "_";
        String tName = sPreFix + StringUtils.headCharUpperCase((String)bizUnitName);
        if (tName.length() > 30) {
            tName = sPreFix + StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)bizUnitName), (int)(30 - sPreFix.length()));
        }
        return tName;
    }

    public static String translateKSQL(Connection conn, String ksql) throws Exception {
        String s = "";
        s = !(conn instanceof KDConnection) ? TransUtil.Translate((String)ksql, (int)DBUtils.getDBType(conn)) : ksql;
        return s;
    }

    public static int getDBType(Connection conn) throws Exception {
        int dbType = 0;
        if (DBUtil.isOracle((Connection)conn)) {
            dbType = 2;
        } else if (DBUtil.isDB2((Connection)conn)) {
            dbType = 1;
        } else if (DBUtil.isMSSQL((Connection)conn)) {
            dbType = 3;
        } else if (DBUtils.isPostgresSQL(conn)) {
            dbType = 5;
        }
        return dbType;
    }

    public static boolean isPostgresSQL(Connection cn) throws SQLException {
        String productName = cn.getMetaData().getDatabaseProductName();
        return productName.equals("PostgreSQL");
    }
}

