/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.bizbill.metadata.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryFilterItemCollection;
import com.kingdee.bos.metadata.query.QueryFilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryParameterCollection;
import com.kingdee.bos.metadata.query.QueryParameterInfo;
import com.kingdee.bos.metadata.query.QuerySorterItemCollection;
import com.kingdee.bos.metadata.query.QuerySorterItemInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.util.GroupType;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DynQueryEntityTreeModel;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DynQueryLinkType;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DynQueryUtil {
    private static final Logger logger = Logger.getLogger(DynQueryUtil.class);

    public static EntityObjectInfo getEntity(String bosObjectId) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BOSObjectType objectType = BOSObjectType.create((String)bosObjectId);
        return loader.getEntity(objectType);
    }

    public static QueryInfo getQueryInfo(String queryName) {
        return MetadataUtils.loadQuery((IMetaDataPK)MetaDataPK.create((String)queryName));
    }

    public static DynQueryEntityTreeModel convertRootEntityNode(QueryInfo queryInfo) throws BOSException {
        SubObjectInfo mainObjInfo = queryInfo.getMainObject();
        DynQueryEntityTreeModel rootEntityNode = DynQueryUtil.convertMetaNode(mainObjInfo, null);
        DynQueryUtil.convertChildrenNodes(rootEntityNode, mainObjInfo);
        return rootEntityNode;
    }

    private static DynQueryEntityTreeModel convertMetaNode(SubObjectInfo subObjectInfo, JoinInfo joinInfo) {
        if (subObjectInfo instanceof SubEntityInfo) {
            return DynQueryUtil.convertEntityNode((SubEntityInfo)subObjectInfo, joinInfo);
        }
        if (subObjectInfo instanceof SubQueryInfo) {
            return DynQueryUtil.convertSubQueryNode((SubQueryInfo)subObjectInfo, joinInfo);
        }
        throw new RuntimeException("Unpredictable type.");
    }

    private static DynQueryEntityTreeModel convertEntityNode(SubEntityInfo subEntityInfo, JoinInfo joinInfo) {
        DynQueryEntityTreeModel entityModel = new DynQueryEntityTreeModel();
        entityModel.setSubQuery(false);
        EntityObjectInfo entityObjectInfo = subEntityInfo.getEntityRef();
        entityModel.setBosObjectId(entityObjectInfo.getType().toString());
        entityModel.setEntityName(subEntityInfo.getName());
        entityModel.setEntityAlias(entityObjectInfo.getAlias());
        entityModel.setSubObjectInfo((SubObjectInfo)subEntityInfo);
        entityModel.setJoinInfo(joinInfo);
        entityModel.setSubmited(true);
        entityModel.setSystem(!subEntityInfo.isConfigured());
        return entityModel;
    }

    private static DynQueryEntityTreeModel convertSubQueryNode(SubQueryInfo subQueryInfo, JoinInfo joinInfo) {
        DynQueryEntityTreeModel entityModel = new DynQueryEntityTreeModel();
        entityModel.setSubQuery(true);
        entityModel.setBosObjectId(subQueryInfo.getQueryRef().getFullName());
        entityModel.setEntityName(subQueryInfo.getName());
        entityModel.setEntityAlias(subQueryInfo.getAlias());
        entityModel.setSubObjectInfo((SubObjectInfo)subQueryInfo);
        entityModel.setJoinInfo(joinInfo);
        entityModel.setSubmited(true);
        entityModel.setSystem(!subQueryInfo.isConfigured());
        return entityModel;
    }

    private static void convertChildrenNodes(DynQueryEntityTreeModel parentEntityNode, SubObjectInfo subObjectInfo) {
        JoinCollection joinCollection = subObjectInfo.getJoinsFromClient();
        int size = joinCollection.size();
        for (int i = 0; i < size; ++i) {
            JoinInfo joinInfo = joinCollection.get(i);
            DynQueryEntityTreeModel entityNode = DynQueryUtil.convertEntityNodeWithJoin(joinInfo);
            parentEntityNode.addChild(entityNode);
            SubObjectInfo rightInfo = joinInfo.getRightObject();
            DynQueryUtil.convertChildrenNodes(entityNode, rightInfo);
        }
    }

    private static DynQueryEntityTreeModel convertEntityNodeWithJoin(JoinInfo joinInfo) {
        SubObjectInfo subObjectInfo = joinInfo.getRightObject();
        DynQueryEntityTreeModel entityNode = DynQueryUtil.convertMetaNode(subObjectInfo, joinInfo);
        JoinType joinType = joinInfo.getJoinType();
        DynQueryLinkType linkType = DynQueryUtil.convertLinkType(joinType);
        entityNode.setLinkType(linkType);
        return entityNode;
    }

    private static DynQueryLinkType convertLinkType(JoinType joinType) {
        if (JoinType.INNERJOIN.getName().equals(joinType.getName())) {
            return DynQueryLinkType.InnerJoin;
        }
        if (JoinType.LEFTJOIN.getName().equals(joinType.getName())) {
            return DynQueryLinkType.LeftJoin;
        }
        if (JoinType.RIGHTJOIN.getName().equals(joinType.getName())) {
            return DynQueryLinkType.RightJoin;
        }
        return DynQueryLinkType.LeftJoin;
    }

    public static boolean isFieldConfigured(QueryFieldInfo field) {
        PropertyRefInfo ref;
        PropertyInfo pro;
        if (field == null) {
            return false;
        }
        if (field.isConfigured()) {
            return true;
        }
        return field.getPropertyRefs() != null && field.getPropertyRefs().get(0) != null && (pro = (ref = field.getPropertyRefs().get(0)).getRefProperty()) != null && pro.isConfigured();
    }

    public static String[] getColumnNames(SubObjectInfo subObjectInfo) {
        String[] columns;
        block5: {
            block4: {
                int i;
                columns = new String[]{};
                if (subObjectInfo == null) {
                    return new String[0];
                }
                if (!(subObjectInfo instanceof SubEntityInfo)) break block4;
                SubEntityInfo subEntity = (SubEntityInfo)subObjectInfo;
                EntityObjectInfo entity = subEntity.getEntityRef();
                PropertyCollection col = entity.getInheritedNoDuplicatedProperties();
                PropertyCollection col2 = new PropertyCollection();
                int n = col.size();
                for (i = 0; i < n; ++i) {
                    RelationshipInfo relationship;
                    PropertyInfo propertyInfo = col.get(i);
                    if (propertyInfo instanceof LinkPropertyInfo && ((relationship = ((LinkPropertyInfo)propertyInfo).getRelationship()) == null || relationship.getClientObject() == null || RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) && CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) && relationship.getClientObject().equals((Object)entity))) continue;
                    col2.add(propertyInfo);
                }
                columns = new String[col2.size()];
                for (i = 0; i < col2.size(); ++i) {
                    PropertyInfo pInfo = col2.get(i);
                    columns[i] = pInfo.getName();
                }
                break block5;
            }
            if (!(subObjectInfo instanceof SubQueryInfo)) break block5;
            SubQueryInfo subQuery = (SubQueryInfo)subObjectInfo;
            SelectorInfo selector = subQuery.getQueryRef().getSelector();
            columns = new String[selector.getFields().size()];
            for (int i = 0; i < selector.getFields().size(); ++i) {
                columns[i] = ((QueryFieldInfo)selector.getFields().get(i)).getName();
            }
        }
        return columns;
    }

    public static String getColumnText(JoinItemInfo item, int columnIndex, SubObjectInfo leftObjectInfo, SubObjectInfo rightObjectInfo) {
        if (columnIndex == 0) {
            if (item.getLeftField() == null || item.getLeftField().getPropertyRefs().size() == 0) {
                return "";
            }
            PropertyRefInfo ref = item.getLeftField().getPropertyRefs().get(0);
            if (leftObjectInfo instanceof SubEntityInfo) {
                return ref.getRefProperty().getName();
            }
            return ref.getRefUnit().getName();
        }
        if (columnIndex == 1) {
            if (item.get("compareType") == null) {
                return "";
            }
            return item.getCompareType().getName();
        }
        if (item.getRightField() == null || item.getRightField().getPropertyRefs().size() == 0) {
            return "";
        }
        PropertyRefInfo ref = item.getRightField().getPropertyRefs().get(0);
        if (rightObjectInfo instanceof SubEntityInfo) {
            return ref.getRefProperty().getName();
        }
        return ref.getRefUnit().getName();
    }

    public static String getSubObjectAlias(SubObjectInfo subObjectInfo) {
        if (subObjectInfo instanceof SubEntityInfo) {
            EntityObjectInfo entityObjectInfo = ((SubEntityInfo)subObjectInfo).getEntityRef();
            entityObjectInfo.getType().toString();
            subObjectInfo.getName();
            return entityObjectInfo.getAlias();
        }
        if (subObjectInfo instanceof SubQueryInfo) {
            SubQueryInfo subQueryInfo = (SubQueryInfo)subObjectInfo;
            return subQueryInfo.getAlias();
        }
        throw new RuntimeException("Unpredictable type.");
    }

    public static String getSubObjectName(SubObjectInfo subObjectInfo) {
        if (subObjectInfo instanceof SubEntityInfo) {
            return subObjectInfo.getName();
        }
        if (subObjectInfo instanceof SubQueryInfo) {
            SubQueryInfo subQueryInfo = (SubQueryInfo)subObjectInfo;
            return subQueryInfo.getName();
        }
        throw new RuntimeException("Unpredictable type.");
    }

    public static boolean isGrouping(QueryInfo query) {
        boolean group = false;
        if (!(query instanceof JoinQueryInfo)) {
            return group;
        }
        ArrayList selector = query.getSelector().getFields();
        for (int i = 0; i < selector.size(); ++i) {
            QueryFieldInfo field = (QueryFieldInfo)selector.get(i);
            if (field.getGroupType().equals((Object)GroupType.NONE)) continue;
            group = true;
            break;
        }
        return group;
    }

    public static int getIndex(String propertyName, SubObjectInfo subObjectInfo) {
        int result;
        String[] choices = DynQueryUtil.getColumnNames(subObjectInfo);
        for (result = choices.length - 1; result >= 0 && !choices[result].equals(propertyName); --result) {
        }
        return result;
    }

    public static String replaceFormula(String formula, String oldKey, String newKey) throws ParserException {
        Lexer lexer = new Lexer(formula);
        StringBuffer buff = new StringBuffer();
        boolean flag = false;
        while (true) {
            Token token = lexer.next();
            if (token.type == 12) break;
            if (flag) {
                buff.append(' ');
            }
            if (token.type == 4 && token.value.equals(oldKey)) {
                buff.append(newKey);
            } else {
                token.output(buff);
            }
            flag = true;
        }
        return buff.toString();
    }

    public static void deleteFromQuery(QueryInfo queryInfo, QueryFieldInfo queryFieldInfo) {
        QuerySorterItemCollection sorters = queryInfo.getDefaultSorters();
        for (int j = 0; j < sorters.size(); ++j) {
            QuerySorterItemInfo sorter = sorters.get(j);
            if (!queryFieldInfo.equals((Object)sorter.getQueryField())) continue;
            sorters.remove(sorter);
        }
        QueryParameterCollection parameters = queryInfo.getParameters();
        for (int j = 0; j < parameters.size(); ++j) {
            QueryParameterInfo parameter = parameters.get(j);
            if (!queryFieldInfo.equals((Object)parameter.getQueryField())) continue;
            parameters.remove(parameter);
        }
        if (queryInfo.getDefaultFilter() != null) {
            QueryFilterItemCollection filters = queryInfo.getDefaultFilter().getFilterItems();
            ArrayList<QueryFilterItemInfo> removedFilters = new ArrayList<QueryFilterItemInfo>();
            for (int j = 0; j < filters.size(); ++j) {
                QueryFilterItemInfo filter = filters.get(j);
                if (!queryFieldInfo.equals((Object)filter.getQueryField())) continue;
                removedFilters.add(filter);
            }
            for (int r = 0; r < removedFilters.size(); ++r) {
                filters.remove((QueryFilterItemInfo)removedFilters.get(r));
            }
        }
        if (queryInfo.getQueryPK() != null) {
            QueryFieldCollection col = queryInfo.getQueryPK().getKeyPropertys();
            col.remove(queryFieldInfo);
        }
        queryInfo.getUnits().remove((PropertyUnitInfo)queryFieldInfo);
    }

    public static void deleteSubObjectFromQuery(QueryInfo query, EntityObjectInfo entityRef, PropertyInfo pInfo) {
        block7: {
            block8: {
                if (!(pInfo instanceof LinkPropertyInfo)) break block8;
                EntityObjectInfo supplierEntityInfo = ((LinkPropertyInfo)pInfo).getRelationship().getSupplierObject();
                if (supplierEntityInfo == null) break block7;
                SubObjectCollection subObjectCol = query.getSubObjects();
                int sizeCol = subObjectCol.size();
                for (int num = 0; num < sizeCol; ++num) {
                    EntityObjectInfo entity = ((SubEntityInfo)subObjectCol.get(num)).getEntityRef();
                    if (entity != null && !entity.getFullName().equals(supplierEntityInfo.getFullName())) continue;
                    try {
                        query.removeSubObject(subObjectCol.get(num));
                    }
                    catch (BOSException e) {
                        logger.error((Object)"DynQueryUtil.deleteSubObjectFromQuery", (Throwable)e);
                    }
                    break block7;
                }
                break block7;
            }
            SubObjectCollection subObjectcCol = query.getSubObjects();
            SelectorInfo selector = query.getSelector();
            QueryFieldInfo prop = null;
            boolean isFind = false;
            int n = subObjectcCol.size();
            for (int i = 0; i < n; ++i) {
                SubObjectInfo subObject = subObjectcCol.get(i);
                EntityObjectInfo querySubObject = ((SubEntityInfo)subObject).getEntityRef();
                if (entityRef == null || !entityRef.equals((Object)querySubObject)) continue;
                isFind = false;
                int m = selector.size();
                for (int j = 0; j < m; ++j) {
                    prop = selector.get(j);
                    PropertyRefCollection propertyRefs = prop.getPropertyRefs();
                    if (propertyRefs == null || propertyRefs.isEmpty() || querySubObject == null || !querySubObject.equals((Object)propertyRefs.get(0).getSubEntity().getEntityRef())) continue;
                    isFind = true;
                    break;
                }
                if (isFind || !subObject.isConfigured()) continue;
                try {
                    query.removeSubObject(subObject);
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)"DynQueryUtil.deleteSubObjectFromQuery", (Throwable)e);
                }
            }
        }
    }

    public static SubEntityInfo getSubEntity(QueryInfo query, EntityObjectInfo entity) {
        if (entity != null) {
            SubObjectCollection subObjects = query.getSubObjects();
            for (int i = 0; i < subObjects.size(); ++i) {
                EntityObjectInfo entityRef;
                SubObjectInfo subObjectInfo = subObjects.get(i);
                if (!(subObjectInfo instanceof SubEntityInfo) || (entityRef = ((SubEntityInfo)subObjectInfo).getEntityRef()) == null || !entityRef.getFullName().equals(entity.getFullName())) continue;
                return (SubEntityInfo)subObjectInfo;
            }
        }
        return null;
    }
}

