/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.converter.core;

import com.kingdee.eas.csinterface.converter.core.Converter;
import com.kingdee.eas.csinterface.converter.core.DefaultConverterLookup;
import com.kingdee.eas.csinterface.converter.core.DefaultMarshaller;
import com.kingdee.eas.csinterface.converter.core.DefaultUnmarshaller;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.util.ClassUtil;
import com.kingdee.eas.csinterface.util.IOUtils;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;

public class DefaultStream {
    public static final String CONVERT_ERROR_MESSAGE = "convert-error-message";
    public static final String NULL = "null";
    private MarshallingContext marshallingContext;
    private UnmarshallingContext unmarshallingContext;
    private DefaultConverterLookup defaultConverterLookup;
    private static DefaultStream defaultStream = null;

    public static DefaultStream getInstance() {
        if (null == defaultStream) {
            defaultStream = new DefaultStream();
        }
        return defaultStream;
    }

    private DefaultStream() {
        this.initContext();
        this.registerDefaultConverter();
    }

    private void initContext() {
        this.defaultConverterLookup = new DefaultConverterLookup();
        this.marshallingContext = new DefaultMarshaller(this.defaultConverterLookup);
        this.unmarshallingContext = new DefaultUnmarshaller(this.defaultConverterLookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDefaultConverter() {
        InputStream inputStream = null;
        try {
            inputStream = DefaultStream.class.getResourceAsStream("default-converter.txt");
            String content = IOUtils.readFully(inputStream, "UTF-8");
            String[] classes = content.split("\n");
            for (int i = 0; i < classes.length; ++i) {
                if (StringUtils.isEmpty((String)classes[i]) || classes[i].startsWith("#")) continue;
                String className = classes[i].trim();
                Object object = ClassUtil.newInstance(className);
                if (null != object && object instanceof Converter) {
                    this.defaultConverterLookup.registerConverter((Converter)object);
                    continue;
                }
                System.out.println("\u65e0\u6cd5\u6dfb\u52a0\u8f6c\u6362\u5668" + className);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public MarshallingContext getMarshallingContext() {
        return this.marshallingContext;
    }

    public UnmarshallingContext getUnmarshallingContext() {
        return this.unmarshallingContext;
    }

    public void registerConverter(Converter converter) {
        this.defaultConverterLookup.registerConverter(converter);
    }
}

