/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.DynamicBillTemplateCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.monitor.FeedBackFlag;
import com.kingdee.eas.csinterface.monitor.FeedBackLogCollection;
import com.kingdee.eas.csinterface.monitor.FeedBackLogFactory;
import com.kingdee.eas.csinterface.monitor.FeedBackLogInfo;
import com.kingdee.eas.csinterface.monitor.FeedBackLogState;
import com.kingdee.eas.csinterface.monitor.FeedBackStatus;
import com.kingdee.eas.csinterface.monitor.app.AbstractFeedBackLogControllerBean;
import com.kingdee.eas.csinterface.monitor.app.FeedBackManager;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class FeedBackLogControllerBean
extends AbstractFeedBackLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.monitor.app.FeedBackLogControllerBean");

    @Override
    protected void _reFeedback(Context ctx, String billMappingId) throws BOSException {
        try {
            BillMappingInfo info = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("select srcDBConn.*,feedback.*,feedbackEnable where id='" + billMappingId + "'");
            if (!info.isFeedbackEnable()) {
                return;
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billmapping.id", (Object)billMappingId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("flag", (Object)-1, CompareType.EQUALS));
            ev.setFilter(filter);
            FeedBackLogCollection colls = FeedBackLogFactory.getLocalInstance(ctx).getFeedBackLogCollection(ev);
            if (colls.isEmpty()) {
                return;
            }
            FeedBackManager.updateFeedBackLogByColl(ctx, colls, FeedBackFlag.SUCCESSED, "");
            FeedBackManager.doFeedBack(colls, info, null, false);
        }
        catch (EASBizException e) {
            logger.error((Object)"\u91cd\u65b0\u53cd\u9988\u5931\u8d25", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"\u91cd\u65b0\u53cd\u9988\u5931\u8d25", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _repairFeedBack(Context ctx, String billMappingID) throws BOSException {
        try {
            BillMappingInfo info = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("select number,entrys.*,srcDBConn.*,feedback.*,feedbackEnable where id='" + billMappingID + "'");
            if (!info.isFeedbackEnable()) {
                return;
            }
            Map<String, String> map = FeedBackManager.getSrcMidFieldMapByCondition(info.getFeedback().getCondition());
            HashMap<String, String> srcMidMap = new HashMap<String, String>();
            BillMappingEntryCollection coll = info.getEntrys();
            for (int i = 0; i < coll.size(); ++i) {
                BillMappingEntryInfo entry = coll.get(i);
                srcMidMap.put(entry.getSrcFieldName(), entry.getMidFieldName());
            }
            Iterator<String> it = map.keySet().iterator();
            HashSet fieldSet = new HashSet();
            HashMap<String, String> coreMap = new HashMap<String, String>();
            while (it.hasNext()) {
                String key = it.next();
                String value = map.get(key);
                fieldSet.add(srcMidMap.get(value));
                coreMap.put(key, (String)srcMidMap.get(value));
            }
            IDynamicBillTemplate template = MidBillFactory.getInstance(ctx, info.getNumber());
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("headpk"));
            sic.add(new SelectorItemInfo("Fivouchered"));
            for (String str : fieldSet) {
                sic.add(new SelectorItemInfo(str));
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select 1 from T_EIP_FeedbackLog where T_EIP_FeedbackLog.FMidID =\"T0\".Fid", CompareType.NOTEXISTS));
            ev.setSelector(sic);
            ev.setFilter(filter);
            DynamicBillTemplateCollection midBills = template.getDynamicBillTemplateCollection(ev);
            DynamicBillTemplateCollection tmp = new DynamicBillTemplateCollection();
            for (int i = 0; i < midBills.size(); ++i) {
                tmp.add(midBills.get(i));
                if (i <= 0 || i % 1000 != 0) continue;
                this.processRepair(ctx, tmp, info, coreMap);
                tmp.clear();
            }
            if (!tmp.isEmpty()) {
                this.processRepair(ctx, tmp, info, coreMap);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"\u4fee\u590d\u5931\u8d25", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"\u4fee\u590d\u5931\u8d25", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void processRepair(Context ctx, DynamicBillTemplateCollection coll, BillMappingInfo info, Map<String, String> map) throws EASBizException, BOSException {
        CoreBaseCollection flcoll = new CoreBaseCollection();
        HashSet<String> midIds = new HashSet<String>();
        HashSet<String> srcIds = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            DynamicBillTemplateInfo midbill = coll.get(i);
            midIds.add(midbill.getId().toString());
            FeedBackLogInfo flinfo = new FeedBackLogInfo();
            flinfo.setBillmapping(info);
            flinfo.setConnection(info.getSrcDBConn());
            flinfo.setHeadpk(midbill.getString("headpk"));
            flinfo.setMidID(midbill.getId().toString());
            Iterator<String> it = map.keySet().iterator();
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            while (it.hasNext()) {
                String srcField = it.next();
                Object srcFieldValue = midbill.get(map.get(srcField));
                map1.put(srcField, srcFieldValue);
            }
            String jsonCondition = new JSONObject(map1).toJSONString();
            flinfo.setFeedbackCondition(jsonCondition);
            if (midbill.isFivouchered()) {
                flinfo.setFeedBackStatus(FeedBackStatus.EXPORT_VOUCHER_SUCCESSED);
                flinfo.setStatus(FeedBackLogState.VOUCHER);
                srcIds.add(midbill.getId().toString());
            } else {
                flinfo.setFeedBackStatus(FeedBackStatus.EXPORT_MID_SUCCESSED);
                flinfo.setStatus(FeedBackLogState.MID);
            }
            flinfo.setFlag(FeedBackFlag.WAITING);
            flcoll.add((CoreBaseInfo)flinfo);
        }
        FeedBackLogFactory.getLocalInstance(ctx).save(flcoll);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", srcIds, CompareType.INCLUDE));
        ev.setFilter(filter);
        BOTRelationCollection btpColl = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(ev);
        FeedBackManager.updateFeedBackLogByBotpRelation(ctx, btpColl);
        FeedBackManager.feedBackByMidIds(ctx, midIds);
    }
}

