/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.concurrent.TimeUnit;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.RecordBaseDataLogInfo;
import com.kingdee.eas.csinterface.app.DynamicBillBatchInsertHelper;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTypeEnum;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.factory.BaseDataHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.factory.BaseDataPlanFactory;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataResourceholder;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynInvokeHelper;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.EIPConfiguration;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingType;
import com.kingdee.eas.csinterface.cache.util.CacheType;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.csinterface.monitor.IMonitorLog;
import com.kingdee.eas.csinterface.monitor.MonitorLogCollection;
import com.kingdee.eas.csinterface.monitor.MonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.MonitorlogType;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogCollection;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.AutoMatchBasedataMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.CheckMidStatusMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.IAssembledMonitorInfo;
import com.kingdee.eas.csinterface.monitor.app.MidBillToDestBaseDataMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MidBillToDestMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.SnapshotDataChangeMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.SrcToMidBillMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.util.monitordel.ScheduleScanEIPConfigFile;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleTaskAction;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.BaseDataSynWebServiceFactory;
import com.kingdee.eas.csinterface.webservice.BaseDataSynWebServiceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MonitorManager {
    private static Logger logger = Logger.getLogger(MonitorManager.class);
    static final ThreadLocal<MonitorLogInfo> threadMonitorIds = new ThreadLocal();
    static final ThreadLocal<String> threadOperatorSources = new ThreadLocal();
    public static final String LOOPBACK_IP = "127.0.0.1";
    private static String localIp;
    public static final String UNKNOW_BILLNUMBER = "[\u672a\u77e5\u5355\u636e]";
    private static ThreadLocal<Boolean> execAPI;
    public static final String agentId4http = "agentId4http";
    static ScheduleScanEIPConfigFile scheduleDelMonitor;

    public static void setOperatorSource(String operatorSource) {
        threadOperatorSources.set(operatorSource);
    }

    public static String getOperatorSource() {
        return threadOperatorSources.get();
    }

    public static void resetThreadMointer(MonitorLogInfo logInfo) {
        threadMonitorIds.set(logInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void enter(Context ctx, MonitorLogInfo monitorLogInfo, String operatorType, String operatorSource, String billNumber, String summary) {
        block36: {
            BaseDataSynHeadInfo baseDataInfo = null;
            String logTypeName = null;
            String billDesc = null;
            if (UNKNOW_BILLNUMBER == billNumber) {
                billDesc = billNumber;
            } else if (monitorLogInfo instanceof AutoMatchBasedataMonitorLogInfo) {
                logTypeName = MonitorlogType.baseDataAutoMatch.getName();
            } else if (monitorLogInfo.get("oprtType") != null) {
                billDesc = billNumber;
            } else if (monitorLogInfo instanceof BaseDataDownMonitorLogInfo) {
                baseDataInfo = (BaseDataSynHeadInfo)new BaseDataHeadFactory().create(ctx, BaseDataPlanFactory.Type.NUMBER, billNumber, CacheType.SYNHEAD);
                billDesc = billNumber + "(" + baseDataInfo.getName() + ")";
                BaseDataSynTypeEnum type = baseDataInfo.getBaseDataSynType();
                logTypeName = type.getName();
                monitorLogInfo.setExtendedProperty("implClass", baseDataInfo.getImplClass());
            } else {
                BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("where number='" + billNumber + "'");
                billDesc = billNumber + "(" + billMappingInfo.getBillMappingName() + ")";
                BillMappingType type = billMappingInfo.getMappingType();
                logTypeName = type.getName();
            }
            List logTypeList = MonitorlogType.getEnumList();
            MonitorlogType logType = null;
            for (int i = 0; i < logTypeList.size(); ++i) {
                logType = (MonitorlogType)((Object)logTypeList.get(i));
                if (!logType.getName().equalsIgnoreCase(logTypeName)) continue;
                monitorLogInfo.setLogType(logType);
                break;
            }
            BOSUuid id = BOSUuid.create((BOSObjectType)monitorLogInfo.getBOSType());
            monitorLogInfo.setId(id);
            String caller = "EIP_USER";
            try {
                UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
                if (userInfo != null) {
                    caller = userInfo.getNumber();
                }
            }
            catch (Exception userInfo) {
                // empty catch block
            }
            monitorLogInfo.setOperator(caller);
            monitorLogInfo.setOperatorType(operatorType);
            if (operatorSource == null) {
                operatorSource = threadOperatorSources.get();
            }
            monitorLogInfo.setOperatorSource(operatorSource);
            monitorLogInfo.setStatus("\u6b63\u5728\u8fd0\u884c");
            monitorLogInfo.setServerIp(MonitorManager.getLocalIP());
            monitorLogInfo.setRpcPort(MonitorManager.getRpcPort());
            monitorLogInfo.setBillNumber(billDesc);
            String instance = Configuration.instanceId();
            String serverName = null;
            if (instance != null) {
                serverName = instance.split("@")[0];
            }
            if (serverName != null) {
                summary = "(" + serverName + ")" + summary;
            }
            monitorLogInfo.setSummary(summary != null && summary.length() > 255 ? summary.substring(0, 254) + "\u2026" : summary);
            monitorLogInfo.setStartTime(new Timestamp(System.currentTimeMillis()));
            if ("\u57fa\u7840\u8d44\u6599\u540c\u6b65".equals(operatorType)) {
                monitorLogInfo.setSimpleName("BaseDataDown");
            } else if ("\u57fa\u7840\u8d44\u6599\u540c\u6b65(\u68c0\u6d4b\u53d8\u5316)".equals(operatorType)) {
                monitorLogInfo.setSimpleName("BaseDataChange");
            } else if ("\u57fa\u7840\u8d44\u6599\u540c\u6b65(\u5220\u9664)".equals(operatorType)) {
                monitorLogInfo.setSimpleName("BaseDataDelete");
            }
            monitorLogInfo.setServerName(serverName);
            monitorLogInfo.setHttpPort(null);
            monitorLogInfo.setServerTag(EIPConfiguration.Instance().getServerTag());
            MonitorManager.saveMonitorLog(ctx, monitorLogInfo);
            threadMonitorIds.set(monitorLogInfo);
            try {
                if (monitorLogInfo instanceof BaseDataDownMonitorLogInfo) {
                    BaseDataDownMonitorLogInfo baseDataLog = (BaseDataDownMonitorLogInfo)monitorLogInfo;
                    boolean needRecord = false;
                    boolean needRecordRepeat = false;
                    if (baseDataInfo != null) {
                        needRecord = "recordLog".equalsIgnoreCase(baseDataInfo.getDescription());
                        baseDataInfo.setExtendedProperty("connNumber", baseDataLog.getExtendedProperty("connNumber"));
                        needRecordRepeat = "repeat".equalsIgnoreCase(baseDataInfo.getDescription());
                    }
                    RecordBaseDataLogInfo recordInfo = new RecordBaseDataLogInfo(ctx, needRecord);
                    recordInfo.recordBaseDataSynHeadInfo(baseDataInfo);
                    baseDataLog.setRecordBaseDataLog(recordInfo);
                    baseDataLog.setRecordRepeat(needRecordRepeat);
                }
            }
            catch (Exception baseDataLog) {
                // empty catch block
            }
            scheduleDelMonitor.setCtx(ctx);
            scheduleDelMonitor.scan(TimeUnit.DAYS, 30L, 0L);
            break block36;
            catch (Exception e) {
                try {
                    logger.error((Object)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (monitorLogInfo instanceof BaseDataDownMonitorLogInfo) {
                            BaseDataDownMonitorLogInfo baseDataLog = (BaseDataDownMonitorLogInfo)monitorLogInfo;
                            boolean needRecord = false;
                            boolean needRecordRepeat = false;
                            if (baseDataInfo != null) {
                                needRecord = "recordLog".equalsIgnoreCase(baseDataInfo.getDescription());
                                baseDataInfo.setExtendedProperty("connNumber", baseDataLog.getExtendedProperty("connNumber"));
                                needRecordRepeat = "repeat".equalsIgnoreCase(baseDataInfo.getDescription());
                            }
                            RecordBaseDataLogInfo recordInfo = new RecordBaseDataLogInfo(ctx, needRecord);
                            recordInfo.recordBaseDataSynHeadInfo(baseDataInfo);
                            baseDataLog.setRecordBaseDataLog(recordInfo);
                            baseDataLog.setRecordRepeat(needRecordRepeat);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    scheduleDelMonitor.setCtx(ctx);
                    scheduleDelMonitor.scan(TimeUnit.DAYS, 30L, 0L);
                    throw throwable;
                }
                try {
                    if (monitorLogInfo instanceof BaseDataDownMonitorLogInfo) {
                        BaseDataDownMonitorLogInfo baseDataLog = (BaseDataDownMonitorLogInfo)monitorLogInfo;
                        boolean needRecord = false;
                        boolean needRecordRepeat = false;
                        if (baseDataInfo != null) {
                            needRecord = "recordLog".equalsIgnoreCase(baseDataInfo.getDescription());
                            baseDataInfo.setExtendedProperty("connNumber", baseDataLog.getExtendedProperty("connNumber"));
                            needRecordRepeat = "repeat".equalsIgnoreCase(baseDataInfo.getDescription());
                        }
                        RecordBaseDataLogInfo recordInfo = new RecordBaseDataLogInfo(ctx, needRecord);
                        recordInfo.recordBaseDataSynHeadInfo(baseDataInfo);
                        baseDataLog.setRecordBaseDataLog(recordInfo);
                        baseDataLog.setRecordRepeat(needRecordRepeat);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                scheduleDelMonitor.setCtx(ctx);
                scheduleDelMonitor.scan(TimeUnit.DAYS, 30L, 0L);
            }
        }
    }

    public static SrcToMidBillMonitorLogInfo enterSrcToMidBill(Context ctx, String operatorSource, String billNumber, String chunkedTransmitNumber) {
        SrcToMidBillMonitorLogInfo monitorLogInfo = new SrcToMidBillMonitorLogInfo();
        monitorLogInfo.setChunkedTransmitNumber(chunkedTransmitNumber);
        BillMappingInfo billMappingInfo = null;
        try {
            billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("where number= '" + billNumber + "'");
        }
        catch (Exception e) {
            logger.error((Object)"\u751f\u6210\u4e2d\u95f4\u5355\u636e\u65e5\u5fd7\u65f6\uff0c\u6839\u636e\u5355\u636e\u7f16\u7801\u67e5\u8be2\u5355\u636e\u5b9e\u4f53\u5f02\u5e38", (Throwable)e);
        }
        String summary = !StringUtils.isEmpty((String)chunkedTransmitNumber) ? "\u4f7f\u7528HTTP-Chunked\u4f20\u8f93\u5355\u636e" + billNumber + "\uff0c\u4f20\u8f93\u7f16\u53f7\u4e3a\uff1a" + chunkedTransmitNumber : "\u751f\u6210\u4e2d\u95f4\u5355\u636e\uff1a" + billNumber;
        if (null != billMappingInfo && !StringUtils.isEmpty((String)billMappingInfo.getDataProcessType().toString())) {
            summary = summary + "\uff1b\u751f\u6210\u7b56\u7565\uff1a" + billMappingInfo.getDataProcessType().toString() + "\uff1b";
        }
        MonitorManager.enter(ctx, monitorLogInfo, "\u751f\u6210\u4e2d\u95f4\u5355\u636e", operatorSource, billNumber, summary);
        return monitorLogInfo;
    }

    public static SrcToMidBillMonitorLogInfo getCurrentSrcToMidBill() {
        return (SrcToMidBillMonitorLogInfo)MonitorManager.getCurrent();
    }

    public static MidBillToDestMonitorLogInfo enterMidBillToDest(Context ctx, String operatorSource, String billNumber, String scheduledId) {
        MidBillToDestMonitorLogInfo monitorLogInfo = new MidBillToDestMonitorLogInfo();
        String summary = "";
        if (StringUtils.isEmpty((String)scheduledId)) {
            summary = "\u624b\u5de5\u6267\u884c\uff0c\u628a\u4e2d\u95f4\u5355\u636e" + billNumber + "\u8f6c\u6362\u6210\u76ee\u6807\u5355\u636e";
        } else {
            ScheduleInfo scheduleInfo;
            try {
                scheduleInfo = (ScheduleInfo)ScheduleFactory.getLocalInstance(ctx).getObjectBaseInfo((IObjectPK)new ObjectUuidPK(scheduledId));
            }
            catch (Exception e) {
                scheduleInfo = new ScheduleInfo();
                scheduleInfo.setId(BOSUuid.read((String)scheduledId));
            }
            summary = "\u6267\u884c\u8c03\u5ea6\u7b56\u7565" + scheduledId + "\uff0c\u628a\u4e2d\u95f4\u5355\u636e" + billNumber + "\u8f6c\u6362\u6210\u76ee\u6807\u5355\u636e";
            monitorLogInfo.setScheduleInfo(scheduleInfo);
        }
        MonitorManager.enter(ctx, monitorLogInfo, "\u751f\u6210\u76ee\u6807\u5355\u636e", operatorSource, billNumber, summary);
        return monitorLogInfo;
    }

    public static MidBillToDestMonitorLogInfo getCurrentMidBillToDest() {
        MidBillToDestMonitorLogInfo monitorLogInfo = new MidBillToDestMonitorLogInfo();
        return (MidBillToDestMonitorLogInfo)MonitorManager.getCurrent();
    }

    public static SnapshotDataChangeMonitorLogInfo enterSnapshotDataChange(Context ctx, String operatorSource, String billNumber) {
        SnapshotDataChangeMonitorLogInfo monitorLogInfo = new SnapshotDataChangeMonitorLogInfo();
        String summary = "\u5feb\u7167\u65b9\u5f0f\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316";
        String operatorType = "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316";
        try {
            BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("where number='" + billNumber + "'");
            BillMappingType mappingType = billMappingInfo.getMappingType();
            if (mappingType.getValue() == "100") {
                operatorType = "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316(\u5f02\u6784\u7cfb\u7edf\u57fa\u7840\u8d44\u6599)";
                summary = "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316(\u5f02\u6784\u7cfb\u7edf\u57fa\u7840\u8d44\u6599)";
            }
        }
        catch (Exception e) {
            logger.error((Object)ThrowableHelper.toString(e));
        }
        MonitorManager.enter(ctx, monitorLogInfo, operatorType, operatorSource, billNumber, summary);
        return monitorLogInfo;
    }

    public static SnapshotDataChangeMonitorLogInfo getCurrentSnapshotDataChange() {
        return (SnapshotDataChangeMonitorLogInfo)MonitorManager.getCurrent();
    }

    public static CheckMidStatusMonitorLogInfo enterCheckMidStatus(Context ctx, String operatorSource, String billNumber, String scheduledId) {
        ScheduleInfo scheduleInfo;
        try {
            scheduleInfo = (ScheduleInfo)ScheduleFactory.getLocalInstance(ctx).getObjectBaseInfo((IObjectPK)new ObjectUuidPK(scheduledId));
        }
        catch (Exception e) {
            scheduleInfo = new ScheduleInfo();
            scheduleInfo.setId(BOSUuid.read((String)scheduledId));
        }
        CheckMidStatusMonitorLogInfo monitorLogInfo = new CheckMidStatusMonitorLogInfo();
        String summary = "\u68c0\u67e5\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u53d8\u5316";
        monitorLogInfo.setScheduleInfo(scheduleInfo);
        monitorLogInfo.setBillMapingId(billNumber);
        MonitorManager.enter(ctx, monitorLogInfo, "\u68c0\u6d4b\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u53d8\u5316", operatorSource, billNumber, summary);
        return monitorLogInfo;
    }

    public static CheckMidStatusMonitorLogInfo getCurrentCheckMidStatus() {
        return (CheckMidStatusMonitorLogInfo)MonitorManager.getCurrent();
    }

    public static CheckMidStatusMonitorLogInfo enterCheckMidStatusforBasedata(Context ctx, String operatorSource, String billNumber, String scheduledId) {
        CheckMidStatusMonitorLogInfo monitorLogInfo = new CheckMidStatusMonitorLogInfo();
        String summary = "";
        if (StringUtils.isEmpty((String)scheduledId)) {
            summary = "\u624b\u5de5\u6267\u884c\uff0c\u68c0\u67e5\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u53d8\u5316";
            if (operatorSource == null) {
                operatorSource = "EAS\u5ba2\u6237\u7aef";
            }
        } else {
            ScheduleInfo scheduleInfo;
            try {
                scheduleInfo = (ScheduleInfo)ScheduleFactory.getLocalInstance(ctx).getObjectBaseInfo((IObjectPK)new ObjectUuidPK(scheduledId));
            }
            catch (Exception e) {
                scheduleInfo = new ScheduleInfo();
                scheduleInfo.setId(BOSUuid.read((String)scheduledId));
            }
            summary = "\u6267\u884c\u8c03\u5ea6\u7b56\u7565" + scheduledId + ",\u68c0\u67e5\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u53d8\u5316";
            monitorLogInfo.setScheduleInfo(scheduleInfo);
            if (operatorSource == null) {
                operatorSource = "\u8c03\u5ea6\u7b56\u7565";
            }
        }
        monitorLogInfo.setBillMapingId(billNumber);
        MonitorManager.enter(ctx, monitorLogInfo, "\u68c0\u6d4b\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u53d8\u5316", operatorSource, billNumber, summary);
        return monitorLogInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BaseDataDownMonitorLogInfo enterBaseData(Context ctx, String operatorSource, String baseDataNumber, String scheduleId, BaseDataSynHeadInfo baseDataSyninfo, String oprType) throws BOSException, EASBizException {
        String connNumber;
        String connectionId;
        String summary;
        BaseDataDownMonitorLogInfo monitorLogInfo;
        block18: {
            ScheduleInfo scheduleInfo;
            block17: {
                monitorLogInfo = new BaseDataDownMonitorLogInfo();
                scheduleInfo = null;
                if (!StringUtils.isEmpty((String)scheduleId)) {
                    try {
                        scheduleInfo = (ScheduleInfo)ScheduleFactory.getLocalInstance(ctx).getObjectBaseInfo((IObjectPK)new ObjectUuidPK(scheduleId));
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                } else {
                    scheduleInfo = new ScheduleInfo();
                }
                summary = "";
                connectionId = "";
                connNumber = "";
                if (!StringUtils.isEmpty((String)scheduleId)) break block17;
                String interfaceResult = baseDataSyninfo.getExtendedProperty("interfaceResult");
                monitorLogInfo.setExtendedProperty("interfaceResult", interfaceResult);
                String isInterface = baseDataSyninfo.getExtendedProperty("isInterface");
                if ("1".equals(isInterface) || execAPI.get() != null && execAPI.get().booleanValue()) {
                    operatorSource = "\u63a5\u53e3\u8c03\u7528";
                    connNumber = baseDataSyninfo.getExtendedProperty("extConnNumber");
                    if (StringUtils.isEmpty((String)connNumber)) {
                        connectionId = baseDataSyninfo.getExtendedProperty("extConnId");
                        try {
                            ConnectionInfo conn = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(connectionId));
                            connNumber = conn.getNumber();
                        }
                        catch (Exception e) {
                            throw new BOSException("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\uff08" + baseDataSyninfo.getNumber() + "\uff09\u8fde\u63a5\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002");
                        }
                    }
                    summary = "\u63a5\u53e3\u8c03\u7528\uff0c\u540c\u6b65\u7684\u57fa\u7840\u8d44\u6599\u65b9\u6848\uff1a" + baseDataNumber + "\uff0c\u76ee\u6807\u6570\u636e\u5e93\u8fde\u63a5\uff1a" + connNumber;
                    break block18;
                } else {
                    operatorSource = "EAS\u5ba2\u6237\u7aef";
                    connectionId = baseDataSyninfo.getExtendedProperty("extConnId");
                    try {
                        ConnectionInfo conn = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(connectionId));
                        connNumber = conn.getNumber();
                        summary = "\u540c\u6b65\u7684\u57fa\u7840\u8d44\u6599\u65b9\u6848\uff1a" + baseDataNumber + "\uff0c\u76ee\u6807\u6570\u636e\u5e93\u8fde\u63a5\uff1a" + connNumber;
                    }
                    catch (Exception e) {
                        throw new BOSException("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\uff08" + baseDataSyninfo.getNumber() + "\uff09\u8fde\u63a5\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002");
                    }
                }
            }
            operatorSource = "\u8c03\u5ea6\u7b56\u7565";
            connectionId = scheduleInfo.getConn().getId().toString();
            try {
                ConnectionInfo conn = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(connectionId));
                connNumber = conn.getNumber();
            }
            catch (Exception e) {
                throw new BOSException("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\uff08" + baseDataSyninfo.getNumber() + "\uff09\u8fde\u63a5\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002");
            }
            summary = "\u8c03\u5ea6\u7b56\u7565\uff1a" + scheduleId + "\uff0c\u540c\u6b65\u7684\u57fa\u7840\u8d44\u6599\u65b9\u6848\uff1a" + baseDataNumber + "\uff0c\u76ee\u6807\u6570\u636e\u5e93\u8fde\u63a5\uff1a" + connNumber;
        }
        if (StringUtils.isEmpty((String)connectionId)) {
            throw new BOSException("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\uff08" + baseDataSyninfo.getNumber() + "\uff09\u7f3a\u5c11\u8fde\u63a5\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539\u3002");
        }
        MonitorManager.setOperatorSource(operatorSource);
        monitorLogInfo.setExtendedProperty("connNumber", connNumber);
        MonitorManager.enter(ctx, monitorLogInfo, oprType, operatorSource, baseDataNumber, summary);
        MonitorManager.getCurrent().setExtendedProperty("connId", connectionId);
        String randomMD5 = baseDataSyninfo.getExtendedProperty("randomMD5");
        if (!StringUtils.isEmpty((String)randomMD5)) {
            BaseDataSynUtil.INTERFACE_PLAN_LOG.put(randomMD5, monitorLogInfo.getId().toString());
        }
        MonitorManager.getCurrent().setExtendedProperty("planNumber", baseDataSyninfo.getNumber());
        MonitorManager.getCurrent().setExtendedProperty("connNumber", connNumber);
        if (!StringUtils.isEmpty((String)baseDataSyninfo.getExtendedProperty("extMainSQL"))) {
            monitorLogInfo.setSrcWhere(baseDataSyninfo.getExtendedProperty("extMainSQL"));
        }
        return monitorLogInfo;
    }

    public static BaseDataDownMonitorLogInfo enterBaseDataByRemoteService(Context ctx, String operatorSource, String baseDataNumber, String scheduleId, BaseDataSynHeadInfo baseDataSyninfo, String oprType) throws BOSException, EASBizException {
        BaseDataDownMonitorLogInfo monitorLogInfo = new BaseDataDownMonitorLogInfo();
        ScheduleInfo scheduleInfo = null;
        if (!StringUtils.isEmpty((String)scheduleId)) {
            try {
                scheduleInfo = (ScheduleInfo)ScheduleFactory.getLocalInstance(ctx).getObjectBaseInfo((IObjectPK)new ObjectUuidPK(scheduleId));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            scheduleInfo = new ScheduleInfo();
        }
        String summary = "";
        String wsserviceId = "";
        String wsserviceNumber = "";
        String webserviceId = "";
        String webserviceNumber = "";
        if (StringUtils.isEmpty((String)scheduleId)) {
            operatorSource = "EAS\u5ba2\u6237\u7aef";
            wsserviceId = baseDataSyninfo.getExtendedProperty("extWsserviceId");
            webserviceId = baseDataSyninfo.getExtendedProperty("extWebServiceId");
            if (!StringUtils.isEmpty((String)wsserviceId)) {
                try {
                    WSServiceInfo wsserviceinfo = WSServiceFactory.getLocalInstance(ctx).getWSServiceInfo(CommonUtil.convert2PK(wsserviceId));
                    wsserviceNumber = wsserviceinfo.getNumber();
                    summary = "\u540c\u6b65\u7684\u57fa\u7840\u8d44\u6599\u65b9\u6848\uff1a" + baseDataNumber + "\uff0c\u8fdc\u7a0b\u670d\u52a1\uff1a" + wsserviceNumber;
                }
                catch (Exception e) {
                    throw new BOSException("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\uff08" + baseDataSyninfo.getNumber() + "\uff09\u8fdc\u7a0b\u670d\u52a1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002");
                }
            }
            if (!StringUtils.isEmpty((String)webserviceId)) {
                try {
                    BaseDataSynWebServiceInfo webserviceinfo = BaseDataSynWebServiceFactory.getLocalInstance(ctx).getBaseDataSynWebServiceInfo(CommonUtil.convert2PK(webserviceId));
                    webserviceNumber = webserviceinfo.getNumber();
                    summary = "\u540c\u6b65\u7684\u57fa\u7840\u8d44\u6599\u65b9\u6848\uff1a" + baseDataNumber + "\uff0cweb\u670d\u52a1\uff1a" + webserviceNumber;
                }
                catch (Exception e) {
                    throw new BOSException("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\uff08" + baseDataSyninfo.getNumber() + "\uff09web\u670d\u52a1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002");
                }
            }
        } else {
            operatorSource = "\u8c03\u5ea6\u7b56\u7565";
            WSServiceInfo wsserviceinfo = scheduleInfo.getWsservice();
            BaseDataSynWebServiceInfo baseDataSynWebServiceInfo = scheduleInfo.getBasedataSynWebService();
            if (wsserviceinfo != null) {
                try {
                    wsserviceId = scheduleInfo.getWsservice().getId().toString();
                    wsserviceinfo = WSServiceFactory.getLocalInstance(ctx).getWSServiceInfo(CommonUtil.convert2PK(wsserviceId));
                    wsserviceNumber = wsserviceinfo.getNumber();
                    summary = "\u8c03\u5ea6\u7b56\u7565\uff1a" + scheduleId + "\uff0c\u540c\u6b65\u7684\u57fa\u7840\u8d44\u6599\u65b9\u6848\uff1a" + baseDataNumber + "\uff0c\u8fdc\u7a0b\u670d\u52a1\uff1a" + wsserviceNumber;
                }
                catch (Exception e) {
                    throw new BOSException("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\uff08" + baseDataSyninfo.getNumber() + "\uff09\u8fdc\u7a0b\u670d\u52a1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002");
                }
                if (baseDataSynWebServiceInfo != null) {
                    try {
                        webserviceId = baseDataSynWebServiceInfo.getId().toString();
                        baseDataSynWebServiceInfo = BaseDataSynWebServiceFactory.getLocalInstance(ctx).getBaseDataSynWebServiceInfo(CommonUtil.convert2PK(webserviceId));
                        webserviceNumber = baseDataSynWebServiceInfo.getNumber();
                        summary = "\u8c03\u5ea6\u7b56\u7565\uff1a" + scheduleId + "\uff0c\u540c\u6b65\u7684\u57fa\u7840\u8d44\u6599\u65b9\u6848\uff1a" + baseDataNumber + "\uff0cweb\u670d\u52a1\uff1a" + webserviceNumber;
                    }
                    catch (Exception e) {
                        throw new BOSException("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\uff08" + baseDataSyninfo.getNumber() + "\uff09\u8fdc\u7a0b\u670d\u52a1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002");
                    }
                }
            }
        }
        MonitorManager.setOperatorSource(operatorSource);
        MonitorManager.enter(ctx, monitorLogInfo, oprType, operatorSource, baseDataNumber, summary);
        MonitorManager.getCurrent().setExtendedProperty("wsserviceId", wsserviceId);
        MonitorManager.getCurrent().setExtendedProperty("webserviceId", webserviceId);
        MonitorManager.getCurrent().setExtendedProperty(agentId4http, StringUtils.isEmpty((String)wsserviceId) ? webserviceId : wsserviceId);
        return monitorLogInfo;
    }

    public static BaseDataDownMonitorLogInfo enterBaseDataChange(Context ctx, String operatorSource, String baseDataNumber, String scheduleId) {
        ScheduleInfo scheduleInfo;
        BaseDataDownMonitorLogInfo monitorLogInfo = new BaseDataDownMonitorLogInfo();
        try {
            scheduleInfo = (ScheduleInfo)ScheduleFactory.getLocalInstance(ctx).getObjectBaseInfo((IObjectPK)new ObjectUuidPK(scheduleId));
        }
        catch (Exception e) {
            scheduleInfo = new ScheduleInfo();
            scheduleInfo.setId(BOSUuid.read((String)scheduleId));
        }
        String summary = "\u6267\u884c\u8c03\u5ea6\u7b56\u7565\uff1a" + scheduleId + "\uff0c\u540c\u6b65\u7684\u57fa\u7840\u8d44\u6599\u65b9\u6848\uff1a" + baseDataNumber;
        MonitorManager.enter(ctx, monitorLogInfo, "\u57fa\u7840\u8d44\u6599\u540c\u6b65(\u68c0\u6d4b\u53d8\u5316)", operatorSource, baseDataNumber, summary);
        MonitorManager.getCurrent().setExtendedProperty("connId", scheduleInfo.getConn().getId().toString());
        return monitorLogInfo;
    }

    public static BaseDataDownMonitorLogInfo getCurrentBaseDataDown() {
        return (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
    }

    public static MonitorLogInfo getCurrent() {
        return threadMonitorIds.get();
    }

    public static void error(Throwable throwable) {
        MonitorLogInfo monitorLogInfo = threadMonitorIds.get();
        if (monitorLogInfo == null) {
            logger.error((Object)"[EIP] not exist MonitorLogInfo in current thread!");
            return;
        }
        String message = null;
        Throwable cause = throwable;
        while (StringUtils.isEmpty((String)(message = cause.getMessage())) && (cause = cause.getCause()) != null) {
        }
        monitorLogInfo.setExtendedProperty("errorMsg", message);
        monitorLogInfo.setStatus("\u5f02\u5e38");
        monitorLogInfo.setStackTrace(ThrowableHelper.toString(throwable));
    }

    public static AutoMatchBasedataMonitorLogInfo enterAutoMatchBaseData(Context ctx, String operatorSource, String baseDataType, String chunkedTransmitNumber) {
        AutoMatchBasedataMonitorLogInfo monitorLogInfo = new AutoMatchBasedataMonitorLogInfo();
        monitorLogInfo.setChunkedTransmitNumber(chunkedTransmitNumber);
        String summary = !StringUtils.isEmpty((String)chunkedTransmitNumber) ? "\u4f7f\u7528HTTP-Chunked\u4f20\u8f93\u5355\u636e" + baseDataType + "\uff0c\u4f20\u8f93\u7f16\u53f7\u4e3a\uff1a" + chunkedTransmitNumber : "\u81ea\u52a8\u5339\u914d\u7c7b\u578b\u6620\u5c04\uff1a" + baseDataType;
        monitorLogInfo.put("oprtType", "\u81ea\u52a8\u5339\u914d\u503c\u6620\u5c04");
        MonitorManager.enter(ctx, monitorLogInfo, "\u81ea\u52a8\u5339\u914d\u503c\u6620\u5c04", operatorSource, baseDataType, summary);
        return monitorLogInfo;
    }

    public static BaseDataDownMonitorLogInfo enterhBaseDataDown(Context ctx, BaseDataSynHeadInfo headInfo, String baseDataType, String chunkedTransmitNumber) {
        BaseDataDownMonitorLogInfo monitorLogInfo = new BaseDataDownMonitorLogInfo();
        monitorLogInfo.setChunkedTransmitNumber("");
        monitorLogInfo.setSimpleName("BaseDataDown");
        String summary = "\u65b9\u6848\u540d\u79f0\uff1a" + headInfo.getNumber();
        String oprtStatus = "\u6b63\u5728\u8fd0\u884c";
        boolean hasData = true;
        BaseDataDownMonitorLogInfo.enter(ctx, monitorLogInfo, "\u57fa\u7840\u8d44\u6599\u540c\u6b65", "\u5ba2\u6237\u7aef\u4ee3\u7406/Web", headInfo.getNumber(), summary, oprtStatus, hasData, false);
        return monitorLogInfo;
    }

    public static AutoMatchBasedataMonitorLogInfo getCurrentAutoMatchBaseData() {
        return (AutoMatchBasedataMonitorLogInfo)MonitorManager.getCurrent();
    }

    public static void error(Context ctx, Throwable throwable) {
        try {
            MonitorLogInfo monitorLogInfo = threadMonitorIds.get();
            if (monitorLogInfo == null) {
                logger.error((Object)"[EIP] not exist MonitorLogInfo in current thread!");
                return;
            }
            String message = null;
            Throwable cause = throwable;
            while (StringUtils.isEmpty((String)(message = cause.getMessage())) && (cause = cause.getCause()) != null) {
            }
            String stackTrace = ThrowableHelper.toString(throwable);
            monitorLogInfo.setExtendedProperty("errorMsg", message);
            monitorLogInfo.setStatus("\u5f02\u5e38");
            monitorLogInfo.setStackTrace(stackTrace);
            String users = monitorLogInfo.getExtendedProperty("userList");
            if (!StringUtils.isEmpty((String)users)) {
                String[] userArr = users.split(",");
                ArrayList<String> receivers = new ArrayList<String>();
                for (String userNum : userArr) {
                    UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo("where number='" + userNum + "'");
                    if (user == null) continue;
                    receivers.add(user.getId().toString());
                }
                if (receivers.size() > 0) {
                    message = message + "\r\n" + stackTrace;
                    MonitorManager.sendByMessage(ctx, monitorLogInfo.getSummary() + "-\u5f02\u5e38\u4fe1\u606f", "\u7cfb\u7edf", message, receivers);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5c06\u5f02\u5e38\u65e5\u5fd7\u53cd\u9988\u5230\u901a\u77e5\u4e2d\u5fc3\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    public static List<String> getReceiver() {
        ArrayList<String> receiverList = new ArrayList<String>();
        if (receiverList.size() == 0) {
            receiverList.add("256c221a-0106-1000-e000-10d7c0a813f413B7DE7F");
        }
        return receiverList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(Context ctx) {
        MonitorLogInfo monitorLogInfo = threadMonitorIds.get();
        if (monitorLogInfo == null) {
            logger.error((Object)"[EIP] not exist MonitorLogInfo in current thread!");
            return;
        }
        try {
            if (monitorLogInfo instanceof AutoMatchBasedataMonitorLogInfo) {
                ((AutoMatchBasedataMonitorLogInfo)monitorLogInfo).assemble(ctx);
            } else if (monitorLogInfo instanceof BaseDataDownMonitorLogInfo) {
                BaseDataDownMonitorLogInfo cfr_ignored_0 = (BaseDataDownMonitorLogInfo)monitorLogInfo;
                BaseDataDownMonitorLogInfo.assemble(ctx, monitorLogInfo, true);
            } else if (monitorLogInfo instanceof IAssembledMonitorInfo) {
                ((IAssembledMonitorInfo)((Object)monitorLogInfo)).assemble(ctx);
            }
            String errorMsg = monitorLogInfo.getExtendedProperty("errorMsg");
            if (!StringUtils.isEmpty((String)monitorLogInfo.getExtendedProperty("errorMsg"))) {
                String content = monitorLogInfo.getContent() + "\n-----------------------\n\u5f02\u5e38\u4fe1\u606f\uff1a";
                content = content + errorMsg;
                monitorLogInfo.setContent(content);
            }
            if (monitorLogInfo.getStatus() == null || "\u6b63\u5728\u8fd0\u884c".equals(monitorLogInfo.getStatus())) {
                monitorLogInfo.setStatus("\u6210\u529f");
            }
            long startTime = monitorLogInfo.getStartTime().getTime();
            long duration = System.currentTimeMillis() - startTime;
            monitorLogInfo.setDuration(MonitorManager.getDurationDesc(duration));
            String reverseResult = "";
            if (monitorLogInfo instanceof BaseDataDownMonitorLogInfo) {
                try {
                    if (monitorLogInfo instanceof BaseDataDownMonitorLogInfo) {
                        BaseDataDownMonitorLogInfo baseDataLog = (BaseDataDownMonitorLogInfo)monitorLogInfo;
                        RecordBaseDataLogInfo recordInfo = baseDataLog.getRecordBaseDataLog();
                        recordInfo.finishRecordInfo(baseDataLog);
                    }
                }
                catch (Exception baseDataLog) {
                    // empty catch block
                }
                try {
                    String implClass = monitorLogInfo.getExtendedProperty("implClass");
                    if (!StringUtils.isEmpty((String)implClass)) {
                        Class<?> ReverseClass = Class.forName(implClass);
                        Method method = ReverseClass.getMethod("_updateReturnVal", Context.class, String.class);
                        String resultJSON = monitorLogInfo.getExtendedProperty("interfaceResult");
                        JSONObject resultObj = null;
                        resultObj = !StringUtils.isEmpty((String)resultJSON) ? new JSONObject(resultJSON) : new JSONObject();
                        boolean isSuccess = StringUtils.isEmpty((String)errorMsg) || "null".equals(errorMsg);
                        resultObj.put("isSuccess", isSuccess);
                        resultObj.put("errorMsg", isSuccess ? "" : errorMsg);
                        StringBuffer resultID = new StringBuffer();
                        HashMap subLogMap = (HashMap)SubMonitorLogFactory.getLocalInstance(ctx).getMainLogByMonitor(monitorLogInfo.getId().toString());
                        for (String planNumber : subLogMap.keySet()) {
                            SubMonitorLogCollection coll = (SubMonitorLogCollection)((Object)subLogMap.get(planNumber));
                            Iterator it = coll.iterator();
                            while (it.hasNext()) {
                                SubMonitorLogInfo logInfo = (SubMonitorLogInfo)it.next();
                                boolean isMainTable = logInfo.isMainTable();
                                if (!isMainTable || logInfo.getSuccess() == null || logInfo.getSuccess().length() <= 0) continue;
                                if (resultID.length() > 0) {
                                    resultID.append(",");
                                }
                                resultID.append(logInfo.getSuccess());
                            }
                        }
                        resultObj.put("sourceBillIds", resultID.toString());
                        JSONObject dataObject = new JSONObject();
                        for (String planNumber : subLogMap.keySet()) {
                            SubMonitorLogCollection coll = (SubMonitorLogCollection)((Object)subLogMap.get(planNumber));
                            Iterator it = coll.iterator();
                            while (it.hasNext()) {
                                SubMonitorLogInfo logInfo = (SubMonitorLogInfo)it.next();
                                boolean isMainTable = logInfo.isMainTable();
                                if (!isMainTable) continue;
                                String tableName = logInfo.getTableName().toUpperCase();
                                if (logInfo.getSuccess() == null || logInfo.getSuccess().length() <= 0) continue;
                                boolean tableExist = dataObject.has(tableName);
                                JSONObject tableData = null;
                                if (!tableExist) {
                                    tableData = new JSONObject();
                                    dataObject.put(tableName, tableData);
                                } else {
                                    tableData = dataObject.getJSONObject(tableName);
                                }
                                String actionkey = logInfo.getCmd().toUpperCase();
                                String actionValue = null;
                                boolean hasAction = tableData.has(actionkey);
                                actionValue = !hasAction ? logInfo.getSuccess() : tableData.getString(actionkey) + "," + logInfo.getSuccess();
                                tableData.put(actionkey, actionValue);
                            }
                        }
                        resultObj.put("tableActionData", dataObject);
                        if (dataObject.length() == 0) {
                            logger.error((Object)("monitorlogid : " + monitorLogInfo.getId() + " jsonStr: " + resultObj.toString()));
                        }
                        method.invoke(ReverseClass.newInstance(), ctx, resultObj.toString());
                    }
                }
                catch (Exception e) {
                    reverseResult = "\r\n\u8c03\u7528\u5b9e\u73b0\u7c7b\u53cd\u9988\u57fa\u7840\u8d44\u6599\u540c\u6b65\u6267\u884c\u7ed3\u679c\u5f02\u5e38:" + e.getMessage();
                    monitorLogInfo.setContent(monitorLogInfo.getContent() + reverseResult);
                    logger.error((Object)e);
                }
            }
            MonitorManager.checkLogValid(ctx, monitorLogInfo);
            BaseDataSynInvokeHelper.fixLogId(threadMonitorIds.get().getId().toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            threadMonitorIds.remove();
            threadOperatorSources.remove();
            try {
                MonitorManager.getCurrentSrcToMidBill().getUnkownBaseDataValues().clear();
            }
            catch (Exception e2) {
                logger.error((Object)("\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff1a" + e2));
            }
            try {
                DynamicBillBatchInsertHelper.close();
            }
            catch (Exception exception) {}
        }
    }

    public void _updateReturnVal(Context ctx, String result) throws Exception {
        logger.error((Object)("--------\u57fa\u7840\u8d44\u6599\u540c\u6b65\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5------" + result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkLogValid(Context ctx, MonitorLogInfo monitorLogInfo) throws Exception {
        IMonitorLog instance = MonitorLogFactory.getLocalInstance(ctx);
        IObjectPK pk = CommonUtil.convert2PK(monitorLogInfo.getId().toString());
        MonitorLogInfo monitorLogInfo2 = monitorLogInfo;
        synchronized (monitorLogInfo2) {
            if (MonitorManager.isZeroMonitorLog(ctx, monitorLogInfo) && MonitorManager.isSameToLast(ctx, monitorLogInfo)) {
                if (instance.exists(pk)) {
                    instance.delete(pk);
                }
            } else {
                MonitorManager.saveMonitorLog(ctx, monitorLogInfo);
            }
        }
    }

    private static void saveMonitorLog(Context ctx, MonitorLogInfo monitorLogInfo) throws Exception {
        IObjectPK pk;
        IMonitorLog instance = MonitorLogFactory.getLocalInstance(ctx);
        if (instance.exists(pk = CommonUtil.convert2PK(monitorLogInfo.getId().toString()))) {
            instance.updateLog(monitorLogInfo);
        } else {
            instance.log(monitorLogInfo);
        }
    }

    public static boolean isZeroMonitorLog(Context ctx, MonitorLogInfo monitorLogInfo) throws Exception {
        AutoMatchBasedataMonitorLogInfo logInfo;
        if (!StringUtils.isEmpty((String)monitorLogInfo.getStackTrace())) {
            return false;
        }
        return monitorLogInfo instanceof AutoMatchBasedataMonitorLogInfo ? (logInfo = (AutoMatchBasedataMonitorLogInfo)monitorLogInfo).getTotalCount() == 0 : (monitorLogInfo instanceof MidBillToDestMonitorLogInfo ? (logInfo = (MidBillToDestMonitorLogInfo)monitorLogInfo).getBillCount() == 0 : (monitorLogInfo instanceof SrcToMidBillMonitorLogInfo ? (logInfo = (SrcToMidBillMonitorLogInfo)monitorLogInfo).getBillCount() == 0 : (monitorLogInfo instanceof CheckMidStatusMonitorLogInfo ? (logInfo = (CheckMidStatusMonitorLogInfo)monitorLogInfo).getBillCount() == 0 : (monitorLogInfo instanceof SnapshotDataChangeMonitorLogInfo ? (logInfo = (SnapshotDataChangeMonitorLogInfo)monitorLogInfo).getUpdateCount() == 0 && logInfo.getDeleteCount() == 0 : monitorLogInfo instanceof BaseDataDownMonitorLogInfo && (logInfo = (BaseDataDownMonitorLogInfo)monitorLogInfo).getChangeCount() == 0))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSameToLast(Context ctx, MonitorLogInfo monitorLogInfo) throws Exception {
        MonitorLogInfo lastLogInfo;
        IMonitorLog instance = MonitorLogFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)monitorLogInfo.getId().toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billNumber", (Object)monitorLogInfo.getBillNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("operator", (Object)monitorLogInfo.getOperator(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("operatorSource", (Object)monitorLogInfo.getOperatorSource(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"\u6b63\u5728\u8fd0\u884c", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("summary", (Object)monitorLogInfo.getSummary(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5");
        ev.setFilter(filter);
        SorterItemInfo sorterItem = new SorterItemInfo();
        sorterItem.setPropertyName("createTime");
        sorterItem.setSortType(SortType.DESCEND);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(sorterItem);
        ev.setSorter(sorterColl);
        ev.setTopCount(1);
        MonitorLogCollection coll = instance.getMonitorLogCollection(ev);
        if (coll.size() > 0 && StringUtils.equals((String)(lastLogInfo = coll.get(0)).getContent(), (String)monitorLogInfo.getContent())) {
            ArrayList<Object[]> log = new ArrayList<Object[]>();
            log.add(new Object[]{lastLogInfo.getId().toString(), lastLogInfo.getStartTime(), lastLogInfo.getDuration()});
            String insertVersion = "insert into T_EIP_MonitorLogVersion(FMonitorLogID,FStartTime,FDuration) VALUES(?,?,?)";
            DbUtil.executeBatch((Context)ctx, (String)insertVersion, log);
            lastLogInfo.setLastUpdateTime(monitorLogInfo.getLastUpdateTime());
            lastLogInfo.setLastUpdateUser(monitorLogInfo.getLastUpdateUser());
            lastLogInfo.setSummary(monitorLogInfo.getSummary());
            lastLogInfo.setStartTime(monitorLogInfo.getStartTime());
            lastLogInfo.setDuration(monitorLogInfo.getDuration());
            lastLogInfo.setStackTrace(monitorLogInfo.getStackTrace());
            instance.updateLog(lastLogInfo);
            if (monitorLogInfo instanceof BaseDataDownMonitorLogInfo) {
                String updateSubLogSQL = "update t_eip_subMonitorlog set fmonitorlogid = '" + lastLogInfo.getId().toString() + "' where fmonitorlogid = '" + monitorLogInfo.getId().toString() + "'";
                String deleteOldSubLogSQL = "delete from t_eip_subMonitorlog where fmonitorlogid = '" + lastLogInfo.getId().toString() + "'";
                Connection conn = null;
                try {
                    conn = SQLUtil.getKSQLConnection(ctx);
                    SQLUtil.executeUpdate(conn, deleteOldSubLogSQL);
                    SQLUtil.executeUpdate(conn, updateSubLogSQL);
                }
                catch (Exception e) {
                    logger.error((Object)"EIP- \u5b50\u65e5\u5fd7\u5220\u9664\u5931\u8d25");
                }
                finally {
                    SQLUtil.cleanup(conn);
                }
            }
            BaseDataSynUtil.INTERFACE_PLAN_LOG.put(monitorLogInfo.getId().toString(), lastLogInfo.getId().toString());
            threadMonitorIds.set(lastLogInfo);
            return true;
        }
        return false;
    }

    static final String getLocalIP() {
        if (localIp != null) {
            return localIp;
        }
        try {
            String ip = InetAddress.getLocalHost().getHostAddress();
            if (!LOOPBACK_IP.equals(ip)) {
                localIp = ip;
                return localIp;
            }
            ArrayList<String> localIPs = new ArrayList<String>();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (LOOPBACK_IP.equals(i.getHostAddress())) continue;
                    localIPs.add(i.getHostAddress());
                }
            }
            if (localIPs.size() > 0) {
                Collections.sort(localIPs);
                localIp = (String)localIPs.get(0);
                return localIp;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        localIp = LOOPBACK_IP;
        return localIp;
    }

    static final String getRpcPort() {
        return String.valueOf(ORMRPConfig.getTcpConnectionPort());
    }

    public static final String getDurationDesc(long t) {
        long hour = t / 3600000L;
        long left = t % 3600000L;
        long minus = left / 60000L;
        long second = (left %= 60000L) / 1000L;
        return hour + "\u65f6" + minus + "\u5206" + second + "\u79d2" + (left %= 1000L) + "\u6beb\u79d2";
    }

    public static void sendByMessage(Context ctx, String msgTitle, String msgSender, String msgBody, List<String> msgReceiver) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = MonitorManager.getContextLocales(ctx);
        Locale locale2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", msgTitle, locale2);
            message.setLocaleStringHeader("sender", msgSender, locale2);
            message.setLocaleStringHeader("body", msgBody, locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 20);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        StringBuffer recievers = new StringBuffer();
        for (int i = 0; i < msgReceiver.size(); ++i) {
            if (i > 0) {
                recievers.append(";");
            }
            recievers.append(msgReceiver.get(i));
        }
        message.setStringHeader("receiver", recievers.toString());
        senderAgent.sendMessage(message);
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public static MidBillToDestBaseDataMonitorLogInfo enterMidBillToDestBaseData(Context ctx, String operatorSource, String billNumber, String scheduledId) {
        MidBillToDestBaseDataMonitorLogInfo monitorLogInfo = new MidBillToDestBaseDataMonitorLogInfo();
        String summary = "";
        if (StringUtils.isEmpty((String)scheduledId)) {
            summary = "\u624b\u5de5\u6267\u884c\uff0c\u628a\u4e2d\u95f4\u5355\u636e" + billNumber + "\u8f6c\u6362\u6210\u76ee\u6807\u57fa\u7840\u8d44\u6599";
        } else {
            ScheduleInfo scheduleInfo;
            try {
                scheduleInfo = (ScheduleInfo)ScheduleFactory.getLocalInstance(ctx).getObjectBaseInfo((IObjectPK)new ObjectUuidPK(scheduledId));
            }
            catch (Exception e) {
                scheduleInfo = new ScheduleInfo();
                scheduleInfo.setId(BOSUuid.read((String)scheduledId));
            }
            summary = "\u6267\u884c\u8c03\u5ea6\u7b56\u7565" + scheduledId + "\uff0c\u628a\u4e2d\u95f4\u5355\u636e" + billNumber + "\u8f6c\u6362\u6210\u76ee\u6807\u5355\u636e";
            monitorLogInfo.setScheduleInfo(scheduleInfo);
        }
        MonitorManager.enter(ctx, monitorLogInfo, "\u751f\u6210\u76ee\u6807\u57fa\u7840\u8d44\u6599", operatorSource, billNumber, summary);
        return monitorLogInfo;
    }

    public static void setExecAPI(Boolean isAPI) {
        execAPI.set(isAPI);
    }

    public static Boolean getExecAPI() {
        return execAPI.get();
    }

    public static void removeExecAPI() {
        execAPI.remove();
    }

    public static boolean isExit() {
        BaseDataDownMonitorLogInfo monitorLogInfo = (BaseDataDownMonitorLogInfo)threadMonitorIds.get();
        logger.error((Object)(monitorLogInfo.isExit() + "  " + (monitorLogInfo.getExecMode() == 1)));
        return monitorLogInfo.isExit() || monitorLogInfo.getExecMode() == 1;
    }

    public static void setExit(boolean isExit) {
        BaseDataDownMonitorLogInfo monitorLogInfo = (BaseDataDownMonitorLogInfo)threadMonitorIds.get();
        monitorLogInfo.setExit(isExit);
    }

    public static void exitByMulti(Context ctx, BaseDataSynHeadInfo baseDataSynInfo) {
        String baseDataKey = baseDataSynInfo.getId().toString() + baseDataSynInfo.getExtendedProperty("extConnId");
        ScheduleTaskAction.BASEDATAMAPPING_PROCESS.remove(baseDataKey);
        BaseDataResourceholder.reset();
        MonitorManager.exit(ctx);
    }

    public static MonitorLogInfo enterBaseDataSynCompare(Context ctx, String operatorSource, String synHeadID) {
        BaseDataDownMonitorLogInfo logInfo = new BaseDataDownMonitorLogInfo();
        String summary = "\u57fa\u7840\u8d44\u6599\u96c6\u6210\u5916\u53d1\u6570\u636e\u6bd4\u5bf9";
        BaseDataSynHeadInfo headInfo = null;
        try {
            headInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(synHeadID));
            MonitorManager.enter(ctx, logInfo, "\u57fa\u7840\u8d44\u6599\u5916\u53d1\u6570\u636e\u6bd4\u5bf9", operatorSource, headInfo.getNumber(), summary);
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u57fa\u7840\u8d44\u6599\u5916\u53d1\u65b9\u6848\u5931\u8d25", (Throwable)e);
        }
        return logInfo;
    }

    static {
        execAPI = new ThreadLocal();
        scheduleDelMonitor = null;
        scheduleDelMonitor = new ScheduleScanEIPConfigFile();
    }
}

