/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.app.util.monitordel;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.monitor.app.util.monitordel.EIPConfigFileInfo;
import com.kingdee.eas.csinterface.monitor.app.util.monitordel.IMonitorDelEventListener;
import com.kingdee.eas.csinterface.monitor.app.util.monitordel.MonitorDelEventObject;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Statement;
import java.util.EventObject;
import org.apache.log4j.Logger;

public class MonitorDelEventListenerImpl
implements IMonitorDelEventListener<MonitorDelEventObject> {
    private static final Logger logger = Logger.getLogger(MonitorDelEventListenerImpl.class);
    Context ctx;
    int inteval = -3;

    public MonitorDelEventListenerImpl() {
    }

    public MonitorDelEventListenerImpl(Context ctx) {
        this.ctx = ctx;
    }

    public MonitorDelEventListenerImpl(Context ctx, int inteval) {
        this.ctx = ctx;
        this.inteval = inteval;
    }

    @Override
    public void handlerEvent(MonitorDelEventObject t) throws BOSException {
        logger.info((Object)"exe eip delete monitor log begin...");
        if (null == t) {
            throw new NullPointerException("schedule eip monitor del EventObject is null.");
        }
        this.ctx = t.getCtx();
        this.doHandler(t, new EIPConfigFileInfo());
    }

    @Override
    public boolean isInterEvent(EventObject t) {
        return t instanceof MonitorDelEventObject;
    }

    private void doHandler(MonitorDelEventObject eventObj, EIPConfigFileInfo eipFile) throws BOSException {
        this.eventObjectOpr(eventObj, eipFile);
        configFileMap.put("eipconfig", eventObj);
        int currOpr = eventObj.getEvnentOpr().ordinal();
        switch (currOpr) {
            case 2: {
                break;
            }
            default: {
                if (!eipFile.isEnableMonitorDel()) break;
                this.doDeleteMonitorLog();
            }
        }
    }

    private void doDeleteMonitorLog() throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        try {
            String ksql = "";
            conn = DBUtils.getConnection(this.ctx);
            stmt = conn.createStatement();
            if (DBUtil.isOracle((Connection)conn)) {
                ksql = "delete from t_eip_monitorlog where FCREATETIME < add_months(sysdate," + this.inteval + ")";
            } else if (DBUtil.isMSSQL((Connection)conn)) {
                ksql = "delete from t_eip_monitorlog where  FCREATETIME < dateadd(month," + this.inteval + ",getdate())";
            }
            stmt.executeUpdate(ksql);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private void eventObjectOpr(MonitorDelEventObject eo, EIPConfigFileInfo eipFile) {
        if (!configFileMap.containsKey("eipconfig")) {
            eo.setEvnentOpr(MonitorDelEventObject.FileOperation.ONE_OPR);
        } else {
            MonitorDelEventObject oldEvnentObj = (MonitorDelEventObject)configFileMap.get("eipconfig");
            EIPConfigFileInfo oldConfigFile = oldEvnentObj.getMonitorDelEventSource().getEipConfigFile();
            if (!oldConfigFile.isExist() && eipFile.isExist()) {
                eo.setEvnentOpr(MonitorDelEventObject.FileOperation.CREATE_OPR);
            }
            if (!oldConfigFile.isExist() && !eipFile.isExist()) {
                eo.setEvnentOpr(MonitorDelEventObject.FileOperation.NONE_OPR);
            }
            if (oldConfigFile.isExist() && !eipFile.isExist()) {
                eo.setEvnentOpr(MonitorDelEventObject.FileOperation.DELETE_OPR);
            }
            if (oldConfigFile.isExist() && eipFile.isExist() && eipFile.getLastUpdatetime() != oldConfigFile.getLastUpdatetime()) {
                eo.setEvnentOpr(MonitorDelEventObject.FileOperation.MODIFY_OPR);
            }
            if (oldConfigFile.isExist() && eipFile.isExist() && eipFile.getLastUpdatetime() == oldConfigFile.getLastUpdatetime()) {
                eo.setEvnentOpr(MonitorDelEventObject.FileOperation.NONE_OPR);
            }
        }
    }
}

