/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.planmanager.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSubPlanCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSubPlanInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTreeFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTreeInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTypeEnum;
import com.kingdee.eas.csinterface.basedatasyn.SynDirection;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataTreeListUI;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ImportUtil;
import com.kingdee.eas.csinterface.util.JDomB9Utils;
import com.kingdee.eas.csinterface.util.PlanManagerHelper;
import com.kingdee.eas.framework.ICoreBase;
import java.util.List;
import org.jdom2.Element;

public class BaseDataSynSimplePlanConverter
extends AbstractDataBaseInfoConverter {
    @Override
    public boolean canConvert(Class type) {
        return BaseDataSynHeadInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        BaseDataSynHeadInfo info = (BaseDataSynHeadInfo)source;
        Element root = new Element(info.getClass().getName());
        this.marshalHeader(root, info);
        if (info.isMultiPlan()) {
            this.marshalHeader(root, info, context);
        } else {
            this.marshalBaseDataTable(root, info, context);
            this.marshalBaseDataColumn(root, info, context);
        }
        return root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        BaseDataSynHeadInfo info = new BaseDataSynHeadInfo();
        List children = data.getChildren();
        this.unmarshalHeader(info, children);
        if (info.isMultiPlan()) {
            this.unmarshalHeader(info, children, context);
        } else {
            this.unmarshalBaseDataTable(children, info, context);
            this.unmarshalBaseDataColumn(children, info, context);
        }
        return info;
    }

    private void marshalHeader(Element root, BaseDataSynHeadInfo info) {
        BaseDataSynTreeInfo treeInfo;
        this.addChild(root, "FID", info.getId().toString());
        this.addChild(root, "number", info.getNumber());
        this.addChild(root, "name", info.getName());
        this.addChild(root, "direction", info.getDirection().getValue());
        this.addChild(root, "multiPlan", info.isMultiPlan() ? "1" : "0");
        this.addChild(root, "preset", info.getPreset() + "");
        this.addChild(root, "mainTableSeq", info.getMainTableSeq() + "");
        this.addChild(root, "enabled", info.isEnabled() ? "1" : "0");
        this.addChild(root, "baseDataSynType", info.getBaseDataSynType().getName());
        this.addChild(root, "implClass", info.getImplClass());
        if (BaseDataSynTypeEnum.alreadyLaunch.equals((Object)info.getBaseDataSynType())) {
            this.addChild(root, "dsType", info.getDsType().getName());
            this.addChild(root, "connection", info.getConn() == null ? "" : info.getConn().getId().toString());
            this.addChild(root, "agentuser", info.getAgent() == null ? "" : info.getAgent().getId().toString());
        }
        if ((treeInfo = info.getTreeid()) != null) {
            try {
                treeInfo = BaseDataSynTreeFactory.getRemoteInstance().getBaseDataSynTreeInfo(CommonUtil.convert2PK(treeInfo.getId().toString()));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        this.addChild(root, "treeid", info.getTreeid() != null ? treeInfo.getNumber() : "");
    }

    public void unmarshalHeader(BaseDataSynHeadInfo info, List<Element> children) {
        info.setNumber(this.getElementTextByName(children, "number"));
        info.setName(this.getElementTextByName(children, "name"));
        info.setMultiPlan("1".equals(this.getElementTextByName(children, "multiPlan")));
        String direction = this.getElementTextByName(children, "direction");
        info.setDirection(SynDirection.getEnum(direction));
        info.setImplClass(this.getElementTextByName(children, "implClass"));
        info.setPreset(Integer.valueOf(this.getElementTextByName(children, "preset")));
        info.setMainTableSeq(Integer.valueOf(this.getElementTextByName(children, "mainTableSeq")));
        info.setBaseDataSynType(BaseDataSynTypeEnum.getEnum(this.getElementTextByName(children, "baseDataSynType")));
        if (BaseDataSynTypeEnum.alreadyLaunch.equals((Object)info.getBaseDataSynType())) {
            try {
                info.setDsType(DataSourceType.getEnum(this.getElementTextByName(children, "dsType")));
                if (DataSourceType.agent.equals((Object)info.getDsType())) {
                    EipUserInfo user = EipUserFactory.getRemoteInstance().getEipUserInfo("where id='" + this.getElementTextByName(children, "agentuser") + "'");
                    info.setAgent(user);
                } else if (DataSourceType.jdbc.equals((Object)info.getDsType())) {
                    ConnectionInfo conn = ConnectionFactory.getRemoteInstance().getConnectionInfo("where id='" + this.getElementTextByName(children, "connection") + "'");
                    info.setConn(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void marshalHeader(Element root, BaseDataSynHeadInfo info, MarshallingContext context) {
        BaseDataSynSubPlanCollection planColl = info.getPlans();
        if (null == planColl || planColl.size() == 0) {
            return;
        }
        Element planEntrys = JDomB9Utils.addChild(root, "subPlan");
        for (int i = 0; i < planColl.size(); ++i) {
            BaseDataSynSubPlanInfo item = planColl.get(i);
            if (null == item) continue;
            BaseDataSynHeadInfo subPlan = new BaseDataSynHeadInfo();
            try {
                subPlan = PlanManagerHelper.getBaseDataSynHeadInfo(item.getSubPlanId());
                Object object = this.marshal(subPlan, context);
                JDomB9Utils.addChild(planEntrys, (Element)object);
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private void unmarshalHeader(BaseDataSynHeadInfo info, List<Element> children, UnmarshallingContext context) {
        Element planEntrys = this.getElementByName(children, "subPlan");
        if (null == planEntrys) {
            return;
        }
        BaseDataSynSubPlanCollection collection = new BaseDataSynSubPlanCollection();
        List list = planEntrys.getChildren(BaseDataSynHeadInfo.class.getName());
        for (Element element : list) {
            BaseDataSynHeadInfo headInfo;
            if (null == element || null == (headInfo = (BaseDataSynHeadInfo)this.unmarshal(element, context))) continue;
            try {
                String currentNumber = headInfo.getNumber();
                EntityViewInfo viewNumber = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                String targetNumber = ImportUtil.getTargetValue((ICoreBase)BaseDataSynHeadFactory.getRemoteInstance(), viewNumber, currentNumber);
                headInfo.setNumber(targetNumber);
                String currentName = headInfo.getName();
                EntityViewInfo viewName = ImportUtil.getEntityViewInfo4Equal("name", currentName);
                String targetName = ImportUtil.getTargetValue((ICoreBase)BaseDataSynHeadFactory.getRemoteInstance(), viewName, currentName);
                headInfo.setName(targetName);
                BaseDataSynTreeInfo treeNode = PlanManagerHelper.getSimpleTreeInfoByTreeNumber(this.getElementTextByName(element, "treeid"));
                headInfo.setTreeid(treeNode);
                IObjectPK pk = PlanManagerHelper.saveBaseDataSynHeadInfo(headInfo);
                BaseDataTreeListUI.setImportSubPlanIds((IObjectPK)pk);
                BaseDataSynSubPlanInfo entryInfo = new BaseDataSynSubPlanInfo();
                entryInfo.setSubPlanId(pk.toString());
                collection.add(entryInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        info.put("plans", (Object)collection);
    }

    private void marshalBaseDataTable(Element root, BaseDataSynHeadInfo info, MarshallingContext context) {
        BaseDataSynTableCollection tableColl = info.getTableEntrys();
        if (null == tableColl || tableColl.size() == 0) {
            return;
        }
        Element tableEntrys = JDomB9Utils.addChild(root, "tableEntrys");
        for (int i = 0; i < tableColl.size(); ++i) {
            BaseDataSynTableInfo item = tableColl.get(i);
            if (null == item) continue;
            Object object = context.marshall(item);
            JDomB9Utils.addChild(tableEntrys, (Element)object);
        }
    }

    private void unmarshalBaseDataTable(List<Element> children, BaseDataSynHeadInfo info, UnmarshallingContext context) {
        Element tableEntrys = this.getElementByName(children, "tableEntrys");
        if (null == tableEntrys) {
            return;
        }
        BaseDataSynTableCollection collection = new BaseDataSynTableCollection();
        List list = tableEntrys.getChildren(BaseDataSynTableInfo.class.getName());
        for (Element element : list) {
            BaseDataSynTableInfo tableInfo;
            if (null == element || null == (tableInfo = (BaseDataSynTableInfo)context.unmarshall(element))) continue;
            collection.add(tableInfo);
        }
        info.put("tableEntrys", (Object)collection);
    }

    private void marshalBaseDataColumn(Element root, BaseDataSynHeadInfo info, MarshallingContext context) {
        BaseDataSynColumnCollection columnColl = info.getColumnEntrys();
        if (null == columnColl || columnColl.size() == 0) {
            return;
        }
        Element columnEntrys = JDomB9Utils.addChild(root, "columnEntrys");
        for (int i = 0; i < columnColl.size(); ++i) {
            BaseDataSynColumnInfo item = columnColl.get(i);
            if (null == item) continue;
            Object object = context.marshall(item);
            JDomB9Utils.addChild(columnEntrys, (Element)object);
        }
    }

    private void unmarshalBaseDataColumn(List<Element> children, BaseDataSynHeadInfo info, UnmarshallingContext context) {
        Element columnEntrys = this.getElementByName(children, "columnEntrys");
        if (null == columnEntrys) {
            return;
        }
        BaseDataSynColumnCollection collection = new BaseDataSynColumnCollection();
        List list = columnEntrys.getChildren(BaseDataSynColumnInfo.class.getName());
        for (Element element : list) {
            BaseDataSynColumnInfo tableInfo;
            if (null == element || null == (tableInfo = (BaseDataSynColumnInfo)context.unmarshall(element))) continue;
            collection.add(tableInfo);
        }
        info.put("columnEntrys", (Object)collection);
    }
}

