/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.reportmapping.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.reportmapping.IReportMapping;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingFactory;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingInfo;
import com.kingdee.eas.csinterface.reportmapping.app.AbstractMidBillDataProcessFacadeControllerBean;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class MidBillDataProcessFacadeControllerBean
extends AbstractMidBillDataProcessFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.reportmapping.app.MidBillDataProcessFacadeControllerBean");

    @Override
    protected void _deleteMidBillData(Context ctx, String billMappingNumber, String[] headpks) throws BOSException {
        logger.info((Object)"--\u8c03\u7528 \u4e86\u4e2d\u95f4\u5355\u636e\u5220\u9664\u63a5\u53e3--");
        if (StringUtils.isEmpty((String)billMappingNumber)) {
            throw new BOSException("\u5355\u636e\u6620\u5c04\u7684\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u4efb\u52a1\u3002");
        }
        if (null == headpks || headpks.length == 0) {
            throw new BOSException("\u5355\u636e\u5934IDs\u6570\u7ec4\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u4efb\u52a1\u3002");
        }
        logger.info((Object)("\u53c2\u6570\u6570\u636e\uff1abillMappingNumber=" + billMappingNumber + ";headpks=" + Arrays.toString(headpks)));
        IReportMapping instance = ReportMappingFactory.getLocalInstance(ctx);
        ReportMappingInfo billMappingInfo = null;
        try {
            billMappingInfo = instance.getReportMappingInfo("where number = '" + billMappingNumber + "'");
        }
        catch (EASBizException e) {
            throw new BOSException("\u67e5\u8be2\u5355\u636e\u6620\u5c04[number=" + billMappingNumber + "]\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (null == billMappingInfo) {
            throw new BOSException("\u65e0\u6cd5\u627e\u5230\u7f16\u53f7\u4e3a\u3010" + billMappingNumber + "\u3011\u7684\u5355\u636e\u6620\u5c04\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u4efb\u52a1.");
        }
        HashSet<String> headpkSet = new HashSet<String>();
        for (String s : headpks) {
            if (StringUtils.isEmpty((String)s)) continue;
            headpkSet.add(s);
        }
        Set<String> idSet = MidBillDataProcessFacadeControllerBean.selectFid(ctx, billMappingInfo, headpkSet);
        try {
            DIPMetadata dm = new DIPMetadata(billMappingNumber);
            MetaDataPK pk = MetaDataPK.create((String)dm.getHeaderEntityPK());
            IDynamicBillTemplate dynamicBillTemplate = (IDynamicBillTemplate)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)pk);
            Object[] successPKs = dynamicBillTemplate.deleteBatchMidBill(billMappingNumber, idSet.toArray(new String[0]), false);
            logger.info((Object)("\u5220\u9664\u8fd4\u56de\u503c\uff1a" + Arrays.toString(successPKs)));
        }
        catch (EASBizException e) {
            logger.info((Object)("\u5220\u9664\u4e2d\u95f4\u5355\u636e\u5f02\u5e38\uff1a" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
    }

    private static Set<String> selectFid(Context ctx, ReportMappingInfo billMappingInfo, Set<String> headpkSet) throws BOSException {
        int i;
        HashSet<String> fidSet = new HashSet<String>();
        String midBillTable = billMappingInfo.getMidBillTable();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        String headId = "cfheadpk";
        StringBuffer headIds = new StringBuffer();
        for (i = 0; i < headpkSet.size(); ++i) {
            if (i > 0) {
                headIds.append(",");
            }
            headIds.append("?");
        }
        try {
            connection = DBUtils.getConnection(ctx);
            preparedStatement = connection.prepareStatement("select  fid from " + midBillTable + " where " + headId + " in (" + headIds.toString() + ")");
            i = 0;
            Iterator<String> it = headpkSet.iterator();
            while (it.hasNext()) {
                preparedStatement.setObject(i + 1, it.next());
                ++i;
            }
            rs = preparedStatement.executeQuery();
            Object temp = null;
            while (rs.next()) {
                temp = rs.getObject(1);
                if (null == temp) continue;
                fidSet.add(temp.toString());
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u67e5\u8be2\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u67e5\u8be2\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preparedStatement, (Connection)connection);
        return fidSet;
    }

    private static void deleteMidData(Context ctx, ReportMappingInfo billMappingInfo, Set<String> headpkSet) throws BOSException {
        String midBillTable = billMappingInfo.getMidBillTable();
        String midBillEntryTable = billMappingInfo.getMidBillEntryTable();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        String headId = "cfheadpk";
        StringBuffer headIds = new StringBuffer();
        for (int i = 0; i < headpkSet.size(); ++i) {
            if (i > 0) {
                headIds.append(",");
            }
            headIds.append("?");
        }
        HashSet<String> fidSet = new HashSet<String>();
        try {
            connection = DBUtils.getConnection(ctx);
            preparedStatement = connection.prepareStatement("select  fid from " + midBillTable + " where " + headId + " in (" + headIds.toString() + ")");
            int i = 0;
            Iterator<String> it = headpkSet.iterator();
            while (it.hasNext()) {
                preparedStatement.setObject(i + 1, it.next());
                ++i;
            }
            rs = preparedStatement.executeQuery();
            Iterator temp = null;
            while (rs.next()) {
                temp = rs.getObject(1);
                if (null == temp) continue;
                fidSet.add(temp.toString());
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u67e5\u8be2\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u67e5\u8be2\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preparedStatement, (Connection)connection);
        try {
            connection = DBUtils.getConnection(ctx);
            String delHeadStr = "delete from " + midBillTable + " where fid=?";
            preparedStatement = connection.prepareStatement(delHeadStr);
            for (String fid : fidSet) {
                preparedStatement.setObject(1, fid);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            String delEntryStr = "delete from " + midBillEntryTable + " where fparentid=?";
            preparedStatement = connection.prepareStatement(delEntryStr);
            for (String fid : fidSet) {
                preparedStatement.setObject(1, fid);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception e1) {
            logger.error((Object)"\u5220\u9664\u4e2d\u95f4\u8868\u5f02\u5e38\uff1a", (Throwable)e1);
            throw new BOSException("\u5220\u9664\u4e2d\u95f4\u8868\u5f02\u5e38\uff1a" + e1.getMessage());
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)preparedStatement, (Connection)connection);
        }
    }

    private static void deletePkTableData(Context ctx, ReportMappingInfo billMappingInfo, Set<String> headpkSet) throws BOSException {
        Connection connection = null;
        PreparedStatement deleteStatement = null;
        try {
            boolean isAgent = DataSourceType.agent.equals((Object)billMappingInfo.getDsType());
            if (isAgent) {
                String[] headpks = headpkSet.toArray(new String[0]);
                return;
            }
            ConnectionInfo conInfo = billMappingInfo.getSrcDBConn();
            if (null == conInfo) {
                throw new BOSException("\u5220\u9664 \u589e\u91cf\u8868[" + billMappingInfo.getPkTableName() + "]\u5f02\u5e38\uff1a\u6e90\u7cfb\u7edf\u8fde\u63a5\u914d\u7f6e\u4e3a\u7a7a.");
            }
            String id = conInfo.getId().toString();
            IObjectPK pk = CommonUtil.convert2PK(id);
            conInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(pk);
            connection = KSQLUtil.getConnection(conInfo);
            deleteStatement = connection.prepareStatement("delete from " + billMappingInfo.getPkTableName() + " where " + "headpk" + " = ?");
            for (String headpk : headpkSet) {
                deleteStatement.setObject(1, headpk);
                deleteStatement.addBatch();
            }
            deleteStatement.executeBatch();
            SQLUtils.cleanup((Statement)deleteStatement, (Connection)connection);
        }
        catch (Exception e) {
            logger.error((Object)"\u5220\u9664\u4e2d\u95f4\u8868\u5f02\u5e38:", (Throwable)e);
            throw new BOSException("\u5220\u9664 \u589e\u91cf\u8868[" + billMappingInfo.getPkTableName() + "]\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            SQLUtils.cleanup(deleteStatement, connection);
        }
    }

    @Override
    protected Object _setMidBillStatus(Context ctx, String midBillTableName, String[] srcObjectIDs) throws BOSException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (StringUtils.isEmpty((String)midBillTableName)) {
            throw new BOSException("\u8bbe\u7f6e\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff1amidBillTableName\uff08\u4e2d\u95f4\u8868\u540d\uff09\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        if (null == srcObjectIDs || srcObjectIDs.length == 0) {
            result.put("srcIdRealNum", 0);
            return result;
        }
        HashSet<String> srcIdSet = new HashSet<String>();
        for (int i = 0; i < srcObjectIDs.length; ++i) {
            if (StringUtils.isEmpty((String)srcObjectIDs[i])) continue;
            srcIdSet.add(srcObjectIDs[i].trim());
        }
        result.put("srcIdRealNum", srcIdSet.size());
        if (srcIdSet.size() < 1) {
            return result;
        }
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)StringUtils.arrayToString((Object[])srcIdSet.toArray(), (String)","), CompareType.INCLUDE));
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        HashSet<String> exitSrcIdSet = new HashSet<String>();
        if (relations != null && relations.size() > 0) {
            for (BOTRelationInfo relation : relations) {
                exitSrcIdSet.add(relation.getSrcObjectID());
            }
        }
        HashSet<String> notexitSrcIdSet = new HashSet<String>();
        for (String id : srcIdSet) {
            if (!exitSrcIdSet.contains(id)) {
                notexitSrcIdSet.add(id);
                continue;
            }
            System.out.println(id + "\u5df2\u7ecf\u5b58\u5728\u8be5ID[" + id + "]\uff0c\u5df2\u751f\u6210\u76ee\u6807\u5355\u636e!");
        }
        if (exitSrcIdSet.size() > 0) {
            this.updateMidBillStatus(ctx, midBillTableName, 1, exitSrcIdSet);
        }
        if (notexitSrcIdSet.size() > 0) {
            this.updateMidBillStatus(ctx, midBillTableName, 0, notexitSrcIdSet);
        }
        result.put("srcIdExitNum", exitSrcIdSet.size());
        result.put("srcIdNotExitNum", notexitSrcIdSet.size());
        return result;
    }

    private Set<String> getFidByNull(Context ctx, String tableName) throws BOSException {
        HashSet<String> hashSet;
        Connection connection = null;
        Statement stm = null;
        ResultSet rs = null;
        HashSet<String> fidSet = new HashSet<String>();
        try {
            connection = DBUtils.getConnection(ctx);
            stm = connection.createStatement();
            rs = stm.executeQuery("select fid from " + tableName + " where fmidbillstatus is null");
            String id = null;
            while (rs.next()) {
                id = rs.getString(1);
                if (!StringUtils.isEmpty((String)id)) continue;
                fidSet.add(id);
            }
            hashSet = fidSet;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u83b7\u53d6\u4e2d\u95f4\u5355\u636e" + tableName + "\u8868\u7684fmidbillstatus\u5b57\u6bb5\u4e3anull\u7684Fid\u5f02\u5e38.\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u83b7\u53d6\u4e2d\u95f4\u5355\u636e" + tableName + "\u8868\u7684fmidbillstatus\u5b57\u6bb5\u4e3anull\u7684Fid\u5f02\u5e38.\uff1a" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stm, (Connection)connection);
        return hashSet;
    }

    private void updateMidBillStatus(Context ctx, String tableName, int status, Set<String> fidSet) throws BOSException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            connection = DBUtils.getConnection(ctx);
            preparedStatement = connection.prepareStatement("update " + tableName + " set fmidbillstatus=?,ffivouchered=?  where fid=?");
            for (String id : fidSet) {
                preparedStatement.setObject(1, status);
                preparedStatement.setObject(2, status);
                preparedStatement.setObject(3, id);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement = connection.prepareStatement("update " + tableName + "Entry set fentryStatus=? where fparentid =?");
            for (String id : fidSet) {
                preparedStatement.setObject(1, status);
                preparedStatement.setObject(2, id);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u8bbe\u7f6e\u4e2d\u95f4\u8868\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u8bbe\u7f6e\u4e2d\u95f4\u8868\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)preparedStatement, (Connection)connection);
    }

    @Override
    protected void _addColumnIfNeed(Context ctx, String tableName, String colName) throws BOSException {
        Connection connection = null;
        ResultSet rs = null;
        Statement stm = null;
        try {
            connection = DBUtils.getConnection(ctx);
            boolean exitCollFlag = false;
            String sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME='" + tableName + "'";
            stm = connection.createStatement();
            if (!StringUtils.isEmpty((String)tableName) && !StringUtils.isEmpty((String)colName)) {
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    if (!colName.equalsIgnoreCase(rs.getString(1))) continue;
                    exitCollFlag = true;
                    break;
                }
            }
            if (!exitCollFlag) {
                stm = connection.createStatement();
                stm.executeUpdate("ALTER TABLE " + tableName + " ADD " + colName + " INT");
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u68c0\u67e5\u6216\u65b0\u589e\u4e2d\u95f4\u8868" + tableName + "\u662f\u5426\u5b58\u5728" + colName + "\u5217\u5f02\u5e38.\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u68c0\u67e5\u6216\u65b0\u589e\u4e2d\u95f4\u8868" + tableName + "\u662f\u5426\u5b58\u5728" + colName + "\u5217\u5f02\u5e38." + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stm, (Connection)connection);
    }

    @Override
    protected Object _setMidBillEntryStatus(Context ctx, String midBillEntryTableName, String[] srcObjectIds) throws BOSException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            connection = DBUtils.getConnection(ctx);
            String jobNumber = "";
            if (MonitorManager.getCurrentMidBillToDest() != null) {
                jobNumber = MonitorManager.getCurrentMidBillToDest().getAssignNumber();
            }
            StringBuilder queryString = new StringBuilder();
            queryString.append(" update ").append(midBillEntryTableName).append(" set ").append(" FAssignmentNumber = '").append(jobNumber).append("' ,").append(" fentryStatus = ? ").append(" where fid = ?");
            preparedStatement = connection.prepareStatement(queryString.toString());
            for (String id : srcObjectIds) {
                preparedStatement.setObject(1, 1);
                preparedStatement.setObject(2, id);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
        catch (Exception e) {
            try {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                logger.error((Object)("\u8bbe\u7f6e\u4e2d\u95f4\u8868\u5206\u5f55\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u8bbe\u7f6e\u4e2d\u95f4\u8868\u5206\u5f55\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)preparedStatement, (Connection)connection);
        return "SUCCESS";
    }
}

