/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.task.EipTaskManager;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.schedule.IScheduleContrlServiceFacade;
import com.kingdee.eas.csinterface.schedule.ScheduleActionEnum;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.schedule.app.service.DBFacade;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleFacade;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;

public class ScheduleContrlServiceFacade
extends AbstractBOSObject
implements IScheduleContrlServiceFacade {
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"BIDSFADE");

    public ScheduleContrlServiceFacade() {
    }

    public ScheduleContrlServiceFacade(Context ctx) {
        super(ctx);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void enableTask(ScheduleInfo scheduleInfo) throws BOSException, EASBizException {
        Context context = this.getContext();
        try {
            EIPLicenseCheckUtil.checkLicenseEnough(context);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        BillMappingInfo billMappInfo = scheduleInfo.getStrategy();
        BaseDataSynHeadInfo baseDataInfo = scheduleInfo.getBaseDataSyn();
        BaseDataMapingInfo mappingInfo = scheduleInfo.getBaseDataMap();
        if (billMappInfo != null && DataSourceType.agent.getValue().equals(billMappInfo.getDsType().getValue())) {
            ScheduleActionEnum actionType = scheduleInfo.getActionType();
            if (actionType.getValue() == 100 || actionType.getValue() == 0 || actionType.getValue() == 200) {
                EipTaskManager.orderBillDataConfig(context, scheduleInfo, actionType);
            } else if (actionType.getValue() == 1) {
                ScheduleFacade.enable(context, scheduleInfo);
            } else {
                if (actionType.getValue() != 300) throw new BOSException("unknow actionType:" + (Object)((Object)actionType));
                ScheduleFacade.enable(context, scheduleInfo);
            }
        } else if (baseDataInfo != null) {
            ScheduleActionEnum actionType = scheduleInfo.getActionType();
            if (400 == actionType.getValue() || 500 == actionType.getValue() || 700 == actionType.getValue()) {
                DataSourceType dsType = scheduleInfo.getDsType();
                if (DataSourceType.agent.equals((Object)dsType)) {
                    EipTaskManager.orderBaseDataSynConfig(context, scheduleInfo, actionType);
                } else if (DataSourceType.jdbc.equals((Object)dsType) || DataSourceType.remoteService.equals((Object)dsType)) {
                    ScheduleFacade.enable(context, scheduleInfo);
                }
            }
        } else {
            ScheduleFacade.enable(context, scheduleInfo);
        }
        DBFacade.saveState(context, scheduleInfo, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void disableTask(ScheduleInfo scheduleInfo) throws BOSException, EASBizException {
        Context context = this.getContext();
        BillMappingInfo billMappInfo = scheduleInfo.getStrategy();
        BaseDataSynHeadInfo baseDataInfo = scheduleInfo.getBaseDataSyn();
        if (billMappInfo != null && billMappInfo.getDsType() != null && DataSourceType.agent.getValue().equals(billMappInfo.getDsType().getValue())) {
            ScheduleActionEnum actionType = scheduleInfo.getActionType();
            if (actionType.getValue() == 100 || actionType.getValue() == 0 || actionType.getValue() == 200) {
                EipTaskManager.orderDeleteBillDataConfig(context, scheduleInfo);
            } else if (actionType.getValue() == 1) {
                ScheduleFacade.disable(context, scheduleInfo);
            } else {
                if (actionType.getValue() != 300) throw new BOSException("unknow actionType:" + (Object)((Object)actionType));
                ScheduleFacade.disable(context, scheduleInfo);
            }
        } else if (baseDataInfo != null) {
            DataSourceType dsType = scheduleInfo.getDsType();
            if (DataSourceType.agent.equals((Object)dsType)) {
                EipTaskManager.orderDeleteBaseDataConfig(context, scheduleInfo);
            } else if (DataSourceType.jdbc.equals((Object)dsType)) {
                ScheduleFacade.disable(context, scheduleInfo);
            }
        } else {
            ScheduleFacade.disable(context, scheduleInfo);
        }
        DBFacade.saveState(context, scheduleInfo, false);
    }
}

