/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.schedule.app.AbstractScheduleControllerBean;
import com.kingdee.eas.csinterface.schedule.app.ScheduleContrlServiceFacade;
import org.apache.log4j.Logger;

public class ScheduleControllerBean
extends AbstractScheduleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.schedule.app.ScheduleControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    @Override
    public ScheduleInfo getScheduleInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ScheduleInfo scheduleInfo = super.getScheduleInfo(ctx, pk);
        if (scheduleInfo.getBotMapping() != null) {
            scheduleInfo.setBotMapping(BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(scheduleInfo.getBotMapping().getId())));
        }
        if (scheduleInfo.getStrategy() != null) {
            try {
                BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo((IObjectPK)new ObjectUuidPK(scheduleInfo.getStrategy().getId()));
                scheduleInfo.setStrategy(billMappingInfo);
                if (billMappingInfo.getAgentUser() != null) {
                    EipUserInfo eipUserInfo = (EipUserInfo)EipUserFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(billMappingInfo.getAgentUser().getId()));
                    billMappingInfo.setAgentUser(eipUserInfo);
                }
            }
            catch (ObjectNotFoundException e) {
                logger.error((Object)e);
            }
        }
        return scheduleInfo;
    }

    @Override
    public IObjectPK addnew(Context ctx, ScheduleInfo model) throws BOSException, EASBizException {
        String scheduleNameVal = model.getSimpleName().replace("'", "''");
        if (ScheduleFactory.getLocalInstance(ctx).exists("where simpleName='" + scheduleNameVal + "'")) {
            throw new BOSException("\u7b56\u7565\u540d\u79f0'" + scheduleNameVal + "'\u5df2\u5b58\u5728\uff01");
        }
        return super.addnew(ctx, model);
    }

    @Override
    protected boolean _enableSchedule(Context ctx, String scheduleId) throws BOSException, EASBizException {
        ScheduleInfo scheduleInfo = this.getScheduleInfo(ctx, (IObjectPK)new ObjectUuidPK(scheduleId));
        ScheduleContrlServiceFacade scheduleContrlServiceFacade = new ScheduleContrlServiceFacade(ctx);
        scheduleContrlServiceFacade.enableTask(scheduleInfo);
        return true;
    }

    @Override
    protected boolean _disableSchedule(Context ctx, String scheduleId) throws BOSException, EASBizException {
        ScheduleInfo scheduleInfo = this.getScheduleInfo(ctx, (IObjectPK)new ObjectUuidPK(scheduleId));
        ScheduleContrlServiceFacade scheduleContrlServiceFacade = new ScheduleContrlServiceFacade(ctx);
        scheduleContrlServiceFacade.disableTask(scheduleInfo);
        return true;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._disableSchedule(ctx, pk.toString());
        JobServiceFactory.getLocalInstance((Context)ctx).deleteByTitle(pk.toString());
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] arrayPK;
        for (IObjectPK pk : arrayPK = super.getPKList(ctx, filter, null)) {
            this._disableSchedule(ctx, pk.toString());
        }
        arrayPK = super._delete(ctx, filter);
        return arrayPK;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (IObjectPK pk : arrayPK) {
            this._disableSchedule(ctx, pk.toString());
        }
        super._delete(ctx, arrayPK);
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] arrayPK;
        for (IObjectPK pk : arrayPK = super.getPKList(ctx, oql)) {
            this._disableSchedule(ctx, pk.toString());
        }
        arrayPK = super._delete(ctx, oql);
        return arrayPK;
    }
}

