/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.BackgroundProcess;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.wrapper.MessageSenderWrapper;
import com.kingdee.bos.service.job.wrapper.MethodWrapper;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.base.job.QuartzParser;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.DynamicBillTemplateCollection;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.MidBillDataProcessFacadeFactory;
import com.kingdee.eas.csinterface.billmapping.TranferType;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.ScheduleActionEnum;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.schedule.app.service.DBFacade;
import com.kingdee.eas.csinterface.schedule.app.service.DesBIllCreator;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleTaskAction;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduledTask;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.InvocationProxy;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.group.GroupBaseDataRunner;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.AbstractTransferManager;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.impl.TransferMultiToMultiManagerImpl;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.impl.TransferOneToOneMangerImpl;
import com.kingdee.eas.csinterface.schedule.app.service.jobhandler.JobHandler4BaseData4API;
import com.kingdee.eas.csinterface.schedule.app.service.util.EIPBackgroundServiceProvider;
import com.kingdee.eas.csinterface.schedule.app.service.util.EipBPJob;
import com.kingdee.eas.csinterface.schedule.app.service.util.JobUtil;
import com.kingdee.eas.csinterface.schedule.util.MyTimer;
import com.kingdee.eas.csinterface.syncdatabase.BDRMappingGroupFactory;
import com.kingdee.eas.csinterface.syncdatabase.BDRMappingGroupInfo;
import com.kingdee.eas.csinterface.syncdatabase.BDRMappingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.MessageSender;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ScheduleFacade {
    private static final Logger logger = Logger.getLogger(ScheduleFacade.class);
    public static final String EIP_SERVICETYPE = "EIP";

    public static void enable(Context ctx, ScheduleInfo scheduleInfo) throws BOSException {
        Timestamp validateTime = scheduleInfo.getTimerStartDate();
        MyTimer timer = MyTimer.parse2MyTimer(scheduleInfo.getTimerRuleExpresssion());
        String shedulerTime = timer.getCornExpression();
        BillMappingInfo mapping = scheduleInfo.getStrategy();
        BaseDataSynHeadInfo baseDataSynHeadInfo = scheduleInfo.getBaseDataSyn();
        BaseDataMapingInfo dataMapping = scheduleInfo.getBaseDataMap();
        BDRMappingInfo bdrMapping = scheduleInfo.getBaseDataRule2BaseData();
        BDRMappingGroupInfo bdrMappingGroup = scheduleInfo.getBaseDataGroupRule2BaseData();
        WSInterfaceInfo wsi = scheduleInfo.getWsinterface();
        WSServiceInfo wsService = scheduleInfo.getWsservice();
        String description = "";
        if (mapping != null) {
            description = bdrMapping != null ? (scheduleInfo.getActionType() == ScheduleActionEnum.RuleBaseDataChange ? ScheduleFacade.getDescription4BaseDataRuleChange(ctx, scheduleInfo, shedulerTime) : ScheduleFacade.getDescription4BaseDataRule(ctx, scheduleInfo, shedulerTime)) : (bdrMappingGroup != null ? ScheduleFacade.getDescription4BaseDataGroupRule(ctx, scheduleInfo, shedulerTime) : ScheduleFacade.getDescription(ctx, scheduleInfo, shedulerTime));
        } else if (dataMapping != null) {
            description = ScheduleFacade.getDescription4Mapping(ctx, scheduleInfo, shedulerTime);
        } else if (baseDataSynHeadInfo != null) {
            description = ScheduleFacade.getDescription4BaseDataSyn(ctx, scheduleInfo, shedulerTime);
        } else if (wsi != null) {
            description = ScheduleFacade.getDescription4wsInterface(ctx, scheduleInfo, shedulerTime);
        } else if (wsService != null) {
            description = ScheduleFacade.getDescription4wsInterface(ctx, scheduleInfo, shedulerTime);
        }
        try {
            JobDef def = ScheduleFacade.getJobDef(ctx, scheduleInfo, description);
            try {
                Method method = def.getClass().getMethod("setServiceType", String.class);
                method.invoke((Object)def, EIP_SERVICETYPE);
            }
            catch (Throwable method) {
                // empty catch block
            }
            Trigger trigger = new Trigger((Date)validateTime, ScheduleFacade.get2100(), def, "timer", true, shedulerTime, false, ScheduleFacade.getIsolation(EIP_SERVICETYPE, ctx));
            IJobService jobService = JobServiceFactory.getLocalInstance((Context)ctx);
            jobService.createJobDef(def, trigger, true);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void enableOnce4Schedule(Context ctx, ScheduleInfo scheduleInfo) throws BOSException {
        Method processBaseDataMethod;
        String scheduleId = scheduleInfo.getId().toString();
        BPOption bpOption = new BPOption();
        bpOption.setPersistent(false);
        bpOption.setImmediately(true);
        try {
            processBaseDataMethod = ScheduledTask.class.getMethod("doTask", Context.class, String.class);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Object[] paramValues = new Object[]{ctx, scheduleId};
        EipBPJob bpJob = new EipBPJob(StringUtils.isEmpty((String)ctx.getClientHostIP()) ? "\u8c03\u5ea6\u7b56\u7565" : "EAS\u5ba2\u6237\u7aef");
        bpOption.setDataCenter(ctx.getAIS());
        BackgroundProcess bp = new BackgroundProcess(ctx, bpOption, (IBOSObject)ScheduleTaskAction.getInstance(), processBaseDataMethod, paramValues);
        bpJob.setBp(bp);
        try {
            EIPBackgroundServiceProvider.getInstance().submit(ctx, bpJob, JobUtil.getScheduleJobMutex(ctx, scheduleInfo));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public static void enableOnce4Interface(Context ctx, Job job, ScheduleInfo scheduleInfo, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String processMethod, Integer actionType, String userList, long delayTime) throws BOSException {
        try {
            boolean isSync;
            try {
                EIPLicenseCheckUtil.checkLicenseEnough(ctx);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            mainSQL = StringUtils.isEmpty((String)mainSQL) ? " " : mainSQL;
            mainPKList = StringUtils.isEmpty((String)mainPKList) ? " " : mainPKList;
            userList = StringUtils.isEmpty((String)userList) ? " " : userList;
            String headId = baseDataSynInfo.getId().toString();
            String connId = baseDataSynInfo.getExtendedProperty("extConnId");
            int mutexCode = (headId + actionType + connId + mainSQL + mainPKList + new SimpleDateFormat("yyyy-MM-dd").format(new Date())).hashCode();
            String description = "~" + mutexCode + "_EIP\u57fa\u7840\u8d44\u6599\u540c\u6b65(" + baseDataSynInfo.getNumber() + ")_" + actionType;
            String sql = "select 1 from T_JOB_INST WITH(READPAST) where ftitle = ? and fstate in (?,?) ";
            int[] types = new int[]{12, 12, 12};
            Object[] params = new Object[]{description, JobState.Waiting.toString(), JobState.Ready.toString()};
            ArrayList result = SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])params);
            if (result.size() != 0) {
                logger.error((Object)("~~~~~~~~~~~~\u4efb\u52a1\u76f8\u540c\u7684\u672a\u6267\u884c\uff0c\u5f53\u524d\u7684\u88ab\u5ffd\u7565~~~~~~~~~~~~~~" + description + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date())));
                return;
            }
            String mutex = "G::_" + baseDataSynInfo.getNumber() + "_" + connId;
            Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() + delayTime);
            Object sync = ctx.get((Object)"sync");
            JobHandler4BaseData4API handler = new JobHandler4BaseData4API(headId, mainSQL, mainPKList, actionType, userList, connId);
            JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)handler, true, true, 0, mutex, null, Configuration.defaultJobIsolationLevel());
            try {
                Method method = cfg.getClass().getMethod("setServiceType", String.class);
                method.invoke((Object)cfg, EIP_SERVICETYPE);
            }
            catch (Throwable method) {
                // empty catch block
            }
            String instanceName = Configuration.instanceId();
            Job job1 = new Job(ctx, instanceName + "_" + description, cfg, null, scheduledTime);
            String isolation = ScheduleFacade.getIsolation(EIP_SERVICETYPE, ctx);
            if (isolation != null) {
                job1.setIsolationBoundary(isolation);
            }
            boolean bl = isSync = sync != null && "true".equalsIgnoreCase(sync.toString());
            if (isSync) {
                handler.execute(job1);
            } else {
                JobServiceFactory.getLocalInstance((Context)ctx).createJobInstance(job1);
            }
            return;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getIsolation(String serviceType, Context ctx) {
        String serversByServiceType = ScheduleFacade.getServersByServiceType(serviceType, ctx);
        if (!StringUtils.isEmpty((String)serversByServiceType)) {
            String[] strings = serversByServiceType.split(",");
            ArrayList<String> serverList = new ArrayList<String>(Arrays.asList(strings));
            return ScheduleFacade.getRandomServer(serverList, ctx);
        }
        return null;
    }

    private static String getServersByServiceType(String serviceType, Context ctx) {
        String servers = null;
        if (!StringUtils.isEmpty((String)serviceType)) {
            String sql = "select fservers from T_JOB_SERVERCONFIG WITH(READPAST) where fservicetype= ? ";
            int[] types = new int[]{12};
            Object[] params = new Object[]{serviceType};
            try {
                ArrayList result = SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])params);
                if (result.size() != 0) {
                    Map map = (Map)result.get(0);
                    servers = (String)map.get("fservers");
                }
            }
            catch (Throwable e) {
                logger.error((Object)("getServersByServiceType catch error,serviceType: " + serviceType), e);
            }
        }
        return servers;
    }

    private static String getRandomServer(List<String> serverList, Context ctx) {
        if (serverList == null || serverList.size() <= 0) {
            return null;
        }
        SecureRandom random = new SecureRandom();
        int index = random.nextInt(serverList.size());
        return serverList.get(index);
    }

    private void orderTask(Context ctx, String voucherId, String companyId, String periodId) throws BOSException, EASBizException {
        String description = "EIP\u8f6c\u63a5\u51ed\u8bc1\u81ea\u52a8\u66f4\u6b63\u4f59\u989d\u8868";
        try {
            JobDef jobDef = null;
            String scheduleId = voucherId;
            MethodWrapper wrapper = new MethodWrapper(ScheduledTask.class, "balanceModify", new Object[]{scheduleId});
            String mutex = "G::" + voucherId;
            jobDef = new JobDef(ctx, null, scheduleId, description, null, null, true, (Wrapper)wrapper, false, mutex, 500, -1, Configuration.defaultJobIsolationLevel(), null);
            Job job2 = jobDef.createJobInstance(ctx, description, null, new Timestamp(System.currentTimeMillis() + 30000L), null, -1, null);
            JobManager.instance().add(job2);
            JobServiceFactory.getLocalInstance((Context)ctx).createJobDef(jobDef);
            return;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void enable_test(Context ctx, ScheduleInfo scheduleInfo) throws BOSException {
        Timestamp validateTime = scheduleInfo.getTimerStartDate();
        MyTimer timer = MyTimer.parse2MyTimer(scheduleInfo.getTimerRuleExpresssion());
        String shedulerTime = timer.getCornExpression();
        BillMappingInfo mapping = scheduleInfo.getStrategy();
        BaseDataMapingInfo dataMapping = scheduleInfo.getBaseDataMap();
        String description = "";
        if (mapping != null) {
            description = ScheduleFacade.getDescription(ctx, scheduleInfo, shedulerTime);
        } else if (dataMapping != null) {
            description = ScheduleFacade.getDescription4Mapping(ctx, scheduleInfo, shedulerTime);
        }
        try {
            JobDef jobDef = ScheduleFacade.getJobDef(ctx, scheduleInfo, description);
            Object[] param = new Object[]{"2222", scheduleInfo.getId().toString(), "211"};
            Job job = jobDef.createJobInstance(ctx, description, (Object)param, null, null, -1, "server1@172.19.74.85");
            JobManager.instance().add(job);
            JobServiceFactory.getLocalInstance((Context)ctx).createJobDef(jobDef);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static JobDef getJobDef(Context ctx, ScheduleInfo scheduleInfo, String description) throws BOSException, Exception {
        String scheduleId = scheduleInfo.getId().toString();
        MethodWrapper wrapper = new MethodWrapper(ScheduledTask.class, "doTask", new Object[]{scheduleId});
        String jobDefId = ScheduleFacade.getJobDefId(ctx, scheduleInfo);
        String mutex = JobUtil.getScheduleJobMutex(ctx, scheduleInfo);
        String title = ScheduleFacade.getTitle(scheduleInfo);
        JobDef jobDef = null;
        jobDef = !StringUtils.isEmpty((String)jobDefId) ? new JobDef(jobDefId, ctx, null, title, description, null, null, true, (Wrapper)wrapper, false, mutex, 500, -1, Configuration.defaultJobIsolationLevel(), null) : new JobDef(ctx, null, title, description, null, null, true, (Wrapper)wrapper, false, mutex, 500, -1, Configuration.defaultJobIsolationLevel(), null);
        ScheduleFacade.addMsgSender(jobDef);
        return jobDef;
    }

    private static void addMsgSender(JobDef jobDef) {
        if (!MessageSender.getInstance().isForSchedule()) {
            return;
        }
        MessageSenderWrapper.MessageReceiver[] receivers = MessageSender.getInstance().getReceivers();
        if (receivers.length != 0) {
            boolean sendMail = MessageSender.getInstance().isSendMail();
            boolean sendSMS = MessageSender.getInstance().isSendSms();
            MessageSenderWrapper msgSender = new MessageSenderWrapper(receivers, ScheduleFacade.getDefaultMessageTemplates(), sendMail, sendSMS);
            try {
                if (MessageSender.getInstance().getScheduleConfig("onslow")) {
                    jobDef.addListener(JobEvent.OnSlow, (Wrapper)msgSender);
                }
                if (MessageSender.getInstance().getScheduleConfig("onfailed")) {
                    jobDef.addListener(JobEvent.OnFailed, (Wrapper)msgSender);
                }
                if (MessageSender.getInstance().getScheduleConfig("onmissed")) {
                    jobDef.addListener(JobEvent.OnMissed, (Wrapper)msgSender);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"\u3010eip\u3011\u6dfb\u52a0\u8c03\u5ea6\u6d88\u606f\u63a8\u9001\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static MessageSenderWrapper.MessageTemplate[] getDefaultMessageTemplates() {
        MessageSenderWrapper.MessageTemplate[] temps = new MessageSenderWrapper.MessageTemplate[3];
        String title = null;
        String body = null;
        title = "Background Services (<% Title%>) <% State%>!";
        body = "Please use\u201c system function -> Background Services -> Background Service Monitoring\u201d to see the name of background matter is title (<% title%>)  detail information,Or directly click on the\u201cBill\u201dbutton to see more information.";
        temps[0] = new MessageSenderWrapper.MessageTemplate(new Locale("l1"), title, body);
        title = "\u540e\u53f0\u4e8b\u52a1 {<%\u6807\u9898%>}  <%\u72b6\u6001%> !";
        body = "\u8bf7\u901a\u8fc7 \u201c \u7cfb\u7edf\u529f\u80fd -> \u540e\u53f0\u4e8b\u52a1 -> \u540e\u53f0\u4e8b\u52a1\u76d1\u63a7\u201d \u67e5\u770b \u201c\u6807\u9898\u201d \u4e3a {<%\u6807\u9898%>} \u7684\u540e\u53f0\u4e8b\u52a1\u7684\u8be6\u7ec6\u4fe1\u606f\uff1b\u6216\u76f4\u63a5\u70b9\u51fb\u201c\u5355\u636e\u201d\u6309\u94ae\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002";
        temps[1] = new MessageSenderWrapper.MessageTemplate(new Locale("l2"), title, body);
        title = "\u5f8c\u81fa\u4e8b\u52d9 {<%\u6a19\u984c%>}  <%\u72c0\u614b%> !";
        body = "\u8acb\u901a\u904e \u201c \u7cfb\u7d71\u529f\u80fd -> \u5f8c\u81fa\u4e8b\u52d9 -> \u5f8c\u81fa\u4e8b\u52d9\u76e3\u63a7\u201d \u67e5\u770b\u6a19\u984c\u70ba {<%\u6a19\u984c%>} \u7684\u5f8c\u81fa\u4e8b\u52d9\u7684\u8a73\u7d30\u4fe1\u606f\uff1b\u6216\u76f4\u63a5\u9ede\u64ca\u201c\u55ae\u64da\u201d\u6309\u9215\u67e5\u770b\u8a73\u7d30\u4fe1\u606f\u3002";
        temps[2] = new MessageSenderWrapper.MessageTemplate(new Locale("l3"), title, body);
        return temps;
    }

    private static String getTitle(ScheduleInfo scheduleInfo) {
        String title = "\u3010EIP\u8c03\u5ea6\u7b56\u7565(" + scheduleInfo.getSimpleName() + ")\u3011";
        return title;
    }

    private static Date get2100() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date expireDate = sdf.parse("2100");
        return expireDate;
    }

    private static String getDescription(Context ctx, ScheduleInfo scheduleInfo, String shedulerTime) {
        QuartzParser quartzParser = new QuartzParser(shedulerTime);
        String time = quartzParser.parse();
        String action = scheduleInfo.getActionType().getAlias();
        String strategy = scheduleInfo.getStrategy().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("\u3010EAS\u96c6\u6210\u7ba1\u7406\u3011 ");
        sb.append(time);
        sb.append(" ");
        sb.append(action);
        sb.append("[");
        sb.append("\u5355\u636e\u6620\u5c04");
        sb.append("\uff1a");
        sb.append(strategy);
        sb.append("]");
        return sb.toString();
    }

    private static String getDescription4Mapping(Context ctx, ScheduleInfo scheduleInfo, String shedulerTime) {
        QuartzParser quartzParser = new QuartzParser(shedulerTime);
        String time = quartzParser.parse();
        String action = scheduleInfo.getActionType().getAlias();
        String mapping = scheduleInfo.getBaseDataMap().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("\u3010EAS\u96c6\u6210\u7ba1\u7406\u3011 ");
        sb.append(time);
        sb.append(" ");
        sb.append(action);
        sb.append("[");
        sb.append("\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04");
        sb.append("\uff1a");
        sb.append(mapping);
        sb.append("]");
        return sb.toString();
    }

    private static String getDescription4BaseDataSyn(Context ctx, ScheduleInfo scheduleInfo, String shedulerTime) {
        QuartzParser quartzParser = new QuartzParser(shedulerTime);
        String time = quartzParser.parse();
        String action = scheduleInfo.getActionType().getAlias();
        String syn = scheduleInfo.getBaseDataSyn().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("\u3010EAS\u96c6\u6210\u7ba1\u7406\u3011 ");
        sb.append(time);
        sb.append(" ");
        sb.append(action);
        sb.append("[");
        sb.append("\u57fa\u7840\u8d44\u6599\u540c\u6b65");
        sb.append("\uff1a");
        sb.append(syn);
        sb.append("]");
        return sb.toString();
    }

    private static String getDescription4wsInterface(Context ctx, ScheduleInfo scheduleInfo, String shedulerTime) {
        QuartzParser quartzParser = new QuartzParser(shedulerTime);
        String time = quartzParser.parse();
        String action = scheduleInfo.getActionType().getAlias();
        String wsi = scheduleInfo.getWsinterface().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("\u3010EAS\u96c6\u6210\u7ba1\u7406\u3011 ");
        sb.append(time);
        sb.append(" ");
        sb.append(action);
        sb.append("[");
        sb.append("\u8fdc\u7a0b\u6570\u636e\u83b7\u53d6");
        sb.append("\uff1a");
        sb.append(wsi);
        sb.append("]");
        return sb.toString();
    }

    private static String getDescription4BaseDataRule(Context ctx, ScheduleInfo scheduleInfo, String shedulerTime) {
        QuartzParser quartzParser = new QuartzParser(shedulerTime);
        String time = quartzParser.parse();
        String action = scheduleInfo.getActionType().getAlias();
        String bdr = scheduleInfo.getBaseDataRule2BaseData().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("\u3010EAS\u96c6\u6210\u7ba1\u7406\u3011 ");
        sb.append(time);
        sb.append(" ");
        sb.append(action);
        sb.append("[");
        sb.append("\u5f02\u6784\u7cfb\u7edf\u57fa\u7840\u8d44\u6599\u96c6\u6210(\u5355\u4e00\u65b9\u6848)");
        sb.append("\uff1a");
        sb.append(bdr);
        sb.append("]");
        return sb.toString();
    }

    private static String getDescription4BaseDataRuleChange(Context ctx, ScheduleInfo scheduleInfo, String shedulerTime) {
        QuartzParser quartzParser = new QuartzParser(shedulerTime);
        String time = quartzParser.parse();
        String action = scheduleInfo.getActionType().getAlias();
        String bdr = scheduleInfo.getBaseDataRule2BaseData().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("\u3010EAS\u96c6\u6210\u7ba1\u7406\u3011 ");
        sb.append(time);
        sb.append(" ");
        sb.append(action);
        sb.append("[");
        sb.append("\u66f4\u65b0\u4e2d\u95f4\u5355\u72b6\u6001(\u5f02\u6784\u7cfb\u7edf\u57fa\u7840\u8d44\u6599\u96c6\u6210)");
        sb.append("\uff1a");
        sb.append(bdr);
        sb.append("]");
        return sb.toString();
    }

    private static String getDescription4BaseDataGroupRule(Context ctx, ScheduleInfo scheduleInfo, String shedulerTime) {
        QuartzParser quartzParser = new QuartzParser(shedulerTime);
        String time = quartzParser.parse();
        String action = scheduleInfo.getActionType().getAlias();
        String bdr = scheduleInfo.getBaseDataGroupRule2BaseData().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("\u3010EAS\u96c6\u6210\u7ba1\u7406\u3011 ");
        sb.append(time);
        sb.append(" ");
        sb.append(action);
        sb.append("[");
        sb.append("\u5f02\u6784\u7cfb\u7edf\u57fa\u7840\u8d44\u6599\u96c6\u6210(\u7ec4\u5408\u65b9\u6848)");
        sb.append("\uff1a");
        sb.append(bdr);
        sb.append("]");
        return sb.toString();
    }

    public static void disable(Context ctx, ScheduleInfo scheduleInfo) throws BOSException {
        String jobDefId = ScheduleFacade.getJobDefId(ctx, scheduleInfo);
        if (StringUtils.isEmpty((String)jobDefId)) {
            return;
        }
        IJobService jobService = JobServiceFactory.getLocalInstance((Context)ctx);
        String triggerId = ScheduleFacade.getTriggerId(ctx, jobDefId);
        if (StringUtils.isEmpty((String)triggerId)) {
            return;
        }
        JobServiceFactory.getLocalInstance((Context)ctx).disableTrigger(triggerId);
    }

    private static String getTriggerId(Context ctx, String jobDefId) throws BOSException {
        String sql = "select fid from t_job_trigger with(readpast) where fjobdefid=?";
        int[] types = new int[]{12};
        Object[] values = new Object[]{jobDefId};
        ArrayList rs = SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])values);
        if (rs.size() == 0) {
            return null;
        }
        String fid = (String)((Map)rs.get(0)).get("fid");
        return fid;
    }

    private static String getJobDefId(Context ctx, ScheduleInfo scheduleInfo) throws BOSException {
        String sql = "select fjobdefid from t_job_def with(readpast) where ftitle=?";
        int[] types = new int[]{12};
        Object[] values = new Object[]{ScheduleFacade.getTitle(scheduleInfo)};
        ArrayList rs = SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])values);
        if (rs.size() == 0) {
            return null;
        }
        String jobDefId = (String)((Map)rs.get(0)).get("fjobdefid");
        return jobDefId;
    }

    public static boolean triggerProcessMidBill(Context ctx, Map param) throws BOSException, EASBizException {
        Method processMidBillMethod;
        String mappingStrategyId = (String)param.get("mappingStrategyId");
        BillMappingInfo billMappingInfo = DataModelUtil.readBillMappingInfo(ctx, mappingStrategyId);
        if (billMappingInfo == null) {
            throw new BOSException("'" + mappingStrategyId + "'\u5bf9\u5e94\u7684\u5355\u636e\u6620\u5c04\u4e0d\u5b58\u5728!");
        }
        if (!DataSourceType.jdbc.getValue().equals(billMappingInfo.getDsType().getValue())) {
            throw new BOSException("'" + mappingStrategyId + "'\u5bf9\u5e94\u7684\u5355\u636e\u6620\u5c04\u201c\u6e90\u7cfb\u7edf\u6570\u636e\u6765\u6e90\u201d\u4e0d\u662f\u201c\u6570\u636e\u5e93(jdbc)\u201d!");
        }
        BPOption bpOption = new BPOption();
        bpOption.setPersistent(false);
        bpOption.setImmediately(true);
        try {
            processMidBillMethod = ScheduleTaskAction.class.getMethod("processMidBill", Context.class, Job.class, BillMappingInfo.class, Map.class);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Object[] paramValues = new Object[]{ctx, billMappingInfo, param};
        EipBPJob bpJob = new EipBPJob(StringUtils.isEmpty((String)ctx.getClientHostIP()) ? "\u8c03\u5ea6\u7b56\u7565" : "EAS\u5ba2\u6237\u7aef");
        bpOption.setDataCenter(ctx.getAIS());
        BackgroundProcess bp = new BackgroundProcess(ctx, bpOption, (IBOSObject)ScheduleTaskAction.getInstance(), processMidBillMethod, paramValues);
        bpJob.setBp(bp);
        EIPBackgroundServiceProvider.getInstance().submit(ctx, bpJob, JobUtil.getMidBillMutex(ctx, mappingStrategyId));
        return true;
    }

    public static boolean triggerProcessBaseDataTaskOnce(Context ctx, Map param) throws BOSException, EASBizException {
        Method processBaseDataDown;
        BPOption bpOption;
        BaseDataSynHeadInfo baseDataSynHeadInfo;
        block6: {
            int baseDataSyn = Integer.valueOf((String)param.get("baseDataSyn"));
            String headInfoId = (String)param.get("headInfoId");
            ObjectUuidPK pk = new ObjectUuidPK(headInfoId);
            baseDataSynHeadInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo((IObjectPK)pk);
            if (baseDataSynHeadInfo == null) {
                throw new BOSException("'" + headInfoId + "'\u5bf9\u5e94\u7684\u65b9\u6848\u4e0d\u5b58\u5728!");
            }
            baseDataSynHeadInfo.getExtendedProperties().putAll(param);
            bpOption = new BPOption();
            bpOption.setPersistent(false);
            bpOption.setImmediately(true);
            try {
                if (400 == baseDataSyn) {
                    processBaseDataDown = ScheduleTaskAction.class.getMethod("processBaseDataDown", Context.class, Job.class, ScheduleInfo.class, BaseDataSynHeadInfo.class, String.class, String.class, String.class);
                    break block6;
                }
                if (500 == baseDataSyn) {
                    processBaseDataDown = ScheduleTaskAction.class.getMethod("processBaseDataChange", Context.class, Job.class, ScheduleInfo.class, BaseDataSynHeadInfo.class, String.class, String.class, String.class);
                    break block6;
                }
                if (700 == baseDataSyn) {
                    processBaseDataDown = ScheduleTaskAction.class.getMethod("processBaseDataDownAndChange", Context.class, Job.class, ScheduleInfo.class, BaseDataSynHeadInfo.class, String.class, String.class, String.class);
                    break block6;
                }
                throw new BOSException(baseDataSyn + " \u7acb\u5373\u6267\u884c\u7684\u540c\u6b65\u7c7b\u578b\u4e0d\u5b58\u5728!");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        Object[] paramValues = new Object[]{ctx, null, baseDataSynHeadInfo, null, null, null};
        EipBPJob bpJob = new EipBPJob(StringUtils.isEmpty((String)ctx.getClientHostIP()) ? "\u8c03\u5ea6\u7b56\u7565" : "EAS\u5ba2\u6237\u7aef");
        bpOption.setDataCenter(ctx.getAIS());
        BackgroundProcess bp = new BackgroundProcess(ctx, bpOption, (IBOSObject)ScheduleTaskAction.getInstance(), processBaseDataDown, paramValues);
        bpJob.setBp(bp);
        EIPBackgroundServiceProvider.getInstance().submit(ctx, bpJob, JobUtil.getBaseDataSynMutex(ctx, baseDataSynHeadInfo));
        return true;
    }

    public static boolean triggerProcessBaseDataTask(Context ctx, Map param) throws BOSException, EASBizException {
        Method processBaseDataDown;
        BPOption bpOption;
        BaseDataSynHeadInfo baseDataSynHeadInfo;
        String userList;
        block11: {
            int baseDataSyn = Integer.valueOf((String)param.get("baseDataSyn"));
            userList = String.valueOf(param.get("userList"));
            String headInfoId = (String)param.get("headInfoId");
            ObjectUuidPK pk = new ObjectUuidPK(headInfoId);
            baseDataSynHeadInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo((IObjectPK)pk);
            if (baseDataSynHeadInfo == null) {
                throw new BOSException("'" + headInfoId + "'\u5bf9\u5e94\u7684\u65b9\u6848\u4e0d\u5b58\u5728!");
            }
            baseDataSynHeadInfo.getExtendedProperties().putAll(param);
            bpOption = new BPOption();
            bpOption.setPersistent(false);
            bpOption.setImmediately(true);
            try {
                if (!StringUtils.isEmpty((String)baseDataSynHeadInfo.getExtendedProperty("extConnId"))) {
                    if (400 == baseDataSyn) {
                        processBaseDataDown = ScheduleTaskAction.class.getMethod("processBaseDataDown", Context.class, Job.class, ScheduleInfo.class, BaseDataSynHeadInfo.class, String.class, String.class, String.class);
                        break block11;
                    }
                    if (500 == baseDataSyn) {
                        processBaseDataDown = ScheduleTaskAction.class.getMethod("processBaseDataChange", Context.class, Job.class, ScheduleInfo.class, BaseDataSynHeadInfo.class, String.class, String.class, String.class);
                        break block11;
                    }
                    if (700 == baseDataSyn) {
                        processBaseDataDown = ScheduleTaskAction.class.getMethod("processBaseDataDownAndChange", Context.class, Job.class, ScheduleInfo.class, BaseDataSynHeadInfo.class, String.class, String.class, String.class);
                        break block11;
                    }
                    if (800 == baseDataSyn) {
                        processBaseDataDown = ScheduleTaskAction.class.getMethod("processBaseDataDelete", Context.class, Job.class, ScheduleInfo.class, BaseDataSynHeadInfo.class, String.class, String.class, String.class);
                        break block11;
                    }
                    throw new BOSException(baseDataSyn + " \u7acb\u5373\u6267\u884c\u7684\u540c\u6b65\u7c7b\u578b\u4e0d\u5b58\u5728!");
                }
                if (400 == baseDataSyn) {
                    processBaseDataDown = ScheduleTaskAction.class.getMethod("processBaseDataDownByRemoteService", Context.class, Job.class, ScheduleInfo.class, BaseDataSynHeadInfo.class, String.class, String.class, String.class);
                    break block11;
                }
                if (500 == baseDataSyn) {
                    processBaseDataDown = ScheduleTaskAction.class.getMethod("processBaseDataChangeByRemoteService", Context.class, Job.class, ScheduleInfo.class, BaseDataSynHeadInfo.class, String.class, String.class, String.class);
                    break block11;
                }
                if (800 == baseDataSyn) {
                    processBaseDataDown = ScheduleTaskAction.class.getMethod("processBaseDataDeleteByRemoteService", Context.class, Job.class, ScheduleInfo.class, BaseDataSynHeadInfo.class, String.class, String.class, String.class);
                    break block11;
                }
                throw new BOSException(baseDataSyn + " \u7acb\u5373\u6267\u884c\u7684\u540c\u6b65\u7c7b\u578b\u4e0d\u5b58\u5728!");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        Object[] paramValues = new Object[]{ctx, null, baseDataSynHeadInfo, param.get("mainSQL"), null, userList};
        EipBPJob bpJob = new EipBPJob(StringUtils.isEmpty((String)ctx.getClientHostIP()) ? "\u8c03\u5ea6\u7b56\u7565" : "EAS\u5ba2\u6237\u7aef");
        bpOption.setDataCenter(ctx.getAIS());
        BackgroundProcess bp = new BackgroundProcess(ctx, bpOption, (IBOSObject)ScheduleTaskAction.getInstance(), processBaseDataDown, paramValues);
        bpJob.setBp(bp);
        EIPBackgroundServiceProvider.getInstance().submit(ctx, bpJob, JobUtil.getBaseDataSynMutex(ctx, baseDataSynHeadInfo));
        return true;
    }

    public static void triggerProcessBOTP(Context ctx, String scheduledId, Map<String, Object> param) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(scheduledId);
        ScheduleInfo scheduleInfo = ScheduleFactory.getLocalInstance(ctx).getScheduleInfo((IObjectPK)pk);
        String stragyId = scheduleInfo.getStrategy().getId().toString();
        if (scheduleInfo.getBotMapping() == null || scheduleInfo.getBotMapping().getId() == null) {
            throw new BOSException("\u8be5\u5b9a\u65f6\u5bf9\u5e94\u7684BOTMapping\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884cBOTP\u8f6c\u6362.");
        }
        BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo((IObjectPK)new ObjectUuidPK(stragyId));
        BOTMappingInfo botMapping = DBFacade.getBotMapping(ctx, scheduleInfo.getBotMapping().getId().toString());
        DesBIllCreator desBIllCreator = new DesBIllCreator(ctx, null, billMappingInfo.getNumber(), botMapping, billMappingInfo.getCashFlowRelation(), billMappingInfo.isIntegrateCashFlow(), billMappingInfo.getEasCashFlowRelation(), billMappingInfo.isIntergrateEASCashFlow(), billMappingInfo.getAssistAccountRelation(), billMappingInfo.isIntegrateEasAssAcc());
        desBIllCreator.botp2DesBill();
    }

    public static void triggerProcessBOTP(Context ctx, Set<String> headpkSet, BOTMappingInfo botMapping, BillMappingInfo billMappingInfo) throws Exception {
        AbstractTransferManager manager = null;
        if (TranferType.oneToOne.equals((Object)billMappingInfo.getTransferType())) {
            manager = new TransferOneToOneMangerImpl(ctx, headpkSet, botMapping, billMappingInfo, null);
        } else if (billMappingInfo.getTransferType() == null || billMappingInfo.getTransferType().equals((Object)TranferType.mutiToMuti) || billMappingInfo.getTransferType().equals((Object)TranferType.multiToOne)) {
            manager = new TransferMultiToMultiManagerImpl(ctx, headpkSet, botMapping, billMappingInfo, null);
        }
        if (manager == null) {
            throw new NullPointerException();
        }
        manager.invokeTansferBotp();
    }

    public static void triggerProcessBaseData(Context ctx, Set headpks, BillMappingInfo billMapping, BDRMappingInfo bdrMapping, ScheduleInfo scheduleInfo) throws Exception {
        InvocationProxy.getBaseDataInvocation(ctx, headpks, bdrMapping.getId().toString(), false, null, scheduleInfo, false).invoke();
    }

    public static void triggerProcessCheckStatus(Context ctx, String billNumber, String[] headpkset, ScheduleInfo scheduleInfo) throws Exception {
        String[] headpks = null;
        if (scheduleInfo == null) {
            if (headpkset.length == 0) {
                return;
            }
            headpks = headpkset;
        }
        if (scheduleInfo != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo SchedulefilterInfo = null;
            if (!StringUtil.isEmpty((String)scheduleInfo.getDataFilter())) {
                EntityViewInfo entityViewInfo = new EntityViewInfo(scheduleInfo.getDataFilter());
                SchedulefilterInfo = entityViewInfo.getFilter();
                logger.info((Object)("\u8c03\u5ea6\u7b56\u7565\u7684\u8fc7\u6ee4\u6761\u4ef6\uff1a" + SchedulefilterInfo));
            }
            if (SchedulefilterInfo != null) {
                ev.setFilter(SchedulefilterInfo);
            }
            FilterInfo existfilter = new FilterInfo();
            EntityViewInfo existentityViewInfo = new EntityViewInfo();
            existentityViewInfo.setFilter(existfilter);
            existfilter.getFilterItems().add(new FilterItemInfo("midBillStatus", (Object)1, CompareType.EQUALS));
            existfilter.getFilterItems().add(new FilterItemInfo("midBillStatus", (Object)2, CompareType.EQUALS));
            existfilter.setMaskString("#0 or #1");
            if (existentityViewInfo != null) {
                if (ev.getFilter() != null) {
                    ev.getFilter().mergeFilter(existentityViewInfo.getFilter(), "and");
                } else {
                    ev.setFilter(existentityViewInfo.getFilter());
                }
            }
            logger.info((Object)("\u8fc7\u6ee4\u6761\u4ef6\uff1a" + ev.getFilter()));
            IDynamicBillTemplate instanse = MidBillFactory.getInstance(ctx, billNumber);
            DynamicBillTemplateCollection colls = instanse.getDynamicBillTemplateCollection(ev);
            headpks = new String[colls.size()];
            for (int i = 0; i < colls.size(); ++i) {
                headpks[i] = colls.get(i).get("headpk").toString();
            }
        }
        MonitorManager.getCurrentCheckMidStatus().addBillCount(headpks.length == 0 ? 0 : headpks.length);
        Object result = MidBillDataProcessFacadeFactory.getLocalInstance(ctx).checkMidStatuForBaseData(billNumber, headpks);
        MonitorManager.getCurrentCheckMidStatus().setTransformResult(result);
    }

    public static void triggerProcessBaseDataGroup(Context ctx, String groupId, ScheduleInfo scheduleInfo) throws Exception {
        BDRMappingGroupInfo bDRMappingGroupInfo = BDRMappingGroupFactory.getLocalInstance(ctx).getBDRMappingGroupInfo("select *,entrys.* where id='" + groupId + "'");
        new GroupBaseDataRunner(ctx, bDRMappingGroupInfo, scheduleInfo).start();
    }
}

