/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.basedata;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.DBType;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.util.backport.concurrent.atomic.AtomicInteger;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.SQLType;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynCheckDiffInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynCompareFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynCompareInfo;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynCompare;
import com.kingdee.eas.csinterface.billmapping.app.util.Log4jUtil;
import com.kingdee.eas.csinterface.billmapping.app.util.ThreadUtil;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.BaseDataCheckUtil;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.CheckDiffConstant;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.CheckDiffStatusEnum;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class BaseDataCheckDiff {
    public static Logger logger = Logger.getLogger(BaseDataCheckDiff.class);
    public static int pageSize = 300;
    public static int dbLinkPageSize = 1500;
    Connection srcCn;
    Connection targetCn;
    ExecutorService services;
    boolean isLocalhost;
    public static boolean runCheckByDiffHost;
    public static boolean delHistoryData;
    public static boolean isClearIncTab;
    public static boolean isClearHisCompareData;
    public static boolean srcCompareBySql;
    Map<String, Object> agentMap = new HashMap<String, Object>();
    String[] checkTabs;
    AtomicInteger atomic;
    BaseDataDownMonitorLogInfo logInfo;
    StringBuilder logBuilder;
    private boolean useDBLink = false;

    public void beforCheck(Context ctx, String checkTable, String targetDB, String scheme) throws Exception {
        this.isLocalhost = true;
        this.checkTabs = checkTable.replace(" ", "").split(";");
        ConnectionInfo connInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(targetDB));
        this.logInfo = new BaseDataDownMonitorLogInfo();
        this.logBuilder = new StringBuilder();
        this.commonParam(ctx, connInfo, scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        try {
            this.synOperation(this.agentMap);
            this.initDiffTable(this.agentMap);
            this.insertBatchLog(this.agentMap);
            this.services = Executors.newFixedThreadPool(7);
            for (String tableName : this.checkTabs) {
                String qrySql = "select  batchNo from T_EIP_CKDIFFBATCHLOG where CHECKTABLE ='" + tableName + "'  and targetDB ='" + this.agentMap.get("targetDB") + "' and status = " + CheckDiffStatusEnum.WATTING.getVal();
                RowSet rowSet = SQLUtils.getJdbcRowSet((Connection)this.srcCn, (String)qrySql);
                Map<String, List<Integer>> assignmentInfo = BaseDataCheckDiff.initAssignment();
                while (rowSet.next()) {
                    int batchNo = rowSet.getInt(1);
                    BaseDataCheckDiff.assignmentHost(batchNo, assignmentInfo);
                }
                if (this.isLocalhost) {
                    this.agentMap.put("batchNoList", assignmentInfo.get("server1"));
                    this.runCheckDiff(this.agentMap, tableName);
                    continue;
                }
                List<Integer> server2 = assignmentInfo.get("server2");
                String compareInfo = BaseDataCheckDiff.wrapInfo(server2, this.agentMap);
                this.runComapreByDiffHost(compareInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u8fdb\u884c\u6bd4\u5bf9\u65f6\u62a5\u9519", (Throwable)e);
            this.logInfo.setStatus("\u5f02\u5e38");
            this.logInfo.setStackTrace(ThreadUtil.logCallStatck(e));
            this.afterCheck(this.agentMap, true);
        }
        finally {
            logger.info((Object)"\u4e3b\u65b9\u6cd5\u6267\u884c\u5b8c\u6210");
        }
    }

    private void synOperation(Map<String, Object> agentMap) throws SQLException {
        String insertSql = "insert into t_eip_synCheckDiff(synFlag,createtime) values ('" + agentMap.get("diffFlag") + "',sysdate)";
        SQLUtils.execute((Connection)this.srcCn, (String)insertSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDiffTable(Map agentMap) throws Exception {
        PreparedStatement statement = null;
        try {
            for (String tableName : this.checkTabs) {
                int checkFlag = (Integer)((Map)agentMap.get("checkFlagMap")).get(tableName);
                String eipTable = (String)((Map)agentMap.get("eipTableMap")).get(tableName);
                String whereSql = (String)((Map)agentMap.get("tabMapSql")).get(tableName);
                String targetDBID = (String)agentMap.get("targetDBID");
                String clearSql = "delete from T_EIP_INSERC where targetDB = '" + checkFlag + "'";
                if (isClearIncTab) {
                    clearSql = "truncate table T_EIP_INSERC";
                }
                SQLUtils.execute((Connection)this.srcCn, (String)clearSql);
                if (isClearHisCompareData) {
                    String delHisSql = "delete from  T_EIP_BaseDataSynCompare where fcheckTable ='" + tableName + "' and ftargetDB = '" + targetDBID + "'";
                    SQLUtils.execute((Connection)this.srcCn, (String)delHisSql);
                }
                StringBuilder execSql = new StringBuilder();
                execSql.append("insert into T_EIP_INSERC (HEADPK,TARGETDB,BATCHNO) select t0.headpk,").append(checkFlag);
                execSql.append(",0 from ").append(eipTable).append(" t0  where t0.agentId = '").append(targetDBID).append("'");
                if (!StringUtils.isEmpty((String)whereSql)) {
                    execSql.append(" and ").append("t0.headpk  in( select fid from ").append(tableName).append(" " + whereSql).append(")");
                }
                String strExecSql = execSql.toString();
                statement = this.srcCn.prepareStatement(strExecSql);
                int insertCount = statement.executeUpdate();
                this.logBuilder.append("\u8868" + tableName + "\u6bd4\u5bf9\u6570\u4e3a\uff1a" + insertCount + "\u6761\r\n");
                if (insertCount == 0) {
                    this.logBuilder.append("\u6267\u884csql\u589e\u91cf\u8868\u521d\u59cb\u5316\uff1a" + strExecSql + "\r\n");
                }
                Log4jUtil.log(99, strExecSql);
            }
        }
        finally {
            SQLUtils.cleanup(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertBatchLog(Map agentMap) throws Exception {
        PreparedStatement statement = null;
        boolean flag = true;
        int batchNo = 1;
        try {
            for (String tableName : this.checkTabs) {
                int checkFlag = (Integer)((Map)agentMap.get("checkFlagMap")).get(tableName);
                String synHeadID = (String)agentMap.get("scheme");
                String fixSql = "update T_EIP_CKDIFFBATCHLOG set status = " + CheckDiffStatusEnum.NORUN.getVal() + ",MSG = 'history unComplete Data',ENDTIME=sysdate  where diffFlag=" + checkFlag + " and status = " + CheckDiffStatusEnum.WATTING.getVal();
                String delSql = "delete T_EIP_CKDIFFBATCHLOG where diffFlag=" + checkFlag;
                if (delHistoryData) {
                    SQLUtils.execute((Connection)this.srcCn, (String)delSql);
                } else {
                    SQLUtils.execute((Connection)this.srcCn, (String)fixSql);
                }
                String qryCount = "select  count(*) countBatch from  T_EIP_CKDIFFBATCHLOG";
                RowSet rs = SQLUtils.getJdbcRowSet((Connection)this.srcCn, (String)qryCount);
                while (rs.next()) {
                    batchNo = rs.getInt(1);
                }
                flag = true;
                while (flag) {
                    String upSql = "update T_EIP_INSERC set batchNo = " + ++batchNo + " where headpk in (select top " + (Boolean.TRUE.equals(this.useDBLink) ? dbLinkPageSize : pageSize) + " headpk from T_EIP_INSERC where batchNo =  0 and targetDB=" + checkFlag + ")";
                    statement = this.srcCn.prepareStatement(upSql);
                    int count = statement.executeUpdate();
                    if (count > 0) {
                        String insertSql = "insert into T_EIP_CKDIFFBATCHLOG (FID, CHECKTABLE, TARGETDB, BATCHNO, BATCHSIZE,STATUS,CREATETIME,ENDTIME,DIFFFLAG,SYNHEADID)values ('1','" + tableName + "','" + agentMap.get("targetDB") + "'," + batchNo + "," + count + "," + CheckDiffStatusEnum.WATTING.getVal() + ",sysdate,sysdate," + checkFlag + ",'" + synHeadID + "')";
                        statement = this.srcCn.prepareStatement(insertSql);
                        statement.executeUpdate();
                        if (count == pageSize) continue;
                        ArrayList<Integer> batchInfo = new ArrayList<Integer>();
                        batchInfo.add(batchNo);
                        batchInfo.add(count);
                        agentMap.put(String.valueOf(checkFlag), batchInfo);
                        continue;
                    }
                    flag = false;
                }
            }
        }
        finally {
            SQLUtils.cleanup(statement);
        }
    }

    public void runCheckDiff(Map<String, Object> agentMap, String tableName) throws SQLException {
        List server1 = (List)agentMap.get("batchNoList");
        int count = server1.size();
        CountDownLatch countDown = new CountDownLatch(count);
        Iterator iterator = server1.iterator();
        while (iterator.hasNext()) {
            int batchNo = (Integer)iterator.next();
            CheckDiffThread checkDiff = new CheckDiffThread(batchNo, tableName, agentMap, countDown);
            this.services.execute(checkDiff);
        }
        CheckSourceThread ckSoThread = new CheckSourceThread(countDown, agentMap);
        ckSoThread.start();
    }

    private void runComapreByDiffHost(String compareInfo) throws Exception {
    }

    private static String wrapInfo(List<Integer> server, Map<String, Object> agentMap) {
        agentMap.put("batchNoList", server);
        return JSON.toJSONString(agentMap);
    }

    private static Map<String, List<Integer>> initAssignment() {
        HashMap<String, List<Integer>> assignmentInfo = new HashMap<String, List<Integer>>();
        ArrayList server1List = new ArrayList();
        ArrayList server2List = new ArrayList();
        assignmentInfo.put("server1", server1List);
        assignmentInfo.put("server2", server2List);
        return assignmentInfo;
    }

    private static void assignmentHost(int batchNo, Map<String, List<Integer>> assignmentInfo) {
        List<Integer> server1 = assignmentInfo.get("server1");
        List<Integer> Integer2 = assignmentInfo.get("server2");
        server1.add(batchNo);
    }

    private void initParam(Context ctx, BaseDataSynCheckDiffInfo checkDiffInfo) throws Exception {
        ConnectionInfo targetDB = checkDiffInfo.getDestDB();
        String synHeadID = checkDiffInfo.getSynheadID();
        String checkDiffID = checkDiffInfo.getId().toString();
        String filterSql = checkDiffInfo.getFilterSql();
        this.logBuilder = new StringBuilder();
        this.logInfo = (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
        HashMap<String, String> tabMapSql = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)filterSql)) {
            String[] arrSql;
            for (String tabSql : arrSql = filterSql.split(";")) {
                if ((tabSql = tabSql.replaceAll("\r|\n", "").trim()).length() == 0) continue;
                String[] arrTab = tabSql.split(":");
                String whereSql = arrTab[1].trim();
                if (StringUtils.isEmpty((String)whereSql) || "#sql#".equalsIgnoreCase(whereSql)) {
                    tabMapSql.put(arrTab[0], "");
                    continue;
                }
                tabMapSql.put(arrTab[0], whereSql);
                this.logInfo.setSrcWhere(arrTab[0] + ":" + whereSql + "\r\n");
            }
            if (tabMapSql.containsKey("DBLINK")) {
                this.useDBLink = true;
                this.agentMap.put("DBLink", tabMapSql.get("DBLINK"));
            }
        }
        this.checkTabs = checkDiffInfo.getCheckTabs().split(",");
        this.agentMap.put("tabMapSql", tabMapSql);
        this.commonParam(ctx, targetDB, synHeadID);
        this.agentMap.put("checkDiffID", checkDiffID);
        this.agentMap.put("diffFlag", checkDiffID.hashCode());
    }

    private void commonParam(Context ctx, ConnectionInfo targetDB, String synHeadID) throws Exception {
        this.isLocalhost = true;
        this.srcCn = DbConnector.getConnection((Context)ctx);
        this.agentMap.put("ctx", ctx);
        this.agentMap.put("srcCn", this.srcCn);
        HashMap<String, String> eipTabMap = new HashMap<String, String>();
        HashMap<String, Integer> checkFlagMap = new HashMap<String, Integer>();
        for (String tableName : this.checkTabs) {
            eipTabMap.put(tableName, BaseDataCheckUtil.getEipTable(tableName));
            checkFlagMap.put(tableName, (synHeadID + tableName).hashCode());
        }
        this.agentMap.put("checkFlagMap", checkFlagMap);
        this.agentMap.put("eipTableMap", eipTabMap);
        this.agentMap.put("checkTabs", this.checkTabs);
        this.atomic = new AtomicInteger(this.checkTabs.length);
        this.targetCn = KSQLUtil.getConnection(targetDB);
        this.agentMap.put("dbType", DBType.getEnum((String)this.targetCn.getMetaData().getDatabaseProductName()));
        this.agentMap.put("targetConnInfo", targetDB);
        this.agentMap.put("targetCn", this.targetCn);
        this.agentMap.put("targetDB", targetDB.getNumber());
        this.agentMap.put("targetDBID", targetDB.getId().toString());
        this.agentMap.put("scheme", synHeadID);
        this.agentMap.put("diffFlag", synHeadID.hashCode());
        if (null == this.agentMap.get("colMaps")) {
            HashMap colMaps = new HashMap();
            HashMap<String, String> baseQrySqlMap = new HashMap<String, String>();
            HashMap<String, Integer> colLengths = new HashMap<String, Integer>();
            HashMap<String, String[]> arrColNames = new HashMap<String, String[]>();
            for (String tableName : this.checkTabs) {
                HashMap<String, String> colMap = new HashMap<String, String>();
                StringBuilder baseQrySql = new StringBuilder();
                StringBuilder baseQrySqlDBLink = new StringBuilder();
                if (this.useDBLink) {
                    baseQrySql.append(CheckDiffConstant.DIALECT);
                }
                baseQrySql.append("select ");
                String qrySql = "select fcolname,fcoldatatype from T_EIP_BaseDataSynColumn where  fparentid='" + synHeadID + "' and ftableName='" + tableName.toUpperCase() + "' and fneedupdateSYN = 1";
                RowSet rowSet = SQLUtils.getJdbcRowSet((Connection)this.srcCn, (String)qrySql);
                int i = 0;
                while (rowSet.next()) {
                    colMap.put(rowSet.getString(1), rowSet.getString(2));
                    if (i > 0) {
                        baseQrySql.append(",");
                        baseQrySqlDBLink.append(" or ");
                    }
                    if (this.useDBLink) {
                        baseQrySql.append("src." + rowSet.getString(1) + " " + "src" + "_" + rowSet.getString(1)).append(", dest." + rowSet.getString(1) + " " + "dest" + "_" + rowSet.getString(1));
                        baseQrySqlDBLink.append("src." + rowSet.getString(1) + " != dest." + rowSet.getString(1));
                    } else {
                        baseQrySql.append(rowSet.getString(1));
                    }
                    ++i;
                }
                if (this.useDBLink) {
                    baseQrySql.append(" from ").append(tableName + " " + "src" + " ");
                    baseQrySql.append(" inner join ").append(tableName + "@" + this.agentMap.get("DBLink") + " " + "dest" + " ").append(" on src.fid  = dest.fid and ( ").append((CharSequence)baseQrySqlDBLink).append(" ) ");
                } else {
                    baseQrySql.append(" from ").append(tableName);
                }
                colMaps.put(tableName, colMap);
                baseQrySqlMap.put(tableName, baseQrySql.toString());
                colLengths.put(tableName, colMap.size());
                Object[] arrInfo = colMap.keySet().toArray();
                int size = arrInfo.length;
                String[] arrColName = new String[size];
                for (int j = 0; j < size; ++j) {
                    arrColName[j] = arrInfo[j].toString();
                }
                arrColNames.put(tableName, arrColName);
            }
            this.agentMap.put("colLengths", colLengths);
            this.agentMap.put("arrColNames", arrColNames);
            this.agentMap.put("colMaps", colMaps);
            this.agentMap.put("baseQrySqlMap", baseQrySqlMap);
            this.logBuilder.append("\r\n\u65b9\u6848ID\u4e3a\uff1a" + synHeadID + "\r\n");
            this.logBuilder.append("\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u4e3a\uff1a" + targetDB.getNumber() + "\r\n");
        }
    }

    public static void compareBaseData(Context ctx, BaseDataSynCheckDiffInfo checkDiffInfo) throws Exception {
        BaseDataCheckUtil.currPlanNum.incrementAndGet();
        BaseDataCheckDiff checkDiff = new BaseDataCheckDiff();
        checkDiff.initParam(ctx, checkDiffInfo);
        checkDiff.check();
    }

    private void afterCheck(Map<String, Object> agentMap, boolean isError) {
        if (this.atomic.decrementAndGet() == 0 || isError) {
            String delSql = "delete from t_eip_synCheckDiff where synflag =" + agentMap.get("diffFlag");
            try {
                SQLUtils.execute((Connection)this.srcCn, (String)delSql);
                if (null != agentMap.get("checkDiffID")) {
                    String upSql = "update T_EIP_BaseDataSynCheckDiff set fstatus= " + (isError ? 3 : 2) + " where fid='" + agentMap.get("checkDiffID") + "'";
                    SQLUtils.execute((Connection)this.srcCn, (String)upSql);
                }
            }
            catch (SQLException e) {
                logger.error((Object)("\u5220\u9664\u540c\u6b65\u4fe1\u606f\u51fa\u9519\uff1a" + delSql), (Throwable)e);
            }
            SQLUtils.cleanup((Connection)this.srcCn);
            SQLUtils.cleanup((Connection)this.targetCn);
            if (null != this.services) {
                this.services.shutdown();
            }
            HashMap<String, String> warnMsg = new HashMap<String, String>();
            warnMsg.put("\u6570\u636e\u6bd4\u5bf9\u5185\u5bb9", this.logBuilder.toString());
            String jsonStr = JSON.toJSONString(warnMsg);
            this.logInfo.getExtendedProperties().put("warnMsg", jsonStr);
            this.logInfo.setChangeCount(1);
            MonitorManager.resetThreadMointer(this.logInfo);
            MonitorManager.exit((Context)agentMap.get("ctx"));
            BaseDataCheckUtil.currPlanNum.decrementAndGet();
            logger.info((Object)"\u76f8\u5173\u8d44\u6e90\u5df2\u5173\u95ed");
        }
    }

    static {
        delHistoryData = false;
        isClearIncTab = false;
        isClearHisCompareData = true;
        srcCompareBySql = true;
    }

    class CheckSourceThread
    extends Thread {
        CountDownLatch latch;
        Map<String, Object> agentMap;

        public CheckSourceThread(CountDownLatch latch, Map<String, Object> agentMap) {
            this.latch = latch;
            this.agentMap = agentMap;
        }

        @Override
        public void run() {
            logger.info((Object)"\u5df2\u542f\u7528\u5f02\u6b65\u7ebf\u7a0b\u68c0\u6d4b");
            try {
                this.latch.await();
                BaseDataCheckDiff.this.afterCheck(this.agentMap, false);
            }
            catch (Exception e) {
                logger.error((Object)"CheckSourceThread-InterruptedException:", (Throwable)e);
                BaseDataCheckDiff.this.afterCheck(this.agentMap, true);
            }
        }
    }

    class CheckDiffThread
    implements Runnable {
        private int batchNo;
        private Map<String, Object> agentMap;
        private CountDownLatch latch;
        private String tableName;

        public CheckDiffThread(int batchNo, String tableName, Map<String, Object> agentMap, CountDownLatch latch) {
            this.batchNo = batchNo;
            this.tableName = tableName;
            this.agentMap = agentMap;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<String, Object> diffMap = new HashMap<String, Object>();
            RowSet rowSet = null;
            StringBuilder srcBuilder = new StringBuilder();
            StringBuilder targetbuilder = new StringBuilder();
            Set<String> srcMissSet = new HashSet<String>();
            HashSet<String> destMissSet = new HashSet<String>();
            boolean isDestMiss = false;
            try {
                this.updateStatus(this.agentMap, this.batchNo, CheckDiffStatusEnum.RUNNING.getVal(), "RUNNING", this.tableName);
                HashMap srcMap = new HashMap();
                String baseQrySql = (String)((Map)this.agentMap.get("baseQrySqlMap")).get(this.tableName);
                int diffFlag = (Integer)((Map)this.agentMap.get("checkFlagMap")).get(this.tableName);
                String qryHeadSql = "select headpk from T_EIP_INSERC where batchNo =" + this.batchNo + " and targetDb =" + diffFlag;
                srcBuilder.append(baseQrySql).append(" where " + (Boolean.TRUE.equals(BaseDataCheckDiff.this.useDBLink) ? "src.fid" : "fid") + " in (");
                srcBuilder.append(qryHeadSql).append(")");
                rowSet = SQLUtils.getJdbcRowSet((Connection)BaseDataCheckDiff.this.srcCn, (String)srcBuilder.toString());
                Map tabColMap = (Map)((Map)this.agentMap.get("colMaps")).get(this.tableName);
                int colLength = (Integer)((Map)this.agentMap.get("colLengths")).get(this.tableName);
                String[] arrColName = (String[])((Map)this.agentMap.get("arrColNames")).get(this.tableName);
                if (BaseDataCheckDiff.this.useDBLink) {
                    while (rowSet.next()) {
                        String fid = rowSet.getString("src_fid");
                        String diffInfo = this.compare(rowSet, null, tabColMap, true);
                        diffMap.put(fid, diffInfo);
                    }
                    String preSql = CheckDiffConstant.DIALECT + "select headpk from (select headpk,tab.fid  Cfid from  T_EIP_INSERC left join ";
                    String aftSql = " tab on headpk = tab.fid  where batchNo =" + this.batchNo + " and targetDb =" + diffFlag + ") m where m.Cfid is null";
                    StringBuilder checkBuilder = new StringBuilder();
                    String srcCheckExist = checkBuilder.append(preSql).append(this.tableName).append(aftSql).toString();
                    rowSet = SQLUtils.getJdbcRowSet((Connection)BaseDataCheckDiff.this.srcCn, (String)srcCheckExist);
                    while (rowSet.next()) {
                        srcMissSet.add(rowSet.getString(1));
                    }
                    checkBuilder.setLength(0);
                    String destCheckExist = checkBuilder.append(preSql).append(this.tableName + "@" + this.agentMap.get("DBLink")).append(aftSql).toString();
                    rowSet = SQLUtils.getJdbcRowSet((Connection)BaseDataCheckDiff.this.srcCn, (String)destCheckExist);
                    while (rowSet.next()) {
                        destMissSet.add(rowSet.getString(1));
                    }
                } else {
                    List listInfo;
                    List listInfo2;
                    targetbuilder.append(baseQrySql).append(" where fid in (");
                    int j = 0;
                    RowSet increRowSet = SQLUtils.getJdbcRowSet((Connection)BaseDataCheckDiff.this.srcCn, (String)qryHeadSql);
                    while (increRowSet.next()) {
                        String headpk = increRowSet.getString(1);
                        destMissSet.add(headpk);
                        if (j > 0) {
                            targetbuilder.append(",");
                        }
                        ++j;
                        targetbuilder.append("'").append(headpk).append("'");
                    }
                    targetbuilder.append(")");
                    while (rowSet.next()) {
                        String fid = rowSet.getString("fid");
                        HashMap<String, Object> rowValMap = new HashMap<String, Object>();
                        for (int i = 0; i < colLength; ++i) {
                            rowValMap.put(arrColName[i], rowSet.getObject(arrColName[i]));
                        }
                        srcMap.put(DBType.MYSQL == this.agentMap.get("dbType") ? fid.toLowerCase() : fid, rowValMap);
                    }
                    rowSet.last();
                    int tabSize = rowSet.getRow();
                    if (tabSize != pageSize && ((Integer)(listInfo2 = (List)this.agentMap.get(String.valueOf(diffFlag))).get(0) != this.batchNo || (Integer)listInfo2.get(0) == this.batchNo && tabSize != (Integer)listInfo2.get(1))) {
                        srcMissSet = this.doDiffOnSrc(this.tableName, qryHeadSql, destMissSet);
                    }
                    HashSet<String> lowerSet = new HashSet<String>();
                    RowSet tarRowSet = SQLUtils.getJdbcRowSet((Connection)BaseDataCheckDiff.this.targetCn, (String)targetbuilder.toString());
                    while (tarRowSet.next()) {
                        String headpk = DBType.MYSQL == this.agentMap.get("dbType") ? tarRowSet.getString("fid").toLowerCase() : tarRowSet.getString("fid");
                        String diffInfo = this.compare(tarRowSet, (Map)srcMap.get(headpk), tabColMap, false);
                        if (diffInfo.length() > 2) {
                            diffMap.put(tarRowSet.getString("fid"), diffInfo);
                        }
                        if (destMissSet.remove(tarRowSet.getString("fid"))) continue;
                        lowerSet.add(headpk);
                    }
                    if (!lowerSet.isEmpty() && DBType.MYSQL == this.agentMap.get("dbType")) {
                        logger.info((Object)("\u5b58\u5728\u76ee\u6807\u7cfb\u7edf\u6570\u636e\u5e93fid\u5c0f\u5199\u7684\u95ee\u9898lowerSet" + ((Object)lowerSet).toString()));
                        HashSet<String> diffSet = new HashSet<String>();
                        for (String headpkLower : lowerSet) {
                            for (String headpk : destMissSet) {
                                if (!headpk.equalsIgnoreCase(headpkLower)) continue;
                                diffSet.add(headpk);
                            }
                        }
                        destMissSet.removeAll(diffSet);
                    }
                    tarRowSet.last();
                    int targetSize = tarRowSet.getRow();
                    if (targetSize != pageSize && ((Integer)(listInfo = (List)this.agentMap.get(String.valueOf(diffFlag))).get(0) != this.batchNo || targetSize != (Integer)listInfo.get(1))) {
                        isDestMiss = true;
                    }
                }
                HashMap<String, HashSet<String>> missInfo = null;
                if (isDestMiss || null != srcMissSet) {
                    missInfo = new HashMap<String, HashSet<String>>();
                    missInfo.put("srcMiss", (HashSet<String>)srcMissSet);
                    missInfo.put("destMiss", destMissSet);
                }
                srcMap.clear();
                this.insertCompareInfo(diffMap, this.agentMap, this.tableName, missInfo);
                this.updateStatus(this.agentMap, this.batchNo, CheckDiffStatusEnum.SUCC.getVal(), "SUCCESS", this.tableName);
                SQLUtils.cleanup((ResultSet)rowSet);
                diffMap = null;
                this.latch.countDown();
            }
            catch (Exception e) {
                this.updateStatus(this.agentMap, this.batchNo, CheckDiffStatusEnum.ERROR.getVal(), e.toString(), this.tableName);
                logger.error((Object)("targetbuilder:" + targetbuilder.toString()), (Throwable)e);
                BaseDataCheckDiff.this.logInfo.setStatus("\u5f02\u5e38");
                BaseDataCheckDiff.this.logInfo.setStackTrace(ThreadUtil.logCallStatck(e));
                BaseDataCheckDiff.this.logBuilder.append("\u7ebf\u7a0b\u6c60\u5185\u6267\u884c\u62a5\u9519\uff0c\u62a5\u9519\u6279\u6b21\u4e3a\uff1a" + this.batchNo);
            }
            finally {
                SQLUtils.cleanup(rowSet);
                diffMap = null;
                this.latch.countDown();
            }
        }

        private Set doDiffOnSrc(String tableName, String qryHeadSql, Set<String> increSet) throws SQLException {
            String tableSql = "";
            tableSql = srcCompareBySql ? "select headpk from (select headpk ,tab.fid tabFid from T_EIP_INSERC left join " + tableName + " tab  on headpk  = tab.fid where headpk in ( " + qryHeadSql + " ) ) m where m.tabFid is null " : "select fid from  " + tableName + " where fid in ( " + qryHeadSql + " )";
            RowSet srcRowSet = SQLUtils.getJdbcRowSet((Connection)BaseDataCheckDiff.this.srcCn, (String)tableSql);
            HashSet<String> srcSet = new HashSet<String>();
            while (srcRowSet.next()) {
                srcSet.add(srcRowSet.getString(1));
            }
            if (srcCompareBySql) {
                return srcSet;
            }
            Set tempSet = this.copySet(increSet);
            tempSet.removeAll(srcSet);
            return tempSet;
        }

        private Set copySet(Set<String> increSet) {
            HashSet<String> TempSet = new HashSet<String>();
            for (String headpk : increSet) {
                TempSet.add(headpk);
            }
            return TempSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateStatus(Map agentMap, int batchNo, int status, String msg, String tableName) {
            String sql = "update  T_EIP_CKDIFFBATCHLOG set STATUS = ? ,MSG = ?,ENDTIME=sysdate  where checkTable =? and batchNo = ? ";
            PreparedStatement statement = null;
            try {
                statement = BaseDataCheckDiff.this.srcCn.prepareStatement(sql);
                statement.setInt(1, status);
                statement.setString(2, msg);
                statement.setString(3, tableName);
                statement.setInt(4, batchNo);
                statement.executeUpdate();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"\u5f53\u524d\u66f4\u65b0\u8868T_EIP_CKDIFFBATCHLOG\u72b6\u6001\u5931\u8d25", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(statement);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)statement);
            }
            SQLUtils.cleanup((Statement)statement);
        }

        private void insertCompareInfo(Map diffMap, Map agentMap, String tableName, Map missInfo) throws BOSException {
            if (diffMap.size() == 0 && missInfo == null) {
                logger.error((Object)"\u5f53\u524d\u672a\u68c0\u6d4b\u5230\u5dee\u5f02\u6570\u636e");
                return;
            }
            IBaseDataSynCompare synCompare = BaseDataSynCompareFactory.getLocalInstance((Context)agentMap.get("ctx"));
            try {
                for (String headpk : diffMap.keySet()) {
                    BaseDataSynCompareInfo item = new BaseDataSynCompareInfo();
                    item.setCheckTable(tableName);
                    item.setHeadpk(headpk);
                    item.setTargetDB((String)agentMap.get("targetDBID"));
                    item.setSynheadID((String)agentMap.get("scheme"));
                    item.setCompareInfo((String)diffMap.get(headpk));
                    item.setCreateTime(new Date());
                    synCompare.addnew(item);
                }
                if (null != missInfo) {
                    HashMap<String, Integer> missMap = new HashMap<String, Integer>();
                    if (null != missInfo.get("srcMiss")) {
                        Set srcMiss = (Set)missInfo.get("srcMiss");
                        for (String headpk : srcMiss) {
                            missMap.put(headpk, 1);
                        }
                    }
                    Set missSetTmp = missMap.keySet();
                    Set descMiss = (Set)missInfo.get("destMiss");
                    for (String headpk : descMiss) {
                        if (missSetTmp.contains(headpk)) {
                            missMap.put(headpk, 3);
                            continue;
                        }
                        missMap.put(headpk, 2);
                    }
                    Set missSet = missMap.keySet();
                    for (String headpk : missSet) {
                        BaseDataSynCompareInfo item = new BaseDataSynCompareInfo();
                        item.setCheckTable(tableName);
                        item.setHeadpk(headpk);
                        item.setTargetDB((String)agentMap.get("targetDBID"));
                        item.setSynheadID((String)agentMap.get("scheme"));
                        item.setCreateTime(new Date());
                        int status = (Integer)missMap.get(headpk);
                        if (1 == status) {
                            item.setExistInfo("\u5f53\u524d\u7cfb\u7edf\u7f3a\u5931");
                        } else if (2 == status) {
                            item.setExistInfo("\u76ee\u6807\u7cfb\u7edf\u7f3a\u5931");
                        } else {
                            item.setExistInfo("\u5f53\u524d/\u76ee\u6807\u7cfb\u7edf\u7f3a\u5931");
                        }
                        synCompare.addnew(item);
                    }
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }

        private String compare(RowSet target, Map src, Map colMap, boolean useDBLink) {
            if (src == null && !useDBLink) {
                try {
                    logger.error((Object)("\u672a\u627e\u5230\u6570\u636e\u7684fid\u4e3a\uff1a" + target.getString("fid")));
                }
                catch (SQLException e) {
                    logger.error((Object)"SQLException", (Throwable)e);
                }
                return "{}";
            }
            HashMap<String, String> diffInfo = new HashMap<String, String>();
            Set colSet = colMap.keySet();
            for (String colName : colSet) {
                String colDataType = (String)colMap.get(colName);
                try {
                    Boolean isEqual = BaseDataCheckUtil.compare(target, src, colName, SQLType.getEnum(colDataType), useDBLink);
                    if (!Boolean.FALSE.equals(isEqual)) continue;
                    if (useDBLink) {
                        diffInfo.put(colName, target.getObject("dest_" + colName) + "||" + target.getObject("src_" + colName));
                        continue;
                    }
                    diffInfo.put(colName, target.getObject(colName) + "||" + src.get(colName));
                }
                catch (Exception e) {
                    diffInfo.put("error", e.toString());
                    try {
                        logger.error((Object)("fid:" + (src == null ? target.getObject("src_" + colName) : target.getObject("fid"))));
                    }
                    catch (SQLException e1) {
                        logger.error((Object)"rowSet \u83b7\u53d6\u5bf9\u8c61\u5f02\u5e38");
                    }
                    logger.error((Object)("colName:" + colName + " colDataType:" + colDataType + " value:" + (src == null ? "" : src.get(colName) + src.get("fid").toString())), (Throwable)e);
                    break;
                }
            }
            return JSON.toJSONString(diffInfo);
        }
    }
}

