/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.basedata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.backport.concurrent.atomic.AtomicInteger;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.SQLType;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynCheckDiffFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynCheckDiffInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.BaseDataCheckDiff;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.log4j.Logger;

public class BaseDataCheckUtil {
    public static Queue<CheckDiffTask> blockQueue = new ArrayBlockingQueue<CheckDiffTask>(30);
    public static AtomicInteger currPlanNum = new AtomicInteger(0);
    public static Logger logger = Logger.getLogger(BaseDataCheckUtil.class);

    public static Boolean compare(ResultSet rowSet, Map src, String colName, SQLType sqlType, boolean useDBLink) throws SQLException {
        String compareValStr;
        String varStr;
        block23: {
            String colNameC = "";
            String colNameT = "";
            if (useDBLink) {
                colNameC = "dest_" + colName;
                colNameT = "src_" + colName;
            } else {
                colNameT = colName;
            }
            if (BaseDataCheckUtil.isBlank(rowSet.getObject(colNameT))) {
                return src != null && BaseDataCheckUtil.isBlank(src.get(colNameT)) || useDBLink && BaseDataCheckUtil.isBlank(rowSet.getObject(colNameC));
            }
            varStr = "";
            if (!useDBLink) {
                varStr = String.valueOf(src.get(colNameT));
            }
            compareValStr = "";
            try {
                if (SQLType.INT.equals(sqlType) || SQLType.PG_INTEGER.equals(sqlType)) {
                    int targetVal = rowSet.getInt(colNameT);
                    if (useDBLink) {
                        return targetVal == rowSet.getInt(colNameC);
                    }
                    return targetVal == Integer.parseInt(src.get(colNameT).toString());
                }
                if (SQLType.NUMBER.equals(sqlType) || SQLType.DECIMAL.equals(sqlType) || SQLType.NUMERIC.equals(sqlType)) {
                    if (useDBLink) {
                        return 0 == rowSet.getBigDecimal(colNameT).compareTo(rowSet.getBigDecimal(colNameC));
                    }
                    compareValStr = rowSet.getBigDecimal(colNameT).toString();
                    break block23;
                }
                if (SQLType.BIGINT.equals(sqlType)) {
                    long targetVal = rowSet.getLong(colNameT);
                    if (useDBLink) {
                        return targetVal == rowSet.getLong(colNameC);
                    }
                    return targetVal == Long.parseLong(String.valueOf(src.get(colNameT)));
                }
                if (SQLType.DOUBLE.equals(sqlType)) {
                    compareValStr = BigDecimal.valueOf(rowSet.getDouble(colNameT)).toString();
                    if (useDBLink) {
                        return compareValStr.equals(BigDecimal.valueOf(rowSet.getDouble(colNameC)).toString());
                    }
                    break block23;
                }
                if (SQLType.CHAR.equals(sqlType) || SQLType.VARCHAR.equals(sqlType) || SQLType.VARCHAR2.equals(sqlType) || SQLType.NCHAR.equals(sqlType) || SQLType.NVARCHAR.equals(sqlType) || SQLType.NVARCHAR2.equals(sqlType) || SQLType.PG_CHARACTER.equals(sqlType) || SQLType.CLOB.equals(sqlType) || SQLType.NCLOB.equals(sqlType) || SQLType.PG_TEXT.equals(sqlType)) {
                    compareValStr = rowSet.getString(colNameT);
                    if (useDBLink) {
                        return compareValStr.equals(rowSet.getString(colNameC));
                    }
                    break block23;
                }
                if (SQLType.DATETIME.equals(sqlType) || SQLType.TIMESTAMP.equals(sqlType) || SQLType.PG_TIMESTAMP.equals(sqlType)) {
                    compareValStr = rowSet.getTimestamp(colNameT).toString();
                    if (useDBLink) {
                        return compareValStr.equals(rowSet.getTimestamp(colNameC).toString());
                    }
                    break block23;
                }
                if (SQLType.BINARY.equals(sqlType) || SQLType.VARBINARY.equals(sqlType)) {
                    compareValStr = Arrays.toString((byte[])rowSet.getBytes(colNameT));
                    if (useDBLink) {
                        return compareValStr.equals(Arrays.toString((byte[])rowSet.getBytes(colNameC)));
                    }
                    break block23;
                }
                if (SQLType.BLOB.equals(sqlType) || SQLType.IMAGE.equals(sqlType)) {
                    ByteArrayOutputStream byteOut = BaseDataCheckUtil.conversion(rowSet, colNameT);
                    compareValStr = null != byteOut ? Arrays.toString((byte[])byteOut.toByteArray()) : "";
                    ByteArrayOutputStream compareByteOut = BaseDataCheckUtil.conversion(rowSet, colNameC);
                    if (useDBLink) {
                        return compareValStr.equals(null != compareByteOut ? Arrays.toString((byte[])compareByteOut.toByteArray()) : "");
                    }
                    break block23;
                }
                String targetVal = rowSet.getObject(colNameT).toString();
                if (useDBLink) {
                    return targetVal.equals(rowSet.getObject(colNameC).toString());
                }
                Object srcVal = src.get(colNameT);
                return targetVal == srcVal;
            }
            catch (NullPointerException e) {
                return true;
            }
        }
        return compareValStr.equalsIgnoreCase(varStr);
    }

    /*
     * Exception decompiling
     */
    private static ByteArrayOutputStream conversion(ResultSet rowSet, String colName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void baseDataCompare(Context ctx, String jsonInfo) throws Exception {
        JSONObject agentMap = JSON.parseObject((String)jsonInfo);
        BaseDataCheckDiff checkDiff = new BaseDataCheckDiff();
        checkDiff.beforCheck(ctx, (String)agentMap.get("checkTable"), (String)agentMap.get("targetDB"), (String)agentMap.get("schema"));
        checkDiff.check();
    }

    public static boolean isBlank(Object c) {
        return null == c || StringUtils.isEmpty((String)c.toString());
    }

    public static String getEipTable(String srcTable) {
        int postion = srcTable.lastIndexOf("_");
        return "T_EIP_Z_" + srcTable.substring(postion + 1, srcTable.length());
    }

    public static String compareBaseData(Context ctx, String actionInfo, IObjectValue checkDiffInfo) {
        CheckDiffTask task;
        BaseDataCheckUtil baseDataCheckUtil = BaseDataCheckUtil.getInstance();
        baseDataCheckUtil.getClass();
        CheckDiffTask checkTask = baseDataCheckUtil.new CheckDiffTask(ctx, actionInfo, checkDiffInfo);
        if (!blockQueue.offer(checkTask)) {
            logger.error((Object)("\u5f53\u524d\u961f\u5217\u5df2\u6ee1\uff0c\u8bf7\u77e5\u6089" + checkDiffInfo.toString()));
            return "overSize";
        }
        int i = currPlanNum.get();
        int j = 0;
        if (i < 0) {
            currPlanNum.set(j);
        }
        while (i < 5 && j < 3 && null != (task = blockQueue.poll())) {
            BaseDataCheckUtil baseDataCheckUtil2 = BaseDataCheckUtil.getInstance();
            baseDataCheckUtil2.getClass();
            Thread checkThread = new Thread(baseDataCheckUtil2.new CheckDiffThread(task));
            checkThread.start();
            ++j;
        }
        return "OK";
    }

    public static BaseDataCheckUtil getInstance() {
        return SingltonEnum.INSTACE.getInstance();
    }

    private static enum SingltonEnum {
        INSTACE;

        private BaseDataCheckUtil checkUtil = new BaseDataCheckUtil();

        public BaseDataCheckUtil getInstance() {
            return this.checkUtil;
        }
    }

    private class CheckDiffThread
    implements Runnable {
        Context ctx;
        String actionType;
        IObjectValue compareInfo;

        public CheckDiffThread(CheckDiffTask task) {
            this.ctx = task.getCtx();
            this.actionType = task.getActionInfo();
            this.compareInfo = task.getCheckDiff();
        }

        @Override
        public void run() {
            BaseDataSynCheckDiffInfo checkDiffInfo = (BaseDataSynCheckDiffInfo)this.compareInfo;
            try {
                MonitorManager.enterBaseDataSynCompare(this.ctx, this.actionType, checkDiffInfo.getSynheadID());
                if (checkDiffInfo.getStatus() == 1) {
                    MonitorManager.getCurrent().setContent("\u5f53\u524d\u65b9\u6848\u6b63\u5728\u6267\u884c  \u5c06\u8df3\u8fc7\u672c\u6b21\u8c03\u5ea6\u5b9a\u65f6\u6267\u884c");
                } else {
                    checkDiffInfo.setStatus(1);
                    BaseDataSynCheckDiffFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)checkDiffInfo);
                    BaseDataCheckDiff.compareBaseData(this.ctx, checkDiffInfo);
                }
            }
            catch (Exception e) {
                currPlanNum.decrementAndGet();
                logger.error((Object)e);
            }
            finally {
                logger.info((Object)("\u5df2\u8fdb\u5165\u7ebf\u7a0b\u6c60\u8fdb\u884c\u6570\u636e\u6bd4\u5bf9\uff01" + checkDiffInfo.getId().toString()));
            }
        }
    }

    class CheckDiffTask {
        Context ctx;
        String actionInfo;
        IObjectValue checkDiff;

        public CheckDiffTask(Context ctx, String actionInfo, IObjectValue checkDiffInfo) {
            this.ctx = ctx;
            this.actionInfo = actionInfo;
            this.checkDiff = checkDiffInfo;
        }

        public Context getCtx() {
            return this.ctx;
        }

        public String getActionInfo() {
            return this.actionInfo;
        }

        public IObjectValue getCheckDiff() {
            return this.checkDiff;
        }
    }
}

