/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.basedata.group;

import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.InvocationProxy;
import com.kingdee.eas.csinterface.schedule.app.service.basedata.invocation.BaseDataInvocation;
import com.kingdee.eas.csinterface.syncdatabase.BDRMappingGroupEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.BDRMappingGroupInfo;
import com.kingdee.eas.csinterface.syncdatabase.BDRMappingInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class GroupBaseDataRunner {
    protected BDRMappingGroupInfo bdrMappingGroup;
    protected Context ctx;
    protected Stack baseDataInvocation = new Stack();
    protected ScheduleInfo scheduleInfo = null;

    public GroupBaseDataRunner(Context ctx, BDRMappingGroupInfo bdrMappingGroup, ScheduleInfo scheduleInfo) {
        this.ctx = ctx;
        this.bdrMappingGroup = bdrMappingGroup;
        this.scheduleInfo = scheduleInfo;
    }

    public void start() throws Exception {
        BDRMappingGroupEntryInfo mainPlan = this.getMainPlan();
        if (mainPlan == null) {
            return;
        }
        this.execEachPlan(mainPlan);
    }

    private void execEachPlan(BDRMappingGroupEntryInfo plan) throws Exception {
        BaseDataInvocation invocation = InvocationProxy.getBaseDataInvocation(this.ctx, null, plan, true, this.scheduleInfo, false);
        invocation.invoke();
        this.baseDataInvocation.push(invocation);
        BDRMappingInfo bdr = (BDRMappingInfo)invocation.getBaseDataContext().getBdrMapping();
        List<BDRMappingGroupEntryInfo> list = this.findPlansByPlanNumber(bdr.getNumber());
        for (BDRMappingGroupEntryInfo bdrg : list) {
            this.execEachPlan(bdrg);
        }
        this.baseDataInvocation.pop();
    }

    private List<BDRMappingGroupEntryInfo> findPlansByPlanNumber(String plan) {
        ArrayList<BDRMappingGroupEntryInfo> result = new ArrayList<BDRMappingGroupEntryInfo>();
        for (int i = 0; i < this.bdrMappingGroup.getEntrys().size(); ++i) {
            BDRMappingGroupEntryInfo info = this.bdrMappingGroup.getEntrys().get(i);
            if (info.getRelatePlan() == null || !info.getRelatePlan().equalsIgnoreCase(plan)) continue;
            result.add(info);
        }
        return result;
    }

    private BDRMappingGroupEntryInfo getMainPlan() {
        for (int i = 0; i < this.bdrMappingGroup.getEntrys().size(); ++i) {
            BDRMappingGroupEntryInfo info = this.bdrMappingGroup.getEntrys().get(i);
            if (!info.isIsMain()) continue;
            return info;
        }
        return null;
    }
}

