/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryInfo;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.monitor.FeedBackStatus;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.FeedBackManager;
import com.kingdee.eas.csinterface.monitor.app.MidBillToDestMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.AbstractTransferHelper;
import com.kingdee.eas.csinterface.schedule.util.DestBillBatchUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractDestBillTransferObject
extends AbstractTransferHelper {
    private static Logger logger = Logger.getLogger(AbstractDestBillTransferObject.class);
    protected Context ctx;
    protected Set<String> headpkSet;
    protected BOTMappingInfo botMapping;
    protected BillMappingInfo billMappingInfo;
    protected String scheduId;
    protected Integer assignNumber;

    public AbstractDestBillTransferObject(Context ctx, String scheduId, Set<String> headpkSet, BOTMappingInfo botMapping, BillMappingInfo billMappingInfo, Integer assignNumber) {
        this.ctx = ctx;
        this.headpkSet = headpkSet;
        this.botMapping = botMapping;
        this.billMappingInfo = billMappingInfo;
        this.scheduId = scheduId;
        this.assignNumber = assignNumber;
    }

    public void invokeTransfer() throws Exception {
        try {
            this.beforeTransfer();
            this.transfer();
        }
        catch (Exception e) {
            MonitorManager.error(e);
            throw e;
        }
        finally {
            this.afterTransfer();
            FeedBackManager.asynFeedBackByMidIds(this.ctx, this.headpkSet);
            MonitorManager.exit(this.ctx);
        }
    }

    public void beforeTransfer() {
        this.headpkSet = DestBillBatchUtil.getBillByAssignNumber(this.ctx, this.assignNumber, this.billMappingInfo.getId().toString());
        if (MonitorManager.getCurrentMidBillToDest() == null) {
            if (this.scheduId != null && !StringUtils.isEmpty((String)this.scheduId)) {
                MonitorManager.enterMidBillToDest(this.ctx, "\u8c03\u5ea6\u7b56\u7565", this.billMappingInfo.getNumber(), this.scheduId);
            } else {
                MonitorManager.enterMidBillToDest(this.ctx, "EAS\u5ba2\u6237\u7aef", this.billMappingInfo.getNumber(), null);
            }
            MonitorManager.getCurrentMidBillToDest().setBillMappingInfo(this.billMappingInfo);
            MonitorManager.getCurrentMidBillToDest().setBotMappingInfo(this.botMapping);
            MonitorManager.getCurrentMidBillToDest().setTransformType(this.botMapping.getDefineSys().getName());
            MonitorManager.getCurrentMidBillToDest().addBillCount(this.headpkSet == null ? 0 : this.headpkSet.size());
            MonitorManager.getCurrentMidBillToDest().setDealingBillHeadpks(new ArrayList<String>(this.headpkSet));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTransfer() {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = DBUtils.getConnection(this.ctx);
            preparedStatement = connection.prepareStatement("delete from T_EIP_AssigNumberBills where fassignmentNumber = ? and fbillMappingId =?");
            preparedStatement.setObject(1, this.assignNumber);
            preparedStatement.setObject(2, this.billMappingInfo.getId().toString());
            preparedStatement.executeQuery();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u5220\u9664\u4efb\u52a1\u5355\u636e\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + this.billMappingInfo.getId().toString() + "\u4f5c\u4e1a\u53f7:" + this.assignNumber), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(preparedStatement, connection);
                throw throwable;
            }
            SQLUtil.cleanup(preparedStatement, connection);
        }
        SQLUtil.cleanup(preparedStatement, connection);
    }

    public abstract void transfer() throws Exception;

    public Integer fillAssigNumber(CoreBillBaseCollection sourceBills) {
        Integer maxNumber = DestBillBatchUtil.getMaxAssNumberByBillMapiing(this.ctx, this.billMappingInfo);
        this.fillAssigNumber(sourceBills, maxNumber);
        return maxNumber;
    }

    public void fillAssigNumber(CoreBillBaseCollection sourceBills, Integer assignNumber) {
        ArrayList<String[]> entryIds = new ArrayList<String[]>(sourceBills.size() * 10);
        for (int i = 0; i < sourceBills.size(); ++i) {
            DynamicBillTemplateInfo info = (DynamicBillTemplateInfo)sourceBills.get(i);
            DynamicBillTemplateEntryCollection entrys = info.getEntrys();
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicBillTemplateEntryInfo entry = entrys.get(j);
                entry.setAssignmentNumber(assignNumber.toString());
                entryIds.add(new String[]{entry.getId().toString()});
            }
        }
        try {
            String updateSql = "update " + this.billMappingInfo.getMidBillEntryTable() + " set fassignmentNumber=" + assignNumber.toString() + " where fid=?";
            DbUtil.executeBatch((Context)this.ctx, (String)updateSql, entryIds);
        }
        catch (Exception e) {
            logger.error((Object)"\u3010\u96c6\u6210\u5e73\u53f0\u3011\u751f\u6210\u76ee\u6807\u5355\u636e\u586b\u5145\u4f5c\u4e1a\u53f7\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public EntityViewInfo getBaseEntityViewInfo(Set<String> headpkSet) {
        return null;
    }

    @Override
    public String initQueryString(String groupBySql, BillMappingInfo billMappingInfo, Set<String> headpkSet) {
        return null;
    }

    protected void recordSucNumber(Integer assignNumber) {
        if (MonitorManager.getCurrentMidBillToDest() != null) {
            List<Integer> sucNumber = MonitorManager.getCurrentMidBillToDest().getSuccessAssignNumber();
            if (sucNumber == null) {
                sucNumber = new ArrayList<Integer>();
                sucNumber.add(assignNumber);
                MonitorManager.getCurrentMidBillToDest().setSuccessAssignNumber(sucNumber);
            } else {
                sucNumber.add(assignNumber);
            }
        }
    }

    protected void recordIDErrorInfoMap(Set<String> ids, String msg, boolean b) throws BOSException {
        MidBillToDestMonitorLogInfo info = MonitorManager.getCurrentMidBillToDest();
        if (info != null) {
            if (b) {
                FeedBackManager.updateFeedBackLogByMidID(this.ctx, ids, msg, FeedBackStatus.EXPORT_VOUCHER_SUCCESSED);
            } else {
                FeedBackManager.updateFeedBackLogByMidID(this.ctx, ids, msg, FeedBackStatus.EXPORT_VOUCHER_FAILED_NDM);
                info.setStatus("\u5931\u8d25");
                CoreBaseCollection colls = new CoreBaseCollection();
                for (String str : ids) {
                    SubMonitorLogInfo logInfo = new SubMonitorLogInfo();
                    String monitorLogId = info.getId().toString();
                    logInfo.setFailure(msg);
                    logInfo.setMonitorLogId(monitorLogId);
                    logInfo.setPlanNumber(str);
                    colls.add((CoreBaseInfo)logInfo);
                }
                try {
                    SubMonitorLogFactory.getLocalInstance(this.ctx).addnewBatchData(colls);
                }
                catch (Exception e) {
                    logger.error((Object)("AbstractDestBillTransferObject.recordIDErrorInfoMap\u5f02\u5e38\uff1a" + e));
                }
            }
        }
    }
}

