/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.DynamicBillTemplateCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryInfo;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.app.service.util.BOTPUtil;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DAPUtil {
    public static int pageSize = 1000;
    private static Logger logger = Logger.getLogger((String)DAPUtil.class.getName());
    public static final String CASHFLOW_FVOUCHERID = "FVoucherID";
    public static final String CASHFLOW_DVOUCHERID = "DVoucherID";
    public static final String CASHFLOW_FENTRYID = "FEntryID";
    public static final String CASHFLOW_DENTRYID = "DEntryID";
    public static final String CASHFLOW_FNUMBER = "FNumber";
    public static final String CASHFLOW_FSUBNUMBER = "FSubNumber";
    public static final String CASHFLOW_FCURRENCY = "FCurrency";
    public static final String CASHFLOW_DCURRENCY = "DCurrency";
    public static final String CASHFLOW_BCURRENCY = "BCurrency";
    public static final String CASHFLOW_FRATIO = "FRatio";
    public static final String CASHFLOW_DRATIO = "DRatio";
    public static final String CASHFLOW_NATURE = "Nature";
    public static final String CASHFLOW_FASSIGID = "FAssigID";
    public static final String CASHFLOW_FCUSTOMER = "Customer";
    public static final String CASHFLOW_FSUPPLIER = "Supplier";
    public static final String CASHFLOW_FAccount = "FAccount";
    public static final String CASHFLOW_FCurrencyType = "FCurrencyType";
    public static final String CASHFLOW_FDC = "FDC";

    public static DAPTransformResult dap(Context ctx, String midTable, CoreBillBaseCollection bills, BOTMappingInfo botMapping) throws BOSException, EASBizException {
        HashMap<String, String> duplEntryMap = new HashMap<String, String>();
        DAPTransformResult result = DAPUtil.dealVouchers(ctx, bills, botMapping, duplEntryMap, null);
        if (MonitorManager.getCurrentMidBillToDest() != null) {
            MonitorManager.getCurrentMidBillToDest().setTransformResult(result);
        }
        return result;
    }

    public static DAPTransformResult dapWithCashFlow(Context ctx, String midTable, CoreBillBaseCollection bills, BOTMappingInfo botMapping, String cashflowRelation) throws BOSException, EASBizException {
        HashMap<String, String> duplEntryMap = new HashMap<String, String>();
        HashSet<String> hkSet = new HashSet<String>();
        CoreBillBaseCollection bills2 = (CoreBillBaseCollection)bills.clone();
        DAPTransformResult result = DAPUtil.dealVouchers(ctx, bills, botMapping, duplEntryMap, hkSet);
        DAPUtil.dealCashFlow(ctx, bills2, result, cashflowRelation, duplEntryMap, hkSet);
        if (MonitorManager.getCurrentMidBillToDest() != null) {
            MonitorManager.getCurrentMidBillToDest().setTransformResult(result);
        }
        return result;
    }

    public static DAPTransformResult dapWithEASCashFlow(Context ctx, String midTable, CoreBillBaseCollection bills, BOTMappingInfo botMapping, String easCashflowRelation, String assistAccountRelation) throws BOSException, EASBizException {
        HashMap<String, String> duplEntryMap = new HashMap<String, String>();
        HashMap<String, Set<String>> cashflowIDMap = new HashMap<String, Set<String>>();
        HashSet<String> hkSet = new HashSet<String>();
        DynamicBillTemplateCollection cashFlowbills = new DynamicBillTemplateCollection();
        DAPTransformResult result = DAPUtil.dealVouchers(ctx, bills, cashFlowbills, botMapping, duplEntryMap, hkSet, easCashflowRelation, assistAccountRelation, cashflowIDMap);
        DAPUtil.dealEASCashFlow(ctx, cashFlowbills, result, easCashflowRelation, assistAccountRelation, duplEntryMap, hkSet, cashflowIDMap);
        if (MonitorManager.getCurrentMidBillToDest() != null) {
            MonitorManager.getCurrentMidBillToDest().setTransformResult(result);
        }
        if (cashflowIDMap.keySet().size() > 0) {
            BOTPUtil.updateMidBillStatusEasCash(ctx, cashflowIDMap, midTable);
        }
        return result;
    }

    private static String findJobNumber(CoreBillBaseCollection bills) {
        DynamicBillTemplateInfo info;
        String jobNumber = "";
        if (null != bills && bills.size() > 0 && bills.get(0) instanceof DynamicBillTemplateInfo && (info = (DynamicBillTemplateInfo)bills.get(0)).getEntrys().size() > 0) {
            DynamicBillTemplateEntryInfo entry = ((DynamicBillTemplateInfo)bills.get(0)).getEntrys().get(0);
            jobNumber = entry.getAssignmentNumber();
        }
        return jobNumber;
    }

    private static DAPTransformResult dealVouchers(Context ctx, CoreBillBaseCollection bills, BOTMappingInfo botMapping, Map<String, String> duplEntryMap, Set<String> hkSet) throws BOSException, EASBizException {
        IDAPTransformer dapTransform = DAPTransformerFactory.getLocalInstance((Context)ctx);
        String botpId = botMapping.getId().toString();
        ObjectUuidPK botMappingPK = new ObjectUuidPK(botpId);
        CoreBillBaseCollection _bills = DAPUtil.findVouchers(bills, duplEntryMap, hkSet);
        DAPTransformResult result = dapTransform.transform(_bills, DAPVoucherTypeEnum.FIVoucher, (IObjectPK)botMappingPK);
        return result;
    }

    private static DAPTransformResult dealVouchers(Context ctx, CoreBillBaseCollection bills, DynamicBillTemplateCollection cashFlowbills, BOTMappingInfo botMapping, Map<String, String> duplEntryMap, Set<String> hkSet, String easCashflowRelation, String assistAccountRelation, Map<String, Set<String>> cashflowIDMap) throws BOSException, EASBizException {
        IDAPTransformer dapTransform = DAPTransformerFactory.getLocalInstance((Context)ctx);
        String botpId = botMapping.getId().toString();
        ObjectUuidPK botMappingPK = new ObjectUuidPK(botpId);
        CoreBillBaseCollection _bills = DAPUtil.findVouchers(bills, cashFlowbills, duplEntryMap, hkSet, easCashflowRelation, assistAccountRelation, cashflowIDMap);
        DAPTransformResult result = dapTransform.transform(_bills, DAPVoucherTypeEnum.FIVoucher, (IObjectPK)botMappingPK);
        return result;
    }

    private static void dealCashFlow(Context ctx, CoreBillBaseCollection bills, DAPTransformResult result, String cashflowRelation, Map<String, String> duplEntryMap, Set<String> hkSet) throws BOSException, EASBizException {
        HashMap<String, Integer> newEntryMap = new HashMap<String, Integer>();
        BOTRelationCollection coll = result.getRelationCollection();
        for (BOTRelationInfo info : coll) {
            BOTRelationEntryCollection entryColl = info.getRelationEntries();
            for (BOTRelationEntryInfo entryInfo : entryColl) {
                BOSUuid id = BOSUuid.read((String)entryInfo.getDestEntryID());
                VoucherEntryInfo voucherEntry = (VoucherEntryInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), CommonUtil.convert2PK(entryInfo.getDestEntryID()));
                newEntryMap.put(entryInfo.getSrcEntryID(), voucherEntry.getSeq());
            }
        }
        VoucherCollection botRelations = (VoucherCollection)result.getVoucherCollection();
        Map<String, String> cachedIDs = DAPUtil.getSuccessVoucherIDS(botRelations);
        DAPUtil.checkSourceBillIDAvailable(hkSet, cachedIDs);
        DAPUtil.updateVoucherCashflowFlagByK3AndEAS(ctx, cachedIDs);
        WSVoucherCollection vouchers = new WSVoucherCollection();
        Map<String, String> decodedRelation = DAPUtil.decodeCashFlowRelation(cashflowRelation);
        StringBuffer errorMsg = new StringBuffer();
        boolean hasException = false;
        DAPUtil.fetchLogInfo(errorMsg);
        Iterator itr = bills.iterator();
        String entryID = "";
        String compositeId = null;
        String tmpStr = null;
        HashMap<String, String> FIDEntryPKMap = null;
        HashSet<String> entrySet = null;
        HashMap<String, Integer> accountMap = null;
        while (itr.hasNext()) {
            DynamicBillTemplateEntryCollection entries;
            WSVoucherCollection tmpVouchers = new WSVoucherCollection();
            DynamicBillTemplateInfo dyBillInfo = (DynamicBillTemplateInfo)itr.next();
            if (null != dyBillInfo && null != (entries = dyBillInfo.getEntrys()) && entries.size() > 0) {
                FIDEntryPKMap = new HashMap<String, String>();
                entrySet = new HashSet<String>();
                accountMap = new HashMap<String, Integer>();
                Iterator empIt = entries.iterator();
                while (empIt.hasNext()) {
                    DynamicBillTemplateEntryInfo dyEntry = (DynamicBillTemplateEntryInfo)empIt.next();
                    String entrypk = dyEntry.get("entrypk").toString();
                    if (!entrySet.contains(entrypk)) {
                        FIDEntryPKMap.put(entrypk, dyEntry.getId().toString());
                    }
                    entrySet.add(entrypk);
                }
                Iterator eitr = entries.iterator();
                while (eitr.hasNext()) {
                    DynamicBillTemplateEntryInfo dyEntry = (DynamicBillTemplateEntryInfo)eitr.next();
                    Boolean pItemIsNotNull = false;
                    Boolean sItemIsNotNull = false;
                    Integer ffentryid = null;
                    Integer currentOrder = 1;
                    pItemIsNotNull = DAPUtil.itemIsNotNull(dyEntry, decodedRelation, CASHFLOW_FNUMBER);
                    sItemIsNotNull = DAPUtil.itemIsNotNull(dyEntry, decodedRelation, CASHFLOW_FSUBNUMBER);
                    try {
                        BOSUuid id;
                        DataBaseInfo itemInfo;
                        String EDEntryId;
                        Method method;
                        if (!pItemIsNotNull.booleanValue() && !sItemIsNotNull.booleanValue()) continue;
                        WSVoucherInfo voucher = new WSVoucherInfo();
                        try {
                            method = WSVoucherInfo.class.getMethod("setSourceBillId", String.class);
                            method.invoke((Object)voucher, dyBillInfo.get(decodedRelation.get(CASHFLOW_FVOUCHERID)).toString());
                        }
                        catch (NoSuchMethodException e) {
                            logger.error((Object)"[EIP] \u627e\u4e0d\u5230setSourceBillId\u65b9\u6cd5");
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                            logger.error((Object)"[EIP]\u8c03\u7528\u51ed\u8bc1\u7684setSourceBillId\u65b9\u6cd5\u5f02\u5e38");
                        }
                        try {
                            method = WSVoucherInfo.class.getMethod("setVoucherId", String.class);
                            method.invoke((Object)voucher, cachedIDs.get(dyBillInfo.get(decodedRelation.get(CASHFLOW_FVOUCHERID)).toString()));
                        }
                        catch (NoSuchMethodException e) {
                            logger.error((Object)"[EIP] \u627e\u4e0d\u5230setVoucherId\u65b9\u6cd5");
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                            logger.error((Object)"[EIP]\u8c03\u7528\u51ed\u8bc1\u7684setVoucherID\u65b9\u6cd5\u5f02\u5e38");
                        }
                        String duplEntry = duplEntryMap.get(entryID);
                        String DEntryId = dyEntry.get(decodedRelation.get(CASHFLOW_DENTRYID)).toString();
                        String dentryFID = (String)FIDEntryPKMap.get(String.valueOf(Integer.parseInt(DEntryId) - 1));
                        duplEntry = duplEntryMap.get(dentryFID);
                        ffentryid = duplEntry != null ? (Integer)newEntryMap.get(duplEntry.toString()) : (Integer)newEntryMap.get(dentryFID);
                        Object faccount = dyEntry.get(decodedRelation.get(CASHFLOW_FAccount));
                        if (faccount != null && faccount instanceof DataBaseInfo) {
                            DataBaseInfo _account = (DataBaseInfo)faccount;
                            BOSUuid id2 = _account.getId();
                            _account = (DataBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id2.getType(), CommonUtil.convert2PK(id2.toString()));
                            tmpStr = _account.getName();
                        } else {
                            tmpStr = faccount == null ? "" : faccount.toString();
                        }
                        compositeId = tmpStr;
                        Object fcurrency = dyEntry.get(decodedRelation.get(CASHFLOW_FCurrencyType));
                        if (fcurrency != null && fcurrency instanceof DataBaseInfo) {
                            DataBaseInfo _fcurrency = (DataBaseInfo)fcurrency;
                            BOSUuid id3 = _fcurrency.getId();
                            _fcurrency = (DataBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id3.getType(), CommonUtil.convert2PK(id3.toString()));
                            tmpStr = _fcurrency.getName();
                        } else {
                            tmpStr = fcurrency == null ? "" : fcurrency.toString();
                        }
                        compositeId = compositeId + "_" + tmpStr;
                        Object fdc = dyEntry.get(decodedRelation.get(CASHFLOW_FDC));
                        tmpStr = fdc == null ? "" : fdc.toString();
                        compositeId = compositeId + "_" + tmpStr;
                        if (accountMap.containsKey(compositeId)) {
                            voucher.setEntrySeq(((Integer)accountMap.get(compositeId)).intValue());
                        } else {
                            accountMap.put(compositeId, ffentryid);
                            voucher.setEntrySeq(ffentryid.intValue());
                        }
                        if (null == (EDEntryId = dyEntry.get(decodedRelation.get(CASHFLOW_FENTRYID)).toString()) || "".equals(EDEntryId) || "0".equals(EDEntryId)) continue;
                        String entryFID = (String)FIDEntryPKMap.get(String.valueOf(Integer.parseInt(EDEntryId) - 1));
                        duplEntry = duplEntryMap.get(entryFID);
                        if (duplEntry != null) {
                            voucher.setOppAccountSeq(((Integer)newEntryMap.get(duplEntry.toString())).intValue());
                        } else {
                            voucher.setOppAccountSeq(((Integer)newEntryMap.get(entryFID)).intValue());
                        }
                        String pItem = "";
                        String sItem = "";
                        String oCash = "0";
                        String lCash = "0";
                        if (pItemIsNotNull.booleanValue()) {
                            Object fItem = dyEntry.get(decodedRelation.get(CASHFLOW_FNUMBER));
                            if (fItem != null && fItem instanceof DataBaseInfo) {
                                itemInfo = (DataBaseInfo)fItem;
                                id = itemInfo.getId();
                                itemInfo = (DataBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), CommonUtil.convert2PK(id.toString()));
                                pItem = itemInfo.getNumber();
                            } else {
                                String string = pItem = fItem == null ? "" : fItem.toString();
                            }
                        }
                        if (null == pItem || "".equals(pItem) || "0".equals(pItem)) continue;
                        if (sItemIsNotNull.booleanValue()) {
                            Object fsItem = dyEntry.get(decodedRelation.get(CASHFLOW_FSUBNUMBER));
                            if (fsItem != null && fsItem instanceof DataBaseInfo) {
                                itemInfo = (DataBaseInfo)fsItem;
                                id = itemInfo.getId();
                                itemInfo = (DataBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), CommonUtil.convert2PK(id.toString()));
                                sItem = itemInfo.getNumber();
                            } else {
                                sItem = fsItem == null ? "" : fsItem.toString();
                            }
                        }
                        voucher.setPrimaryItem(pItem);
                        voucher.setSupplyItem(sItem);
                        Boolean oCashIsNotNull = false;
                        Boolean lCashIsNotNull = false;
                        oCashIsNotNull = DAPUtil.itemIsNotNull(dyEntry, decodedRelation, CASHFLOW_FCURRENCY);
                        lCashIsNotNull = DAPUtil.itemIsNotNull(dyEntry, decodedRelation, CASHFLOW_DCURRENCY);
                        if (oCashIsNotNull.booleanValue()) {
                            oCash = dyEntry.get(decodedRelation.get(CASHFLOW_FCURRENCY)).toString();
                        }
                        if (lCashIsNotNull.booleanValue()) {
                            lCash = dyEntry.get(decodedRelation.get(CASHFLOW_DCURRENCY)).toString();
                        }
                        voucher.setCashflowAmountOriginal(Double.parseDouble(oCash));
                        voucher.setCashflowAmountLocal(Double.parseDouble(lCash));
                        voucher.setItemFlag(1);
                        tmpVouchers.add(voucher);
                    }
                    catch (Exception ex) {
                        String headpk = dyBillInfo.get(decodedRelation.get(CASHFLOW_FVOUCHERID)).toString();
                        errorMsg.append("\u6e90\u51ed\u8bc1").append((Object)headpk).append("\u96c6\u6210\u73b0\u91d1\u6d41\u51fa\u9519,\u5206\u5f55\u53f7").append(dyEntry.get(decodedRelation.get(CASHFLOW_DENTRYID))).append("\uff0c\u5bf9\u65b9\u5206\u5f55\u53f7").append(dyEntry.get(decodedRelation.get(CASHFLOW_FENTRYID))).append(",\u8bf7\u68c0\u67e5\u73b0\u91d1\u6d41\u5b9a\u4e49\u662f\u5426\u6b63\u786e\uff01");
                        logger.error((Object)errorMsg.toString());
                        MonitorManager.error(ex);
                        VoucherFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(cachedIDs.get(dyBillInfo.get(decodedRelation.get(CASHFLOW_FVOUCHERID)).toString())));
                        break;
                    }
                }
            }
            if (tmpVouchers.size() <= 0) continue;
            vouchers.addCollection(tmpVouchers);
        }
        DAPUtil.integrateCashFlow(ctx, cachedIDs, vouchers, errorMsg, hasException);
    }

    private static void updateVoucherCashflowFlagByK3AndEAS(Context ctx, Map<String, String> cachedIDs) {
        if (null != cachedIDs && cachedIDs.size() > 0) {
            Set<String> set = cachedIDs.keySet();
            int pageCount = (set.size() - 1) / pageSize + 1;
            ArrayList<String> list = new ArrayList<String>(set);
            HashMap<Integer, String> cacheMap = new HashMap<Integer, String>();
            for (int k = 0; k < pageCount; ++k) {
                int head = k * pageSize;
                int tail = Math.min((k + 1) * pageSize, list.size());
                List subList = list.subList(head, tail);
                Object[] obj = subList.toArray();
                try {
                    if (StringUtils.isEmpty((String)((String)cacheMap.get(obj.length)))) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("update t_gl_voucher set fcashflowflag=4 where fid in( ");
                        for (int j = 0; j < obj.length; ++j) {
                            if (j > 0) {
                                builder.append(",");
                            }
                            builder.append("?");
                        }
                        builder.append(" )");
                        cacheMap.put(obj.length, builder.toString());
                    }
                    DbUtil.execute((Context)ctx, (String)((String)cacheMap.get(obj.length)), (Object[])obj);
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private static void dealEASCashFlow(Context ctx, DynamicBillTemplateCollection bills, DAPTransformResult result, String easCashflowRelation, String assistAccountRelation, Map<String, String> duplEntryMap, Set<String> hkSet, Map<String, Set<String>> cashflowIDMap) throws BOSException, EASBizException {
        HashMap<String, String> srcEntryIDMapToVoucherId = new HashMap<String, String>();
        HashMap<String, VoucherEntryInfo> srcEntryIDMapToVoucherEntryInfo = new HashMap<String, VoucherEntryInfo>();
        HashMap<String, String> cfAccountEntryMap = new HashMap<String, String>();
        Map<String, String> decodedEASRelation = DAPUtil.decodeCashFlowRelation(easCashflowRelation);
        DAPUtil.decodeEntryInfo(ctx, result, srcEntryIDMapToVoucherId, srcEntryIDMapToVoucherEntryInfo, cfAccountEntryMap, decodedEASRelation);
        Map<String, String> srcBillIDMapVoucherID = DAPUtil.getSuccessVoucherIDS(result);
        HashMap<String, VoucherInfo> srcEntryIDMapToVoucherInfo = new HashMap<String, VoucherInfo>();
        CashflowRecordCollection cashFlows = new CashflowRecordCollection();
        StringBuffer errorMsg = new StringBuffer();
        boolean hasException = false;
        DAPUtil.fetchLogInfo(errorMsg);
        Iterator itr = bills.iterator();
        HashMap<String, VoucherAssistRecordCollection> cachedVoucherAssistRecord = new HashMap<String, VoucherAssistRecordCollection>();
        HashMap<VoucherInfo, CashflowRecordCollection> cashflowCols = new HashMap<VoucherInfo, CashflowRecordCollection>();
        while (itr.hasNext()) {
            DynamicBillTemplateEntryCollection entries;
            CashflowRecordCollection tmpcashFlows = new CashflowRecordCollection();
            VoucherInfo voucher = null;
            DynamicBillTemplateInfo dyBillInfo = (DynamicBillTemplateInfo)itr.next();
            if (null != dyBillInfo && null != (entries = dyBillInfo.getEntrys()) && entries.size() > 0) {
                Iterator eitr = entries.iterator();
                while (eitr.hasNext()) {
                    DynamicBillTemplateEntryInfo dyEntry = (DynamicBillTemplateEntryInfo)eitr.next();
                    Object cfFid = dyEntry.get(decodedEASRelation.get("CFFid"));
                    try {
                        if (null == cfFid || !StringUtils.isNotEmpty((String)cfFid.toString())) continue;
                        List<Object> objects = DAPUtil.buildObjectInfo(ctx, duplEntryMap, srcEntryIDMapToVoucherId, srcEntryIDMapToVoucherEntryInfo, cfAccountEntryMap, decodedEASRelation, srcEntryIDMapToVoucherInfo, srcBillIDMapVoucherID, cachedVoucherAssistRecord, dyBillInfo, dyEntry);
                        voucher = (VoucherInfo)objects.get(0);
                        CashflowRecordInfo cashflowRecord = (CashflowRecordInfo)objects.get(1);
                        tmpcashFlows.add(cashflowRecord);
                    }
                    catch (Exception ex) {
                        voucher = null;
                        cashflowIDMap.remove(dyBillInfo.getId().toString());
                        String headpk = dyBillInfo.get(decodedEASRelation.get(CASHFLOW_FVOUCHERID)).toString();
                        errorMsg.append("\u6e90\u51ed\u8bc1").append((Object)headpk).append("\u96c6\u6210\u73b0\u91d1\u6d41\u51fa\u9519,\u5206\u5f55\u53f7").append(dyEntry.get(decodedEASRelation.get("CFEntryID"))).append("\uff0c\u5bf9\u65b9\u5206\u5f55\u53f7").append(dyEntry.get(decodedEASRelation.get("CFOpposingAccountEntryID"))).append(",\u8bf7\u68c0\u67e5EAS\u73b0\u91d1\u6d41\u5b9a\u4e49\u662f\u5426\u6b63\u786e\uff01");
                        MonitorManager.error(ex);
                        String voucherId = srcBillIDMapVoucherID.get(dyBillInfo.getId().toString());
                        if (StringUtils.isEmpty((String)voucherId)) break;
                        VoucherFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(voucherId));
                        break;
                    }
                }
            }
            if (tmpcashFlows.size() <= 0 || null == voucher) continue;
            voucher.setCashflowFlag(CashflowFlag.FINISHED);
            cashflowCols.put(voucher, tmpcashFlows);
        }
        DAPUtil.integrateEASCashFlow(ctx, srcBillIDMapVoucherID, cashflowCols, errorMsg, hasException, cashflowIDMap);
    }

    private static List<Object> buildObjectInfo(Context ctx, Map<String, String> duplEntryMap, Map<String, String> srcEntryIDMapToVoucherId, Map<String, VoucherEntryInfo> srcEntryIDMapToVoucherEntryInfo, Map<String, String> cfAccountEntryMap, Map<String, String> decodedEASRelation, Map<String, VoucherInfo> srcEntryIDMapToVoucherInfo, Map<String, String> srcBillIDMapVoucherID, Map<String, VoucherAssistRecordCollection> cachedVoucherAssistRecord, DynamicBillTemplateInfo dyBillInfo, DynamicBillTemplateEntryInfo dyEntry) throws BOSException {
        String cfType;
        String isSupItem;
        DataBaseInfo itemInfo;
        BOSUuid id;
        Object id2;
        String cfentryid;
        String entryID;
        ArrayList<Object> objects = new ArrayList<Object>();
        CashflowRecordInfo cfRecord = new CashflowRecordInfo();
        VoucherInfo voucher = null;
        Object obj = decodedEASRelation.get("CFSeq");
        if (null != obj) {
            String cfSeq = null;
            if (null != dyEntry.get(obj.toString())) {
                cfSeq = dyEntry.get(obj.toString()).toString();
            }
            if (StringUtils.isNotEmpty(cfSeq)) {
                cfRecord.setSeq(Integer.parseInt(cfSeq));
            }
            if (null != (voucher = DAPUtil.getSuccessVoucherInfo(ctx, srcEntryIDMapToVoucherInfo, srcBillIDMapVoucherID, dyBillInfo.getId().toString()))) {
                cfRecord.setVoucher(voucher);
            }
        }
        String originalAmount = "0";
        String localAmount = "0";
        String reportingAmount = "0";
        obj = decodedEASRelation.get("CFOriginalAmount");
        if (null != obj && StringUtils.isNotEmpty((String)(originalAmount = dyEntry.get(obj.toString()).toString()))) {
            cfRecord.setOriginalAmount(new BigDecimal(originalAmount));
        }
        if (null != (obj = decodedEASRelation.get("CFLocalAmount")) && StringUtils.isNotEmpty((String)(localAmount = dyEntry.get(obj.toString()).toString()))) {
            cfRecord.setLocalAmount(new BigDecimal(localAmount));
        }
        if (null != (obj = decodedEASRelation.get("CFReportingAmount")) && StringUtils.isNotEmpty((String)(reportingAmount = dyEntry.get(obj.toString()).toString()))) {
            cfRecord.setReportingAmount(new BigDecimal(reportingAmount));
        }
        obj = decodedEASRelation.get("CFEntryID");
        VoucherEntryInfo entry = null;
        if (null != obj) {
            entryID = dyEntry.get(obj.toString()).toString();
            cfentryid = cfAccountEntryMap.get(entryID);
            entry = srcEntryIDMapToVoucherEntryInfo.get(cfentryid);
            if (null == entry) {
                String duplEntry = duplEntryMap.get(cfentryid);
                if (duplEntry != null) {
                    cfentryid = srcEntryIDMapToVoucherId.get(duplEntry.toString());
                }
                entry = srcEntryIDMapToVoucherEntryInfo.get(cfentryid);
                cfRecord.setEntry(entry);
            } else {
                cfRecord.setEntry(entry);
            }
        }
        if (null != (obj = decodedEASRelation.get("CFAccount"))) {
            obj = dyEntry.get(obj.toString());
            AccountViewInfo _account = null;
            if (obj != null && obj instanceof DataBaseInfo) {
                DataBaseInfo account = (DataBaseInfo)obj;
                id2 = account.getId();
                _account = (AccountViewInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id2.getType(), CommonUtil.convert2PK(id2.toString()));
            }
            if (null != _account) {
                cfRecord.setAccount(_account);
            }
        }
        if (null != (obj = decodedEASRelation.get("CFCurrency"))) {
            CurrencyInfo _currency = null;
            if ((obj = dyEntry.get(obj.toString())) != null && obj instanceof DataBaseInfo) {
                DataBaseInfo currency = (DataBaseInfo)obj;
                id2 = currency.getId();
                _currency = (CurrencyInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id2.getType(), CommonUtil.convert2PK(id2.toString()));
            }
            if (null != _currency) {
                cfRecord.setCurrency(_currency);
            }
        }
        if (null != entry) {
            cfRecord.setEntryDC(entry.getEntryDC());
        }
        obj = decodedEASRelation.get("CFOpposingAccountEntryID");
        VoucherEntryInfo oppEntry = null;
        if (null != obj) {
            entryID = dyEntry.get(obj.toString()).toString();
            cfentryid = cfAccountEntryMap.get(entryID);
            oppEntry = srcEntryIDMapToVoucherEntryInfo.get(cfentryid);
            if (null == oppEntry) {
                String duplEntry = duplEntryMap.get(cfentryid);
                if (duplEntry != null) {
                    cfentryid = srcEntryIDMapToVoucherId.get(duplEntry.toString());
                }
                oppEntry = srcEntryIDMapToVoucherEntryInfo.get(cfentryid);
                cfRecord.setOpposingAccountEntry(oppEntry);
            } else {
                cfRecord.setOpposingAccountEntry(oppEntry);
            }
        }
        if (null != (obj = decodedEASRelation.get("CFOppaccountAccount"))) {
            obj = dyEntry.get(obj.toString());
            AccountViewInfo _account = null;
            if (obj != null && obj instanceof DataBaseInfo) {
                DataBaseInfo account = (DataBaseInfo)obj;
                id = account.getId();
                _account = (AccountViewInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), CommonUtil.convert2PK(id.toString()));
            }
            if (null != _account) {
                cfRecord.setOppAccount(_account);
            }
            cfRecord.setOppEntryDC(oppEntry.getEntryDC());
        }
        if (null != (obj = decodedEASRelation.get("CFPrimaryNumber"))) {
            obj = dyEntry.get(obj.toString());
            CashFlowItemInfo _itemInfo = null;
            if (obj != null && obj instanceof DataBaseInfo) {
                itemInfo = (DataBaseInfo)obj;
                id = itemInfo.getId();
                _itemInfo = (CashFlowItemInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), CommonUtil.convert2PK(id.toString()));
            }
            if (obj != null && obj instanceof String) {
                id2 = obj.toString();
                try {
                    _itemInfo = CashFlowItemFactory.getLocalInstance((Context)ctx).getCashFlowItemInfo(CommonUtil.convert2PK(((String)id2).toString()));
                }
                catch (EASBizException e) {
                    logger.error((Object)("\u627e\u4e0d\u5230\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\uff1aid = " + (String)id2));
                }
            }
            cfRecord.setPrimaryItem(_itemInfo);
        }
        CashFlowItemInfo _supplementaryItem = null;
        obj = decodedEASRelation.get("CFSupplementaryNumber");
        if (null != obj) {
            if ((obj = dyEntry.get(obj.toString())) != null && obj instanceof DataBaseInfo) {
                itemInfo = (DataBaseInfo)obj;
                id = itemInfo.getId();
                _supplementaryItem = (CashFlowItemInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), CommonUtil.convert2PK(id.toString()));
            }
            if (obj != null && obj instanceof String) {
                id2 = obj.toString();
                try {
                    _supplementaryItem = CashFlowItemFactory.getLocalInstance((Context)ctx).getCashFlowItemInfo(CommonUtil.convert2PK(((String)id2).toString()));
                }
                catch (EASBizException e) {
                    logger.error((Object)("\u627e\u4e0d\u5230\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\uff1aid = " + (String)id2));
                }
            }
            cfRecord.setSupplementaryItem(_supplementaryItem);
        }
        if (null != (obj = decodedEASRelation.get("CFISSupItem")) && StringUtils.isNotEmpty((String)(isSupItem = dyEntry.get(obj.toString()).toString()))) {
            cfRecord.setIsSupItem(Integer.valueOf(isSupItem) != 0);
        }
        if (null != (obj = decodedEASRelation.get("CFType")) && StringUtils.isNotEmpty((String)(cfType = dyEntry.get(obj.toString()).toString()))) {
            cfRecord.setType(CashflowTypeEnum.getEnum((int)Integer.valueOf(cfType)));
        }
        AssistantHGInfo _assistHGInfo = null;
        obj = decodedEASRelation.get("CFAssGrpId");
        if (null != obj) {
            Object cfassGrp = dyEntry.get(obj.toString());
            if (cfassGrp != null) {
                BOSUuid id3 = BOSUuid.read((String)cfassGrp.toString());
                _assistHGInfo = (AssistantHGInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id3.getType(), CommonUtil.convert2PK(id3.toString()));
            }
            cfRecord.setAssGrp(_assistHGInfo);
        }
        String recordID = decodedEASRelation.get("CFOppVoucherAssistRecordId");
        VoucherAssistRecordCollection varc = DAPUtil.cacheVocherAssistRecord(ctx, oppEntry, cachedVoucherAssistRecord);
        VoucherAssistRecordInfo asstRecord = DAPUtil.findVoucherAssistRecordInfoBy(ctx, varc, dyEntry, recordID);
        cfRecord.setOppVoucherAssistRecord(asstRecord);
        if (null != asstRecord) {
            cfRecord.setOppAssGrp(asstRecord.getAssGrp());
        }
        if (null != (obj = decodedEASRelation.get("CFItemFlag"))) {
            Object cfItemF = dyEntry.get(obj.toString());
            String cfItemFlag = "";
            if (cfItemF != null) {
                cfItemFlag = cfItemF.toString();
            }
            if (StringUtils.isNotEmpty((String)cfItemFlag)) {
                cfRecord.setItemFlag(ItemFlag.getEnum((int)Integer.valueOf(cfItemFlag)));
            }
        }
        if (null != (obj = decodedEASRelation.get("CFPrimaryCoeffient"))) {
            Object priCoe = dyEntry.get(obj.toString());
            String primaryCoefficient = "";
            if (null != priCoe) {
                primaryCoefficient = priCoe.toString();
            }
            if (StringUtils.isNotEmpty((String)primaryCoefficient)) {
                cfRecord.setPrimaryCoefficient(Integer.valueOf(primaryCoefficient).intValue());
            }
        }
        if (null != (obj = decodedEASRelation.get("CFSupplementaryCoeffient"))) {
            Object supCoe = dyEntry.get(obj.toString());
            String supplementaryCoefficient = "";
            if (null != supCoe) {
                supplementaryCoefficient = supCoe.toString();
            }
            if (StringUtils.isNotEmpty((String)supplementaryCoefficient)) {
                cfRecord.setSupplementaryCoefficient(Integer.valueOf(supplementaryCoefficient).intValue());
            }
        }
        if (null != (obj = decodedEASRelation.get("CfFullInfoItemNumber"))) {
            Object fullInfo = dyEntry.get(obj.toString());
            CashFlowItemInfo _fullInfo = null;
            if (fullInfo != null && fullInfo instanceof DataBaseInfo) {
                DataBaseInfo itemInfo2 = (DataBaseInfo)fullInfo;
                BOSUuid id4 = itemInfo2.getId();
                _fullInfo = (CashFlowItemInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id4.getType(), CommonUtil.convert2PK(id4.toString()));
            }
            cfRecord.setFullInfoItem(_fullInfo);
        }
        objects.add(voucher);
        objects.add(cfRecord);
        return objects;
    }

    private static void decodeEntryInfo(Context ctx, DAPTransformResult result, Map<String, String> srcEntryIDMapToVoucherId, Map<String, VoucherEntryInfo> srcEntryIDMapToVoucherInfo, Map<String, String> cfAccountEntryMap, Map<String, String> decodedEASRelation) throws BOSException {
        IDynamicObject dbtInstance = DynamicObjectFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection botRelationCollection = result.getRelationCollection();
        for (BOTRelationInfo info : botRelationCollection) {
            BOTRelationEntryCollection entryColl = info.getRelationEntries();
            for (BOTRelationEntryInfo entryInfo : entryColl) {
                BOSUuid id = BOSUuid.read((String)entryInfo.getDestEntryID());
                VoucherEntryInfo voucherEntry = (VoucherEntryInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), CommonUtil.convert2PK(entryInfo.getDestEntryID()));
                srcEntryIDMapToVoucherId.put(entryInfo.getSrcEntryID(), voucherEntry.getId().toString());
                srcEntryIDMapToVoucherInfo.put(entryInfo.getSrcEntryID(), voucherEntry);
            }
            BOSUuid id = BOSUuid.read((String)info.getSrcObjectID());
            DynamicBillTemplateInfo dbtInfo = (DynamicBillTemplateInfo)dbtInstance.getValue(id.getType(), CommonUtil.convert2PK(info.getSrcObjectID()));
            if (dbtInfo.getEntrys() == null) continue;
            Iterator _iter = dbtInfo.getEntrys().iterator();
            while (_iter.hasNext()) {
                DynamicBillTemplateEntryInfo _entry = (DynamicBillTemplateEntryInfo)_iter.next();
                int n = dbtInfo.getEntrys().size();
                for (int i = 0; i < n; ++i) {
                    DynamicBillTemplateEntryInfo tmp = dbtInfo.getEntrys().get(i);
                    Object rawValue = tmp.get(decodedEASRelation.get("EntryPK"));
                    Object colValue = _entry.get(decodedEASRelation.get("CFEntryID"));
                    if (colValue != null && rawValue != null && colValue.toString().equals(rawValue) && srcEntryIDMapToVoucherId.get(tmp.getId().toString()) != null && cfAccountEntryMap.get(colValue.toString()) == null) {
                        cfAccountEntryMap.put(colValue.toString(), tmp.getId().toString());
                    }
                    if ((colValue = _entry.get(decodedEASRelation.get("CFOpposingAccountEntryID"))) == null || rawValue == null || !colValue.toString().equals(rawValue) || srcEntryIDMapToVoucherId.get(tmp.getId().toString()) == null || cfAccountEntryMap.get(colValue.toString()) != null) continue;
                    cfAccountEntryMap.put(colValue.toString(), tmp.getId().toString());
                }
            }
        }
    }

    private static void checkSourceBillIDAvailable(Set<String> hkSet, Map<String, String> cachedIDs) throws BOSException {
        if (hkSet == null) {
            throw new IllegalArgumentException("hkSet\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        for (String hk : cachedIDs.keySet()) {
            if (hkSet.contains(hk)) continue;
            throw new BOSException("BOTP\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5[\u5355\u636e\u5934\u8f6c\u6362\u89c4\u5219-\u539f\u59cb\u5355\u636eID]\u914d\u7f6e\u662f\u5426\u4e3aheakpk!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void integrateCashFlow(Context ctx, Map<String, String> cachedIDs, WSVoucherCollection vouchers, StringBuffer errorMsg, boolean hasException) throws BOSException {
        List ret = null;
        try {
            if (vouchers.size() > 0) {
                Class<?> cashFlowFactory = Class.forName("com.kingdee.eas.fi.gl.CashFlowImpFacadeFactory");
                Method method = cashFlowFactory.getMethod("getLocalInstance", Context.class);
                Object cashFlowFacadeObj = method.invoke(cashFlowFactory, ctx);
                Class<?> facade = cashFlowFacadeObj.getClass();
                Method method2 = facade.getMethod("importCashFlow", IObjectCollection.class, Map.class);
                Object resultv = method2.invoke(cashFlowFacadeObj, vouchers, null);
                if (resultv != null) {
                    ret = (List)resultv;
                }
            }
        }
        catch (Exception e) {
            MonitorManager.error(e);
            hasException = true;
            String[] ids = null;
            if (cachedIDs.values() != null) {
                ids = cachedIDs.values().toArray(new String[0]);
            }
            DAPUtil.delete(ctx, ids, errorMsg);
        }
        finally {
            if (!hasException) {
                DAPUtil.delete(ctx, ret);
            }
            DAPUtil.fetchLogInfo(errorMsg);
            DAPUtil.updateLogInfo(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void integrateEASCashFlow(Context ctx, Map<String, String> cachedIDs, Map<VoucherInfo, CashflowRecordCollection> cashflowCols, StringBuffer errorMsg, boolean hasException, Map<String, Set<String>> cashflowIDMap) throws BOSException {
        try {
            if (cashflowCols.keySet().size() > 0) {
                ICashflowRecord item = CashflowRecordFactory.getLocalInstance((Context)ctx);
                for (Map.Entry<VoucherInfo, CashflowRecordCollection> entry : cashflowCols.entrySet()) {
                    VoucherInfo vch = entry.getKey();
                    HashMap<String, String> mapParam = new HashMap<String, String>();
                    mapParam.put("vchid", vch.getId().toString());
                    mapParam.put("vch", (String)vch);
                    mapParam.put("cfReq", "true");
                    item.saveCashflowCols((IObjectCollection)entry.getValue(), mapParam);
                }
            }
        }
        catch (Exception e) {
            cashflowIDMap.clear();
            MonitorManager.error(e);
            hasException = true;
            String[] ids = null;
            if (cachedIDs.values() != null) {
                ids = cachedIDs.values().toArray(new String[0]);
            }
            DAPUtil.delete(ctx, ids, errorMsg);
        }
        finally {
            DAPUtil.fetchLogInfo(errorMsg);
            DAPUtil.updateLogInfo(errorMsg);
        }
    }

    private static CoreBillBaseCollection findVouchers(CoreBillBaseCollection bills, DynamicBillTemplateCollection cashFlowBills, Map<String, String> duplEntryMap, Set<String> hkSet, String easCashflowRelation, String assistAccountRelation, Map<String, Set<String>> cashflowIDMap) throws BOSException, EASBizException {
        if (hkSet == null) {
            return bills;
        }
        if (null == cashFlowBills) {
            cashFlowBills = new DynamicBillTemplateCollection();
        }
        if (null == cashflowIDMap) {
            cashflowIDMap = new HashMap<String, Set<String>>();
        }
        HashMap<String, String> uniqueMap = new HashMap<String, String>();
        Iterator itr = bills.iterator();
        HashSet<String> uniqueRecord = new HashSet<String>();
        HashSet<String> uniqueCashFlow = new HashSet<String>();
        String compositId = null;
        String cfCompositId = null;
        Object midValue = null;
        DynamicBillTemplateInfo dyBillInfo = null;
        DynamicBillTemplateEntryCollection entries = null;
        Iterator eitr = null;
        Map<String, String> decodedAssistRelation = DAPUtil.decodeCashFlowRelation(assistAccountRelation);
        Map<String, String> decodedEasRelation = DAPUtil.decodeCashFlowRelation(easCashflowRelation);
        boolean hasAssignmentNumber = true;
        while (itr.hasNext()) {
            dyBillInfo = (DynamicBillTemplateInfo)itr.next();
            DynamicBillTemplateInfo copyBillInfo = (DynamicBillTemplateInfo)dyBillInfo.clone();
            copyBillInfo.getEntrys().clear();
            if (null != dyBillInfo && null != (entries = dyBillInfo.getEntrys()) && entries.size() > 0) {
                eitr = entries.iterator();
                HashSet<String> entryIDs = new HashSet<String>();
                while (eitr.hasNext()) {
                    Object cfFid;
                    DynamicBillTemplateEntryInfo dyEntry = (DynamicBillTemplateEntryInfo)eitr.next();
                    if (hasAssignmentNumber && MonitorManager.getCurrentMidBillToDest() != null && dyEntry.getAssignmentNumber() != null) {
                        MonitorManager.getCurrentMidBillToDest().setAssignNumber(dyEntry.getAssignmentNumber());
                        hasAssignmentNumber = false;
                    }
                    compositId = dyBillInfo.get("headpk").toString();
                    if (hkSet != null) {
                        hkSet.add(compositId);
                    }
                    cfCompositId = compositId = compositId + "_" + dyEntry.get("entrypk").toString();
                    midValue = dyEntry.get(decodedAssistRelation.get("AFid"));
                    if (null != midValue && StringUtils.isNotEmpty((String)midValue.toString())) {
                        compositId = compositId + "_" + midValue.toString();
                    }
                    if (null != (cfFid = dyEntry.get(decodedEasRelation.get("CFFid")))) {
                        if (!uniqueCashFlow.contains(cfCompositId = cfCompositId + "_" + cfFid.toString())) {
                            copyBillInfo.getEntrys().add(dyEntry);
                            uniqueCashFlow.add(cfCompositId);
                        }
                        entryIDs.add(dyEntry.getId().toString());
                    } else if (MonitorManager.getCurrentMidBillToDest() != null) {
                        MonitorManager.getCurrentMidBillToDest().setAssignNumber(dyEntry.getAssignmentNumber());
                    }
                    if (uniqueRecord.contains(compositId)) {
                        duplEntryMap.put(dyEntry.getId().toString(), (String)uniqueMap.get(compositId));
                        eitr.remove();
                    } else {
                        uniqueMap.put(compositId, dyEntry.getId().toString());
                    }
                    uniqueRecord.add(compositId);
                }
                if (entryIDs.size() > 0) {
                    cashflowIDMap.put(dyBillInfo.getId().toString(), entryIDs);
                }
            }
            cashFlowBills.add(copyBillInfo);
        }
        uniqueRecord = null;
        uniqueMap = null;
        return bills;
    }

    private static CoreBillBaseCollection findVouchers(CoreBillBaseCollection bills, Map<String, String> duplEntryMap, Set<String> hkSet) throws BOSException, EASBizException {
        if (hkSet == null) {
            return bills;
        }
        HashMap<String, String> uniqueMap = new HashMap<String, String>();
        Iterator itr = bills.iterator();
        HashSet<String> uniqueRecord = new HashSet<String>();
        String compositId = "";
        DynamicBillTemplateInfo dyBillInfo = null;
        DynamicBillTemplateEntryCollection entries = null;
        Iterator eitr = null;
        while (itr.hasNext()) {
            dyBillInfo = (DynamicBillTemplateInfo)itr.next();
            if (null == dyBillInfo || null == (entries = dyBillInfo.getEntrys()) || entries.size() <= 0) continue;
            eitr = entries.iterator();
            while (eitr.hasNext()) {
                DynamicBillTemplateEntryInfo dyEntry = (DynamicBillTemplateEntryInfo)eitr.next();
                compositId = dyBillInfo.get("headpk").toString();
                if (hkSet != null) {
                    hkSet.add(compositId);
                }
                if (uniqueRecord.contains(compositId = compositId + "_" + dyEntry.get("entrypk").toString())) {
                    duplEntryMap.put(dyEntry.getId().toString(), (String)uniqueMap.get(compositId));
                    eitr.remove();
                } else {
                    uniqueMap.put(compositId, dyEntry.getId().toString());
                }
                uniqueRecord.add(compositId);
            }
        }
        uniqueRecord = null;
        uniqueMap = null;
        return bills;
    }

    private static DynamicBillTemplateCollection fetchAllEASCashFlowEntry(CoreBillBaseCollection bills, String easCashflowRelation) throws BOSException, EASBizException {
        DynamicBillTemplateCollection cashFlowBills = new DynamicBillTemplateCollection();
        Iterator itr = bills.iterator();
        DynamicBillTemplateInfo dyBillInfo = null;
        DynamicBillTemplateEntryCollection entries = null;
        Iterator eitr = null;
        Map<String, String> decodedEasRelation = DAPUtil.decodeCashFlowRelation(easCashflowRelation);
        while (itr.hasNext()) {
            dyBillInfo = (DynamicBillTemplateInfo)itr.next();
            DynamicBillTemplateInfo copyBillInfo = (DynamicBillTemplateInfo)dyBillInfo.clone();
            copyBillInfo.getEntrys().clear();
            if (null != dyBillInfo && null != (entries = dyBillInfo.getEntrys()) && entries.size() > 0) {
                eitr = entries.iterator();
                while (eitr.hasNext()) {
                    DynamicBillTemplateEntryInfo dyEntry = (DynamicBillTemplateEntryInfo)eitr.next();
                    Object cfFid = dyEntry.get(decodedEasRelation.get("CFFid"));
                    if (null == cfFid) continue;
                    copyBillInfo.getEntrys().add(dyEntry);
                }
            }
            cashFlowBills.add(copyBillInfo);
        }
        return cashFlowBills;
    }

    private static void delete(Context ctx, List records) throws BOSException {
        StringBuffer errMsg = new StringBuffer();
        String[] voucherIds = null;
        if (records != null && records.size() > 0) {
            errMsg.append("\u96c6\u6210\u73b0\u91d1\u6d41\u51fa\u9519\uff0c");
            voucherIds = new String[records.size()];
            for (int i = 0; i < records.size(); ++i) {
                Object[] ret = (String[])records.get(i);
                if (!StringUtils.isNotEmpty((String)ret[1])) continue;
                voucherIds[i] = ret[1];
                errMsg.append(Arrays.toString((Object[])ret)).append("\n");
            }
            DAPUtil.delete(ctx, voucherIds, errMsg);
        }
    }

    private static void delete(Context ctx, String[] voucherIds, StringBuffer errorMsg) throws BOSException {
        if (errorMsg == null) {
            errorMsg = new StringBuffer();
        }
        DAPUtil.fetchLogInfo(errorMsg);
        IVoucher vInstance = VoucherFactory.getLocalInstance((Context)ctx);
        if (voucherIds != null && voucherIds.length > 0) {
            for (int i = 0; i < voucherIds.length; ++i) {
                String vId = voucherIds[i];
                if (!StringUtils.isNotEmpty((String)vId)) continue;
                try {
                    vInstance.delete(CommonUtil.convert2PK(vId));
                    continue;
                }
                catch (Exception ex) {
                    errorMsg.append("\u5220\u9664\u51ed\u8bc1\u51fa\u9519\uff0c\u76ee\u6807\u51ed\u8bc1ID ").append(vId).append("\n");
                    throw new BOSException((Throwable)ex);
                }
                finally {
                    DAPUtil.updateLogInfo(errorMsg);
                }
            }
        }
    }

    private static void fetchLogInfo(StringBuffer errorMsg) {
        String content = "";
        if (MonitorManager.getCurrentMidBillToDest() != null) {
            content = MonitorManager.getCurrentMidBillToDest().getExtendedProperty("errorMsg");
            errorMsg.append(content == null ? "" : content);
        }
    }

    private static void updateLogInfo(StringBuffer errorMsg) {
        if (MonitorManager.getCurrentMidBillToDest() != null) {
            MonitorManager.getCurrentMidBillToDest().setExtendedProperty("errorMsg", errorMsg.toString());
        }
    }

    private static Map<String, String> decodeCashFlowRelation(String cashFlowRelation) {
        HashMap<String, String> cashMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)cashFlowRelation)) {
            String[] cashGroup;
            for (String cash : cashGroup = cashFlowRelation.split(";")) {
                String[] realtion = cash.split(",");
                boolean noDesc = realtion.length == 1;
                cashMap.put(realtion[0], noDesc ? "" : realtion[1]);
            }
        }
        return cashMap;
    }

    private static Boolean itemIsNotNull(DynamicBillTemplateEntryInfo dyEntry, Map<String, String> decodedRelation, String middleFieldName) {
        return StringUtils.isNotEmpty((String)decodedRelation.get(middleFieldName)) && dyEntry.get(decodedRelation.get(middleFieldName)) != null && StringUtils.isNotEmpty((String)dyEntry.get(decodedRelation.get(middleFieldName)).toString());
    }

    private static Map<String, String> getSuccessVoucherIDS(VoucherCollection voucherCollection) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (VoucherInfo info : voucherCollection) {
            if (!StringUtils.isNotEmpty((String)info.getSourceBillId()) || info.getId() == null || !StringUtils.isNotEmpty((String)info.getId().toString())) continue;
            result.put(info.getSourceBillId(), info.getId().toString());
        }
        return result;
    }

    private static Map<String, String> getSuccessVoucherIDS(DAPTransformResult result) throws BOSException {
        HashMap<String, String> results = new HashMap<String, String>();
        for (BOTRelationInfo botInfo : result.getRelationCollection()) {
            if (botInfo == null || botInfo.getSrcObjectID() == null || !StringUtils.isNotEmpty((String)botInfo.getSrcObjectID())) continue;
            results.put(botInfo.getSrcObjectID(), botInfo.getDestObjectID());
        }
        return results;
    }

    private static VoucherInfo getSuccessVoucherInfo(Context ctx, Map<String, VoucherInfo> cachedVouchers, Map<String, String> srcBillIDMapVoucherID, String sourceBillId) throws BOSException {
        VoucherInfo info = null;
        if (cachedVouchers.get(sourceBillId) != null) {
            return cachedVouchers.get(sourceBillId);
        }
        String destObjectId = srcBillIDMapVoucherID.get(sourceBillId);
        if (StringUtils.isNotEmpty((String)destObjectId)) {
            BOSUuid id = BOSUuid.read((String)destObjectId);
            VoucherInfo voucher = (VoucherInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), CommonUtil.convert2PK(destObjectId));
            cachedVouchers.put(sourceBillId, voucher);
            info = voucher;
        }
        return info;
    }

    private static VoucherAssistRecordInfo findVoucherAssistRecordInfoBy(Context ctx, VoucherAssistRecordCollection varc, DynamicBillTemplateEntryInfo dyEntry, String assistRecord) {
        String key = null;
        VoucherAssistRecordInfo record = null;
        if (varc != null && varc.size() > 0) {
            int n = varc.size();
            for (int i = 0; i < n; ++i) {
                AssistantHGInfo ahInfo = (AssistantHGInfo)varc.get(i).get("assGrp");
                if (ahInfo != null) {
                    key = ahInfo.getId().toString();
                }
                record = varc.get(i);
                if (!(key = key + "_" + (record.get("description") == null ? "" : record.get("description")) + "_" + record.get("originalAmount")).equals(dyEntry.get(assistRecord))) continue;
                boolean hasDupRecord = DAPUtil.hasDuplicateRecord(varc, record);
                if (hasDupRecord) {
                    varc.remove(record);
                }
                return record;
            }
            if (varc.size() == 1) {
                return varc.get(0);
            }
        }
        return null;
    }

    private static VoucherAssistRecordCollection cacheVocherAssistRecord(Context ctx, VoucherEntryInfo entry, Map<String, VoucherAssistRecordCollection> cacheVocherAssistRecord) {
        if (cacheVocherAssistRecord.get(entry.getId().toString()) != null) {
            return cacheVocherAssistRecord.get(entry.getId().toString());
        }
        VoucherAssistRecordCollection varc = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("entry.id", (Object)entry.getId().toString(), CompareType.EQUALS));
        try {
            varc = VoucherAssistRecordFactory.getLocalInstance((Context)ctx).getVoucherAssistRecordCollection(view);
            cacheVocherAssistRecord.put(entry.getId().toString(), varc);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return varc;
    }

    private static boolean hasDuplicateRecord(VoucherAssistRecordCollection varc, VoucherAssistRecordInfo record) {
        String key = "";
        String searchKey = "";
        int matchCount = 0;
        int n = varc.size();
        for (int i = 0; i < n; ++i) {
            AssistantHGInfo ahInfo = (AssistantHGInfo)varc.get(i).get("assGrp");
            AssistantHGInfo searchInfo = (AssistantHGInfo)record.get("assGrp");
            if (ahInfo != null) {
                key = ahInfo.getId().toString();
            }
            if (searchInfo != null) {
                searchKey = searchInfo.getId().toString();
            }
            if (!(key = key + "_" + (varc.get(i).get("description") == null ? "" : varc.get(i).get("description")) + "_" + varc.get(i).get("originalAmount")).equals(searchKey = searchKey + "_" + (record.get("description") == null ? "" : record.get("description")) + "_" + record.get("originalAmount"))) continue;
            ++matchCount;
        }
        return matchCount > 1;
    }
}

