/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;

public class JobUtil {
    static String MUTEX_PREFIX = "G::";

    public static final String getScheduleJobMutex(Context ctx, ScheduleInfo scheduleInfo) throws EASBizException, BOSException {
        String baseDataMappingId;
        String number = "";
        if (scheduleInfo.getStrategy() != null) {
            String stragyId = scheduleInfo.getStrategy().getId().toString();
            BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo((IObjectPK)new ObjectUuidPK(stragyId));
            number = billMappingInfo.getNumber();
        } else if (scheduleInfo.getBaseDataMap() != null) {
            baseDataMappingId = scheduleInfo.getBaseDataMap().getId().toString();
            BaseDataMapingInfo mappingInfo = BaseDataMapingFactory.getLocalInstance(ctx).getBaseDataMapingInfo((IObjectPK)new ObjectUuidPK(baseDataMappingId));
            number = mappingInfo.getNumber();
        } else if (scheduleInfo.getBaseDataSyn() != null) {
            baseDataMappingId = scheduleInfo.getBaseDataSyn().getId().toString();
            BaseDataSynHeadInfo synInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo("select number where id = '" + baseDataMappingId + "'");
            String agentId = null;
            ConnectionInfo conn = scheduleInfo.getConn();
            EipUserInfo user = scheduleInfo.getAgent();
            WSServiceInfo service = scheduleInfo.getWsservice();
            agentId = conn != null ? conn.getId().toString() : (user != null ? user.getId().toString() : (service != null ? service.getId().toString() : "_"));
            number = agentId.hashCode() + "_" + synInfo.getNumber();
        }
        String mutex = MUTEX_PREFIX + number;
        if (mutex.length() > 39) {
            mutex = mutex.substring(0, 39);
        }
        return mutex;
    }

    public static final String getMidBillMutex(Context ctx, String strategyId) throws EASBizException, BOSException {
        BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo((IObjectPK)new ObjectUuidPK(strategyId));
        return MUTEX_PREFIX + billMappingInfo.getNumber();
    }

    public static final String getBaseDataSynMutex(Context ctx, BaseDataSynHeadInfo headInfo) throws EASBizException, BOSException {
        return MUTEX_PREFIX + headInfo.getNumber();
    }

    public static final String getInterfaceNumberMutex(Context ctx, String wsTaskId) throws EASBizException, BOSException {
        return MUTEX_PREFIX + wsTaskId;
    }

    public static final String getConfigHashCodeMutex(Context ctx, String config) throws EASBizException, BOSException {
        return MUTEX_PREFIX + config.hashCode();
    }
}

