/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.app.base.EIPORMServiceUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.business.BizWizardCollection;
import com.kingdee.eas.csinterface.business.BizWizardFactory;
import com.kingdee.eas.csinterface.business.BizWizardInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.app.AbstractConnectionControllerBean;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.util.BizReference;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConnectionControllerBean
extends AbstractConnectionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.syncdatabase.app.ConnectionControllerBean");
    static String ACTION_DELETE = "\u5220\u9664";
    static String ACTION_MODIFY = "\u4fee\u6539";

    private void checkCanDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkRelation(ctx, pk, ACTION_DELETE);
    }

    private void checkCanModify(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ConnectionInfo connInfo = (ConnectionInfo)model;
        IObjectPK pk = CommonUtil.convert2PK(connInfo.getId().toString());
        boolean hasBeanUsed = this.checkRelation(ctx, pk, ACTION_MODIFY);
        if (hasBeanUsed) {
            ConnectionInfo savedInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo((IObjectPK)new ObjectUuidPK(connInfo.getId()));
            if (!StringUtils.equals((String)connInfo.getIP(), (String)savedInfo.getIP()) || connInfo.getPort() != savedInfo.getPort() || !StringUtils.equals((String)connInfo.getInstance(), (String)savedInfo.getInstance())) {
                throw new BOSException("\u8fde\u63a5\uff08" + connInfo.getNumber() + "\uff09\u5df2\u53d1\u751f\u4e1a\u52a1\u914d\u7f6e\uff0c\u4e0d\u80fd\u4fee\u6539IP\u5730\u5740\u3001\u7aef\u53e3\u3001\u6570\u636e\u5e93\u540d\u3002");
            }
        }
    }

    private boolean checkRelation(Context ctx, IObjectPK pk, String actionType) throws BOSException, EASBizException {
        ConnectionInfo conn = this.getConnectionInfo(ctx, pk);
        boolean hasSrc = this.checkSrcDBView(ctx, pk, conn, actionType);
        if (hasSrc) {
            return hasSrc;
        }
        boolean hasBill = this.checkBillMapping(ctx, pk, conn, actionType);
        if (hasBill) {
            return hasBill;
        }
        boolean hashBaseDataType = this.checkBaseDataType(ctx, pk, conn, actionType);
        if (hashBaseDataType) {
            return hashBaseDataType;
        }
        boolean hashBaseData = this.checkBaseData(ctx, pk, conn, actionType);
        if (hashBaseData) {
            return hashBaseData;
        }
        boolean hashSchedule = this.checkSchedule(ctx, pk, conn, actionType);
        if (hashSchedule) {
            return hashSchedule;
        }
        boolean hashSpecialSQL = this.checkBaseDataSPSQL(ctx, pk, conn, actionType);
        if (hashSpecialSQL) {
            return hashSpecialSQL;
        }
        boolean hasDataSource = this.checkDataSource(ctx, pk, conn, actionType);
        if (hasDataSource) {
            return hasDataSource;
        }
        return false;
    }

    private String _checkTableRelation(Context ctx, String tableName, String fieldName, String fieldValue) throws BOSException {
        StringBuilder number = new StringBuilder();
        String sql = "SELECT FID,FNUMBER FROM " + tableName + " WHERE " + fieldName + " = '" + fieldValue + "'";
        Connection connection = DBUtils.getConnection(ctx);
        IRowSet rowSet = KSQLUtil.executeQuery(connection, sql);
        try {
            while (rowSet.next()) {
                if (number.length() > 0) {
                    number.append(",");
                }
                number.append(rowSet.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return number.toString();
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            EIPLicenseCheckUtil.checkLicenseEnough(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        boolean isModify = false;
        ConnectionInfo oldInfo = null;
        if (model.get("id") != null) {
            isModify = true;
            this.checkCanModify(ctx, model);
            ConnectionInfo connInfo = (ConnectionInfo)model;
            IObjectPK pk = CommonUtil.convert2PK(connInfo.getId().toString());
            oldInfo = this.getConnectionInfo(ctx, pk);
        }
        IObjectPK pk = super._submit(ctx, model);
        if (isModify) {
            ctx.put((Object)"EIPLICENSEOBJECT", oldInfo);
            EIPORMServiceUtil.releaseLicense(ctx);
            ctx.put((Object)"EIPLICENSEOBJECT", (Object)model);
            EIPORMServiceUtil.addLicense(ctx);
        } else {
            ctx.put((Object)"EIPLICENSEOBJECT", (Object)model);
            EIPORMServiceUtil.addLicense(ctx);
        }
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            EIPLicenseCheckUtil.checkLicenseEnough(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        boolean isModify = false;
        ConnectionInfo oldInfo = null;
        if (model.get("id") != null) {
            isModify = true;
            this.checkCanModify(ctx, model);
            ConnectionInfo connInfo = (ConnectionInfo)model;
            IObjectPK pk = CommonUtil.convert2PK(connInfo.getId().toString());
            oldInfo = this.getConnectionInfo(ctx, pk);
        }
        IObjectPK pk = super._submit(ctx, model);
        if (isModify) {
            ctx.put((Object)"EIPLICENSEOBJECT", oldInfo);
            EIPORMServiceUtil.releaseLicense(ctx);
            ctx.put((Object)"EIPLICENSEOBJECT", (Object)model);
            EIPORMServiceUtil.addLicense(ctx);
        } else {
            ctx.put((Object)"EIPLICENSEOBJECT", (Object)model);
            EIPORMServiceUtil.addLicense(ctx);
        }
        return pk;
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ConnectionInfo conn = this.getConnectionInfo(ctx, pk);
        this.checkCanDelete(ctx, pk);
        super._delete(ctx, pk);
        ctx.put((Object)"EIPLICENSEOBJECT", (Object)conn);
        EIPORMServiceUtil.releaseLicense(ctx);
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] arrayPK;
        for (IObjectPK pk : arrayPK = super.getPKList(ctx, filter, null)) {
            this.checkCanDelete(ctx, pk);
        }
        arrayPK = super._delete(ctx, filter);
        return arrayPK;
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] arrayPK;
        for (IObjectPK pk : arrayPK = super.getPKList(ctx, oql)) {
            this.checkCanDelete(ctx, pk);
        }
        arrayPK = super._delete(ctx, oql);
        return arrayPK;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (IObjectPK pk : arrayPK) {
            this.checkCanDelete(ctx, pk);
        }
        super._delete(ctx, arrayPK);
    }

    private void checkBizWizard(Context ctx, IObjectPK pk, ConnectionInfo conn) throws BOSException, EASBizException {
        StringBuffer wizardNum = new StringBuffer();
        BizWizardCollection wizardColl = BizWizardFactory.getLocalInstance(ctx).getBizWizardCollection("where connection.id = '" + pk.toString() + "'");
        Iterator it = wizardColl.iterator();
        while (it.hasNext()) {
            if (wizardNum.length() > 0) {
                wizardNum.append(",");
            }
            BizWizardInfo wizardInfo = (BizWizardInfo)it.next();
            wizardNum.append(wizardInfo.getNumber());
        }
        if (wizardNum.length() > 0) {
            throw new BOSException("\u7f16\u7801\u4e3a(" + conn.getNumber() + ")\u7684\u6e90\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5\u5df2\u7ecf\u88ab\u96c6\u6210\u5411\u5bfc(\u201c" + wizardNum.toString() + ")\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
        }
    }

    private boolean checkBillMapping(Context ctx, IObjectPK pk, ConnectionInfo conn, String actionType) throws BOSException, EASBizException {
        String hasNumber = this._checkTableRelation(ctx, "T_EIP_BillMapping", "FSRCDBCONNID", pk.toString());
        if (hasNumber.length() > 0) {
            if (ACTION_DELETE.equals(actionType)) {
                BizReference bizReference = new BizReference();
                bizReference.setRefEntityAlias_L2("\u3010\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u3011(\u201c" + hasNumber + "\u201d)");
                throw new ObjectReferedException((Object)bizReference);
            }
            return true;
        }
        return false;
    }

    private boolean checkSrcDBView(Context ctx, IObjectPK pk, ConnectionInfo conn, String actionType) throws BOSException, EASBizException {
        String hasNumber = this._checkTableRelation(ctx, "T_SYN_SrcDBView", "FCONNECTIONID", pk.toString());
        if (hasNumber.length() > 0) {
            if (ACTION_DELETE.equals(actionType)) {
                BizReference bizReference = new BizReference();
                bizReference.setRefEntityAlias_L2("\u3010\u6e90\u7cfb\u7edf\u89c6\u56fe\u3011(\u201c" + hasNumber + "\u201d)");
                throw new ObjectReferedException((Object)bizReference);
            }
            return true;
        }
        return false;
    }

    private boolean checkBaseDataType(Context ctx, IObjectPK pk, ConnectionInfo conn, String actionType) throws BOSException, EASBizException {
        String hasNumber = this._checkTableRelation(ctx, "T_SYN_BaseDataType", "FCONNID", pk.toString());
        if (hasNumber.length() > 0) {
            if (ACTION_DELETE.equals(actionType)) {
                BizReference bizReference = new BizReference();
                bizReference.setRefEntityAlias_L2("\u3010\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3011(\u201c" + hasNumber + "\u201d)");
                throw new ObjectReferedException((Object)bizReference);
            }
            return true;
        }
        return false;
    }

    private boolean checkBaseData(Context ctx, IObjectPK pk, ConnectionInfo conn, String actionType) throws BOSException, EASBizException {
        String hasNumber = this._checkTableRelation(ctx, "T_EIP_BaseDataSynHead", "FDBCONNID", pk.toString());
        if (hasNumber.length() > 0) {
            if (ACTION_DELETE.equals(actionType)) {
                BizReference bizReference = new BizReference();
                bizReference.setRefEntityAlias_L2("\u3010\u57fa\u7840\u8d44\u6599\u540c\u6b65\u3011(\u201c" + hasNumber + "\u201d)");
                throw new ObjectReferedException((Object)bizReference);
            }
            return true;
        }
        return false;
    }

    private boolean checkSchedule(Context ctx, IObjectPK pk, ConnectionInfo conn, String actionType) throws BOSException, EASBizException {
        String hasNumber = this._checkTableRelation(ctx, "T_DIP_Schedule", "FDBCONNID", pk.toString());
        if (hasNumber.length() > 0) {
            if (ACTION_DELETE.equals(actionType)) {
                BizReference bizReference = new BizReference();
                bizReference.setRefEntityAlias_L2("\u3010\u8c03\u5ea6\u6267\u884c\u3011(\u201c" + hasNumber + "\u201d)");
                throw new ObjectReferedException((Object)bizReference);
            }
            return true;
        }
        return false;
    }

    private boolean checkDataSource(Context ctx, IObjectPK pk, ConnectionInfo conn, String actionType) throws BOSException, EASBizException {
        String hasNumber = this._checkTableRelation(ctx, "T_EIP_BIZ_DataSource", "FCONNECTIONID", pk.toString());
        if (hasNumber.length() > 0) {
            if (ACTION_DELETE.equals(actionType)) {
                BizReference bizReference = new BizReference();
                bizReference.setRefEntityAlias_L2("\u3010\u6570\u636e\u6e90\u3011(\u201c" + hasNumber + "\u201d)");
                throw new ObjectReferedException((Object)bizReference);
            }
            return true;
        }
        return false;
    }

    private boolean checkBaseDataSPSQL(Context ctx, IObjectPK pk, ConnectionInfo conn, String actionType) throws BOSException, EASBizException {
        StringBuilder hasNumber = new StringBuilder();
        String sql = "SELECT sql.FID,head.FNUMBER FROM T_EIP_BaseDataSynSpecialSQL sql left join T_EIP_BaseDataSynHead head ON sql.FPARENTID = head.FID WHERE sql.FCONNECTIONID = '" + pk.toString() + "'";
        Connection connection = DBUtils.getConnection(ctx);
        IRowSet rowSet = KSQLUtil.executeQuery(connection, sql);
        try {
            while (rowSet.next()) {
                if (hasNumber.length() > 0) {
                    hasNumber.append(",");
                }
                hasNumber.append(rowSet.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        if (hasNumber.length() > 0) {
            if (ACTION_DELETE.equals(actionType)) {
                BizReference bizReference = new BizReference();
                bizReference.setRefEntityAlias_L2("\u3010\u57fa\u7840\u8d44\u6599\u540c\u6b65\u3011(\u201c" + hasNumber + "\u201d)\u7684\u7279\u6b8a\u67e5\u8be2\u6761\u4ef6\u5f15\u7528");
                throw new ObjectReferedException((Object)bizReference);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean _canModifyConnection(Context ctx, IObjectValue model) throws BOSException {
        try {
            ConnectionInfo connInfo = (ConnectionInfo)model;
            IObjectPK pk = CommonUtil.convert2PK(connInfo.getId().toString());
            boolean hasBeanUsed = this.checkRelation(ctx, pk, ACTION_MODIFY);
            return !hasBeanUsed;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)("EIP:Check Connection Modify error:" + ex.getMessage()));
            return false;
        }
    }

    @Override
    public String _getLicenseInfo(Context ctx, boolean isRefresh) throws BOSException {
        return EIPORMServiceUtil.getLicenseInfo(ctx, isRefresh);
    }
}

