/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.app.util.BillFunMetuxUtil;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.DataExtractor;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.model.StructuredTableData;
import com.kingdee.eas.csinterface.data.provider.db.MiddleBillDataProvider;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleFacade;
import com.kingdee.eas.csinterface.syncdatabase.BDRMappingInfo;
import com.kingdee.eas.csinterface.syncdatabase.app.AbstractMiddleBillDataFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MiddleBillDataFacadeControllerBean
extends AbstractMiddleBillDataFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.syncdatabase.app.MiddleBillDataFacadeControllerBean");

    @Override
    protected StructuredTableData _readFromDataProvider(Context ctx, Map param) throws BOSException, EASBizException {
        String mappingStrategyId = (String)param.get("mappingStrategyId");
        StructuredDataModel dataModel = DataModelUtil.convertFromBillMapping(ctx, mappingStrategyId);
        MiddleBillDataProvider dataProvider = new MiddleBillDataProvider(dataModel);
        DataExtractor dataExtractor = new DataExtractor(dataProvider, dataModel);
        try {
            dataExtractor.extract(ctx, param, false);
        }
        catch (DIPException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return dataExtractor.getStructuredTableData();
    }

    @Override
    protected boolean _extractData(Context ctx, Map param) throws BOSException, EASBizException {
        MutexParameter retParam = null;
        boolean b = false;
        BillMappingInfo billMappingInfo = null;
        try {
            String mappingStrategyId = (String)param.get("mappingStrategyId");
            billMappingInfo = DataModelUtil.readBillMappingInfo(ctx, mappingStrategyId);
            if (null != billMappingInfo && billMappingInfo.isIsBillRequestMutex()) {
                if (BillFunMetuxUtil.isRequstFunMutex(ctx, billMappingInfo, "\u751f\u6210\u4e2d\u95f4\u5355\u636e")) {
                    retParam = BillFunMetuxUtil.requestFunMutex(ctx, (CoreBaseInfo)billMappingInfo, "\u751f\u6210\u4e2d\u95f4\u5355\u636e");
                    b = ScheduleFacade.triggerProcessMidBill(ctx, param);
                } else {
                    BillFunMetuxUtil.triggerBillDelayTask4Client(ctx, param, null, billMappingInfo, null, null, "\u751f\u6210\u4e2d\u95f4\u5355\u636e", 10000L);
                }
            } else {
                b = ScheduleFacade.triggerProcessMidBill(ctx, param);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5355\u636e\u96c6\u6210\uff1a" + (null != billMappingInfo ? billMappingInfo.getNumber() : "") + ",\u751f\u6210\u4e2d\u95f4\u5355\u5f02\u5e38\uff01"), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != retParam) {
                BillFunMetuxUtil.releaseFunctionMutex(ctx, retParam.getRequestId());
            }
        }
        return b;
    }

    @Override
    protected void _processBOTP(Context ctx, Set headSet, BOTMappingInfo botp, BillMappingInfo billMappingInfo) throws BOSException {
        MutexParameter retParam = null;
        try {
            if (null != billMappingInfo && billMappingInfo.isIsBillRequestMutex()) {
                if (BillFunMetuxUtil.isRequstFunMutex(ctx, billMappingInfo, "\u751f\u6210\u76ee\u6807\u5355\u636e")) {
                    retParam = BillFunMetuxUtil.requestFunMutex(ctx, (CoreBaseInfo)billMappingInfo, "\u751f\u6210\u76ee\u6807\u5355\u636e");
                    ScheduleFacade.triggerProcessBOTP(ctx, headSet, botp, billMappingInfo);
                } else {
                    BillFunMetuxUtil.triggerBillDelayTask4Client(ctx, null, null, billMappingInfo, botp, headSet, "\u751f\u6210\u76ee\u6807\u5355\u636e", 10000L);
                }
            } else {
                ScheduleFacade.triggerProcessBOTP(ctx, headSet, botp, billMappingInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5355\u636e\u96c6\u6210\uff1a" + billMappingInfo.getNumber() + ",\u751f\u6210\u76ee\u6807\u5355\u5f02\u5e38\uff01"), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != retParam) {
                BillFunMetuxUtil.releaseFunctionMutex(ctx, retParam.getRequestId());
            }
        }
    }

    @Override
    protected void _processBaseData(Context ctx, Set headpks, BillMappingInfo billMapping, BDRMappingInfo bdrMapping) throws BOSException {
        try {
            ScheduleFacade.triggerProcessBaseData(ctx, headpks, billMapping, bdrMapping, null);
        }
        catch (Exception e) {
            logger.error((Object)"\u3010eip\u3011  process basedata error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _processBaseDataGroup(Context ctx, String groupId) throws BOSException {
        try {
            ScheduleFacade.triggerProcessBaseDataGroup(ctx, groupId, null);
        }
        catch (Exception e) {
            logger.error((Object)"\u3010eip\u3011  process basedata error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _processCheckData(Context ctx, String billNumber, String[] headpks) throws BOSException {
        try {
            MonitorManager.enterCheckMidStatusforBasedata(ctx, null, billNumber, null);
            ScheduleFacade.triggerProcessCheckStatus(ctx, billNumber, headpks, null);
        }
        catch (Exception e) {
            logger.error((Object)"\u3010eip\u3011\u4e2d\u95f4\u5355\u72b6\u6001\u68c0\u6d4b\u5f02\u5e38", (Throwable)e);
            MonitorManager.error(e);
            throw new BOSException((Throwable)e);
        }
        finally {
            MonitorManager.exit(ctx);
        }
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        EIPLicenseCheckUtil.checkLicense(svcCtx);
        super.invokeServiceBefore(svcCtx);
    }
}

