/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.MD5;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.process.impl.BaseDataMappingHelper;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryCollection;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingEntryCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataMatchType;
import com.kingdee.eas.csinterface.syncdatabase.EIPRelationCollection;
import com.kingdee.eas.csinterface.syncdatabase.EIPRelationFactory;
import com.kingdee.eas.csinterface.syncdatabase.EIPRelationInfo;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataInfoUtil;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataTypeRuleFilter;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.utils.BaseDataMappingUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BaseDataParse {
    private static Logger logger = Logger.getLogger((String)BaseDataParse.class.getName());

    public static Map<String, Map<String, CoreBaseInfo>> getParseData(IRowSet rs, BillMappingEntryCollection entryColl, String autoMatch, Context ctx, StructuredDataModel dataModel) throws SQLException, BOSException {
        HashMap<String, Map<String, CoreBaseInfo>> resultMap = new HashMap<String, Map<String, CoreBaseInfo>>();
        String selfField = BaseDataParse.getSelfField(entryColl);
        Map<String, String> autoMatchMap = BaseDataParse.getAutoMatchRule(autoMatch);
        int n = entryColl.size();
        for (int i = 0; i < n; ++i) {
            BaseDataTypeInfo feildType;
            BillMappingEntryInfo entryInfo = entryColl.get(i);
            String fieldName = entryInfo.getSrcFieldName();
            if (selfField != null && fieldName.equalsIgnoreCase(selfField)) continue;
            String filedValue = autoMatchMap.get(fieldName);
            if (entryInfo.isDropped() || (feildType = entryInfo.getBaseDataType()) == null || entryInfo.getBaseDataType().getId() == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            while (rs.next()) {
                String s = rs.getString(fieldName);
                map.put(s, StringUtils.isEmpty((String)filedValue) || rs.getObject(filedValue) == null ? null : rs.getObject(filedValue).toString());
            }
            rs.beforeFirst();
            ICoreBase instance = BaseDataMappingHelper.getCoreBaseInstance(ctx, feildType);
            String typeID = entryInfo.getBaseDataType().getId().toString();
            Map<String, CoreBaseInfo> dataMap = BaseDataParse.getData(map, ctx, typeID, instance, dataModel);
            resultMap.put(fieldName, dataMap);
        }
        return resultMap;
    }

    public static String getSelfField(BillMappingEntryCollection entryColl) {
        String selfField = null;
        boolean flag = false;
        for (int j = 0; j < entryColl.size(); ++j) {
            String temp = entryColl.get(j).getMidFieldName();
            if (temp.length() < 4 || !(flag = temp.substring(temp.length() - 4).equalsIgnoreCase("_SRC"))) continue;
            selfField = temp.substring(0, temp.length() - 4);
            break;
        }
        return selfField;
    }

    public static Map<String, CoreBaseInfo> getData(Set<String> set, Context ctx, String typeID, ICoreBase instance, StructuredDataModel model) throws BOSException {
        try {
            BaseDataTypeInfo info = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeInfo("where id='" + typeID + "'");
            String replaceRule = info.getRule();
            if (BaseDataTypeRuleFilter.matchReplace(replaceRule)) {
                String[] rule = replaceRule.split("\\?");
                HashSet<String> tempSet = new HashSet<String>();
                for (String str : set) {
                    if (str == null) continue;
                    tempSet.add(str.replace(rule[1], rule[0]));
                }
                set.clear();
                set.addAll(tempSet);
                tempSet = null;
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer strb = new StringBuffer();
        for (String key : set) {
            if (!StringUtils.isEmpty((String)strb.toString())) {
                strb.append(",");
            }
            strb.append(key);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("baseDataType.id", (Object)typeID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("entrys.srcID", (Object)strb.toString(), CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        ev.setSelector(BaseDataParse.getSelectors());
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.csinterface.syncdatabase.app", "BaseDataMappingQuery4Server");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        queryExec.setObjectView(ev);
        IRowSet rowSet = queryExec.executeQuery();
        Map<String, CoreBaseInfo> resultMap = BaseDataParse.getResultMap(ctx, rowSet, instance, model);
        Iterator<String> it = set.iterator();
        HashMap<String, CoreBaseInfo> checkDataMap = new HashMap<String, CoreBaseInfo>();
        while (it.hasNext()) {
            String key = it.next();
            if (key == null) continue;
            CoreBaseInfo value = resultMap.get(key);
            checkDataMap.put(key, value);
        }
        return checkDataMap;
    }

    public static Map<String, CoreBaseInfo> getData(Map<String, String> srcAll, Context ctx, String typeID, ICoreBase instance, StructuredDataModel model) throws BOSException {
        try {
            BaseDataTypeInfo info = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeInfo("where id='" + typeID + "'");
            String replaceRule = info.getRule();
            if (BaseDataTypeRuleFilter.matchReplace(replaceRule)) {
                String[] rule = replaceRule.split("\\?");
                HashMap<String, String> tempMap = new HashMap<String, String>();
                for (String key : srcAll.keySet()) {
                    String value = srcAll.get(key);
                    tempMap.put(key.replace(rule[1], rule[0]), value);
                }
                srcAll.clear();
                srcAll.putAll(tempMap);
                tempMap = null;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6620\u5c04\u83b7\u53d6\u89c4\u5219\u51fa\u9519\uff0cFID:" + typeID));
            throw new BOSException((Throwable)e);
        }
        BaseDataParse.setCompany(model, srcAll);
        Set<String> set = srcAll.keySet();
        HashSet<String> backSet = new HashSet<String>();
        StringBuffer strb = new StringBuffer();
        for (String key : set) {
            backSet.add(key);
            if (!StringUtils.isEmpty((String)strb.toString())) {
                strb.append(",");
            }
            strb.append(key);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("baseDataType.id", (Object)typeID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("entrys.srcID", (Object)strb.toString(), CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        ev.setSelector(BaseDataParse.getSelectors());
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.csinterface.syncdatabase.app", "BaseDataMappingQuery4Server");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        queryExec.setObjectView(ev);
        IRowSet rowSet = queryExec.executeQuery();
        Map<String, CoreBaseInfo> resultMap = BaseDataParse.getResultMap(ctx, rowSet, instance, model);
        if (resultMap != null) {
            Iterator<Map.Entry<String, String>> entryset = srcAll.entrySet().iterator();
            while (entryset.hasNext()) {
                Map.Entry<String, String> entry = entryset.next();
                if (StringUtils.isEmpty((String)entry.getKey())) {
                    entryset.remove();
                }
                if (!resultMap.containsKey(entry.getKey())) continue;
                entryset.remove();
            }
        }
        if (!srcAll.isEmpty()) {
            Map<String, CoreBaseInfo> relationMap = null;
            try {
                relationMap = BaseDataParse.getRelationMatchResultMap(srcAll, instance, typeID, ctx);
                if (relationMap != null) {
                    Iterator<Map.Entry<String, String>> entryset = srcAll.entrySet().iterator();
                    while (entryset.hasNext()) {
                        Map.Entry<String, String> entry = entryset.next();
                        if (!relationMap.containsKey(entry.getKey())) continue;
                        entryset.remove();
                    }
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            resultMap.putAll(relationMap);
        }
        if (!srcAll.isEmpty()) {
            Map<String, CoreBaseInfo> autoMap = BaseDataParse.getAutoMatchResultMap(srcAll, instance, typeID, ctx, model);
            resultMap.putAll(autoMap);
        }
        Iterator<String> it = backSet.iterator();
        HashMap<String, CoreBaseInfo> checkDataMap = new HashMap<String, CoreBaseInfo>();
        while (it.hasNext()) {
            String key = it.next();
            if (key == null) continue;
            CoreBaseInfo value = resultMap.get(key);
            checkDataMap.put(key, value);
        }
        return checkDataMap;
    }

    private static void setCompany(StructuredDataModel model, Map<String, String> srcAll) {
        if (model == null) {
            return;
        }
        CompanyOrgUnitInfo company = null;
        Object companyField = model.getProperty("companyField");
        String companyValue = null;
        if (companyField != null) {
            companyValue = srcAll.get(companyField.toString());
        } else {
            Object companyObj = model.getProperty("company");
            if (companyObj != null) {
                company = (CompanyOrgUnitInfo)companyObj;
            }
        }
        model.setProperty("company", company);
    }

    public static Map<String, CoreBaseInfo> getRelationMatchResultMap(Map<String, String> rs, ICoreBase instance, String typeID, Context ctx) throws BOSException, EASBizException {
        HashMap<String, CoreBaseInfo> result = new HashMap<String, CoreBaseInfo>();
        BaseDataTypeInfo baseDataTypeInfo = null;
        String bosType = null;
        try {
            baseDataTypeInfo = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeInfo("select destBaseData.* where id='" + typeID + "'");
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        ConnectionInfo connectionInfo = (ConnectionInfo)ctx.get((Object)"srcDBConn");
        if (connectionInfo == null) {
            return result;
        }
        String srcDatabase = connectionInfo.getIP() + "+" + connectionInfo.getPort() + "+" + connectionInfo.getInstance();
        String newHashCode = null;
        try {
            newHashCode = MD5.code(srcDatabase);
        }
        catch (Exception e1) {
            logger.error((Object)"\u8d26\u5957\u8fde\u63a5\u4fe1\u606f\u751f\u6210MD5\u503c\u5f02\u5e38", (Throwable)e1);
            throw new BOSException("\u8d26\u5957\u8fde\u63a5\u4fe1\u606f\u751f\u6210MD5\u503c\u5f02\u5e38", (Throwable)e1);
        }
        String queryName = baseDataTypeInfo.getDestBaseData().getQueryName();
        EntityObjectInfo eof = CommonUtil.getEntityObjectInfo(queryName);
        bosType = eof.getType().toString();
        EIPRelationCollection EIPRelationInfoColl = null;
        if (!bosType.isEmpty() && (EIPRelationInfoColl = EIPRelationFactory.getLocalInstance(ctx).getEIPRelationCollection("where destEntityID = '" + bosType + "' and sourceValue = '" + newHashCode + "'")).size() < 1) {
            return result;
        }
        result.putAll(BaseDataParse.getRelationMatchResultMap(rs, instance, ctx, EIPRelationInfoColl));
        return result;
    }

    public static Map<String, CoreBaseInfo> getRelationMatchResultMap(Map<String, String> rs, ICoreBase instance, Context ctx, EIPRelationCollection EIPRelationInfoColl) throws EASBizException, BOSException {
        HashMap<String, CoreBaseInfo> result = new HashMap<String, CoreBaseInfo>();
        for (int i = 0; i < EIPRelationInfoColl.size(); ++i) {
            EIPRelationInfo bdrInfo = EIPRelationInfoColl.get(i);
            String srcObjectId = bdrInfo.getSrcObjectID();
            if (!rs.containsKey(srcObjectId)) continue;
            String destId = bdrInfo.getDestObjectID();
            IObjectPK pk = CommonUtil.convert2PK(destId);
            CoreBaseInfo value = instance.getValue(pk);
            result.put(srcObjectId, value);
        }
        return result;
    }

    public static Map<String, CoreBaseInfo> getAutoMatchResultMap(Map<String, String> rs, ICoreBase instance, String typeID, Context ctx, StructuredDataModel model) throws BOSException {
        HashMap<String, CoreBaseInfo> result = new HashMap<String, CoreBaseInfo>();
        BaseDataTypeInfo baseDataTypeInfo = null;
        try {
            baseDataTypeInfo = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeInfo((IObjectPK)new ObjectUuidPK(typeID));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (!baseDataTypeInfo.isIsAutoMatch()) {
            return result;
        }
        BaseDataMapingCollection coll = BaseDataMapingFactory.getLocalInstance(ctx).getBaseDataMapingCollection("where baseDataType='" + baseDataTypeInfo.getId().toString() + "'");
        BaseDataMapingInfo baseDataMapingInfo = null;
        int len = coll.size();
        for (int i = 0; i < len; ++i) {
            baseDataMapingInfo = coll.get(i);
            if (baseDataMapingInfo == null) continue;
            try {
                result.putAll(BaseDataParse.getAutoMatchResultMap(rs, instance, baseDataMapingInfo, ctx, model));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    public static Map<String, CoreBaseInfo> getAutoMatchResultMap(Map<String, String> rs, ICoreBase instance, BaseDataMapingInfo baseDataMappingInfo, Context ctx, StructuredDataModel model) throws Exception {
        CoreBaseInfo value;
        IObjectPK pk;
        BaseDataMapingEntryInfo entry;
        String name;
        String number;
        String id;
        IObjectValue obj;
        BaseDataTypeInfo baseDataTypeInfo = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeInfo((IObjectPK)new ObjectUuidPK(baseDataMappingInfo.getBaseDataType().getId().toString()));
        HashMap<String, CoreBaseInfo> result = new HashMap<String, CoreBaseInfo>();
        Map<String, String> unMatchkeyMap = rs;
        HashMap<String, String> unMatchValueMap = new HashMap<String, String>(rs.size());
        for (String key : rs.keySet()) {
            unMatchValueMap.put(rs.get(key), key);
        }
        HashMap<String, String> unMatchkeyMap2 = new HashMap<String, String>();
        HashMap<String, String> unMatchValueMap2 = new HashMap<String, String>();
        unMatchkeyMap2.putAll(unMatchkeyMap);
        unMatchValueMap2.putAll(unMatchValueMap);
        HashMap<String, IObjectValue> resultNumMap = new HashMap<String, IObjectValue>();
        HashMap<String, IObjectValue> resultNameMap = new HashMap<String, IObjectValue>();
        DataMatchType matchType = baseDataTypeInfo.getMatchType();
        if (matchType == null || matchType.equals((Object)DataMatchType.NumName)) {
            BaseDataParse.getDescValues(matchType, unMatchkeyMap, unMatchValueMap, "number", resultNumMap, baseDataTypeInfo, baseDataMappingInfo, ctx, model);
            BaseDataParse.getDescValues(matchType, unMatchkeyMap, unMatchValueMap, "name", resultNameMap, baseDataTypeInfo, baseDataMappingInfo, ctx, model);
        } else if (matchType.equals((Object)DataMatchType.NumAndName)) {
            BaseDataParse.getDescValues(matchType, unMatchkeyMap, unMatchValueMap, "both", resultNumMap, baseDataTypeInfo, baseDataMappingInfo, ctx, model);
        } else {
            BaseDataParse.getDescValues(matchType, unMatchkeyMap, unMatchValueMap, "", resultNameMap, baseDataTypeInfo, baseDataMappingInfo, ctx, model);
        }
        BaseDataMapingEntryCollection entryColl = baseDataMappingInfo.getEntrys();
        Iterator it = entryColl.iterator();
        HashSet<String> existSet = new HashSet<String>();
        while (it.hasNext()) {
            BaseDataMapingEntryInfo entry2 = (BaseDataMapingEntryInfo)it.next();
            existSet.add(entry2.getSrcID());
        }
        HashSet<String> hasMatchSet = new HashSet<String>();
        BaseDataMapingEntryCollection newEntryColl = new BaseDataMapingEntryCollection();
        int successCount = 0;
        for (String key : resultNameMap.keySet()) {
            obj = (IObjectValue)resultNameMap.get(key);
            id = obj.get("id").toString();
            number = String.valueOf(obj.get(baseDataTypeInfo.getDestID()));
            name = String.valueOf(obj.get(baseDataTypeInfo.getDestDisplay()));
            if (existSet.contains(number)) continue;
            entry = new BaseDataMapingEntryInfo();
            if (matchType != null && matchType.equals((Object)DataMatchType.OnlyNum)) {
                entry.setSrcID(number);
                entry.setSrcDisplay((String)unMatchkeyMap2.get(number));
                entry.setDestID(id);
                entry.setDestNum(number);
                entry.setDestDisplay(name);
            } else if (matchType != null && matchType.equals((Object)DataMatchType.OnlyName)) {
                entry.setSrcID((String)unMatchValueMap2.get(name));
                entry.setSrcDisplay(name);
                entry.setDestID(id);
                entry.setDestNum(number);
                entry.setDestDisplay(name);
            } else {
                entry.setSrcID((String)unMatchValueMap2.get(name));
                entry.setSrcDisplay(name);
                entry.setDestID(id);
                entry.setDestNum(number);
                entry.setDestDisplay(name);
            }
            entry.setSystemAuto(true);
            newEntryColl.add(entry);
            try {
                pk = CommonUtil.convert2PK(id);
                value = instance.getValue(pk);
                result.put(entry.getSrcID(), value);
            }
            catch (Throwable t) {
                logger.warn((Object)("\u8b66\u544a\uff1a\u67e5\u8be2\u57fa\u7840\u8d44\u6599[" + id + "]\u5f02\u5e38\uff1a" + t.getMessage()));
                t.printStackTrace();
            }
            ++successCount;
            hasMatchSet.add(entry.getSrcID());
        }
        for (String key : resultNumMap.keySet()) {
            obj = (IObjectValue)resultNumMap.get(key);
            id = obj.get("id").toString();
            number = (String)obj.get(baseDataTypeInfo.getDestID());
            name = (String)obj.get(baseDataTypeInfo.getDestDisplay());
            if (existSet.contains(key) || hasMatchSet.contains(key)) continue;
            entry = new BaseDataMapingEntryInfo();
            entry.setSrcID(key);
            entry.setSrcDisplay((String)unMatchkeyMap2.get(key));
            entry.setDestID(id);
            entry.setDestNum(number);
            entry.setDestDisplay(name);
            entry.setSystemAuto(true);
            newEntryColl.add(entry);
            try {
                pk = CommonUtil.convert2PK(id);
                value = instance.getValue(pk);
                result.put(entry.getSrcID(), value);
            }
            catch (Throwable t) {
                logger.warn((Object)("\u8b66\u544a\uff1a\u67e5\u8be2\u57fa\u7840\u8d44\u6599[" + id + "]\u5f02\u5e38\uff1a" + t.getMessage()));
                t.printStackTrace();
            }
            hasMatchSet.add(entry.getSrcID());
            ++successCount;
        }
        baseDataMappingInfo.getEntrys().addCollection(newEntryColl);
        BaseDataMapingFactory.getLocalInstance(ctx).save((CoreBaseInfo)baseDataMappingInfo);
        return result;
    }

    private static Map<String, CoreBaseInfo> getResultMap(Context ctx, IRowSet rowSet, ICoreBase instance, StructuredDataModel model) throws BOSException {
        HashMap<String, CoreBaseInfo> resultMap = new HashMap<String, CoreBaseInfo>();
        try {
            String bosType = instance.getType().toString();
            boolean isSpecial = false;
            if (model != null && "9DA99826".equals(bosType)) {
                CompanyOrgUnitInfo company = null;
                Object companyObj = model.getProperty("company");
                if (companyObj != null) {
                    company = (CompanyOrgUnitInfo)companyObj;
                }
                if (company != null) {
                    isSpecial = true;
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("number"));
                    selector.add(new SelectorItemInfo("accountTable.id"));
                    company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(CommonUtil.convert2PK(company.getId()), selector);
                    if (company.get("accountTable") == null) {
                        throw new BOSException("\u7ec4\u7ec7\uff08" + company.getNumber() + "\uff09\u6ca1\u6709\u914d\u7f6e\u79d1\u76ee\u8868\uff0c\u65e0\u6cd5\u751f\u6210\u51ed\u8bc1.");
                    }
                    HashSet<String> numberSet = new HashSet<String>();
                    HashMap tempMap = new HashMap();
                    while (rowSet.next()) {
                        String srcID = rowSet.getString("entrys.srcID");
                        String destNum = rowSet.getString("entrys.destNum");
                        numberSet.add(destNum);
                        HashSet<String> srcSet = null;
                        if (tempMap.containsKey(destNum)) {
                            srcSet = (HashSet<String>)tempMap.get(destNum);
                        } else {
                            srcSet = new HashSet<String>(3);
                            tempMap.put(destNum, srcSet);
                        }
                        srcSet.add(srcID);
                        tempMap.put(destNum, srcSet);
                    }
                    try {
                        if (numberSet.size() == 0) {
                            return resultMap;
                        }
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
                        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString(), CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)((DataBaseInfo)company.get("accountTable")).getId().toString(), CompareType.EQUALS));
                        view.setFilter(filter);
                        SelectorItemCollection selectors = new SelectorItemCollection();
                        selectors.add(new SelectorItemInfo("id"));
                        selectors.add(new SelectorItemInfo("number"));
                        selectors.add(new SelectorItemInfo("CAA"));
                        selectors.add(new SelectorItemInfo("companyID"));
                        view.setSelector(selectors);
                        CoreBaseCollection values = instance.getCollection(view);
                        Iterator ite = values.iterator();
                        HashMap<String, CoreBaseInfo> querytMap = new HashMap<String, CoreBaseInfo>();
                        CoreBaseInfo tempCore = null;
                        while (ite.hasNext()) {
                            tempCore = (CoreBaseInfo)ite.next();
                            querytMap.put(tempCore.getString("number"), tempCore);
                        }
                        for (String accNumber : tempMap.keySet()) {
                            if (!querytMap.containsKey(accNumber)) continue;
                            for (String srcId : (Set)tempMap.get(accNumber)) {
                                resultMap.put(srcId, (CoreBaseInfo)querytMap.get(accNumber));
                            }
                        }
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("\u8b66\u544a\uff1a\u67e5\u8be2\u79d1\u76ee\u5f02\u5e38\uff1a" + t.getMessage()));
                        t.printStackTrace();
                    }
                }
            }
            if (!isSpecial) {
                while (rowSet.next()) {
                    String srcID = rowSet.getString("entrys.srcID");
                    String destID = rowSet.getString("entrys.destID");
                    IObjectPK pk = CommonUtil.convert2PK(destID);
                    try {
                        CoreBaseInfo value = instance.getValue(pk);
                        resultMap.put(srcID, value);
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("\u8b66\u544a\uff1a\u67e5\u8be2\u57fa\u7840\u8d44\u6599[" + destID + "]\u5f02\u5e38\uff1a" + t.getMessage()));
                        t.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    private static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseDataType.id"));
        sic.add(new SelectorItemInfo("entrys.srcID"));
        sic.add(new SelectorItemInfo("entrys.destID"));
        sic.add(new SelectorItemInfo("entrys.srcDisplay"));
        sic.add(new SelectorItemInfo("entrys.destNum"));
        sic.add(new SelectorItemInfo("entrys.destDisplay"));
        return sic;
    }

    private static SelectorItemCollection getStcIDSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.srcID"));
        return sic;
    }

    public static Map<String, CoreBaseInfo> getAssAccData(Context ctx, AssistAccountTypeInfo assistAccountType) throws BOSException {
        HashMap<String, CoreBaseInfo> resultMap = new HashMap<String, CoreBaseInfo>();
        if (assistAccountType == null) {
            return resultMap;
        }
        AssistAccountTypeEntryCollection coll = assistAccountType.getEntrys();
        for (int index = 0; index < coll.size(); ++index) {
            AssistAccountTypeEntryInfo info = coll.get(index);
            String srcID = info.getSrcID();
            String destID = info.getDestID();
            IObjectPK pk = CommonUtil.convert2PK(destID);
            ICoreBase instance = null;
            String queryName = "";
            queryName = info.isIsCustomedAssAcc() ? "com.kingdee.eas.basedata.master.auxacct.app.F7GeneralAsstActTypeQuery" : "com.kingdee.eas.basedata.master.auxacct.app.F7AsstActTypeQuery";
            instance = CommonUtil.getCoreBaseInstanceByQueryName(ctx, queryName);
            try {
                CoreBaseInfo value = instance.getValue(pk);
                resultMap.put(srcID, value);
                continue;
            }
            catch (Throwable t) {
                logger.warn((Object)("\u8b66\u544a\uff1a\u67e5\u8be2\u57fa\u7840\u8d44\u6599[" + destID + "]\u5f02\u5e38\uff1a" + t.getMessage()));
                t.printStackTrace();
            }
        }
        return resultMap;
    }

    public static List<String> getDataOnlySrcID(Set<String> set, Context ctx, String typeID, ICoreBase instance) throws BOSException {
        HashMap checkDataMap = new HashMap();
        LinkedList<String> tmpList = new LinkedList<String>(set);
        LinkedList<String> unMatchList = new LinkedList<String>();
        int defaultPageSize = 10000;
        int totalSize = tmpList.size();
        int totalPage = totalSize / defaultPageSize + (totalSize % defaultPageSize > 0 ? 1 : 0);
        int begin = 0;
        int end = 0;
        List filterList = new ArrayList();
        for (int i = 0; i < totalPage; ++i) {
            begin = defaultPageSize * i;
            end = defaultPageSize * (i + 1);
            end = end > totalSize ? totalSize : end;
            filterList = tmpList.subList(begin, end);
            StringBuffer strb = new StringBuffer();
            for (String key : filterList) {
                if (!StringUtils.isEmpty((String)strb.toString())) {
                    strb.append(",");
                }
                strb.append(key);
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("baseDataType.id", (Object)typeID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("entrys.srcID", (Object)strb.toString(), CompareType.INCLUDE));
            ev.setFilter(filterInfo);
            ev.setSelector(BaseDataParse.getStcIDSelectors());
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.csinterface.syncdatabase.app", "BaseDataMappingQuery4Server");
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
            queryExec.setObjectView(ev);
            IRowSet rowSet = queryExec.executeQuery();
            try {
                while (rowSet.next()) {
                    String srcID = rowSet.getString("entrys.srcID");
                    unMatchList.add(srcID);
                }
                tmpList.removeAll(unMatchList);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (tmpList.contains(null)) {
            tmpList.remove(null);
        }
        return tmpList;
    }

    private static void filtWithOrgUnitInfo(Context ctx, FilterItemCollection fic, BaseDataMapingInfo baseDataMapingInfo, BaseDataTypeInfo baseDataTypeInfo, StructuredDataModel model) throws BOSException, EASBizException {
        Object object;
        String orgId = baseDataMapingInfo.getOrgUnit();
        boolean isAccount = BaseDataParse.isAccountBaseType(ctx, baseDataTypeInfo);
        if (isAccount && model != null && model.getProperty("company") != null) {
            orgId = ((CompanyOrgUnitInfo)model.getProperty("company")).getId().toString();
        }
        OrgType orgType = BaseDataParse.getOrgType(ctx, baseDataTypeInfo);
        if (StringUtils.isEmpty((String)orgId)) {
            return;
        }
        OrgUnitInfo orgUnitInfo = NewOrgViewHelper.getOrgUnitInfo((Context)ctx, (String)orgId, (OrgType)orgType);
        if (null == orgUnitInfo) {
            return;
        }
        if (null == baseDataTypeInfo) {
            return;
        }
        String destOrgField = baseDataTypeInfo.getDestOrgField();
        if (StringUtils.isEmpty((String)destOrgField)) {
            return;
        }
        String orgUnitId = orgUnitInfo.getId().toString();
        fic.add(new FilterItemInfo(destOrgField, (Object)orgUnitId, CompareType.EQUALS));
        if (isAccount && (object = orgUnitInfo.get("accounttable")) != null) {
            try {
                String accountTableIDValue = BaseDataParse.getAccountTableInfoId(object);
                fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTableIDValue, CompareType.EQUALS));
                fic.add(new FilterItemInfo("isleaf", (Object)1, CompareType.EQUALS));
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
    }

    private static void getDescValues(DataMatchType matchType, Map<String, String> unMatchKeyMap, Map<String, String> unMatchValueMap, String specialType, Map<String, IObjectValue> resultMap, BaseDataTypeInfo baseDataTypeInfo, BaseDataMapingInfo baseDataMapingInfo, Context ctx, StructuredDataModel model) throws BOSException, EASBizException, ParserException, SQLException {
        String queryName = BaseDataInfoUtil.getQueryName(baseDataTypeInfo, ctx);
        MetaDataPK queryPK = MetaDataPK.create((String)queryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo view = null;
        String where = baseDataMapingInfo.getDestWhere();
        view = StringUtils.isEmpty((String)where) ? new EntityViewInfo() : new EntityViewInfo(where);
        if (null == view.getFilter()) {
            view.setFilter(new FilterInfo());
        }
        BaseDataParse.filtWithOrgUnitInfo(ctx, filter.getFilterItems(), baseDataMapingInfo, baseDataTypeInfo, model);
        BaseDataParse.filterWithMatchType(matchType, unMatchKeyMap, filter.getFilterItems(), specialType, baseDataTypeInfo);
        if (filter.getFilterItems().size() > 0) {
            view.getFilter().mergeFilter(filter, "AND");
        }
        exec.setObjectView(view);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)queryPK);
        SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
        SubEntityInfo mainEntityInfo = null;
        if (mainObjectInfo instanceof SubEntityInfo) {
            mainEntityInfo = (SubEntityInfo)mainObjectInfo;
            mainEntityInfo.getEntityRef();
        }
        BOSObjectType type = null;
        if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
            type = mainEntityInfo.getEntityRef().getType();
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo(baseDataTypeInfo.getDestID()));
        selectors.add(new SelectorItemInfo(baseDataTypeInfo.getDestDisplay()));
        view.setSelector(selectors);
        IObjectCollection coll = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(type, view);
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            IObjectValue object = coll.getObject(i);
            String number = BaseDataMappingUtil.getDestValue(object, baseDataTypeInfo.getDestID());
            String name = BaseDataMappingUtil.getDestValue(object, baseDataTypeInfo.getDestDisplay());
            if (StringUtils.equals((String)specialType, (String)"number")) {
                if (!unMatchKeyMap.containsKey(number)) continue;
                unMatchKeyMap.remove(number);
                resultMap.put(number, object);
                continue;
            }
            if (StringUtils.equals((String)specialType, (String)"name")) {
                if (!unMatchValueMap.containsKey(name)) continue;
                unMatchValueMap.remove(name);
                resultMap.put(number, object);
                continue;
            }
            if (StringUtils.equals((String)specialType, (String)"both")) {
                String unMatchName = unMatchKeyMap.get(number);
                if (unMatchName == null || !StringUtils.equals((String)unMatchName, (String)name)) continue;
                resultMap.put(number, object);
                continue;
            }
            if (matchType.equals((Object)DataMatchType.OnlyNum)) {
                if (!unMatchKeyMap.containsKey(number)) continue;
                unMatchKeyMap.remove(number);
                resultMap.put(number, object);
                continue;
            }
            if (!matchType.equals((Object)DataMatchType.OnlyName) || !unMatchValueMap.containsKey(name)) continue;
            unMatchValueMap.remove(name);
            resultMap.put(number, object);
        }
    }

    private static void filterWithMatchType(DataMatchType matchType, Map<String, String> unMatchValue, FilterItemCollection filterItemCollection, String type, BaseDataTypeInfo baseDataTypeInfo) {
        if (unMatchValue.size() == 0) {
            unMatchValue.put("", "");
        }
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.addAll(unMatchValue.values());
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(unMatchValue.keySet());
        if (StringUtils.equals((String)type, (String)"number")) {
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestID(), keySet, CompareType.INCLUDE));
        } else if (StringUtils.equals((String)type, (String)"name")) {
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestDisplay(), valueSet, CompareType.INCLUDE));
        } else if (matchType.equals((Object)DataMatchType.NumAndName)) {
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestID(), keySet, CompareType.INCLUDE));
        } else if (matchType.equals((Object)DataMatchType.OnlyNum)) {
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestID(), keySet, CompareType.INCLUDE));
        } else if (matchType.equals((Object)DataMatchType.OnlyName)) {
            filterItemCollection.add(new FilterItemInfo(baseDataTypeInfo.getDestDisplay(), valueSet, CompareType.INCLUDE));
        }
    }

    private static String getAccountTableInfoId(Object object) {
        try {
            Class<?> clazz = BaseDataParse.class.getClassLoader().loadClass("com.kingdee.eas.basedata.master.account.AccountTableInfo");
            Method getId = clazz.getMethod("getId", new Class[0]);
            BOSUuid bosUuid = (BOSUuid)getId.invoke(object, new Object[0]);
            return bosUuid.toString();
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
            return null;
        }
    }

    private static OrgType getOrgType(Context ctx, BaseDataTypeInfo baseDataType) {
        BaseDataInfo baseData = baseDataType.getDestBaseData();
        IObjectPK pk = CommonUtil.convert2PK(baseData.getId().toString());
        try {
            baseData = BaseDataFactory.getLocalInstance(ctx).getBaseDataInfo(pk);
        }
        catch (Exception e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        String queryName = baseData.getQueryName();
        OrgType orgType = CommonUtil.getOrgTypeByQueryName(queryName);
        return orgType;
    }

    private static boolean isAccountBaseType(Context ctx, BaseDataTypeInfo baseDataType) {
        BaseDataInfo baseDataInfo = baseDataType.getDestBaseData();
        if (null != baseDataInfo) {
            try {
                String queryName = BaseDataInfoUtil.getQueryName(baseDataType, ctx);
                String bosType = CommonUtil.getEntityObjectInfo(queryName).getType().toString();
                return "9DA99826".equals(bosType);
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
        return false;
    }

    private static Map<String, String> getAutoMatchRule(String autoMatch) {
        String[] autoMatchGroup;
        HashMap<String, String> map = new HashMap<String, String>();
        if (autoMatch == null || StringUtils.isEmpty((String)autoMatch)) {
            return map;
        }
        for (String str : autoMatchGroup = autoMatch.split(";")) {
            String[] realtion = str.split(",");
            boolean noDesc = realtion.length == 1;
            map.put(realtion[0], noDesc ? "" : realtion[1]);
        }
        return map;
    }
}

