/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.FieldDifferenceType;
import com.kingdee.eas.csinterface.util.DataTypeConverter;
import com.kingdee.eas.csinterface.util.DataTypeInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataTypeComparer {
    public static final int INT_MAX_LENGTH = 10;
    public static final String infoSplit = "\uff1b";
    public static final String msgSplit = "\u3002";
    public static final List<SQLType> onlyTypes = new ArrayList<SQLType>();
    private KDTable mainTable;
    private DataTypeInfo srcCols;
    private DataTypeInfo tarCols;
    private String resultCol;
    private DBType srcDbType;
    private DBType tarDbType;
    private DataTypeConverter srcConvert;
    private DataTypeConverter tarConvert;

    public DataTypeComparer(KDTable mainTable, DataTypeInfo srcCols, DataTypeInfo tarCols, String resultCol, DBType srcDbType, DBType tarDbType) throws Exception {
        this.mainTable = mainTable;
        this.srcCols = srcCols;
        this.tarCols = tarCols;
        this.resultCol = resultCol;
        this.srcDbType = srcDbType;
        this.tarDbType = tarDbType;
        String checkRs = this.checkIntegrity();
        if (!StringUtils.isEmpty((String)checkRs)) {
            throw new Exception(checkRs);
        }
    }

    private String checkIntegrity() {
        String tarFieldExist;
        String srcFieldExist;
        String dbType;
        StringBuffer buffer = new StringBuffer();
        String argsIsNull = this.checkArgsIsNull();
        if (!StringUtils.isEmpty((String)argsIsNull)) {
            buffer.append(argsIsNull).append(msgSplit);
        }
        if (!StringUtils.isEmpty((String)(dbType = this.checkDBType()))) {
            buffer.append(dbType).append(msgSplit);
        }
        if (!StringUtils.isEmpty((String)(srcFieldExist = this.checkFieldExist(this.srcCols, "srcCols")))) {
            buffer.append(srcFieldExist).append(msgSplit);
        }
        if (!StringUtils.isEmpty((String)(tarFieldExist = this.checkFieldExist(this.tarCols, "tarCols")))) {
            buffer.append(tarFieldExist).append(msgSplit);
        }
        return buffer.toString();
    }

    private String checkArgsIsNull() {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        if (this.mainTable == null) {
            args.add("mainTable \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.srcCols == null) {
            args.add("srcCols \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.tarCols == null) {
            args.add("tarCols \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.srcDbType == null) {
            args.add("srcDbType \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.tarDbType == null) {
            args.add("tarDbType \u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String str : args) {
            if (buffer.length() > 0) {
                buffer.append(infoSplit);
            }
            buffer.append(str);
        }
        return buffer.toString();
    }

    private String checkDBType() {
        StringBuffer str = new StringBuffer();
        if (this.srcDbType.equals((Object)DBType.DB2)) {
            str.append("srcDbType \u4e0d\u80fd\u4e3aDB2");
        }
        if (this.tarDbType.equals((Object)DBType.DB2)) {
            if (str.length() > 0) {
                str.append(infoSplit);
            }
            str.append("tarDbType \u4e0d\u80fd\u4e3aDB2");
        }
        return str.toString();
    }

    private String checkFieldExist(DataTypeInfo dataTypeInfo, String info) {
        StringBuffer buffer = new StringBuffer();
        List<String> list = dataTypeInfo.getValueList();
        for (String str : list) {
            if (StringUtils.isEmpty((String)str)) {
                if (buffer.length() > 0) {
                    buffer.append(infoSplit);
                }
                buffer.append(info + " \u5b57\u6bb5\u5c5e\u6027\u6709\u7a7a\u503c");
            }
            try {
                if (this.mainTable.getColumn(str) != null) continue;
                if (buffer.length() > 0) {
                    buffer.append(infoSplit);
                }
                buffer.append(info + "\u5b57\u6bb5\u5c5e\u6027" + str + "\u5728mainTable\u4e2d\u4e0d\u5b58\u5728");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (buffer.length() > 0) {
                    buffer.append(infoSplit);
                }
                buffer.append(info + "\u5b57\u6bb5\u5c5e\u6027" + str + "\u5728mainTable\u4e2d\u4e0d\u5b58\u5728");
            }
        }
        return buffer.toString();
    }

    public Map<Integer, FieldDifferenceType> compareFields(int start, int end) {
        HashMap<Integer, FieldDifferenceType> diff = new HashMap<Integer, FieldDifferenceType>();
        if (start >= end) {
            return diff;
        }
        if (this.srcConvert == null) {
            this.srcConvert = DataTypeConverter.getConverter(this.srcDbType);
        }
        if (this.tarConvert == null) {
            this.tarConvert = DataTypeConverter.getConverter(this.tarDbType);
        }
        boolean isNeedPut = false;
        if (!StringUtils.isEmpty((String)this.resultCol)) {
            isNeedPut = true;
        }
        FieldDifferenceType rs = null;
        IRow row = null;
        for (int i = start; i < end; ++i) {
            row = this.mainTable.getRow(i);
            if (row == null) {
                diff.put(i, rs);
                continue;
            }
            rs = this.compareField(row);
            diff.put(i, rs);
            if (!isNeedPut) continue;
            row.getCell(this.resultCol).setValue((Object)rs.getAlias());
        }
        return diff;
    }

    private FieldDifferenceType compareField(IRow row) {
        SQLType tarType;
        SQLType srcType;
        block31: {
            Object srcTypeObj = row.getCell(this.srcCols.getDATA_TYPE()).getValue();
            Object tarTypeObj = row.getCell(this.tarCols.getDATA_TYPE()).getValue();
            if (srcTypeObj == null && tarTypeObj == null) {
                return FieldDifferenceType.notDiff;
            }
            if (srcTypeObj != null && tarTypeObj == null) {
                return FieldDifferenceType.srcMore;
            }
            if (srcTypeObj == null && tarTypeObj != null) {
                return FieldDifferenceType.tarMore;
            }
            srcType = null;
            tarType = null;
            try {
                srcType = SQLType.getEnum((String)srcTypeObj.toString());
                if (srcType == null) {
                    srcType = this.srcConvert.convert(srcTypeObj.toString());
                }
                if ((tarType = SQLType.getEnum((String)tarTypeObj.toString())) == null) {
                    tarType = this.tarConvert.convert(tarTypeObj.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (srcType == null) {
                    return FieldDifferenceType.tarMore;
                }
                if (tarType != null) break block31;
                return FieldDifferenceType.srcMore;
            }
        }
        if (!srcType.equals((Object)tarType)) {
            return this.compareSameMeaningField(srcType, tarType, row);
        }
        if (onlyTypes.contains(srcType)) {
            Object srcNullableObj = row.getCell(this.srcCols.getNULLABLE()).getValue();
            Object tarNullableObj = row.getCell(this.tarCols.getNULLABLE()).getValue();
            if (!StringUtils.equals((String)srcNullableObj.toString(), (String)tarNullableObj.toString())) {
                return FieldDifferenceType.nullableUnequals;
            }
            return FieldDifferenceType.notDiff;
        }
        Object srcLengthObj = row.getCell(this.srcCols.getDATA_LENGTH()).getValue();
        Object tarLengthObj = row.getCell(this.tarCols.getDATA_LENGTH()).getValue();
        int srcLength = 0;
        int tarLength = 0;
        if (srcLengthObj == null && tarLengthObj == null) {
            return FieldDifferenceType.notDiff;
        }
        try {
            if (srcLengthObj != null) {
                srcLength = Integer.valueOf(srcLengthObj.toString());
            }
            if (tarLengthObj != null) {
                tarLength = Integer.valueOf(tarLengthObj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((SQLType.CHAR.equals((Object)srcType) || SQLType.VARCHAR.equals((Object)srcType)) && srcLength > tarLength) {
            return FieldDifferenceType.lengthUnequals;
        }
        if (SQLType.INT.equals((Object)srcType) || SQLType.NUMERIC.equals((Object)srcType)) {
            Object srcPrecisionObj = row.getCell(this.srcCols.getDATA_PRECISION()).getValue();
            Object tarPrecisionObj = row.getCell(this.tarCols.getDATA_PRECISION()).getValue();
            int srcPrecision = 0;
            int tarPrecision = 0;
            if (srcPrecisionObj == null && tarPrecisionObj == null) {
                return FieldDifferenceType.notDiff;
            }
            try {
                if (srcPrecisionObj != null) {
                    srcPrecision = Integer.valueOf(srcPrecisionObj.toString());
                }
                if (tarPrecisionObj != null) {
                    tarPrecision = Integer.valueOf(tarPrecisionObj.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (srcPrecision > tarPrecision) {
                return FieldDifferenceType.scalaUnequals;
            }
            Object srcScaleObj = row.getCell(this.srcCols.getDATA_SCALE()).getValue();
            Object tarScaleObj = row.getCell(this.tarCols.getDATA_SCALE()).getValue();
            int srcScale = 0;
            int tarScale = 0;
            if (srcScaleObj == null && tarScaleObj == null) {
                return FieldDifferenceType.notDiff;
            }
            try {
                if (srcScaleObj != null) {
                    srcScale = Integer.valueOf(srcScaleObj.toString());
                }
                if (tarScaleObj != null) {
                    tarScale = Integer.valueOf(tarScaleObj.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (srcScale > tarScale) {
                return FieldDifferenceType.scalaUnequals;
            }
        }
        Object srcNullableObj = row.getCell(this.srcCols.getNULLABLE()).getValue();
        Object tarNullableObj = row.getCell(this.tarCols.getNULLABLE()).getValue();
        if (("0".equals(tarNullableObj) || "N".equals(tarNullableObj) || Boolean.FALSE.equals(tarNullableObj)) && ("1".equals(srcNullableObj) || "Y".equals(srcNullableObj) || Boolean.TRUE.equals(srcNullableObj))) {
            return FieldDifferenceType.nullableUnequals;
        }
        return FieldDifferenceType.notDiff;
    }

    private FieldDifferenceType compareSameMeaningField(SQLType srcType, SQLType tarType, IRow row) {
        Object srcLengthObj = row.getCell(this.srcCols.getDATA_LENGTH()).getValue();
        Object tarLengthObj = row.getCell(this.tarCols.getDATA_LENGTH()).getValue();
        int srcLength = 0;
        int tarLength = 0;
        try {
            if (srcLengthObj != null) {
                srcLength = Integer.valueOf(srcLengthObj.toString());
            }
            if (tarLengthObj != null) {
                tarLength = Integer.valueOf(tarLengthObj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object srcPrecisionObj = row.getCell(this.srcCols.getDATA_PRECISION()).getValue();
        Object tarPrecisionObj = row.getCell(this.tarCols.getDATA_PRECISION()).getValue();
        int srcPrecision = 0;
        int tarPrecision = 0;
        try {
            if (srcPrecisionObj != null) {
                srcPrecision = Integer.valueOf(srcPrecisionObj.toString());
            }
            if (tarPrecisionObj != null) {
                tarPrecision = Integer.valueOf(tarPrecisionObj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object srcScaleObj = row.getCell(this.srcCols.getDATA_SCALE()).getValue();
        Object tarScaleObj = row.getCell(this.tarCols.getDATA_SCALE()).getValue();
        int srcScale = 0;
        int tarScale = 0;
        try {
            if (srcScaleObj != null) {
                srcScale = Integer.valueOf(srcScaleObj.toString());
            }
            if (tarScaleObj != null) {
                tarScale = Integer.valueOf(tarScaleObj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (SQLType.INT.equals((Object)srcType)) {
            if (SQLType.NUMERIC.equals((Object)tarType) && srcPrecision <= tarPrecision && srcScale <= tarScale) {
                return FieldDifferenceType.notDiff;
            }
            return FieldDifferenceType.scalaUnequals;
        }
        if (SQLType.NUMERIC.equals((Object)srcType)) {
            if (SQLType.INT.equals((Object)tarType) && srcPrecision <= tarPrecision && srcScale <= tarScale) {
                return FieldDifferenceType.notDiff;
            }
            return FieldDifferenceType.typeUnequals;
        }
        if (SQLType.CHAR.equals((Object)srcType)) {
            if (SQLType.NCHAR.equals((Object)tarType) && srcPrecision <= tarPrecision && srcScale <= tarScale) {
                return FieldDifferenceType.notDiff;
            }
            if ((SQLType.VARCHAR.equals((Object)tarType) || SQLType.NVARCHAR.equals((Object)tarType)) && srcLength <= (tarLength = this.getVarcharLength(this.tarDbType, tarLength, tarPrecision))) {
                return FieldDifferenceType.notDiff;
            }
            return FieldDifferenceType.typeUnequals;
        }
        if (SQLType.NCHAR.equals((Object)srcType)) {
            if (SQLType.NVARCHAR.equals((Object)tarType) && srcLength <= (tarLength = this.getVarcharLength(this.tarDbType, tarLength, tarPrecision))) {
                return FieldDifferenceType.notDiff;
            }
            return FieldDifferenceType.typeUnequals;
        }
        if (SQLType.VARCHAR.equals((Object)srcType)) {
            srcLength = this.getVarcharLength(this.srcDbType, srcLength, srcPrecision);
            if ((SQLType.CHAR.equals((Object)tarType) || SQLType.NCHAR.equals((Object)tarType)) && srcLength <= tarLength) {
                return FieldDifferenceType.notDiff;
            }
            if (SQLType.NVARCHAR.equals((Object)tarType) && srcLength <= (tarLength = this.getVarcharLength(this.tarDbType, tarLength, tarPrecision))) {
                return FieldDifferenceType.notDiff;
            }
            return FieldDifferenceType.typeUnequals;
        }
        if (SQLType.NVARCHAR.equals((Object)srcType)) {
            srcLength = this.getVarcharLength(this.srcDbType, srcLength, srcPrecision);
            if (SQLType.NCHAR.equals((Object)tarType) && srcLength <= tarLength) {
                return FieldDifferenceType.notDiff;
            }
            return FieldDifferenceType.typeUnequals;
        }
        return FieldDifferenceType.typeUnequals;
    }

    private int getVarcharLength(DBType dbType, int length, int precision) {
        return length;
    }

    static {
        onlyTypes.add(SQLType.BINARY);
        onlyTypes.add(SQLType.VARBINARY);
        onlyTypes.add(SQLType.BLOB);
        onlyTypes.add(SQLType.CLOB);
        onlyTypes.add(SQLType.NCLOB);
        onlyTypes.add(SQLType.DATETIME);
    }
}

