/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.util.StringUtils;

public class DataTypeConverter {
    private static DB2 instanceDB2 = new DB2();
    private static ORACLE instanceORACLE = new ORACLE();
    private static ORACLE10 instanceORACLE10 = new ORACLE10();
    private static ORACLE9 instanceORACLE9 = new ORACLE9();
    private static MSSQL instanceMSSQL = new MSSQL();
    private static MYSQL instanceMYSQL = new MYSQL();
    private static PGSQL instancePGSQL = new PGSQL();

    public SQLType convert(String type) {
        return null;
    }

    String getTableName(String tabName) {
        if (StringUtils.isEmpty((String)tabName)) {
            throw new NullPointerException("tableName is empty !");
        }
        if (tabName.charAt(0) != '\"') {
            tabName = tabName.toUpperCase();
        }
        return tabName;
    }

    public String getColumnDefinedSql(String tabName) {
        return "SHOW COLUMNS FROM " + this.getTableName(tabName);
    }

    public static DataTypeConverter getDataType(int dbtype) {
        switch (dbtype) {
            case 1: {
                return instanceDB2;
            }
            case 2: {
                return instanceORACLE;
            }
            case 7: {
                return instanceORACLE9;
            }
            case 8: {
                return instanceORACLE10;
            }
            case 3: {
                return instanceMSSQL;
            }
            case 6: {
                return instanceMYSQL;
            }
            case 5: {
                return instancePGSQL;
            }
        }
        throw new RuntimeException("unsupported DbType '" + dbtype + "'");
    }

    public static DataTypeConverter getConverter(DBType dbTypeEnum) {
        int dbType = DataTypeConverter.convertDBType(dbTypeEnum);
        return DataTypeConverter.getDataType(dbType);
    }

    private static int convertDBType(DBType dbTypeEnum) {
        if (DBType.SQLServer.equals((Object)dbTypeEnum)) {
            return 3;
        }
        if (DBType.Oracle.equals((Object)dbTypeEnum)) {
            return 2;
        }
        if (DBType.MySql.equals((Object)dbTypeEnum)) {
            return 6;
        }
        if (DBType.PostgreSQL.equals((Object)dbTypeEnum)) {
            return 5;
        }
        if (DBType.DB2.equals((Object)dbTypeEnum)) {
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301 DB2 ");
        }
        return 3;
    }

    static class ORACLE10
    extends ORACLE9 {
        ORACLE10() {
        }
    }

    static class ORACLE9
    extends ORACLE {
        ORACLE9() {
        }
    }

    static class ORACLE
    extends DataTypeConverter {
        ORACLE() {
        }

        @Override
        public SQLType convert(String type) {
            if ("VARCHAR2".equalsIgnoreCase(type)) {
                return SQLType.VARCHAR;
            }
            if ("VARCHAR".equalsIgnoreCase(type)) {
                return SQLType.VARCHAR;
            }
            if ("NVARCHAR2".equalsIgnoreCase(type)) {
                return SQLType.NVARCHAR;
            }
            if ("CHAR".equalsIgnoreCase(type)) {
                return SQLType.NVARCHAR;
            }
            if ("NCHAR".equalsIgnoreCase(type)) {
                return SQLType.NVARCHAR;
            }
            if ("NUMBER".equalsIgnoreCase(type)) {
                return SQLType.NUMERIC;
            }
            if ("LONG".equalsIgnoreCase(type) || "INT".equalsIgnoreCase(type)) {
                return SQLType.INT;
            }
            if ("DATE".equalsIgnoreCase(type)) {
                return SQLType.DATETIME;
            }
            if (type.matches("(?i)TIMESTAMP\\(\\d+\\)")) {
                return SQLType.DATETIME;
            }
            if ("CLOB".equalsIgnoreCase(type)) {
                return SQLType.CLOB;
            }
            if ("BLOB".equalsIgnoreCase(type)) {
                return SQLType.BLOB;
            }
            if ("NCLOB".equalsIgnoreCase(type)) {
                return SQLType.NCLOB;
            }
            if ("RAW".equalsIgnoreCase(type)) {
                return SQLType.BINARY;
            }
            if ("LONG RAW".equalsIgnoreCase(type)) {
                return SQLType.VARBINARY;
            }
            throw new RuntimeException("unsupported type in Oracle : '" + type + "'");
        }

        @Override
        public String getColumnDefinedSql(String tabName) {
            return "select COLUMN_NAME, DATA_TYPE, DATA_LENGTH, DEFAULT_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, TABLE_NAME from USER_TAB_COLUMNS where table_name = '" + this.getTableName(tabName) + "' ORDER BY COLUMN_ID";
        }
    }

    static class MSSQL
    extends DataTypeConverter {
        MSSQL() {
        }

        @Override
        public SQLType convert(String type) {
            if ("bit".equalsIgnoreCase(type)) {
                return SQLType.INT;
            }
            if ("int".equalsIgnoreCase(type)) {
                return SQLType.INT;
            }
            if ("smallint".equalsIgnoreCase(type)) {
                return SQLType.INT;
            }
            if ("tinyint".equalsIgnoreCase(type)) {
                return SQLType.INT;
            }
            if ("numeric".equalsIgnoreCase(type)) {
                return SQLType.NUMERIC;
            }
            if ("decimal".equalsIgnoreCase(type)) {
                return SQLType.NUMERIC;
            }
            if ("float".equalsIgnoreCase(type)) {
                return SQLType.NUMERIC;
            }
            if ("real".equalsIgnoreCase(type)) {
                return SQLType.NUMERIC;
            }
            if ("datetime".equalsIgnoreCase(type)) {
                return SQLType.DATETIME;
            }
            if ("smalldatetime".equalsIgnoreCase(type)) {
                return SQLType.DATETIME;
            }
            if ("char".equalsIgnoreCase(type)) {
                return SQLType.CHAR;
            }
            if ("varchar".equalsIgnoreCase(type)) {
                return SQLType.NVARCHAR;
            }
            if ("varchar2".equalsIgnoreCase(type)) {
                return SQLType.NVARCHAR;
            }
            if ("text".equalsIgnoreCase(type)) {
                return SQLType.CLOB;
            }
            if ("nchar".equalsIgnoreCase(type)) {
                return SQLType.NCHAR;
            }
            if ("nvarchar".equalsIgnoreCase(type)) {
                return SQLType.NVARCHAR;
            }
            if ("ntext".equalsIgnoreCase(type)) {
                return SQLType.NCLOB;
            }
            if ("money".equalsIgnoreCase(type)) {
                return SQLType.NUMERIC;
            }
            if ("smallmoney".equalsIgnoreCase(type)) {
                return SQLType.NUMERIC;
            }
            if ("binary".equalsIgnoreCase(type)) {
                return SQLType.BLOB;
            }
            if ("varbinary".equalsIgnoreCase(type)) {
                return SQLType.BLOB;
            }
            if ("image".equalsIgnoreCase(type)) {
                return SQLType.BLOB;
            }
            if ("bigint".equalsIgnoreCase(type)) {
                return SQLType.NUMERIC;
            }
            throw new RuntimeException("unsupported type in MSSQL : '" + type + "'");
        }
    }

    static class MYSQL
    extends DataTypeConverter {
        MYSQL() {
        }

        @Override
        public SQLType convert(String type) {
            if ("SMALLINT".equalsIgnoreCase(type) || "INT".equalsIgnoreCase(type) || "TINYINT".equalsIgnoreCase(type) || "MEDIUMINT".equalsIgnoreCase(type) || "BIGINT".equalsIgnoreCase(type)) {
                return SQLType.INT;
            }
            if ("DATE".equalsIgnoreCase(type) || "DATETIME".equalsIgnoreCase(type) || "TIMESTAMP".equalsIgnoreCase(type)) {
                return SQLType.DATETIME;
            }
            if ("CHAR".equalsIgnoreCase(type)) {
                return SQLType.CHAR;
            }
            if ("VARCHAR".equalsIgnoreCase(type)) {
                return SQLType.VARCHAR;
            }
            if ("TINYTEXT".equalsIgnoreCase(type) || "TEXT".equalsIgnoreCase(type) || "MEDIUMTEXT".equalsIgnoreCase(type)) {
                return SQLType.CLOB;
            }
            if ("LONGTEXT".equalsIgnoreCase(type)) {
                return SQLType.NCLOB;
            }
            if ("NUMERIC".equalsIgnoreCase(type) || "DECIMAL".equalsIgnoreCase(type) || "FLOAT".equalsIgnoreCase(type) || "DOUBLE".equalsIgnoreCase(type)) {
                return SQLType.NUMERIC;
            }
            if ("BLOB".equalsIgnoreCase(type)) {
                return SQLType.BLOB;
            }
            throw new RuntimeException("unsupported type in MYSQL : '" + type + "'");
        }

        @Override
        public String getColumnDefinedSql(String tabName) {
            return "SELECT COLUMN_NAME,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH,NUMERIC_PRECISION,NUMERIC_SCALE,IS_NULLABLE,TABLE_NAME from information_schema.columns where table_name = '" + tabName + "'";
        }
    }

    static class DB2
    extends DataTypeConverter {
        DB2() {
        }

        @Override
        public SQLType convert(String type) {
            if ("SMALLINT".equalsIgnoreCase(type)) {
                return SQLType.INT;
            }
            if ("TIMESTAMP".equalsIgnoreCase(type)) {
                return SQLType.DATETIME;
            }
            if ("VARGRAPHIC".equalsIgnoreCase(type)) {
                return SQLType.NVARCHAR;
            }
            if ("GRAPHIC".equalsIgnoreCase(type)) {
                return SQLType.NCHAR;
            }
            if ("CLOB".equalsIgnoreCase(type)) {
                return SQLType.NCLOB;
            }
            if ("VARCHAR".equalsIgnoreCase(type)) {
                return SQLType.BINARY;
            }
            if ("VARCHAR".equalsIgnoreCase(type)) {
                return SQLType.VARBINARY;
            }
            if ("INT".equalsIgnoreCase(type)) {
                return SQLType.INT;
            }
            throw new RuntimeException("unsupported type in DB2 : '" + type + "'");
        }
    }

    static class PGSQL
    extends DataTypeConverter {
        PGSQL() {
        }

        @Override
        public SQLType convert(String type) {
            if (!type.isEmpty()) {
                type = type.replace("\"", "");
            }
            if ("VARCHAR".equalsIgnoreCase(type) || "character varying".equalsIgnoreCase(type)) {
                return SQLType.VARCHAR;
            }
            if ("timestamp".equalsIgnoreCase(type) || "timestamp without time zone".equalsIgnoreCase(type) || "DATE".equalsIgnoreCase(type) || type.matches("(?i)TIMESTAMP\\(\\d+\\)")) {
                return SQLType.DATETIME;
            }
            if ("NVARCHAR2".equalsIgnoreCase(type) || "NCHAR".equalsIgnoreCase(type) || "VARCHAR2".equalsIgnoreCase(type)) {
                return SQLType.NVARCHAR;
            }
            if ("NUMBER".equalsIgnoreCase(type) || "numeric".equalsIgnoreCase(type) || "double precision".equalsIgnoreCase(type)) {
                return SQLType.NUMERIC;
            }
            if ("LONG".equalsIgnoreCase(type) || "INT".equalsIgnoreCase(type) || "INTEGER".equalsIgnoreCase(type)) {
                return SQLType.INT;
            }
            if ("CLOB".equalsIgnoreCase(type) || "BLOB".equalsIgnoreCase(type)) {
                return SQLType.CLOB;
            }
            if ("NCLOB".equalsIgnoreCase(type)) {
                return SQLType.NCLOB;
            }
            if ("RAW".equalsIgnoreCase(type)) {
                return SQLType.BINARY;
            }
            if ("LONG RAW".equalsIgnoreCase(type)) {
                return SQLType.VARBINARY;
            }
            if ("character".equalsIgnoreCase(type) || "char".equalsIgnoreCase(type)) {
                return SQLType.CHAR;
            }
            if ("text".equalsIgnoreCase(type)) {
                return SQLType.BLOB;
            }
            throw new RuntimeException("unsupported type in PG : '" + type + "'");
        }
    }
}

