/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.utils;

import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class ViewSQLSimpleParser {
    private String sql;
    private ArrayList<ViewParseResult> parseResults;

    public ViewSQLSimpleParser(String sql) {
        if (sql == null) {
            throw new NullPointerException();
        }
        this.sql = sql;
    }

    public synchronized ArrayList<ViewParseResult> getParseResult() {
        if (this.parseResults == null) {
            this.parseResults = new ArrayList();
            this.parse();
            int i = 0;
            while (i < this.parseResults.size()) {
                if (StringUtils.isEmpty((String)this.parseResults.get((int)i).viewSql)) {
                    this.parseResults.remove(i);
                    continue;
                }
                ++i;
            }
        }
        return this.parseResults;
    }

    private void parse() {
        int NULL;
        int len = this.sql.length();
        int index = 0;
        int nextIndex = -1;
        int priorChar = NULL = 0;
        int inInnerContext = 0;
        boolean inInnerEnd = false;
        StringBuffer viewSqlBuf = new StringBuffer();
        String priorWord = null;
        StringBuffer word = null;
        int wordIndex = 0;
        ViewParseResult parseResult = new ViewParseResult();
        this.parseResults.add(parseResult);
        while (index < len) {
            char currentChar = this.sql.charAt(index);
            int skip = 1;
            nextIndex = index + 1;
            if (currentChar == '\'') {
                if (inInnerContext == 0) {
                    inInnerContext = 1;
                } else if (inInnerContext == 1) {
                    if (nextIndex < len && this.sql.charAt(nextIndex) == '\'') {
                        skip = 2;
                    } else {
                        inInnerEnd = true;
                    }
                }
            } else if (currentChar == '\"') {
                if (inInnerContext == 0) {
                    inInnerContext = 2;
                } else if (inInnerContext == 2) {
                    if (nextIndex < len && this.sql.charAt(nextIndex) == '\"') {
                        skip = 2;
                    } else {
                        inInnerEnd = true;
                    }
                }
            } else if (currentChar == '-') {
                if (nextIndex < len && this.sql.charAt(nextIndex) == '-') {
                    inInnerContext = 3;
                    skip = 2;
                }
            } else if (currentChar == '/') {
                if (nextIndex < len && this.sql.charAt(nextIndex) == '*') {
                    inInnerContext = 4;
                    skip = 2;
                } else if (priorChar == 42 && inInnerContext == 4) {
                    inInnerEnd = true;
                }
            } else if (currentChar == '\n' && inInnerContext > 0 && inInnerContext <= 3) {
                inInnerEnd = true;
            }
            boolean isNewSql = false;
            while (skip-- > 0) {
                char c = this.sql.charAt(index);
                if (inInnerContext < 3) {
                    if (inInnerContext == 1 || inInnerContext == 2) {
                        if (word == null) {
                            word = new StringBuffer();
                            ++wordIndex;
                        }
                        word.append(c);
                    } else if (c <= ' ' || c == ',' || c == '(' || c == ')') {
                        String currentWord = null;
                        if (word != null && word.length() > 0) {
                            currentWord = word.toString();
                            if (wordIndex <= 3) {
                                parseResult.addFrontWord(currentWord);
                            }
                            if ("as".equalsIgnoreCase(priorWord)) {
                                if ("headpk".equalsIgnoreCase(currentWord) || "\"headpk\"".equalsIgnoreCase(currentWord)) {
                                    parseResult.hasHeadpk = true;
                                    parseResult.headpkName = currentWord;
                                } else if ("entrypk".equalsIgnoreCase(currentWord) || "\"entrypk\"".equalsIgnoreCase(currentWord)) {
                                    parseResult.hasEntrypk = true;
                                }
                            }
                            priorWord = currentWord;
                            word = null;
                        }
                    } else if (c == ';' || c == '\uff1b') {
                        parseResult.viewSql = viewSqlBuf.toString().trim();
                        viewSqlBuf = new StringBuffer();
                        parseResult = new ViewParseResult();
                        this.parseResults.add(parseResult);
                        wordIndex = 0;
                        priorWord = null;
                        word = null;
                        priorChar = NULL;
                        inInnerContext = 0;
                        inInnerEnd = false;
                        isNewSql = true;
                    } else {
                        if (word == null) {
                            word = new StringBuffer();
                            ++wordIndex;
                        }
                        word.append(c);
                    }
                    if (!isNewSql) {
                        viewSqlBuf.append(c);
                    }
                } else if (c == '\n') {
                    viewSqlBuf.append(c);
                }
                priorChar = c;
                ++index;
            }
            if (inInnerEnd) {
                inInnerContext = 0;
                inInnerEnd = false;
            }
            if (index != len || parseResult.viewSql != null) continue;
            parseResult.viewSql = viewSqlBuf.toString().trim();
        }
    }

    public static class ViewParseResult {
        public String viewSql;
        public String viewName;
        public boolean hasHeadpk;
        public boolean hasEntrypk;
        public String headpkName;
        private ArrayList<String> frontWords = new ArrayList();

        public void addFrontWord(String word) {
            if (this.frontWords.size() == 2 && this.isCreateViewSql()) {
                this.viewName = word;
            }
            this.frontWords.add(word);
        }

        public String toString() {
            return "viewName:" + this.viewName + ",hasHeadpk:" + this.hasHeadpk + ",hasEntrypk:" + this.hasEntrypk + ",frontWords:" + this.frontWords;
        }

        public String getFrontWordString() {
            StringBuffer sb = new StringBuffer();
            for (String frontWord : this.frontWords) {
                sb.append(frontWord).append(" ");
            }
            sb.append("...");
            return sb.toString();
        }

        public boolean isCreateViewSql() {
            if (this.frontWords.size() < 2) {
                return false;
            }
            return "create".equalsIgnoreCase(this.frontWords.get(0)) && "view".equalsIgnoreCase(this.frontWords.get(1));
        }
    }
}

