/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.model;

import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.webservice.app.model.WSColumnModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WSTableModel
implements Serializable {
    private static final long serialVersionUID = 4984100858533057477L;
    public static final int RELATION_NONE = -1;
    public static final int RELATION_ONE_TO_MANY = 1;
    public static final int RELATION_MANY_TO_ONE = 2;
    public final String name;
    public final WSColumnModel[] columns;
    public final WSColumnModel pkColumn;
    public String srcEntity;
    public String desEntiry;
    public WSColumnModel[] baseDataTypes;
    private transient Map tableRelations;

    public WSTableModel(String srcName, WSColumnModel[] columns, String srcEntity, String desEntiry) {
        this.name = srcName;
        this.srcEntity = srcEntity;
        this.desEntiry = desEntiry;
        WSColumnModel pkColumn = null;
        ArrayList<WSColumnModel> _columns = new ArrayList<WSColumnModel>();
        ArrayList<WSColumnModel> baseDataTypes = new ArrayList<WSColumnModel>();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].isPk) {
                pkColumn = columns[i];
                _columns.add(0, columns[i]);
            } else {
                _columns.add(columns[i]);
            }
            if (columns[i].baseDataType == null) continue;
            baseDataTypes.add(columns[i]);
        }
        this.columns = _columns.toArray(new WSColumnModel[0]);
        this.pkColumn = pkColumn;
        this.baseDataTypes = baseDataTypes.toArray(new WSColumnModel[0]);
    }

    void addRelation(WSTableModel relationTable, int relation) throws DIPException {
        switch (relation) {
            case 1: {
                break;
            }
            case 2: {
                if (this.tableRelations == null) {
                    this.tableRelations = new HashMap();
                }
                this.tableRelations.put(relationTable, new Integer(relation));
                break;
            }
            default: {
                throw new DIPException("\u672a\u77e5\u5173\u7cfb\u503c'" + relation + "'");
            }
        }
    }

    Map getTableRelations() {
        return this.tableRelations;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return ((WSTableModel)obj).name.equals(this.name);
    }

    public String toString() {
        return this.name;
    }

    public String getSrcEntity() {
        return this.srcEntity;
    }

    public void setSrcEntity(String srcEntity) {
        this.srcEntity = srcEntity;
    }

    public String getDesEntiry() {
        return this.desEntiry;
    }

    public void setDesEntiry(String desEntiry) {
        this.desEntiry = desEntiry;
    }

    public WSColumnModel[] getBaseDataTypes() {
        return this.baseDataTypes;
    }

    public void setBaseDataTypes(WSColumnModel[] baseDataTypes) {
        this.baseDataTypes = baseDataTypes;
    }

    public String getName() {
        return this.name;
    }

    public WSColumnModel[] getColumns() {
        return this.columns;
    }

    public WSColumnModel getPkColumn() {
        return this.pkColumn;
    }
}

