/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.converter;

import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceCollection;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.converter.ConverterUtil;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class WSInterfaceCollectionConverter
extends AbstractDataBaseInfoConverter {
    @Override
    public boolean canConvert(Class type) {
        return WSInterfaceCollection.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        WSInterfaceCollection coll = (WSInterfaceCollection)((Object)source);
        Element root = new Element(((Object)((Object)coll)).getClass().getName());
        Iterator ites = coll.iterator();
        int current = 1;
        int total = coll.size();
        while (ites.hasNext()) {
            WSInterfaceInfo info = (WSInterfaceInfo)ites.next();
            ConverterUtil.currentPlan(info, current, total);
            this.marshalInterface(root, info, context);
            ConverterUtil.currentPercent(current++, total);
        }
        return root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        WSInterfaceCollection collInfo = new WSInterfaceCollection();
        List children = data.getChildren();
        this.unmarshallWSInterface(children, collInfo, context);
        return collInfo;
    }

    private void unmarshallWSInterface(List<Element> children, WSInterfaceCollection info, UnmarshallingContext context) {
        for (int i = 0; i < children.size(); ++i) {
            Element data = children.get(i);
            if (null == data) continue;
            WSInterfaceInfo item = (WSInterfaceInfo)context.unmarshall(data);
            info.add(item);
        }
    }

    private void marshalInterface(Element root, WSInterfaceInfo info, MarshallingContext context) {
        if (null == info) {
            return;
        }
        Object object = context.marshall(info);
        this.addChild(root, (Element)object);
    }

    private void marshalInterfaceSelf(Element root, WSInterfaceInfo info, MarshallingContext context) {
        if (null == info) {
            return;
        }
        Object object = context.marshall(info);
        this.addChild(root, info.getClass().getName(), (Element)object);
    }

    private void marshalBillMapping(Element root, WSInterfaceInfo info, MarshallingContext context) {
        WSBillMappingInfo billInfo = info.getWsbillMapping();
        if (null == billInfo) {
            return;
        }
        Object object = context.marshall(billInfo);
        this.addChild(root, billInfo.getClass().getName(), (Element)object);
    }

    private void marshalQueryMarker(Element root, WSInterfaceInfo info, MarshallingContext context) {
        WSFreeMarkerInfo queryMarker = info.getQueryFreeMarker();
        if (null == queryMarker) {
            return;
        }
        Object object = context.marshall(queryMarker);
        this.addChild(root, queryMarker.getClass().getName(), (Element)object);
    }

    private void marshalReturnMarker(Element root, WSInterfaceInfo info, MarshallingContext context) {
        WSFreeMarkerInfo returnMarker = info.getFreeMarker();
        if (null == returnMarker) {
            return;
        }
        Object object = context.marshall(returnMarker);
        this.addChild(root, returnMarker.getClass().getName(), (Element)object);
    }

    private void marshalService(Element root, WSInterfaceInfo info, MarshallingContext context) {
        WSServiceInfo service = info.getWebservice();
        if (null == service) {
            return;
        }
        Object object = context.marshall(service);
        this.addChild(root, service.getClass().getName(), (Element)object);
    }
}

