/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.analysis;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.ep.analysis.CharFilter;
import org.apache.lucene.ep.analysis.CharStream;

public abstract class BaseCharFilter
extends CharFilter {
    private List pcmList;

    public BaseCharFilter(CharStream in) {
        super(in);
    }

    @Override
    protected int correct(int currentOff) {
        if (this.pcmList == null || this.pcmList.isEmpty()) {
            return currentOff;
        }
        for (int i = this.pcmList.size() - 1; i >= 0; --i) {
            if (currentOff < ((OffCorrectMap)this.pcmList.get((int)i)).off) continue;
            return currentOff + ((OffCorrectMap)this.pcmList.get((int)i)).cumulativeDiff;
        }
        return currentOff;
    }

    protected int getLastCumulativeDiff() {
        return this.pcmList == null || this.pcmList.isEmpty() ? 0 : ((OffCorrectMap)this.pcmList.get((int)(this.pcmList.size() - 1))).cumulativeDiff;
    }

    protected void addOffCorrectMap(int off, int cumulativeDiff) {
        if (this.pcmList == null) {
            this.pcmList = new ArrayList();
        }
        this.pcmList.add(new OffCorrectMap(off, cumulativeDiff));
    }

    static class OffCorrectMap {
        int off;
        int cumulativeDiff;

        OffCorrectMap(int off, int cumulativeDiff) {
            this.off = off;
            this.cumulativeDiff = cumulativeDiff;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            sb.append(this.off);
            sb.append(',');
            sb.append(this.cumulativeDiff);
            sb.append(')');
            return sb.toString();
        }
    }
}

