/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.index.TermDocs;
import org.apache.lucene.ep.index.TermEnum;
import org.apache.lucene.ep.search.DocIdSet;
import org.apache.lucene.ep.search.Filter;
import org.apache.lucene.ep.search.FilteredTermEnum;
import org.apache.lucene.ep.search.MultiTermQuery;
import org.apache.lucene.ep.util.OpenBitSet;

public class MultiTermQueryWrapperFilter
extends Filter {
    protected final MultiTermQuery query;

    protected MultiTermQueryWrapperFilter(MultiTermQuery query) {
        this.query = query;
    }

    public String toString() {
        return this.query.toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass().equals(o.getClass())) {
            return this.query.equals(((MultiTermQueryWrapperFilter)o).query);
        }
        return false;
    }

    public final int hashCode() {
        return this.query.hashCode();
    }

    public int getTotalNumberOfTerms() {
        return this.query.getTotalNumberOfTerms();
    }

    public void clearTotalNumberOfTerms() {
        this.query.clearTotalNumberOfTerms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BitSet bits(IndexReader reader) throws IOException {
        try (FilteredTermEnum enumerator = this.query.getEnum(reader);){
            final BitSet bitSet = new BitSet(reader.maxDoc());
            new TermGenerator(){

                @Override
                public void handleDoc(int doc) {
                    bitSet.set(doc);
                }
            }.generate(reader, enumerator);
            BitSet bitSet2 = bitSet;
            return bitSet2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        try (FilteredTermEnum enumerator = this.query.getEnum(reader);){
            if (((TermEnum)enumerator).term() == null) {
                DocIdSet docIdSet = DocIdSet.EMPTY_DOCIDSET;
                return docIdSet;
            }
            final OpenBitSet bitSet = new OpenBitSet(reader.maxDoc());
            new TermGenerator(){

                @Override
                public void handleDoc(int doc) {
                    bitSet.set(doc);
                }
            }.generate(reader, enumerator);
            OpenBitSet openBitSet = bitSet;
            return openBitSet;
        }
    }

    abstract class TermGenerator {
        TermGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generate(IndexReader reader, TermEnum enumerator) throws IOException {
            int[] docs = new int[32];
            int[] freqs = new int[32];
            try (TermDocs termDocs = reader.termDocs();){
                Term term;
                int termCount = 0;
                while ((term = enumerator.term()) != null) {
                    int count;
                    ++termCount;
                    termDocs.seek(term);
                    while ((count = termDocs.read(docs, freqs)) != 0) {
                        for (int i = 0; i < count; ++i) {
                            this.handleDoc(docs[i]);
                        }
                    }
                    if (enumerator.next()) continue;
                }
                MultiTermQueryWrapperFilter.this.query.incTotalNumberOfTerms(termCount);
            }
        }

        public abstract void handleDoc(int var1);
    }
}

