/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search.function;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.function.DocValues;
import org.apache.lucene.ep.search.function.ValueSource;
import org.apache.lucene.ep.util.ReaderUtil;

public final class MultiValueSource
extends ValueSource {
    final ValueSource other;

    public MultiValueSource(ValueSource other) {
        this.other = other;
    }

    @Override
    public DocValues getValues(IndexReader reader) throws IOException {
        IndexReader[] subReaders = reader.getSequentialSubReaders();
        if (subReaders != null) {
            return new MultiDocValues(subReaders);
        }
        return this.other.getValues(reader);
    }

    @Override
    public String description() {
        return this.other.description();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MultiValueSource) {
            return ((MultiValueSource)o).other.equals(this.other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.other.hashCode();
    }

    private final class MultiDocValues
    extends DocValues {
        final DocValues[] docValues;
        final int[] docStarts;

        MultiDocValues(IndexReader[] subReaders) throws IOException {
            this.docValues = new DocValues[subReaders.length];
            this.docStarts = new int[subReaders.length];
            int base = 0;
            for (int i = 0; i < subReaders.length; ++i) {
                this.docValues[i] = MultiValueSource.this.other.getValues(subReaders[i]);
                this.docStarts[i] = base;
                base += subReaders[i].maxDoc();
            }
        }

        @Override
        public float floatVal(int doc) {
            int n = ReaderUtil.subIndex(doc, this.docStarts);
            return this.docValues[n].floatVal(doc - this.docStarts[n]);
        }

        @Override
        public int intVal(int doc) {
            int n = ReaderUtil.subIndex(doc, this.docStarts);
            return this.docValues[n].intVal(doc - this.docStarts[n]);
        }

        @Override
        public long longVal(int doc) {
            int n = ReaderUtil.subIndex(doc, this.docStarts);
            return this.docValues[n].longVal(doc - this.docStarts[n]);
        }

        @Override
        public double doubleVal(int doc) {
            int n = ReaderUtil.subIndex(doc, this.docStarts);
            return this.docValues[n].doubleVal(doc - this.docStarts[n]);
        }

        @Override
        public String strVal(int doc) {
            int n = ReaderUtil.subIndex(doc, this.docStarts);
            return this.docValues[n].strVal(doc - this.docStarts[n]);
        }

        @Override
        public String toString(int doc) {
            int n = ReaderUtil.subIndex(doc, this.docStarts);
            return this.docValues[n].toString(doc - this.docStarts[n]);
        }

        @Override
        public Explanation explain(int doc) {
            int n = ReaderUtil.subIndex(doc, this.docStarts);
            return this.docValues[n].explain(doc - this.docStarts[n]);
        }
    }
}

