/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.Context2;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.spi.SPInfo;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IBaseEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.dap.IDAPTransformerWrapper;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvAgentRpcHelper;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.FrameHelperFacadeFactory;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.IFrameHelperFacade;
import com.kingdee.eas.framework.app.UIHandlerPermissionHelper;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.config.IUserCustomConfig;
import com.kingdee.eas.framework.config.UserCustomConfigFactory;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaseFrameService {
    private static final Logger logger = Logger.getLogger(BaseFrameService.class);

    public static BaseFrameService getInstance() {
        return new BaseFrameService();
    }

    public static ResponseContext getMultiKey(ResponseContext response, Class modelClass, String methodName, Class[] params, Object[] paramValue, Object value) throws Exception {
        if (response == null) {
            response = new ResponseContext();
        }
        Method method = modelClass.getMethod(methodName, params);
        response.put(MultiParamKey.create((Class)modelClass, (Method)method, (Object[])paramValue).toString(), value);
        return response;
    }

    public static boolean isSessionItem(String key, String sessionId) throws Exception {
        if (key == null) {
            return false;
        }
        ISessionManager sessionManager = SessionManager.getInstance();
        SessionInfo session = sessionManager.getSessionWithException(sessionId);
        Boolean bool = (Boolean)session.get((Object)key);
        return bool != null && bool != false;
    }

    public static void putSessionItem(String key, String sessionId) throws Exception {
        if (key == null) {
            return;
        }
        ISessionManager sessionManager = SessionManager.getInstance();
        SessionInfo session = sessionManager.getSessionWithException(sessionId);
        session.put((Object)key, (Object)Boolean.TRUE);
    }

    public Context switchMainOrg(RequestContext request, ResponseContext response, Context context) throws Exception {
        if (request.getOrg() != null && request.getMainOrgType() != null) {
            Context ctx = new Context();
            String orgId = request.getOrg().toString();
            IOrgSwitchFacade switchOrg = OrgSwitchFacadeFactory.getLocalInstance((Context)context);
            HashMap map = switchOrg.getSwitchOrgs(orgId);
            FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)map.get("CurOU");
            FrameWorkUtils.setCurrentOrgUnit(ctx, (OrgUnitInfo)ouInfo);
            for (OrgType orgType : OrgType.getEnumList()) {
                OrgUnitInfo orgUnitInfo = (OrgUnitInfo)map.get(orgType);
                if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType)) continue;
                FrameWorkUtils.setCurrentOrgUnit(ctx, orgType, orgUnitInfo);
            }
            OrgUnitInfo orginfo = FrameWorkUtils.getCurrentOrgUnit(ctx, request.getMainOrgType());
            request.setMainOrg(orginfo == null ? null : orginfo.getId().toString());
            BaseFrameService.mergContext2(ctx, context);
        }
        return null;
    }

    public static void mergContext2(Context objectctx, Context context) {
        if (objectctx != null) {
            Context2 ctx2 = null;
            if (context instanceof Context2) {
                ctx2 = (Context2)context;
                ctx2.initOwnContext(objectctx);
            }
        }
    }

    public void checkActionPermission(RequestContext request, ResponseContext response, Context context) throws Exception {
        UIHandlerPermissionHelper.idAuthorize(context, request.getPerMenuItem(), response);
        if (request.getUserPK() != null) {
            ObjectUuidPK pk = null;
            if (request.getMainOrg() != null) {
                pk = new ObjectUuidPK(request.getMainOrg());
            }
            if ("ActionOnLoad".equals(request.getOnLoad()) && request.getPerMenuItem() != null) {
                UIHandlerPermissionHelper.checkFunctionPermission(context, request.getUserPK(), (IObjectPK)pk, null, null, request.getPerMenuItem(), request.getOrgExt());
            } else if (request.getMetaDataPK() != null && request.getActionPK() != null) {
                UIHandlerPermissionHelper.checkFunctionPermission(context, request.getUserPK(), (IObjectPK)pk, request.getMetaDataPK(), request.getActionPK(), null, request.getOrgExt());
            }
        }
    }

    public void netFunction(RequestContext request, ResponseContext response, Context context) throws Exception {
        MutexParameter param = request.getNetParam();
        if (request.getMutexStr() == null || param == null || param.toString().length() == 0) {
            return;
        }
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)context);
        boolean bool = mutexServiceControl.requestMutex((MutexParameter)param.clone());
        BaseFrameService.getMultiKey(response, IMutexServiceControl.class, "requestMutex", new Class[]{MutexParameter.class}, new Object[]{param}, new Boolean(bool));
    }

    public void repleaseNetFunction(RequestContext request, ResponseContext response, Context context) throws Exception {
        Uuid uuid = request.getNetUuid();
        if (uuid == null || request.getMutexStr() == null) {
            return;
        }
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)context);
        mutexServiceControl.releaseMutex(uuid);
        BaseFrameService.getMultiKey(response, IMutexServiceControl.class, "releaseMutex", new Class[]{Uuid.class}, new Object[]{uuid}, null);
    }

    public void checkFieldPermission(RequestContext request, ResponseContext response, Context context) throws Exception {
        IObjectPK userPK = request.getUserPK();
        ObjectUuidPK orgPK = null;
        if (request.getMainOrg() != null) {
            orgPK = new ObjectUuidPK(request.getMainOrg());
        }
        BOSObjectType bosType = request.getBosType();
        UIHandlerPermissionHelper.getFieldPermission(context, bosType, userPK, (IObjectPK)orgPK);
    }

    public void checkQueryFieldPermission(RequestContext request, ResponseContext response, Context context) throws Exception {
        IMetaDataPK queryPK;
        IObjectPK userPK = request.getUserPK();
        ObjectUuidPK orgPK = null;
        if (request.getMainOrg() != null) {
            orgPK = new ObjectUuidPK(request.getMainOrg());
        }
        if ((queryPK = request.getQueryPK()) == null) {
            return;
        }
        UIHandlerPermissionHelper.getQueryFieldPermission(context, queryPK, userPK, (IObjectPK)orgPK);
        if (orgPK == null && request.getOrg() != null) {
            orgPK = request.getOrg();
            UIHandlerPermissionHelper.getQueryFieldPermission(context, queryPK, userPK, (IObjectPK)orgPK);
        }
        ArrayList<String> orgList = new ArrayList<String>();
        String orgFieldName = request.getOrgField();
        if (orgFieldName != null) {
            IRowSet rowSet = request.getRowSet();
            while (rowSet != null && rowSet.next()) {
                String orgId = rowSet.getString(orgFieldName);
                if (orgList.contains(orgId)) continue;
                orgList.add(orgId);
            }
        }
        if (orgList.size() == 0) {
            return;
        }
        UIHandlerPermissionHelper.getQueryFieldPermission(context, queryPK, userPK, orgList);
    }

    public void checkQueryFieldPermissionByUI(RequestContext request, ResponseContext response, Context context) throws Exception {
        IMetaDataPK uiPk = request.getMetaDataPK();
        IObjectPK userPK = request.getUserPK();
        ObjectUuidPK orgPK = null;
        if (request.getMainOrg() != null) {
            orgPK = new ObjectUuidPK(request.getMainOrg());
        }
        if (request.getState() == null) {
            UIHandlerPermissionHelper.getQueryFieldPermission(context, uiPk, userPK, (IObjectPK)orgPK);
        }
    }

    public void requestMutextControl(RequestContext request, ResponseContext response, Context context) throws Exception {
        String userName = request.getUserName();
        String dcName = request.getDcName();
        String id = request.getId();
        IMutexServiceControl serviceControl = MutexServiceControlFactory.getLocalInstance((Context)context);
        boolean bool = false;
        Class[] typeClass = null;
        Object[] paramsValue = null;
        if (dcName != null) {
            bool = serviceControl.requestObjIDForUpdate(id, userName, dcName);
            typeClass = new Class[]{String.class, String.class, String.class};
            paramsValue = new Object[]{id, userName, dcName};
        } else {
            bool = serviceControl.requestObjIDForUpdate(id, userName);
            typeClass = new Class[]{String.class, String.class};
            paramsValue = new Object[]{id, userName};
        }
        BaseFrameService.getMultiKey(response, IMutexServiceControl.class, "requestObjIDForUpdate", typeClass, paramsValue, new Boolean(bool));
        if (!bool) {
            throw new EASBizException(new NumericExceptionSubItem("100", EASCommonResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)context.getLocale())));
        }
    }

    public void batchRequestMutext(RequestContext request, ResponseContext response, Context context) throws Exception {
        List idList = request.getIdList();
        if (idList == null) {
            return;
        }
        IMutexServiceControl serviceControl = MutexServiceControlFactory.getLocalInstance((Context)context);
        Map map = serviceControl.batchRequestObjIDForUpdate(idList);
        BaseFrameService.getMultiKey(response, IMutexServiceControl.class, "batchRequestObjIDForUpdate", new Class[]{List.class}, new Object[]{idList}, map);
    }

    public void repleaseMutextControl(RequestContext request, ResponseContext response, Context context) throws Exception {
        String id = request.getId();
        if (id != null) {
            IMutexServiceControl serviceControl = MutexServiceControlFactory.getLocalInstance((Context)context);
            serviceControl.releaseObjIDForUpdate(id);
        }
        Class[] typeClass = new Class[]{String.class};
        Object[] paramsValue = new Object[]{id};
        BaseFrameService.getMultiKey(response, IMutexServiceControl.class, "releaseObjIDForUpdate", typeClass, paramsValue, null);
    }

    public void batchRepleaseMutext(RequestContext request, ResponseContext response, Context context) throws Exception {
        List idList = request.getIdList();
        if (idList == null) {
            return;
        }
        IMutexServiceControl serviceControl = MutexServiceControlFactory.getLocalInstance((Context)context);
        serviceControl.batchReleaseObjIDForUpdate(idList);
        BaseFrameService.getMultiKey(response, IMutexServiceControl.class, "batchReleaseObjIDForUpdate", new Class[]{List.class}, new Object[]{idList}, null);
    }

    public void getTableConfig(RequestContext request, ResponseContext response, Context context) throws Exception {
        IObjectPK configPk = request.getConfigPK();
        if (configPk != null) {
            IUserCustomConfig iUserCustom = UserCustomConfigFactory.getLocalInstance(context);
            iUserCustom.getValue(configPk);
        }
    }

    public void checkLicense(RequestContext request, ResponseContext response, Context context) throws Exception {
        LicenseUserInfo user = (LicenseUserInfo)request.get("License.UserInfo");
        String fullName = request.getUIName();
        String check = (String)request.get("License.Ckeck");
        LicenseSrvAgentRpcHelper.checkLicence((LicenseUserInfo)user, (String)fullName, (String)check);
    }

    public void checkWorkFlow(RequestContext request, ResponseContext response, Context context) throws Exception {
        AssignmentInfo assignMent = (AssignmentInfo)request.getAssignInfo();
        Map flowMap = request.getFlowMap();
        String actionName = request.getActionName();
        IMetaDataPK uiObjectPK = request.getMetaDataPK();
        String userId = request.getUserPK().toString();
        boolean bindFlow = request.isBindFlow();
        if (assignMent != null || !bindFlow) {
            return;
        }
        String bizObjId = null;
        for (Object obj : flowMap.keySet()) {
            String item;
            String string = item = obj != null ? obj.toString() : "";
            if (bizObjId == null) {
                bizObjId = item;
                continue;
            }
            bizObjId = bizObjId + ", " + item;
        }
        IEnactmentService engine = EnactmentServiceFactory.createEnactService((Context)context);
        AssignmentInfo[] assignmentInfos = engine.checkAssignmentInfo(bizObjId, userId, uiObjectPK, actionName);
    }

    public void workFlowAction(RequestContext request, ResponseContext response, Context context) throws Exception {
        int actionSize = request.getActionSize();
        IRowSet rowSet = request.getRowSet();
        if (actionSize > 0 && rowSet != null) {
            String uiName = request.getUIName();
            String userPK = request.getUserPK().toString();
            String id = null;
            try {
                rowSet.beforeFirst();
                rowSet.next();
                id = rowSet.getString("id");
                rowSet.beforeFirst();
            }
            catch (Exception e) {
                logger.error((Object)"workFlowAction error", (Throwable)e);
            }
            if (id == null) {
                return;
            }
            IEnactmentService service = (IEnactmentService)BOSObjectFactory.createBOSObject((Context)context, (String)"com.kingdee.bos.workflow.service.EnactmentServiceProxy");
            ProcessInstInfo[] processInfo = service.getProcessInstanceByHoldedObjectId(id);
            BaseFrameService.getMultiKey(response, IBaseEnactmentService.class, "getProcessInstanceByHoldedObjectId", new Class[]{String.class}, new Object[]{id}, processInfo);
            if (processInfo.length > 0) {
                MetaDataPK uiNamePK = new MetaDataPK(uiName);
                try {
                    service.checkAssignmentInfo(id, userPK, (IMetaDataPK)uiNamePK, null);
                }
                catch (MatchAssignmentException e) {
                    logger.error((Object)e);
                }
                Class[] typeClass = new Class[]{String.class, String.class, IMetaDataPK.class, String.class};
                Object[] paramsValue = new Object[]{id, userPK, uiNamePK, null};
                BaseFrameService.getMultiKey(response, IBaseEnactmentService.class, "checkAssignmentInfo", typeClass, paramsValue, paramsValue);
            }
        }
    }

    public void getSignatrue(RequestContext request, ResponseContext response, Context context) throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getLocalInstance(context);
        facade.getSignatrueConfig();
    }

    public static final IDAPTransformerWrapper getDapWrapper(Context ctx) throws BOSException {
        IDAPTransformerWrapper wrapper = null;
        if (SPManager.isSPInstalled((String)"DAPServerProvider")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("DAPServerProvider");
            try {
                Constructor constructor = spInfo.getProviderClass().getConstructor(Context.class);
                Object dapWrapper = constructor.newInstance(ctx);
                return (IDAPTransformerWrapper)dapWrapper;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return wrapper;
    }
}

