/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.cellformatter.ICellFormatter;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.framework.report.util.CommRptResourceUtil;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptConstant;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import java.awt.Color;
import java.util.List;

public class KDTableUtil {
    public static void setHeader(RptTableHeader mm, KDTable tbl) {
        int i;
        if (mm == null) {
            return;
        }
        Object[][] data = mm.getLabels();
        List mergedRegionList = mm.getMergedRegionList();
        int cols = data[0].length;
        RptCellFormatter rcf = new RptCellFormatter();
        for (i = 0; i < cols; ++i) {
            IColumn column = tbl.addColumn(i);
            RptTableColumn rptCol = mm.getColumn(i);
            column.setWidth(rptCol.getWidth());
            column.setKey(rptCol.getName());
            if (rptCol.getFormatFunction() != null) {
                rcf.addFormatFunction(rptCol.getFormatFunctionName(), rptCol.getFormatFunction());
                column.getStyleAttributes().setNumberFormat(RptCellFormatter.buildFormatFunctionNameKey(rptCol.getFormatFunctionName()));
            } else {
                column.getStyleAttributes().setNumberFormat(rptCol.getFormatPattern());
            }
            column.getStyleAttributes().setHided(rptCol.isHided());
            Styles.HorizontalAlignment align = rptCol.getAligment() == 1 ? Styles.HorizontalAlignment.CENTER : (rptCol.getAligment() == 2 ? Styles.HorizontalAlignment.RIGHT : Styles.HorizontalAlignment.LEFT);
            column.getStyleAttributes().setHorizontalAlign(align);
        }
        for (i = 0; i < data.length; ++i) {
            IRow row = tbl.addHeadRow();
            for (int j = 0; j < cols; ++j) {
                row.getCell(j).setValue(data[i][j]);
            }
        }
        KDTableUtil.mergeTableCell(mergedRegionList, true, tbl);
        tbl.setCellCustomFormatter((ICellFormatter)rcf);
    }

    public static void insertRows(RptRowSet rs, int insertRowIndex, KDTable table) {
        KDTableUtil.insertRows(rs, insertRowIndex, table, new DefaultKDTableInsertHandler(rs));
    }

    public static void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, KDTableInsertHandler handler) {
        KDTableUtil.insertRows(rs, insertRowIndex, table, true, handler);
    }

    public static void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler) {
        table.setRefresh(false);
        while (rs.next()) {
            IRow row = table.setRow(insertRowIndex++);
            handler.setTableRowData(row, rs.toRowArray());
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    public static int getSelectedRow(KDTable tbl) {
        return com.kingdee.eas.util.client.KDTableUtil.getSelectedRow((KDTable)tbl);
    }

    public static int[] getSelectedRows(KDTable tbl) {
        return com.kingdee.eas.util.client.KDTableUtil.getSelectedRows((KDTable)tbl);
    }

    public static String getNumberFormat(int scale, boolean needkilobit) {
        StringBuffer sb = new StringBuffer("%r{");
        if (needkilobit) {
            sb.append("#,##");
        }
        sb.append("0");
        if (scale > 0) {
            sb.append(".");
            for (int i = 0; i < scale; ++i) {
                sb.append("0");
            }
        }
        sb.append("}f");
        return sb.toString();
    }

    public static Object zeroToEmpty(Object value) {
        if (value == null || String.valueOf(value).matches("0(\\.[0]{1,})?")) {
            return "";
        }
        return value;
    }

    public static String parseDatePart(String value) {
        if (value == null) {
            return "";
        }
        return value.substring(0, Math.min(10, value.length()));
    }

    public static void insertRows(Object[][] rowData, Object[] rowObject, int insertRowIndex, KDTable table) {
        KDTableUtil.insertRows(rowData, rowObject, null, insertRowIndex, table);
    }

    public static void insertRows(Object[][] data, Object[] userRowObjects, Color[] rowColors, int insertRowIndex, KDTable table) {
        if (data.length == 0) {
            return;
        }
        table.setRefresh(false);
        int cols = Math.min(data[0].length, table.getColumnCount());
        for (int i = 0; i < data.length; ++i) {
            IRow row = table.addRow(insertRowIndex++);
            if (userRowObjects != null) {
                row.setUserObject(userRowObjects[i]);
            }
            if (rowColors != null && rowColors[i] != null) {
                row.getStyleAttributes().setBackground(rowColors[i]);
            }
            for (int j = 0; j < cols; ++j) {
                row.getCell(j).setValue(data[i][j]);
            }
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    public static void insertTableSubTotalRow(KDTable tblLeft) {
        tblLeft.getMergeManager().getMergeBlockSet().clear();
        int rows = tblLeft.getRowCount();
        int cols = tblLeft.getColumnCount();
        if (rows <= 0) {
            return;
        }
        tblLeft.setRefresh(false);
        int justBaseCol = 0;
        int count = 0;
        Object[] last = new Object[cols];
        Object[] cur = new Object[cols];
        block0: for (int c = cols - 1; c > 0; --c) {
            justBaseCol = c;
            count = 0;
            int r = -1;
            while (++r < rows) {
                boolean isLast;
                int i;
                int i2;
                for (i2 = 0; i2 < justBaseCol; ++i2) {
                    cur[i2] = tblLeft.getRow(r).getCell(i2).getValue();
                }
                if (r == 0) {
                    for (i2 = 0; i2 < justBaseCol; ++i2) {
                        last[i2] = cur[i2];
                    }
                    count = 1;
                    if (r != rows - 1) continue;
                }
                boolean equals = true;
                for (i = 0; i < justBaseCol; ++i) {
                    if (last[i].equals(cur[i])) continue;
                    equals = false;
                    break;
                }
                if (!equals) {
                    for (i = 0; i < justBaseCol; ++i) {
                        last[i] = cur[i];
                    }
                    IRow row = tblLeft.addRow(r);
                    for (int i3 = 0; i3 <= justBaseCol; ++i3) {
                        row.getCell(i3).setValue(tblLeft.getRow(r - 1).getCell(i3).getValue());
                    }
                    row.getCell(c).setValue((Object)CommRptResourceUtil.getRes("subtotal"));
                    row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_TOTAL);
                    ++rows;
                    ++r;
                    count = 1;
                } else {
                    ++count;
                }
                if (!(isLast = r == rows - 1)) continue;
                IRow row = tblLeft.addRow(rows);
                for (int i4 = 0; i4 <= justBaseCol; ++i4) {
                    row.getCell(i4).setValue(tblLeft.getRow(rows - 1).getCell(i4).getValue());
                }
                row.getCell(c).setValue((Object)CommRptResourceUtil.getRes("subtotal"));
                row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_TOTAL);
                ++rows;
                continue block0;
            }
        }
        IRow row = tblLeft.addRow(rows);
        row.getCell(0).setValue((Object)CommRptResourceUtil.getRes("total"));
        row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_TOTAL);
        tblLeft.setRefresh(true);
    }

    public static void setNumberFormat(int[] columns, String numberFormat, KDTable table) {
        for (int i = 0; i < columns.length; ++i) {
            table.getColumn(columns[i]).getStyleAttributes().setNumberFormat(numberFormat);
        }
    }

    public static void setHeader(Object[] header, KDTable tbl) {
        int cols = header.length;
        for (int i = 0; i < cols; ++i) {
            tbl.addColumn();
        }
        IRow row = tbl.addHeadRow();
        for (int j = 0; j < cols; ++j) {
            row.getCell(j).setValue(header[j]);
        }
    }

    public static void setHeader(KDTableHeaderModel mm, KDTable tbl) {
        int i;
        if (mm == null) {
            return;
        }
        String[][] data = mm.getData();
        List mergedRegionList = mm.getMergedRegionList();
        int[] freezedColumns = mm.getFreezedColumnIndexices();
        int[] hiddenColumns = mm.getHiddenColumnIndexices();
        int[] alignColumns = mm.getAlignColumns();
        String[] columnsFormat = mm.getColumnsFormat();
        int[] columnWidths = mm.getColumnWidths();
        int cols = data[0].length;
        for (i = 0; i < cols; ++i) {
            IColumn column = tbl.addColumn(i);
            if (columnWidths == null) continue;
            column.setWidth(columnWidths[i]);
            column.setKey("KEY_" + i);
        }
        for (i = 0; i < data.length; ++i) {
            IRow row = tbl.addHeadRow();
            for (int j = 0; j < cols; ++j) {
                row.getCell(j).setValue((Object)data[i][j]);
            }
        }
        if (mergedRegionList != null && mergedRegionList.size() > 0) {
            for (i = 0; i < mergedRegionList.size(); ++i) {
                int[] region = (int[])mergedRegionList.get(i);
                tbl.getHeadMergeManager().mergeBlock(region[1], region[0], region[3], region[2]);
            }
        }
        if (columnsFormat != null) {
            for (i = 0; i < cols; ++i) {
                if (columnsFormat[i] == null) continue;
                tbl.getColumn(i).getStyleAttributes().setNumberFormat(columnsFormat[i]);
            }
        }
        if (alignColumns != null) {
            int cc = Math.min(cols, alignColumns.length);
            for (int i2 = 0; i2 < cc; ++i2) {
                Styles.HorizontalAlignment align = alignColumns[i2] == 1 ? Styles.HorizontalAlignment.CENTER : (alignColumns[i2] == 2 ? Styles.HorizontalAlignment.RIGHT : Styles.HorizontalAlignment.LEFT);
                tbl.getColumn(i2).getStyleAttributes().setHorizontalAlign(align);
            }
        }
        if (hiddenColumns != null) {
            for (i = 0; i < hiddenColumns.length; ++i) {
                tbl.getColumn(hiddenColumns[i]).getStyleAttributes().setHided(true);
            }
        }
        if (freezedColumns != null) {
            for (i = 0; i < freezedColumns.length; ++i) {
                tbl.getColumn(freezedColumns[i]).getStyleAttributes().setLocked(true);
            }
        }
    }

    public static int getSelectedTop(KDTable tbl) {
        KDTSelectBlock b = tbl.getSelectManager().get();
        return b == null ? -1 : b.getTop();
    }

    public static void mergeTableCell(List mergedRegionList, boolean mergeHeader, KDTable tbl) {
        if (mergedRegionList != null && mergedRegionList.size() > 0) {
            KDTMergeManager mm = mergeHeader ? tbl.getHeadMergeManager() : tbl.getMergeManager();
            for (int i = 0; i < mergedRegionList.size(); ++i) {
                int[] region = (int[])mergedRegionList.get(i);
                mm.mergeBlock(region[1], region[0], region[3], region[2]);
                if (mergeHeader) continue;
                tbl.getCell(region[1], region[0]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            }
        }
    }
}

