/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.formula.kscript.debug.ui;

import com.kingdee.bos.formula.kscript.debug.ui.DebugManager;
import com.kingdee.bos.formula.kscript.debug.ui.DebugUI;
import com.kingdee.bos.formula.kscript.debug.ui.DefaultEditMenu;
import com.kingdee.bos.formula.kscript.debug.ui.EvalDialog;
import com.kingdee.bos.formula.kscript.debug.ui.SourcePage;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class ConsolePanel
extends JScrollPane {
    public SourcePage sourcePage;
    public JTextPane textPanel = new JTextPane();
    private Style defaultStyle;
    private Style titleStyle;
    private Style messageStyle;
    private Style errorStyle;
    private Style finishStyle;
    private DefaultEditMenu editMenu = null;
    private static final String EVAL_SCRIPT = "Eval Script";
    private static final String EVAL_EXPR = "Eval Expression";
    private EvalDialog dlgEval = null;
    private String lastSource = null;
    private boolean lastNewLine = true;

    public Component getComponent() {
        return this;
    }

    public ConsolePanel(SourcePage sourcePage) {
        this.sourcePage = sourcePage;
        this.setViewportView(this.textPanel);
        DebugUI.setTextFont(this.textPanel);
        this.defaultStyle = this.textPanel.addStyle("defaultStyle", null);
        this.titleStyle = this.textPanel.addStyle("titleStyle", this.defaultStyle);
        this.messageStyle = this.textPanel.addStyle("messageStyle", this.defaultStyle);
        this.errorStyle = this.textPanel.addStyle("messageStyle", this.defaultStyle);
        this.finishStyle = this.textPanel.addStyle("finishStyle", this.defaultStyle);
        this.errorStyle.addAttribute(StyleConstants.Foreground, Color.RED);
        this.finishStyle.addAttribute(StyleConstants.Foreground, Color.GREEN.darker());
        this.editMenu = new DefaultEditMenu("console", this.textPanel, false){

            @Override
            protected void buildActionMenu(JPopupMenu menu) {
                super.buildActionMenu(menu);
                menu.addSeparator();
                super.addAction(menu, ConsolePanel.EVAL_SCRIPT);
                super.addAction(menu, ConsolePanel.EVAL_EXPR);
            }

            @Override
            protected boolean isExtandActionEnabled(String action) {
                return ConsolePanel.this.isActionEnabled(action);
            }

            @Override
            protected void extandActionPerformed(ActionEvent e) {
                ConsolePanel.this.editActionPerformed(e);
            }
        };
    }

    private Style getStyle(int state) {
        switch (state) {
            case -4: {
                return this.messageStyle;
            }
            case -2: {
                return this.finishStyle;
            }
            case 1: {
                return this.errorStyle;
            }
        }
        return null;
    }

    private boolean isActionEnabled(String action) {
        return this.sourcePage.sourcePanel.debugPanel.isPausedState();
    }

    private void editActionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == null) {
            return;
        }
        try {
            if (cmd.equals(EVAL_SCRIPT)) {
                if (this.dlgEval == null) {
                    this.dlgEval = new EvalDialog(this.sourcePage);
                }
                this.dlgEval.setVisible(true);
            } else if (cmd.equals(EVAL_EXPR)) {
                this.evalScript(true);
            }
        }
        catch (Exception ex) {
            this.sourcePage.sourcePanel.debugPanel.uiMain.handleException(ex);
        }
    }

    private void evalScript(boolean isExpr) throws Exception {
        String expr;
        if (!this.sourcePage.sourcePanel.debugPanel.isPausedState()) {
            return;
        }
        String key = this.sourcePage.getName() + ".eval";
        key = isExpr ? key + "expr" : key + "script";
        String expr0 = expr = DebugUI.props.inputText(key, "eval script");
        if (expr == null || expr.trim().length() == 0) {
            return;
        }
        if (!expr.endsWith(";")) {
            expr = expr + ";";
        }
        if (isExpr) {
            expr = "return " + expr;
        }
        IDebugContext debug = this.sourcePage.sourcePanel.debugPanel.debug;
        IValue r = debug.evalNoDebug(expr);
        String msg = isExpr ? expr0 + " = " + String.valueOf(r) + "\r\n" : "eval return value is " + String.valueOf(r) + "\r\n";
        this.output(debug, msg, -4);
    }

    private void appendText(String text, Style style) throws Exception {
        Document doc = this.textPanel.getDocument();
        doc.insertString(doc.getLength(), text, style);
    }

    private void appendText1(String source, String text, int state) {
        try {
            if (this.lastSource == null || !this.lastSource.equals(source)) {
                if (!this.lastNewLine) {
                    this.appendText("\r\n", null);
                }
                this.appendText(source, this.titleStyle);
                this.appendText(" ", null);
                this.lastSource = source;
            }
            this.lastNewLine = text.endsWith("\n");
            this.appendText(text, this.getStyle(state));
        }
        catch (Exception ex) {
            this.sourcePage.sourcePanel.debugPanel.uiMain.handleException(ex);
        }
    }

    private void appendText(String source, String text, int state) {
        while (text.length() > 0) {
            int i = text.indexOf(10);
            if (i < 0) {
                this.appendText1(source, text, state);
                break;
            }
            this.appendText1(source, text.substring(0, i + 1), state);
            if (state != 1) {
                this.lastSource = null;
            }
            text = text.substring(i + 1);
        }
        if (this.lastNewLine) {
            this.lastSource = null;
        }
    }

    public void output(IDebugContext debug, Object val, int state) {
        String msg = String.valueOf(val);
        if (msg.length() == 0) {
            return;
        }
        try {
            String name = DebugManager.getDebugRuntimeName(debug);
            String thread = debug.getRunningThread().toString();
            String source = "[" + name + "][" + thread + "]";
            this.appendText(source, msg, state);
            this.textPanel.setCaretPosition(this.textPanel.getDocument().getLength());
        }
        catch (Exception ex) {
            this.sourcePage.sourcePanel.debugPanel.uiMain.handleDebugContextException(ex);
        }
    }

    public void clear() {
        try {
            Document doc = this.textPanel.getDocument();
            this.textPanel.getDocument().remove(0, doc.getLength());
        }
        catch (Exception ex) {
            this.sourcePage.sourcePanel.debugPanel.uiMain.handleException(ex);
        }
    }
}

